<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EE Micro LMS</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0; 
            padding: 40px; 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            text-align: center;
            background: rgba(255,255,255,0.1);
            padding: 60px;
            border-radius: 20px;
            backdrop-filter: blur(10px);
            box-shadow: 0 8px 32px rgba(0,0,0,0.3);
        }
        h1 { 
            font-size: 3em; 
            margin-bottom: 20px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        p { 
            font-size: 1.2em; 
            margin-bottom: 30px;
            opacity: 0.9;
        }
        .links {
            margin-top: 30px;
        }
        .links a {
            display: inline-block;
            margin: 10px;
            padding: 12px 24px;
            background: rgba(255,255,255,0.2);
            color: white;
            text-decoration: none;
            border-radius: 25px;
            transition: all 0.3s ease;
            border: 2px solid rgba(255,255,255,0.3);
        }
        .links a:hover {
            background: rgba(255,255,255,0.3);
            transform: translateY(-2px);
        }
        .status {
            margin-top: 40px;
            padding: 20px;
            background: rgba(0,255,0,0.2);
            border-radius: 10px;
            border: 1px solid rgba(0,255,0,0.3);
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎓 EE Micro LMS</h1>
        <p>Electrical Engineering Micro Learning Management System</p>
        <p>Laravel {{ app()->version() }} + React + Inertia.js</p>
        
        <div class="status">
            <h3>✅ System Status: OPERATIONAL</h3>
            <p>Backend: Laravel Server Running</p>
            <p>Database: Connected</p>
            <p>Frontend: Ready for React Integration</p>
        </div>
        
        <div class="links">
            <a href="/login">🔐 Login</a>
            <a href="/register">📝 Register</a>
            <a href="/dashboard">📊 Dashboard</a>
        </div>
        
        <div style="margin-top: 30px; font-size: 0.9em; opacity: 0.7;">
            <p>Server Time: {{ date('Y-m-d H:i:s') }}</p>
        </div>
    </div>
</body>
</html>