@extends('layouts.student')

@section('title', 'My Schedule')

@section('content')
<style>
    .schedule-header {
        background: rgba(255,255,255,0.2);
        backdrop-filter: blur(20px);
        padding: 40px;
        border-radius: 25px;
        margin-bottom: 30px;
        border: 1px solid rgba(255,255,255,0.3);
    }

    .schedule-header h1 {
        color: white;
        font-size: 2.5em;
        margin-bottom: 15px;
        font-weight: 800;
    }

    .schedule-header p {
        color: rgba(255,255,255,0.95);
        font-size: 1.1em;
    }

    .schedule-grid {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 30px;
        margin-bottom: 30px;
    }

    .schedule-card {
        background: white;
        border-radius: 25px;
        padding: 40px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }

    .schedule-card h2 {
        font-size: 1.8em;
        color: #333;
        margin-bottom: 25px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .topic-schedule-item {
        background: #f9fafb;
        padding: 25px;
        border-radius: 15px;
        margin-bottom: 20px;
        border-left: 4px solid #667eea;
        transition: all 0.3s ease;
    }

    .topic-schedule-item:hover {
        transform: translateX(10px);
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }

    .schedule-course {
        font-size: 0.85em;
        color: #667eea;
        font-weight: 700;
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .schedule-topic-title {
        font-size: 1.3em;
        font-weight: 700;
        color: #333;
        margin-bottom: 10px;
    }

    .schedule-lesson {
        color: #6b7280;
        margin-bottom: 15px;
    }

    .schedule-status {
        display: inline-block;
        padding: 6px 16px;
        border-radius: 15px;
        font-size: 0.85em;
        font-weight: 600;
        margin-bottom: 15px;
    }

    .status-not-started {
        background: rgba(102, 126, 234, 0.1);
        color: #667eea;
    }

    .status-in-progress {
        background: rgba(245, 158, 11, 0.1);
        color: #f59e0b;
    }

    .btn-start-topic {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 12px 25px;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border-radius: 15px;
        text-decoration: none;
        font-weight: 700;
        transition: all 0.3s ease;
    }

    .btn-start-topic:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }

    .activity-item {
        display: flex;
        gap: 15px;
        padding: 20px;
        background: #f9fafb;
        border-radius: 15px;
        margin-bottom: 15px;
        transition: all 0.3s ease;
    }

    .activity-item:hover {
        background: white;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    }

    .activity-icon {
        width: 45px;
        height: 45px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2em;
        flex-shrink: 0;
    }

    .activity-icon.completed {
        background: linear-gradient(135deg, #10b981, #059669);
        color: white;
    }

    .activity-icon.in-progress {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .activity-details {
        flex: 1;
    }

    .activity-title {
        font-weight: 700;
        color: #333;
        margin-bottom: 5px;
    }

    .activity-course {
        color: #6b7280;
        font-size: 0.9em;
        margin-bottom: 5px;
    }

    .activity-time {
        color: #9ca3af;
        font-size: 0.85em;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
    }

    .empty-state i {
        font-size: 4em;
        color: #d1d5db;
        margin-bottom: 20px;
    }

    .empty-state h3 {
        color: #6b7280;
        font-size: 1.3em;
        margin-bottom: 10px;
    }

    .empty-state p {
        color: #9ca3af;
        margin-bottom: 25px;
    }

    @media (max-width: 1024px) {
        .schedule-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="schedule-header">
    <h1>📅 My Learning Schedule</h1>
    <p>Stay on track with your learning goals and upcoming topics!</p>
</div>

<div class="schedule-grid">
    <!-- Next Topics to Study -->
    <div class="schedule-card">
        <h2>
            <i class="fas fa-tasks"></i>
            Up Next
        </h2>

        @forelse($schedule as $item)
            <div class="topic-schedule-item">
                <div class="schedule-course">{{ $item['course']->name }}</div>
                <div class="schedule-topic-title">{{ $item['topic']->title }}</div>
                <div class="schedule-lesson">
                    <i class="fas fa-book"></i> {{ $item['lesson']->title }}
                </div>
                <span class="schedule-status status-{{ $item['status'] }}">
                    <i class="fas fa-{{ $item['status'] == 'not-started' ? 'play' : 'spinner' }}"></i>
                    {{ ucfirst(str_replace('-', ' ', $item['status'])) }}
                </span>
                <div>
                    <a href="{{ route('learn.topic', ['course' => $item['course']->id, 'lesson' => $item['lesson']->id, 'topic' => $item['topic']->id]) }}" class="btn-start-topic">
                        <i class="fas fa-play"></i>
                        {{ $item['status'] == 'not-started' ? 'Start Learning' : 'Continue' }}
                    </a>
                </div>
            </div>
        @empty
            <div class="empty-state">
                <i class="fas fa-check-circle"></i>
                <h3>All caught up!</h3>
                <p>You've completed all topics in your enrolled courses</p>
                <a href="{{ route('student.browse') }}" class="btn-start-topic">
                    <i class="fas fa-search"></i>
                    Browse More Courses
                </a>
            </div>
        @endforelse
    </div>

    <!-- Recent Activity -->
    <div class="schedule-card">
        <h2>
            <i class="fas fa-history"></i>
            Recent Activity
        </h2>

        @forelse($recentActivity as $activity)
            <div class="activity-item">
                <div class="activity-icon {{ $activity->completed ? 'completed' : 'in-progress' }}">
                    <i class="fas fa-{{ $activity->completed ? 'check' : 'clock' }}"></i>
                </div>
                <div class="activity-details">
                    <div class="activity-title">{{ $activity->topic->title }}</div>
                    <div class="activity-course">{{ $activity->topic->lesson->course->name }}</div>
                    <div class="activity-time">
                        <i class="fas fa-clock"></i> {{ $activity->updated_at->diffForHumans() }}
                    </div>
                </div>
            </div>
        @empty
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>No activity yet</h3>
                <p>Start learning to see your recent activity</p>
            </div>
        @endforelse
    </div>
</div>

<!-- Quick Stats -->
<div class="schedule-card">
    <h2>
        <i class="fas fa-chart-line"></i>
        Today's Goals
    </h2>
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
        <div style="text-align: center; padding: 30px; background: linear-gradient(135deg, #667eea, #764ba2); border-radius: 15px; color: white;">
            <div style="font-size: 3em; font-weight: 800; margin-bottom: 10px;">{{ count($schedule) }}</div>
            <div style="font-size: 1em; opacity: 0.9;">Topics to Complete</div>
        </div>
        <div style="text-align: center; padding: 30px; background: linear-gradient(135deg, #10b981, #059669); border-radius: 15px; color: white;">
            <div style="font-size: 3em; font-weight: 800; margin-bottom: 10px;">{{ $recentActivity->where('completed', true)->count() }}</div>
            <div style="font-size: 1em; opacity: 0.9;">Recent Completions</div>
        </div>
        <div style="text-align: center; padding: 30px; background: linear-gradient(135deg, #f59e0b, #d97706); border-radius: 15px; color: white;">
            <div style="font-size: 3em; font-weight: 800; margin-bottom: 10px;">{{ $recentActivity->where('completed', false)->count() }}</div>
            <div style="font-size: 1em; opacity: 0.9;">In Progress</div>
        </div>
    </div>
</div>
@endsection
