<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Enroll - {{ $course->name }}</title>
    
    @php
        $brand = \App\Support\BrandSettings::data();
        $faviconUrl = $brand['favicon_url'] ?? null;
    @endphp
    
    @if($faviconUrl)
        <link rel="icon" type="image/png" href="{{ $faviconUrl }}">
        <link rel="shortcut icon" type="image/png" href="{{ $faviconUrl }}">
    @endif
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .enrollment-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 700px;
            width: 100%;
            overflow: hidden;
            animation: slideUp 0.5s ease;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .course-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 40px 30px;
            color: white;
            text-align: center;
        }

        .course-icon {
            font-size: 4em;
            margin-bottom: 15px;
            animation: bounce 2s infinite;
        }

        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .course-title {
            font-size: 2em;
            font-weight: 700;
            margin-bottom: 10px;
        }

        .course-subtitle {
            font-size: 1.1em;
            opacity: 0.9;
        }

        .course-content {
            padding: 40px 30px;
        }

        .course-description {
            font-size: 1.05em;
            line-height: 1.7;
            color: #333;
            margin-bottom: 30px;
        }

        .course-meta {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .meta-item {
            text-align: center;
            padding: 20px;
            background: #f9fafb;
            border-radius: 12px;
            border: 2px solid #e5e7eb;
        }

        .meta-icon {
            font-size: 2em;
            color: #667eea;
            margin-bottom: 10px;
        }

        .meta-value {
            font-size: 1.5em;
            font-weight: 700;
            color: #333;
            margin-bottom: 5px;
        }

        .meta-label {
            font-size: 0.9em;
            color: #6b7280;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .alert-warning {
            background: #fef3c7;
            border: 2px solid #f59e0b;
            color: #92400e;
        }

        .alert-info {
            background: #dbeafe;
            border: 2px solid #3b82f6;
            color: #1e40af;
        }

        .alert i {
            font-size: 1.5em;
        }

        .price-badge {
            display: inline-block;
            padding: 10px 20px;
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
            border-radius: 25px;
            font-size: 1.2em;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .price-badge.paid {
            background: linear-gradient(135deg, #667eea, #764ba2);
        }

        .button-group {
            display: flex;
            gap: 15px;
            margin-top: 30px;
        }

        .btn {
            flex: 1;
            padding: 15px 30px;
            border: none;
            border-radius: 12px;
            font-size: 1.1em;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-primary:disabled {
            background: #9ca3af;
            cursor: not-allowed;
            transform: none;
        }

        .btn-secondary {
            background: white;
            color: #667eea;
            border: 2px solid #667eea;
        }

        .btn-secondary:hover {
            background: #f3f4f6;
        }

        .prerequisites-list {
            background: #fef3c7;
            padding: 20px;
            border-radius: 12px;
            border-left: 4px solid #f59e0b;
            margin-bottom: 20px;
        }

        .prerequisites-list h4 {
            color: #92400e;
            margin-bottom: 10px;
            font-size: 1.1em;
        }

        .prerequisites-list p {
            color: #78350f;
            margin-bottom: 10px;
        }

        @media (max-width: 600px) {
            .course-header {
                padding: 30px 20px;
            }

            .course-title {
                font-size: 1.5em;
            }

            .course-content {
                padding: 30px 20px;
            }

            .button-group {
                flex-direction: column;
            }

            .course-meta {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="enrollment-container">
        <div class="course-header">
            <div class="course-icon">
                <i class="fas fa-graduation-cap"></i>
            </div>
            <h1 class="course-title">{{ $course->name }}</h1>
            <p class="course-subtitle">Ready to start your learning journey?</p>
        </div>

        <div class="course-content">
            @if($course->short_description)
                <p class="course-description">{{ $course->short_description }}</p>
            @endif

            <div class="course-meta">
                <div class="meta-item">
                    <div class="meta-icon"><i class="fas fa-book"></i></div>
                    <div class="meta-value">{{ $course->lessons->count() }}</div>
                    <div class="meta-label">Lessons</div>
                </div>
                <div class="meta-item">
                    <div class="meta-icon"><i class="fas fa-tasks"></i></div>
                    <div class="meta-value">{{ $course->lessons->sum(function($lesson) { return $lesson->topics->count(); }) }}</div>
                    <div class="meta-label">Topics</div>
                </div>
                <div class="meta-item">
                    <div class="meta-icon"><i class="fas fa-clock"></i></div>
                    <div class="meta-value">Self-Paced</div>
                    <div class="meta-label">Learning Mode</div>
                </div>
            </div>

            @if(!$canEnroll)
                <div class="prerequisites-list">
                    <h4><i class="fas fa-lock"></i> Prerequisites Required</h4>
                    <p>{{ $prerequisiteMessage }}</p>
                    <p><strong>Please complete the prerequisite course first before enrolling in this course.</strong></p>
                </div>
            @endif

            @if($course->is_free)
                <span class="price-badge">
                    <i class="fas fa-gift"></i> FREE COURSE
                </span>
            @else
                <span class="price-badge paid">
                    <i class="fas fa-tag"></i> ${{ number_format($course->price, 2) }} {{ $course->currency }}
                </span>
            @endif

            @if($canEnroll)
                @if($course->is_free)
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i>
                        <div>
                            <strong>Ready to learn?</strong> This course is completely free! Click the button below to enroll and start learning immediately.
                        </div>
                    </div>
                @else
                    <div class="alert alert-warning">
                        <i class="fas fa-credit-card"></i>
                        <div>
                            <strong>Payment Required:</strong> Proceed to checkout to purchase and unlock this course.
                        </div>
                    </div>
                @endif
            @endif

            <div class="button-group">
                @if($canEnroll)
                    @if($course->is_free)
                        <form action="{{ route('student.enroll', $course) }}" method="POST" style="flex: 1;">
                            @csrf
                            <button type="submit" class="btn btn-primary" style="width: 100%;">
                                <i class="fas fa-check-circle"></i> Enroll Now
                            </button>
                        </form>
                    @else
                        <a class="btn btn-primary" style="width: 100%; text-align: center;" href="{{ route('payment.checkout', $course) }}">
                            <i class="fas fa-shopping-cart"></i> Purchase Now
                        </a>
                    @endif
                @else
                    <button class="btn btn-primary" disabled>
                        <i class="fas fa-lock"></i> Prerequisites Required
                    </button>
                @endif
                
                <a href="{{ url()->previous() }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Go Back
                </a>
            </div>
        </div>
    </div>
</body>
</html>
