@extends('layouts.public')

@section('title', 'Payment Successful')

@section('content')
<div class="container mx-auto px-4 py-12 max-w-2xl">
    <div class="bg-white rounded-lg shadow-lg p-8 text-center">
        <div class="mb-6">
            <svg class="w-20 h-20 text-green-500 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
        </div>

        <h1 class="text-3xl font-bold text-gray-800 mb-4">Payment Successful!</h1>
        <p class="text-lg text-gray-600 mb-8">
            Thank you for your purchase. You now have access to <strong>{{ $course->title }}</strong>.
        </p>

        <div class="bg-green-50 border border-green-200 rounded-lg p-6 mb-8">
            <h2 class="font-semibold text-gray-800 mb-2">What's Next?</h2>
            <p class="text-gray-600 mb-4">Start learning right away! Your course is now available in your dashboard.</p>
            
            <div class="space-y-3">
                <a href="{{ route('learn.course', $course->id) }}" class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition">
                    Start Learning Now
                </a>
                <a href="{{ route('dashboard') }}" class="block w-full bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-3 px-6 rounded-lg transition">
                    Go to Dashboard
                </a>
            </div>
        </div>

        <div class="text-sm text-gray-600">
            <p>A confirmation email has been sent to your registered email address.</p>
            <p class="mt-2">Need help? <a href="{{ route('contact') }}" class="text-blue-600 hover:underline">Contact Support</a></p>
        </div>
    </div>
</div>
@endsection
