@extends('layouts.public')

@section('title', 'Checkout - ' . $course->name)

@push('styles')
<style>
    .checkout-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 40px 20px;
    }

    .checkout-card {
        background: white;
        border-radius: 16px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        padding: 40px;
        margin-bottom: 20px;
    }

    .checkout-title {
        font-size: 2rem;
        font-weight: 800;
        margin-bottom: 30px;
        color: #1a202c;
        text-align: center;
    }

    .checkout-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 30px;
        margin-bottom: 30px;
    }

    @media (max-width: 768px) {
        .checkout-grid {
            grid-template-columns: 1fr;
        }
    }

    .checkout-section {
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        padding: 24px;
    }

    .section-title {
        font-size: 1.25rem;
        font-weight: 700;
        margin-bottom: 20px;
        color: #2d3748;
    }

    .course-image {
        width: 100%;
        height: 200px;
        object-fit: cover;
        border-radius: 8px;
        margin-bottom: 20px;
    }

    .course-name {
        font-size: 1.125rem;
        font-weight: 700;
        margin-bottom: 12px;
        color: #1a202c;
    }

    .course-description {
        font-size: 0.9375rem;
        color: #4a5568;
        margin-bottom: 20px;
        line-height: 1.6;
    }

    .price-section {
        border-top: 2px solid #e2e8f0;
        padding-top: 16px;
    }

    .price-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }

    .price-label {
        font-size: 0.875rem;
        color: #4a5568;
    }

    .price-value {
        font-size: 0.875rem;
        color: #4a5568;
    }

    .price-original {
        text-decoration: line-through;
        color: #a0aec0;
    }

    .price-discount {
        color: #48bb78;
        font-weight: 600;
    }

    .price-total {
        font-size: 1.25rem;
        font-weight: 700;
        color: #667eea;
        margin-top: 10px;
        padding-top: 10px;
        border-top: 2px solid #e2e8f0;
    }

    .payment-button {
        width: 100%;
        padding: 16px 24px;
        font-size: 1rem;
        font-weight: 700;
        border: none;
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        margin-bottom: 12px;
    }

    .payment-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }

    .btn-stripe {
        background: linear-gradient(135deg, #6772e5, #5469d4);
        color: white;
    }

    .btn-paypal {
        background: linear-gradient(135deg, #0070ba, #003087);
        color: white;
    }

    .btn-paystack {
        background: linear-gradient(135deg, #00c3f7, #0099cc);
        color: white;
    }

    .btn-crypto {
        background: linear-gradient(135deg, #f7931a, #ff6b00);
        color: white;
    }

    .security-badge {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 0.875rem;
        color: #48bb78;
        margin-top: 20px;
        padding: 12px;
        background: #f0fff4;
        border-radius: 8px;
    }

    .security-badge i {
        font-size: 1.125rem;
    }

    .back-link {
        display: inline-block;
        text-align: center;
        color: #667eea;
        text-decoration: none;
        font-weight: 600;
        margin-top: 20px;
        transition: color 0.3s ease;
    }

    .back-link:hover {
        color: #5a67d8;
        text-decoration: underline;
    }
</style>
@endpush

@section('content')
@php
    $priceValue = floatval($course->price ?? 0);
    $discountValue = floatval($course->discount ?? 0);
    $discountType = $course->discount_type ?? 'amount';
    
    if ($discountType === 'percent' && $discountValue > 0) {
        $discountedPrice = $priceValue - ($priceValue * ($discountValue / 100));
    } else if ($discountValue > 0) {
        $discountedPrice = $priceValue - $discountValue;
    } else {
        $discountedPrice = $priceValue;
    }
    
    $discountedPrice = max($discountedPrice, 0);
    $hasDiscount = $discountValue > 0 && $discountedPrice < $priceValue;
@endphp

<div class="checkout-container">
    <div class="checkout-card">
        <h1 class="checkout-title">Complete Your Purchase</h1>

        <div class="checkout-grid">
            <!-- Course Details -->
            <div class="checkout-section">
            <div class="checkout-section">
                <h2 class="section-title">Course Details</h2>
                @if($course->thumbnail_url)
                    <img src="{{ $course->thumbnail_url }}" alt="{{ $course->name }}" class="course-image">
                @endif
                <h3 class="course-name">{{ $course->name }}</h3>
                <p class="course-description">{{ Str::limit($course->short_description ?? $course->description, 150) }}</p>
                <div class="price-section">
                    @if($hasDiscount)
                        <div class="price-row">
                            <span class="price-label">Original Price:</span>
                            <span class="price-value price-original">{{ $course->currency }} {{ number_format($priceValue, 2) }}</span>
                        </div>
                        <div class="price-row">
                            <span class="price-label price-discount">
                                Discount ({{ $discountType === 'percent' ? $discountValue . '%' : $course->currency . ' ' . number_format($discountValue, 2) }}):
                            </span>
                            <span class="price-value price-discount">-{{ $course->currency }} {{ number_format($priceValue - $discountedPrice, 2) }}</span>
                        </div>
                    @endif
                    <div class="price-row price-total">
                        <span>Total:</span>
                        <span>{{ $course->currency }} {{ number_format($discountedPrice, 2) }}</span>
                    </div>
                </div>
            </div>

            <!-- Payment Methods -->
            <div class="checkout-section">
                <h2 class="section-title">Select Payment Method</h2>
                
                @if(empty($activeGateways))
                    <div style="padding: 30px; text-align: center; background: #fff3cd; border: 2px solid #ffc107; border-radius: 10px;">
                        <i class="fas fa-exclamation-triangle" style="font-size: 3rem; color: #ff9800; margin-bottom: 15px;"></i>
                        <h3 style="color: #856404; margin-bottom: 10px;">No Payment Methods Available</h3>
                        <p style="color: #856404;">Please contact the administrator to enable payment gateways.</p>
                    </div>
                @else
                    <!-- Stripe Payment -->
                    @if(in_array('stripe', $activeGateways))
                        <button onclick="processStripePayment()" class="payment-button btn-stripe">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M13.976 9.15c-2.172-.806-3.356-1.426-3.356-2.409 0-.831.683-1.305 1.901-1.305 2.227 0 4.515.858 6.09 1.631l.89-5.494C18.252.975 15.697 0 12.165 0 9.667 0 7.589.654 6.104 1.872 4.56 3.147 3.757 4.992 3.757 7.218c0 4.039 2.467 5.76 6.476 7.219 2.585.92 3.445 1.571 3.445 2.711 0 .866-.723 1.405-2.01 1.405-2.722 0-5.738-.986-7.304-2.033L3.75 22.5c1.803 1.053 4.423 1.5 7.083 1.5 2.742 0 4.96-.646 6.59-1.906 1.643-1.283 2.479-3.146 2.479-5.537 0-4.125-2.666-6.119-5.926-7.407z"/>
                            </svg>
                            Pay with Card (Stripe)
                        </button>
                    @endif

                    <!-- PayPal Payment -->
                    @if(in_array('paypal', $activeGateways))
                        <button onclick="processPayPalPayment()" class="payment-button btn-paypal">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M7.076 21.337H2.47a.641.641 0 0 1-.633-.74L4.944.901C5.026.382 5.474 0 5.998 0h7.46c2.57 0 4.578.543 5.69 1.81 1.01 1.15 1.304 2.42 1.012 4.287-.023.143-.047.288-.077.437-.983 5.05-4.349 6.797-8.647 6.797h-2.19c-.524 0-.968.382-1.05.9l-1.12 7.106zm14.146-14.42a3.35 3.35 0 0 0-.607-.541c-.013.076-.026.175-.041.254-.93 4.778-4.005 7.201-9.138 7.201h-2.19a.563.563 0 0 0-.556.479l-1.187 7.527h-.506l-.24 1.516a.56.56 0 0 0 .554.647h3.882c.46 0 .85-.334.922-.788.06-.26.76-4.852.76-4.852a.932.932 0 0 1 .922-.788h.58c3.76 0 6.705-1.528 7.565-5.946.36-1.847.174-3.388-.777-4.471z"/>
                            </svg>
                            Pay with PayPal
                        </button>
                    @endif

                    <!-- Paystack Payment -->
                    @if(in_array('paystack', $activeGateways))
                        <button onclick="processPaystackPayment()" class="payment-button btn-paystack">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M0 12C0 5.373 5.373 0 12 0s12 5.373 12 12-5.373 12-12 12S0 18.627 0 12zm8.182 4.364h7.636v-8.728H8.182v8.728z"/>
                            </svg>
                            Pay with Paystack
                        </button>
                    @endif

                    <!-- Crypto Payment -->
                    @if(in_array('crypto', $activeGateways))
                        <button onclick="alert('Crypto payment coming soon!')" class="payment-button btn-crypto">
                            <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M23.638 14.904c-1.602 6.43-8.113 10.34-14.542 8.736C2.67 22.05-1.244 15.525.362 9.105 1.962 2.67 8.475-1.243 14.9.358c6.43 1.605 10.342 8.115 8.738 14.548v-.002zm-6.35-4.613c.24-1.59-.974-2.45-2.64-3.03l.54-2.153-1.315-.33-.525 2.107c-.345-.087-.705-.167-1.064-.25l.526-2.127-1.32-.33-.54 2.165c-.285-.067-.565-.132-.84-.2l-1.815-.45-.35 1.407s.975.225.955.236c.535.136.63.486.615.766l-1.477 5.92c-.075.166-.24.406-.614.314.015.02-.96-.24-.96-.24l-.66 1.51 1.71.426.93.242-.54 2.19 1.32.327.54-2.17c.36.1.705.19 1.05.273l-.51 2.154 1.32.33.545-2.19c2.24.427 3.93.257 4.64-1.774.57-1.637-.03-2.58-1.217-3.196.854-.193 1.5-.76 1.68-1.93h.01zm-3.01 4.22c-.404 1.64-3.157.75-4.05.53l.72-2.9c.896.23 3.757.67 3.33 2.37zm.41-4.24c-.37 1.49-2.662.735-3.405.55l.654-2.64c.744.18 3.137.524 2.75 2.084v.006z"/>
                            </svg>
                            Pay with Crypto
                        </button>
                    @endif

                    <div class="security-badge">
                        <i class="fas fa-lock"></i>
                        <div>
                            <strong>Secure SSL Payment</strong><br>
                            <span style="font-size: 0.75rem; color: #4a5568;">Instant access after payment • Money-back guarantee</span>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <div style="text-align: center;">
            <a href="{{ url()->previous() }}" class="back-link">← Back to Courses</a>
        </div>
    </div>
</div>

<!-- Stripe JS -->
<script src="https://js.stripe.com/v3/"></script>
<!-- Paystack JS -->
<script src="https://js.paystack.co/v1/inline.js"></script>

<script>
    // Stripe Payment
    async function processStripePayment() {
        try {
            const response = await fetch('{{ route("payment.process.stripe", $course->id) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    payment_method: 'card'
                })
            });

            const data = await response.json();
            
            if (data.error) {
                alert(data.error);
                return;
            }

            // Redirect to Stripe Checkout
            window.location.href = data.url;
        } catch (error) {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        }
    }

    // PayPal Payment
    async function processPayPalPayment() {
        try {
            const response = await fetch('{{ route("payment.process.paypal", $course->id) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            });

            const data = await response.json();
            
            if (data.error) {
                alert(data.error);
                return;
            }

            // Redirect to PayPal
            window.location.href = data.approvalUrl;
        } catch (error) {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        }
    }

    // Paystack Payment
    async function processPaystackPayment() {
        try {
            const response = await fetch('{{ route("payment.process.paystack", $course->id) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            });

            const data = await response.json();
            
            if (data.error) {
                alert(data.error);
                return;
            }

            // Initialize Paystack payment
            const handler = PaystackPop.setup({
                key: data.public_key,
                email: data.email,
                amount: data.amount,
                currency: data.currency,
                ref: data.reference,
                callback: function(response) {
                    window.location.href = '{{ route("payment.paystack.callback") }}?reference=' + response.reference;
                },
                onClose: function() {
                    alert('Payment cancelled');
                }
            });
            
            handler.openIframe();
        } catch (error) {
            console.error('Error:', error);
            alert('An error occurred. Please try again.');
        }
    }
</script>
@endsection
