@extends('layouts.public')

@section('title', 'Payment Cancelled')

@section('content')
<div class="container mx-auto px-4 py-12 max-w-2xl">
    <div class="bg-white rounded-lg shadow-lg p-8 text-center">
        <div class="mb-6">
            <svg class="w-20 h-20 text-yellow-500 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
            </svg>
        </div>

        <h1 class="text-3xl font-bold text-gray-800 mb-4">Payment Cancelled</h1>
        <p class="text-lg text-gray-600 mb-8">
            Your payment was cancelled. No charges were made to your account.
        </p>

        @if($course)
        <div class="bg-gray-50 border border-gray-200 rounded-lg p-6 mb-8">
            <h2 class="font-semibold text-gray-800 mb-4">Would you like to try again?</h2>
            
            <div class="space-y-3">
                <a href="{{ route('payment.checkout', $course->id) }}" class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition">
                    Try Another Payment Method
                </a>
                <a href="{{ route('student.browse') }}" class="block w-full bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-3 px-6 rounded-lg transition">
                    Continue Browsing Courses
                </a>
            </div>
        </div>
        @else
        <div class="space-y-3">
            <a href="{{ route('student.browse') }}" class="block w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition">
                Browse Courses
            </a>
            <a href="{{ route('dashboard') }}" class="block w-full bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-3 px-6 rounded-lg transition">
                Go to Dashboard
            </a>
        </div>
        @endif

        <div class="text-sm text-gray-600 mt-6">
            <p>Need help? <a href="{{ route('contact') }}" class="text-blue-600 hover:underline">Contact Support</a></p>
        </div>
    </div>
</div>
@endsection
