@extends('layouts.public')

@section('title', $page->title . ' - EE Micro LMS')
@section('meta_description', $page->meta_description ?? '')
@if($page->meta_keywords)
    @push('meta')
        <meta name="keywords" content="{{ $page->meta_keywords }}">
    @endpush
@endif

@push('styles')
<style>
    .page-hero {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 80px 0;
        text-align: center;
    }
    
    .page-hero h1 {
        font-size: 48px;
        font-weight: 900;
        margin-bottom: 20px;
    }
    
    .page-content {
        padding: 80px 0;
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .content-block {
        margin-bottom: 40px;
    }
    
    .block-heading h2 {
        font-size: 32px;
        font-weight: 800;
        margin-bottom: 20px;
        color: var(--text-dark);
    }
    
    .block-text {
        font-size: 16px;
        line-height: 1.8;
        color: var(--text-gray);
    }
    
    .block-text p {
        margin-bottom: 20px;
    }
    
    .block-image img {
        width: 100%;
        border-radius: 16px;
        box-shadow: 0 4px 16px rgba(0,0,0,0.1);
    }
    
    .block-video {
        position: relative;
        padding-bottom: 56.25%; /* 16:9 aspect ratio */
        height: 0;
        overflow: hidden;
        border-radius: 16px;
    }
    
    .block-video iframe {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        border-radius: 16px;
    }
    
    .block-button {
        text-align: center;
        margin: 40px 0;
    }
    
    .block-button a {
        display: inline-block;
        padding: 16px 32px;
        background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        color: white;
        text-decoration: none;
        border-radius: 8px;
        font-weight: 700;
        transition: transform 0.2s ease;
    }
    
    .block-button a:hover {
        transform: translateY(-2px);
    }
    
    .block-columns {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
    }
    
    .column {
        background: var(--bg-light);
        padding: 30px;
        border-radius: 16px;
    }
    
    @media (max-width: 768px) {
        .page-hero h1 {
            font-size: 32px;
        }
        
        .page-content {
            padding: 40px 20px;
        }
    }
</style>
@endpush

@section('content')
@php
    $blocks = $page->getBlocks();
    $firstBlockIsHero = !empty($blocks) && ($blocks[0]['type'] ?? '') === 'hero';
@endphp

@if(!$firstBlockIsHero)
    <!-- Page Hero (only show if content doesn't start with hero block) -->
    <section class="page-hero">
        <div class="container">
            <h1>{{ $page->title }}</h1>
            @if($page->meta_description)
                <p>{{ $page->meta_description }}</p>
            @endif
        </div>
    </section>
@endif

<!-- Page Content -->
<section class="page-content" style="{{ $firstBlockIsHero ? 'padding-top: 0;' : '' }}">
    @foreach($page->getBlocks() as $block)
        @php
            $blockType = $block['type'] ?? 'text';
            $blockContent = $block['content'] ?? [];
            $isFullWidth = in_array($blockType, ['hero', 'cta', 'stats']);
        @endphp
        
        @if($isFullWidth)
            {{-- Full-width blocks render without container --}}
        @else
            <div class="container">
        @endif
            
            @switch($blockType)
                @case('hero')
                    <div class="content-block block-hero" style="
                        background: {{ $blockContent['background'] ?? 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)' }}; 
                        color: {{ $blockContent['text_color'] ?? '#ffffff' }}; 
                        padding: 100px 20px; 
                        text-align: center; 
                        margin: 0 0 0 0;
                        width: 100vw;
                        position: relative;
                        left: 50%;
                        right: 50%;
                        margin-left: -50vw;
                        margin-right: -50vw;
                    ">
                        <div style="max-width: 1200px; margin: 0 auto;">
                            <h1 style="font-size: 3em; font-weight: 900; margin-bottom: 20px; line-height: 1.2;">{{ $blockContent['heading'] ?? '' }}</h1>
                            @if(isset($blockContent['subheading']))
                                <p style="font-size: 1.3em; margin-bottom: 30px; line-height: 1.6; opacity: 0.95;">{{ $blockContent['subheading'] }}</p>
                            @endif
                            @if(isset($blockContent['button_text']) && isset($blockContent['button_link']))
                                <a href="{{ $blockContent['button_link'] }}" style="
                                    display: inline-block; 
                                    padding: 16px 40px; 
                                    background: rgba(255,255,255,0.25); 
                                    border: 2px solid white; 
                                    color: white; 
                                    border-radius: 50px; 
                                    text-decoration: none; 
                                    font-weight: 700;
                                    font-size: 1.1em;
                                    transition: all 0.3s ease;
                                    backdrop-filter: blur(10px);
                                ">
                                    {{ $blockContent['button_text'] }}
                                </a>
                            @endif
                        </div>
                    </div>
                    @break
                
                @case('heading')
                    <div class="content-block block-heading">
                        @php
                            $level = $blockContent['level'] ?? 'h2';
                            $align = $blockContent['align'] ?? 'left';
                            $text = $blockContent['text'] ?? '';
                        @endphp
                        <{{ $level }} style="text-align: {{ $align }};">{{ $text }}</{{ $level }}>
                    </div>
                    @break
                
                @case('text')
                    <div class="content-block block-text">
                        {!! $blockContent['html'] ?? ($blockContent['content'] ?? '') !!}
                    </div>
                    @break
                
                @case('image')
                    <div class="content-block block-image">
                        <img src="{{ $blockContent['url'] ?? '' }}" alt="{{ $blockContent['alt'] ?? '' }}">
                        @if(isset($blockContent['caption']))
                            <p style="text-align: center; margin-top: 12px; color: var(--text-gray); font-size: 14px;">
                                {{ $blockContent['caption'] }}
                            </p>
                        @endif
                    </div>
                    @break
                
                @case('features')
                    <div class="content-block block-features">
                        @if(isset($blockContent['heading']))
                            <h2 style="text-align: center; margin-bottom: 30px;">{{ $blockContent['heading'] }}</h2>
                        @endif
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                            @foreach(($blockContent['features'] ?? []) as $feature)
                                <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                                    <div style="font-size: 40px; margin-bottom: 10px;">{{ $feature['icon'] ?? '📦' }}</div>
                                    <h3 style="margin-bottom: 10px;">{{ $feature['title'] ?? 'Feature' }}</h3>
                                    <p style="color: #6c757d;">{{ $feature['description'] ?? '' }}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    @break
                
                @case('stats')
                    <div class="content-block block-stats" style="
                        width: 100vw;
                        position: relative;
                        left: 50%;
                        right: 50%;
                        margin-left: -50vw;
                        margin-right: -50vw;
                        padding: 60px 20px;
                        background: #f8f9fa;
                    ">
                        <div style="max-width: 1200px; margin: 0 auto; display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 40px; text-align: center;">
                            @foreach(($blockContent['stats'] ?? []) as $stat)
                                <div>
                                    <div style="font-size: 48px; font-weight: 900; color: #667eea; margin-bottom: 10px;">{{ $stat['number'] ?? '0' }}</div>
                                    <div style="color: #6c757d; font-size: 16px; font-weight: 600;">{{ $stat['label'] ?? 'Stat' }}</div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    @break
                
                @case('testimonials')
                    <div class="content-block block-testimonials">
                        @if(isset($blockContent['heading']))
                            <h2 style="text-align: center; margin-bottom: 30px;">{{ $blockContent['heading'] }}</h2>
                        @endif
                        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 20px;">
                            @foreach(($blockContent['testimonials'] ?? []) as $testimonial)
                                <div style="background: #f8f9fa; padding: 25px; border-radius: 12px;">
                                    <div style="margin-bottom: 15px;">
                                        <span style="color: #fbbf24;">{{ str_repeat('⭐', $testimonial['rating'] ?? 5) }}</span>
                                    </div>
                                    <p style="color: #4b5563; font-style: italic; margin-bottom: 15px;">"{{ $testimonial['text'] ?? '' }}"</p>
                                    <div style="display: flex; align-items: center; gap: 12px;">
                                        <div style="width: 45px; height: 45px; border-radius: 50%; background: linear-gradient(135deg, #667eea, #764ba2); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">
                                            {{ $testimonial['avatar'] ?? 'A' }}
                                        </div>
                                        <div>
                                            <div style="font-weight: 700;">{{ $testimonial['author'] ?? 'Author' }}</div>
                                            <div style="font-size: 13px; color: #6b7280;">{{ $testimonial['role'] ?? 'Role' }}</div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    @break
                
                @case('cta')
                    <div class="content-block block-cta" style="
                        background: {{ $blockContent['background'] ?? 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)' }}; 
                        color: white; 
                        padding: 80px 20px; 
                        text-align: center;
                        width: 100vw;
                        position: relative;
                        left: 50%;
                        right: 50%;
                        margin-left: -50vw;
                        margin-right: -50vw;
                        margin-top: 40px;
                    ">
                        <div style="max-width: 800px; margin: 0 auto;">
                            <h2 style="font-size: 2.5em; margin-bottom: 20px; font-weight: 900;">{{ $blockContent['heading'] ?? 'Call to Action' }}</h2>
                            @if(isset($blockContent['text']))
                                <p style="font-size: 1.2em; margin-bottom: 30px; opacity: 0.95;">{{ $blockContent['text'] }}</p>
                            @endif
                            @if(isset($blockContent['button_text']) && isset($blockContent['button_link']))
                                <a href="{{ $blockContent['button_link'] }}" style="
                                    display: inline-block; 
                                    padding: 16px 40px; 
                                    background: white; 
                                    color: #667eea; 
                                    border: none; 
                                    border-radius: 50px; 
                                    font-weight: 700;
                                    font-size: 1.1em;
                                    text-decoration: none;
                                    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
                                    transition: all 0.3s ease;
                                ">
                                    {{ $blockContent['button_text'] }}
                                </a>
                            @endif
                        </div>
                    </div>
                    @break
                
                @case('two_column')
                    <div class="content-block block-columns" style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px;">
                        <div style="padding: 20px; background: #f8f9fa; border-radius: 8px;">
                            {!! $blockContent['left']['html'] ?? '' !!}
                        </div>
                        <div style="padding: 20px; background: #f8f9fa; border-radius: 8px;">
                            {!! $blockContent['right']['html'] ?? '' !!}
                        </div>
                    </div>
                    @break
                
                @case('spacer')
                    <div class="content-block block-spacer" style="height: {{ $blockContent['height'] ?? '50px' }};"></div>
                    @break
                
                @case('course_list')
                    <div class="content-block block-course-list">
                        @if(isset($blockContent['heading']))
                            <h2 style="text-align: center; margin-bottom: 15px;">{{ $blockContent['heading'] }}</h2>
                        @endif
                        @if(isset($blockContent['description']))
                            <p style="text-align: center; color: #6c757d; margin-bottom: 30px;">{{ $blockContent['description'] }}</p>
                        @endif
                        <div style="padding: 30px; background: white; border: 2px dashed #dee2e6; border-radius: 8px; text-align: center;">
                            <i class="fas fa-graduation-cap" style="font-size: 48px; color: #667eea; margin-bottom: 10px;"></i>
                            <p style="color: #6c757d;">Course list will be dynamically loaded</p>
                        </div>
                    </div>
                    @break
                
                @case('video')
                    <div class="content-block block-video">
                        @if(isset($blockContent['embed']))
                            {!! $blockContent['embed'] !!}
                        @elseif(isset($blockContent['url']))
                            <iframe src="{{ $blockContent['url'] }}" frameborder="0" allowfullscreen></iframe>
                        @endif
                    </div>
                    @break
                
                @case('button')
                    <div class="content-block block-button">
                        <a href="{{ $blockContent['url'] ?? '#' }}" 
                           @if(($blockContent['new_tab'] ?? false)) target="_blank" rel="noopener noreferrer" @endif>
                            {{ $blockContent['text'] ?? 'Click Here' }}
                        </a>
                    </div>
                    @break
                
                @case('columns')
                    <div class="content-block block-columns">
                        @foreach(($blockContent['columns'] ?? []) as $column)
                            <div class="column">
                                {!! $column['content'] ?? '' !!}
                            </div>
                        @endforeach
                    </div>
                    @break
                
                @case('html')
                    <div class="content-block">
                        {!! $blockContent['content'] ?? '' !!}
                    </div>
                    @break
                
                @default
                    <!-- Unknown block type: {{ $blockType }} -->
            @endswitch
            
            @if(!$isFullWidth)
                </div>{{-- Close container for regular blocks --}}
            @endif
        @endforeach
        
        @if(empty($page->getBlocks()))
            <div class="container">
                <div class="content-block block-text">
                    <p>No content available.</p>
                </div>
            </div>
        @endif
</section>
@endsection
