@extends('layouts.public')

@section('title', 'Privacy Policy - EE Micro LMS')
@section('meta_description', 'Learn how we collect, use, and protect your personal information.')

@push('styles')
<style>
    .page-hero {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 80px 0;
        text-align: center;
    }
    
    .page-hero h1 {
        font-size: 48px;
        font-weight: 900;
        margin-bottom: 20px;
    }
    
    .page-hero p {
        font-size: 18px;
        opacity: 0.9;
    }
    
    .legal-content {
        padding: 80px 0;
        max-width: 900px;
        margin: 0 auto;
    }
    
    .legal-content h2 {
        font-size: 28px;
        font-weight: 800;
        margin-top: 40px;
        margin-bottom: 20px;
        color: var(--text-dark);
    }
    
    .legal-content h3 {
        font-size: 20px;
        font-weight: 700;
        margin-top: 30px;
        margin-bottom: 15px;
        color: var(--text-dark);
    }
    
    .legal-content p {
        font-size: 16px;
        line-height: 1.8;
        color: var(--text-gray);
        margin-bottom: 20px;
    }
    
    .legal-content ul, 
    .legal-content ol {
        margin-bottom: 20px;
        padding-left: 30px;
    }
    
    .legal-content li {
        font-size: 16px;
        line-height: 1.8;
        color: var(--text-gray);
        margin-bottom: 10px;
    }
    
    .legal-content strong {
        color: var(--text-dark);
        font-weight: 700;
    }
    
    .last-updated {
        background: var(--bg-light);
        padding: 20px;
        border-radius: 12px;
        margin-bottom: 40px;
        border-left: 4px solid var(--primary-color);
    }
    
    .last-updated p {
        margin: 0;
        font-weight: 600;
    }
    
    .highlight-box {
        background: #f0f9ff;
        border-left: 4px solid var(--primary-color);
        padding: 20px;
        margin: 30px 0;
        border-radius: 8px;
    }
    
    .highlight-box h4 {
        font-size: 18px;
        font-weight: 700;
        margin-bottom: 12px;
        color: var(--text-dark);
    }
    
    @media (max-width: 768px) {
        .page-hero h1 {
            font-size: 32px;
        }
        
        .legal-content {
            padding: 40px 20px;
        }
    }
</style>
@endpush

@section('content')
<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <h1>Privacy Policy</h1>
        <p>Your privacy is important to us</p>
    </div>
</section>

<!-- Legal Content -->
<section class="legal-content">
    <div class="container">
        <div class="last-updated">
            <p><strong>Last Updated:</strong> January 1, 2025</p>
        </div>
        
        <div class="highlight-box">
            <h4><i class="fas fa-shield-alt"></i> Your Privacy Matters</h4>
            <p>EE Micro LMS is committed to protecting your privacy and ensuring the security of your personal information. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our platform.</p>
        </div>
        
        <h2>1. Information We Collect</h2>
        
        <h3>1.1 Personal Information</h3>
        <p>We collect information that you provide directly to us, including:</p>
        <ul>
            <li><strong>Account Information:</strong> Name, email address, username, password, and profile information</li>
            <li><strong>Payment Information:</strong> Billing address and payment method details (processed securely through third-party payment processors)</li>
            <li><strong>Profile Data:</strong> Educational background, interests, profile picture, and bio</li>
            <li><strong>Communications:</strong> Messages, reviews, forum posts, and support inquiries</li>
        </ul>
        
        <h3>1.2 Automatically Collected Information</h3>
        <p>When you use our platform, we automatically collect certain information:</p>
        <ul>
            <li><strong>Device Information:</strong> IP address, browser type, operating system, and device identifiers</li>
            <li><strong>Usage Data:</strong> Pages visited, courses accessed, time spent on platform, and interaction patterns</li>
            <li><strong>Location Data:</strong> General geographic location based on IP address</li>
            <li><strong>Cookies and Tracking:</strong> Information collected through cookies, web beacons, and similar technologies</li>
        </ul>
        
        <h3>1.3 Learning Data</h3>
        <p>We collect data related to your learning activities:</p>
        <ul>
            <li>Course enrollment and completion status</li>
            <li>Quiz and assignment submissions and scores</li>
            <li>Video watch progress and engagement metrics</li>
            <li>Course ratings and reviews</li>
            <li>Certificates earned</li>
        </ul>
        
        <h2>2. How We Use Your Information</h2>
        
        <p>We use the information we collect for the following purposes:</p>
        
        <h3>2.1 Provide and Improve Services</h3>
        <ul>
            <li>Create and manage your account</li>
            <li>Process course enrollments and payments</li>
            <li>Deliver course content and educational materials</li>
            <li>Track your learning progress and issue certificates</li>
            <li>Provide customer support and respond to inquiries</li>
            <li>Improve platform functionality and user experience</li>
        </ul>
        
        <h3>2.2 Communication</h3>
        <ul>
            <li>Send important updates about courses and platform changes</li>
            <li>Provide course recommendations based on your interests</li>
            <li>Send promotional materials and special offers (with your consent)</li>
            <li>Respond to your comments and questions</li>
        </ul>
        
        <h3>2.3 Analytics and Research</h3>
        <ul>
            <li>Analyze platform usage and learning patterns</li>
            <li>Conduct research to improve educational outcomes</li>
            <li>Generate aggregate statistics and insights</li>
            <li>Monitor platform performance and security</li>
        </ul>
        
        <h3>2.4 Legal and Security</h3>
        <ul>
            <li>Prevent fraud and unauthorized access</li>
            <li>Comply with legal obligations</li>
            <li>Enforce our Terms and Conditions</li>
            <li>Protect the rights and safety of our users</li>
        </ul>
        
        <h2>3. Information Sharing and Disclosure</h2>
        
        <p>We do not sell your personal information. We may share your information in the following circumstances:</p>
        
        <h3>3.1 With Your Consent</h3>
        <p>We share information with third parties when you give us explicit permission to do so.</p>
        
        <h3>3.2 Service Providers</h3>
        <p>We share information with vendors who provide services on our behalf, including:</p>
        <ul>
            <li>Payment processors (Stripe, PayPal)</li>
            <li>Email service providers</li>
            <li>Cloud hosting providers</li>
            <li>Analytics services</li>
            <li>Customer support tools</li>
        </ul>
        
        <h3>3.3 Course Instructors</h3>
        <p>Course instructors have access to anonymized or aggregated data about student performance and engagement in their courses.</p>
        
        <h3>3.4 Legal Requirements</h3>
        <p>We may disclose information if required by law or in response to valid legal requests from government authorities.</p>
        
        <h3>3.5 Business Transfers</h3>
        <p>In the event of a merger, acquisition, or sale of assets, your information may be transferred to the acquiring entity.</p>
        
        <h2>4. Data Security</h2>
        
        <p>We implement industry-standard security measures to protect your information:</p>
        <ul>
            <li><strong>Encryption:</strong> All data transmitted between your device and our servers is encrypted using SSL/TLS</li>
            <li><strong>Secure Storage:</strong> Personal data is stored on secure servers with restricted access</li>
            <li><strong>Access Controls:</strong> We limit access to personal information to authorized personnel only</li>
            <li><strong>Regular Audits:</strong> We conduct regular security assessments and updates</li>
            <li><strong>Password Protection:</strong> Passwords are hashed and salted using industry-standard algorithms</li>
        </ul>
        
        <div class="highlight-box">
            <h4><i class="fas fa-exclamation-triangle"></i> Important Notice</h4>
            <p>While we implement strong security measures, no method of transmission over the internet is 100% secure. We cannot guarantee absolute security of your information.</p>
        </div>
        
        <h2>5. Your Rights and Choices</h2>
        
        <h3>5.1 Access and Update</h3>
        <p>You can access and update your account information at any time through your profile settings.</p>
        
        <h3>5.2 Data Portability</h3>
        <p>You have the right to request a copy of your personal data in a portable format.</p>
        
        <h3>5.3 Deletion</h3>
        <p>You can request deletion of your account and personal data by contacting us. Note that some information may be retained for legal or legitimate business purposes.</p>
        
        <h3>5.4 Marketing Communications</h3>
        <p>You can opt out of promotional emails by clicking the "unsubscribe" link in any marketing email or by updating your communication preferences.</p>
        
        <h3>5.5 Cookies</h3>
        <p>You can control cookies through your browser settings. However, disabling cookies may affect platform functionality.</p>
        
        <h3>5.6 Do Not Track</h3>
        <p>We currently do not respond to Do Not Track (DNT) signals from web browsers.</p>
        
        <h2>6. Children's Privacy</h2>
        
        <p>Our platform is not intended for children under 13 years of age. We do not knowingly collect personal information from children under 13. If you are a parent or guardian and believe your child has provided us with personal information, please contact us immediately.</p>
        
        <h2>7. International Data Transfers</h2>
        
        <p>Your information may be transferred to and processed in countries other than your country of residence. We ensure appropriate safeguards are in place to protect your information in accordance with this Privacy Policy.</p>
        
        <h3>7.1 GDPR Compliance (for EU Users)</h3>
        <p>If you are located in the European Economic Area (EEA), you have additional rights under the General Data Protection Regulation (GDPR):</p>
        <ul>
            <li>Right to access your personal data</li>
            <li>Right to rectification of inaccurate data</li>
            <li>Right to erasure ("right to be forgotten")</li>
            <li>Right to restrict processing</li>
            <li>Right to data portability</li>
            <li>Right to object to processing</li>
            <li>Right to withdraw consent</li>
            <li>Right to lodge a complaint with a supervisory authority</li>
        </ul>
        
        <h2>8. Cookies and Tracking Technologies</h2>
        
        <p>We use cookies and similar tracking technologies to enhance your experience:</p>
        
        <h3>8.1 Types of Cookies</h3>
        <ul>
            <li><strong>Essential Cookies:</strong> Required for platform functionality</li>
            <li><strong>Performance Cookies:</strong> Help us understand how users interact with the platform</li>
            <li><strong>Functional Cookies:</strong> Remember your preferences and settings</li>
            <li><strong>Marketing Cookies:</strong> Used to deliver relevant advertisements</li>
        </ul>
        
        <h3>8.2 Third-Party Cookies</h3>
        <p>We use third-party services (such as Google Analytics) that may set their own cookies. Please refer to their privacy policies for more information.</p>
        
        <h2>9. Data Retention</h2>
        
        <p>We retain your personal information for as long as necessary to:</p>
        <ul>
            <li>Provide our services to you</li>
            <li>Comply with legal obligations</li>
            <li>Resolve disputes</li>
            <li>Enforce our agreements</li>
        </ul>
        
        <p>After you close your account, we may retain certain information for legitimate business purposes or as required by law.</p>
        
        <h2>10. Changes to This Privacy Policy</h2>
        
        <p>We may update this Privacy Policy from time to time. We will notify you of any material changes by:</p>
        <ul>
            <li>Posting the new Privacy Policy on this page</li>
            <li>Updating the "Last Updated" date</li>
            <li>Sending you an email notification (for significant changes)</li>
        </ul>
        
        <p>We encourage you to review this Privacy Policy periodically to stay informed about how we protect your information.</p>
        
        <h2>11. Contact Us</h2>
        
        <p>If you have questions, concerns, or requests regarding this Privacy Policy or our data practices, please contact us:</p>
        
        <div class="highlight-box">
            <ul style="list-style: none; padding: 0;">
                <li><i class="fas fa-envelope"></i> <strong>Email:</strong> privacy@eemicrolms.com</li>
                <li><i class="fas fa-phone"></i> <strong>Phone:</strong> +1 (555) 123-4567</li>
                <li><i class="fas fa-map-marker-alt"></i> <strong>Address:</strong> 123 Learning Street, San Francisco, CA 94102, United States</li>
            </ul>
        </div>
        
        <h2>12. California Privacy Rights (CCPA)</h2>
        
        <p>If you are a California resident, you have additional rights under the California Consumer Privacy Act (CCPA):</p>
        <ul>
            <li>Right to know what personal information is collected</li>
            <li>Right to know if personal information is sold or disclosed</li>
            <li>Right to say no to the sale of personal information</li>
            <li>Right to access your personal information</li>
            <li>Right to request deletion of personal information</li>
            <li>Right to equal service and price</li>
        </ul>
        
        <p>To exercise these rights, please contact us using the information provided above. We will respond to your request within 45 days.</p>
    </div>
</section>
@endsection
