@extends('layouts.public')

@section('title', 'EntrepreneurEducation - Future of Entrepreneur Training')
@section('meta_description', 'Get Simple, Easy, Enjoyable & Accessible education for entrepreneurs. Digital products, AI tools, and innovative learning for the next generation.')

@push('styles')
<style>
    :root {
        --ee-purple: #7c3aed;
        --ee-cyan: #06b6d4;
        --ee-dark: #0f172a;
        --ee-light: #f8fafc;
        --ee-glass: rgba(255, 255, 255, 0.08);
        --ee-glow: rgba(124, 58, 237, 0.3);
        --ee-bg: #f8fafc;
        --ee-card: #ffffff;
    }
    
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }
    
    body {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        background: var(--ee-bg);
        color: #334155;
        overflow-x: hidden;
    }
    
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 24px;
    }
    
    /* HERO SECTION - GenZ Style */
    .hero-section {
        min-height: 90vh;
        position: relative;
        overflow: hidden;
        padding: 80px 0;
        background: 
            radial-gradient(circle at 20% 50%, rgba(124, 58, 237, 0.05) 0%, transparent 50%),
            radial-gradient(circle at 80% 20%, rgba(6, 182, 212, 0.05) 0%, transparent 50%),
            linear-gradient(180deg, #f8fafc 0%, #f1f5f9 100%);
    }
    
    .hero-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 64px;
        align-items: center;
    }
    
    .hero-content h1 {
        font-size: 3.5rem;
        font-weight: 900;
        line-height: 1.1;
        margin-bottom: 20px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .hero-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: white;
        padding: 12px 20px;
        border-radius: 100px;
        border: 1px solid #e2e8f0;
        margin-bottom: 24px;
        font-weight: 600;
        animation: float 3s ease-in-out infinite;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        color: var(--ee-purple);
    }
    
    @keyframes float {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-8px); }
    }
    
    .hero-tagline {
        font-size: 1.25rem;
        color: #64748b;
        margin-bottom: 40px;
        line-height: 1.6;
    }
    
    .cta-buttons {
        display: flex;
        gap: 16px;
        flex-wrap: wrap;
    }
    
    .cta-primary {
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        color: white;
        padding: 16px 32px;
        border-radius: 12px;
        font-weight: 700;
        border: none;
        cursor: pointer;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        font-size: 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        text-decoration: none;
        text-align: center;
    }
    
    .cta-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 20px 40px rgba(124, 58, 237, 0.2);
    }
    
    .cta-secondary {
        background: white;
        color: var(--ee-purple);
        padding: 16px 32px;
        border-radius: 12px;
        font-weight: 700;
        border: 2px solid #e2e8f0;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        text-align: center;
    }
    
    .cta-secondary:hover {
        border-color: var(--ee-purple);
        background: rgba(124, 58, 237, 0.05);
    }
    
    .hero-visual {
        position: relative;
    }
    
    .visual-card {
        background: white;
        border-radius: 24px;
        padding: 32px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.08);
        transform: perspective(1000px) rotateY(-15deg);
        transition: transform 0.5s ease;
    }
    
    .visual-card:hover {
        transform: perspective(1000px) rotateY(0deg);
    }
    
    .service-pill {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: rgba(6, 182, 212, 0.1);
        padding: 8px 16px;
        border-radius: 100px;
        margin-bottom: 24px;
        font-weight: 600;
        color: var(--ee-cyan);
    }
    
    .service-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px;
        margin-top: 24px;
    }
    
    .service-item {
        background: #f8fafc;
        padding: 20px;
        border-radius: 12px;
        border-left: 4px solid var(--ee-purple);
        transition: transform 0.3s ease;
    }
    
    .service-item:hover {
        transform: translateY(-4px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
    }
    
    .service-item h4 {
        font-size: 1rem;
        margin-bottom: 8px;
        color: #1e293b;
    }
    
    .service-item p {
        font-size: 0.875rem;
        color: #64748b;
        line-height: 1.5;
    }
    
    /* VALUES SECTION */
    .values-section {
        padding: 80px 0;
        position: relative;
        background: white;
    }
    
    .section-title {
        text-align: center;
        margin-bottom: 48px;
    }
    
    .section-title h2 {
        font-size: 2.5rem;
        font-weight: 900;
        margin-bottom: 16px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .section-subtitle {
        font-size: 1.125rem;
        color: #64748b;
        max-width: 600px;
        margin: 0 auto;
    }
    
    .values-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 24px;
    }
    
    .value-card {
        background: white;
        border-radius: 20px;
        padding: 32px;
        border: 1px solid #e2e8f0;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.03);
    }
    
    .value-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, var(--ee-purple), var(--ee-cyan));
        border-radius: 4px 4px 0 0;
    }
    
    .value-card:hover {
        transform: translateY(-8px);
        border-color: rgba(124, 58, 237, 0.3);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.08);
    }
    
    .value-icon {
        width: 56px;
        height: 56px;
        border-radius: 16px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 24px;
        font-size: 24px;
        color: white;
    }
    
    .value-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 16px;
        color: #1e293b;
    }
    
    .value-desc {
        color: #64748b;
        line-height: 1.6;
    }
    
    /* TRAINING TRACKS - Updated to 4 cards */
    .tracks-section {
        padding: 80px 0;
        background: #f8fafc;
    }
    
    .tracks-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 24px;
        margin-bottom: 48px;
    }
    
    .track-card {
        background: white;
        border-radius: 16px;
        padding: 32px;
        border: 2px solid #e2e8f0;
        transition: all 0.3s ease;
        text-align: center;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.03);
    }
    
    .track-card:hover {
        border-color: var(--ee-purple);
        background: rgba(124, 58, 237, 0.02);
        transform: translateY(-4px);
    }
    
    .track-acronym {
        font-size: 2.5rem;
        font-weight: 900;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 16px;
    }
    
    .track-name {
        font-size: 1.25rem;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 8px;
    }
    
    .track-desc {
        color: #64748b;
        font-size: 0.875rem;
        line-height: 1.5;
    }
    
    /* SEPARATE RBET SECTION */
    .rbet-section {
        padding: 60px;
        background: linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
        border-radius: 24px;
        text-align: center;
        color: white;
        position: relative;
        overflow: hidden;
    }
    
    .rbet-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 30% 70%, rgba(124, 58, 237, 0.15) 0%, transparent 50%),
            radial-gradient(circle at 70% 30%, rgba(6, 182, 212, 0.15) 0%, transparent 50%);
    }
    
    .rbet-content {
        position: relative;
        z-index: 2;
    }
    
    .rbet-content h2 {
        font-size: 2.5rem;
        font-weight: 900;
        margin-bottom: 16px;
        color: white;
    }
    
    .rbet-acronym {
        font-size: 3rem;
        font-weight: 900;
        background: linear-gradient(135deg, #f59e0b, #fbbf24);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 8px;
    }
    
    .rbet-full {
        font-size: 1.5rem;
        margin-bottom: 16px;
        color: white;
        font-weight: 700;
    }
    
    .rbet-desc {
        color: #cbd5e1;
        font-size: 1.125rem;
        max-width: 600px;
        margin: 0 auto;
        line-height: 1.6;
    }
    
    /* PROCESS SECTION - 3 P's */
    .process-section {
        padding: 80px 0;
        background: white;
        position: relative;
        overflow: hidden;
    }
    
    .process-section::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 50%;
        height: 100%;
        background: linear-gradient(135deg, rgba(124, 58, 237, 0.02) 0%, rgba(6, 182, 212, 0.02) 100%);
    }
    
    .process-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 32px;
        position: relative;
        z-index: 2;
    }
    
    .process-card {
        background: white;
        border-radius: 20px;
        padding: 40px;
        border: 2px solid #e2e8f0;
        transition: all 0.4s ease;
        position: relative;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.03);
    }
    
    .process-card::before {
        content: '';
        position: absolute;
        top: -2px;
        left: -2px;
        right: -2px;
        bottom: -2px;
        border-radius: 20px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        opacity: 0;
        transition: opacity 0.4s ease;
        z-index: -1;
    }
    
    .process-card:hover::before {
        opacity: 1;
    }
    
    .process-card:hover {
        transform: translateY(-8px);
        border-color: transparent;
        box-shadow: 0 20px 40px rgba(124, 58, 237, 0.15);
    }
    
    .process-number {
        width: 64px;
        height: 64px;
        border-radius: 16px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 24px;
        font-size: 28px;
        font-weight: 900;
        color: white;
        box-shadow: 0 8px 20px rgba(124, 58, 237, 0.3);
    }
    
    .process-title {
        font-size: 1.75rem;
        font-weight: 800;
        margin-bottom: 16px;
        color: #1e293b;
    }
    
    .process-desc {
        color: #64748b;
        line-height: 1.7;
        margin-bottom: 20px;
    }
    
    .process-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .process-list li {
        display: flex;
        align-items: flex-start;
        gap: 12px;
        margin-bottom: 12px;
        color: #475569;
        font-size: 0.95rem;
    }
    
    .process-list li::before {
        content: '✓';
        color: var(--ee-cyan);
        font-weight: 700;
        font-size: 1.25rem;
        flex-shrink: 0;
    }
    
    /* PRODUCTS SECTION */
    .products-section {
        padding: 80px 0;
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    }
    
    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 24px;
    }
    
    .product-card {
        background: white;
        border-radius: 16px;
        padding: 32px;
        border: 1px solid #e2e8f0;
        transition: all 0.3s ease;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.03);
    }
    
    .product-card:hover {
        transform: translateY(-6px);
        box-shadow: 0 16px 40px rgba(0, 0, 0, 0.1);
        border-color: var(--ee-purple);
    }
    
    .product-icon {
        width: 56px;
        height: 56px;
        border-radius: 12px;
        background: linear-gradient(135deg, rgba(124, 58, 237, 0.1), rgba(6, 182, 212, 0.1));
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 20px;
        font-size: 28px;
    }
    
    .product-title {
        font-size: 1.25rem;
        font-weight: 700;
        margin-bottom: 12px;
        color: #1e293b;
    }
    
    .product-desc {
        color: #64748b;
        line-height: 1.6;
        font-size: 0.95rem;
    }
    
    /* CTA BANNER - UPDATED FOR CENTERED BUTTON */
    .cta-banner {
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        padding: 80px 0;
        text-align: center;
        position: relative;
        overflow: hidden;
    }
    
    .cta-banner::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 30% 70%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
            radial-gradient(circle at 70% 30%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
    }
    
    .cta-content {
        position: relative;
        z-index: 2;
        max-width: 800px;
        margin: 0 auto;
        text-align: center;
    }
    
    .cta-content h2 {
        font-size: 2.5rem;
        font-weight: 900;
        margin-bottom: 24px;
        color: white;
    }
    
    .cta-content p {
        font-size: 1.25rem;
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 40px;
    }
    
    .cta-button-container {
        display: flex;
        justify-content: center;
        margin-bottom: 32px;
    }
    
    .cta-button {
        display: inline-flex;
        align-items: center;
        gap: 12px;
        background: white;
        color: var(--ee-purple);
        padding: 20px 48px;
        border-radius: 100px;
        font-weight: 800;
        font-size: 1.125rem;
        text-decoration: none;
        transition: all 0.3s ease;
        border: 2px solid transparent;
        text-align: center;
    }
    
    .cta-button:hover {
        background: transparent;
        color: white;
        border-color: white;
        transform: translateY(-3px) scale(1.05);
        box-shadow: 0 15px 40px rgba(255, 255, 255, 0.1);
    }
    
    .cta-warning {
        display: inline-flex;
        align-items: center;
        gap: 12px;
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(10px);
        padding: 16px 28px;
        border-radius: 100px;
        font-weight: 700;
        color: white;
        border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    /* RESPONSIVE DESIGN */
    @media (max-width: 1024px) {
        .hero-grid {
            grid-template-columns: 1fr;
            gap: 48px;
        }
        
        .hero-content h1 {
            font-size: 2.75rem;
        }
        
        .visual-card {
            transform: none;
        }
    }
    
    @media (max-width: 768px) {
        .hero-content h1 {
            font-size: 2.25rem;
        }
        
        .section-title h2 {
            font-size: 2rem;
        }
        
        .cta-buttons {
            flex-direction: column;
        }
        
        .service-grid {
            grid-template-columns: 1fr;
        }
        
        .tracks-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        
        .process-grid {
            grid-template-columns: 1fr;
        }
        
        .rbet-section {
            padding: 40px 24px;
        }
        
        .cta-button {
            padding: 16px 32px;
            font-size: 1rem;
        }
    }
    
    @media (max-width: 480px) {
        .hero-content h1 {
            font-size: 2rem;
        }
        
        .section-title h2 {
            font-size: 1.75rem;
        }
        
        .value-card,
        .track-card {
            padding: 24px;
        }
        
        .tracks-grid {
            grid-template-columns: 1fr;
        }
        
        .process-grid {
            grid-template-columns: 1fr;
        }
        
        .cta-button {
            width: 100%;
            justify-content: center;
        }
    }
</style>
@endpush

@section('content')
<!-- HERO SECTION -->
<section class="hero-section">
    <div class="container">
        <div class="hero-grid">
            <div class="hero-content">
                <div class="hero-badge">
                    <span>🚀</span> <span>ENTREPRENEUREDUCATION INDUCTION 2025</span>
                </div>
                
                <h1>Future Entrepreneurs Start Here</h1>
                
                <p class="hero-tagline">
                    Where innovation meets excellence. We specialize in digital products that make learning 
                    <span style="color: var(--ee-cyan); font-weight: 700;">Simple</span>, 
                    <span style="color: var(--ee-purple); font-weight: 700;">Easy</span>, 
                    <span style="color: #f59e0b; font-weight: 700;">Enjoyable</span>, and 
                    <span style="color: #10b981; font-weight: 700;">Accessible</span>.
                </p>
                
                <div class="cta-buttons">
                    <a href="https://induction.entreprenreducation.com/learn/course/41" class="cta-primary">
                        <span>Start Your Free Induction</span>
                        <span>→</span>
                    </a>
                    <a href="{{ asset('assets/Entreprenr Education Induction 2025.pdf') }}" class="cta-secondary" download="EntrepreneurEducation_Induction_2025.pdf" target="_blank">
                        <span>📥 Download Induction PDF</span>
                    </a>
                </div>
            </div>
            
            <div class="hero-visual">
                <div class="visual-card">
                    <div class="service-pill">
                        <span>🔥</span>
                        <span>2 CORE SERVICES</span>
                    </div>
                    
                    <h3 style="font-size: 1.5rem; margin-bottom: 16px; color: #1e293b;">
                        Digital-First Entrepreneur Training
                    </h3>
                    
                    <div class="service-grid">
                        <div class="service-item">
                            <h4>🎓 Education Training</h4>
                            <p>Webinars, courses & certifications from top experts</p>
                        </div>
                        <div class="service-item">
                            <h4>🤖 Business AI Tools</h4>
                            <p>Cutting-edge AI solutions to streamline operations</p>
                        </div>
                        <div class="service-item">
                            <h4>🌐 Digital Products</h4>
                            <p>Accessible anywhere, anytime for all entrepreneurs</p>
                        </div>
                        <div class="service-item">
                            <h4>📈 Master Business Skills</h4>
                            <p>Advanced growth strategies and practical implementation</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CORE VALUES -->
<section class="values-section">
    <div class="container">
        <div class="section-title">
            <h2>Why We're Different</h2>
            <p class="section-subtitle">Built for the next generation of entrepreneurs</p>
        </div>
        
        <div class="values-grid">
            <div class="value-card">
                <div class="value-icon">🚀</div>
                <h3 class="value-title">S.E.A Philosophy</h3>
                <p class="value-desc">
                    We make education <strong>Simple</strong> by organizing it systematically, 
                    <strong>Easy & Enjoyable</strong> to enhance learning, and <strong>Accessible</strong> 
                    online anytime, anywhere.
                </p>
            </div>
            
            <div class="value-card">
                <div class="value-icon">💎</div>
                <h3 class="value-title">E.A.R.T.H Culture</h3>
                <p class="value-desc">
                    <strong>Entrepreneurial</strong>, <strong>Aware</strong>, <strong>Responsive</strong>, 
                    <strong>Transparent</strong>, and <strong>Honest</strong>. We build from the ground up.
                </p>
            </div>
            
            <div class="value-card">
                <div class="value-icon">⚡</div>
                <h3 class="value-title">Digital First</h3>
                <p class="value-desc">
                    Everything we create is designed for the digital age: webinars, 
                    AI tools, video courses, and interactive learning experiences.
                </p>
            </div>
            
            <div class="value-card">
                <div class="value-icon">🌍</div>
                <h3 class="value-title">Global Access</h3>
                <p class="value-desc">
                    No barriers. Learn from anywhere in the world with just an 
                    internet connection. Built for remote-first entrepreneurs.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- PRODUCTS SECTION -->
<section class="products-section">
    <div class="container">
        <div class="section-title">
            <h2>What We Offer</h2>
            <p class="section-subtitle">Comprehensive resources for every entrepreneur</p>
        </div>
        
        <div class="products-grid">
            <div class="product-card">
                <div class="product-icon">🎙️</div>
                <h3 class="product-title">FREE Webinars</h3>
                <p class="product-desc">
                    Expert-led sessions on Mindset, Health & Healing, and Fitness & Strengths. 
                    Accessible to everyone, anytime.
                </p>
            </div>
            
            <div class="product-card">
                <div class="product-icon">🎧</div>
                <h3 class="product-title">Audio Content</h3>
                <p class="product-desc">
                    Curated audio programs from EntrepreneurEducation and trusted partners. 
                    Learn on the go.
                </p>
            </div>
            
            <div class="product-card">
                <div class="product-icon">🎥</div>
                <h3 class="product-title">Video Training</h3>
                <p class="product-desc">
                    High-quality video courses covering business, personal development, 
                    and entrepreneurship skills.
                </p>
            </div>
            
            <div class="product-card">
                <div class="product-icon">📚</div>
                <h3 class="product-title">eBooks Library</h3>
                <p class="product-desc">
                    Extensive collection of downloadable eBooks from EntrepreneurEducation 
                    and partner publishers.
                </p>
            </div>
            
            <div class="product-card">
                <div class="product-icon">🎓</div>
                <h3 class="product-title">Training Courses</h3>
                <p class="product-desc">
                    Structured digital courses with certifications. Master specific skills 
                    at your own pace.
                </p>
            </div>
            
            <div class="product-card">
                <div class="product-icon">🏆</div>
                <h3 class="product-title">Scholarships</h3>
                <p class="product-desc">
                    Free training opportunities for qualified students. Invest in your 
                    future with zero barriers.
                </p>
            </div>
            
            <div class="product-card">
                <div class="product-icon">💎</div>
                <h3 class="product-title">Membership</h3>
                <p class="product-desc">
                    Exclusive paid membership with premium content, community access, 
                    and special benefits.
                </p>
            </div>
            
            <div class="product-card">
                <div class="product-icon">🤖</div>
                <h3 class="product-title">Business AI Tools</h3>
                <p class="product-desc">
                    Cutting-edge AI solutions to automate, optimize, and scale your 
                    entrepreneurial ventures.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- TRAINING TRACKS (4 CARDS) -->
<section class="tracks-section">
    <div class="container">
        <div class="section-title">
            <h2>Specialized Training Tracks</h2>
            <p class="section-subtitle">Choose your path to entrepreneurial mastery</p>
        </div>
        
        <div class="tracks-grid">
            <div class="track-card">
                <div class="track-acronym">SET</div>
                <h3 class="track-name">Spiritual Entrepreneur Training</h3>
                <p class="track-desc">Align your business with purpose and mindfulness</p>
            </div>
            
            <div class="track-card">
                <div class="track-acronym">PDT</div>
                <h3 class="track-name">Personal Development Training</h3>
                <p class="track-desc">Build mindset, health, fitness, and personal growth</p>
            </div>
            
            <div class="track-card">
                <div class="track-acronym">BET</div>
                <h3 class="track-name">Business Entrepreneur Training</h3>
                <p class="track-desc">Master business skills and growth strategies</p>
            </div>
            
            <div class="track-card">
                <div class="track-acronym">Crypto</div>
                <h3 class="track-name">Cryptocurrency Training</h3>
                <p class="track-desc">Learn blockchain and crypto investment strategies</p>
            </div>
        </div>
        
        <!-- SEPARATE RBET SECTION -->
        <div class="rbet-section">
            <div class="rbet-content">
                <div class="rbet-acronym">RBET</div>
                <h2 class="rbet-full">Religious Business Entrepreneur Training</h2>
                <p class="rbet-desc">
                    A unique program that integrates faith principles with entrepreneurial success. 
                    Designed for those who want to build businesses aligned with their spiritual values 
                    and create meaningful impact in their communities.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- PROCESS SECTION - 3 P's (Promote, Produce, Provide) -->
<section class="process-section">
    <div class="container">
        <div class="section-title">
            <h2>Our Proven Process</h2>
            <p class="section-subtitle">The 3 P's that power entrepreneurial excellence</p>
        </div>
        
        <div class="process-grid">
            <div class="process-card">
                <div class="process-number">1</div>
                <h3 class="process-title">Promote</h3>
                <p class="process-desc">
                    We inspire entrepreneurs with FREE webinars and video clips that showcase 
                    what's possible in your entrepreneurial journey.
                </p>
                <ul class="process-list">
                    <li>Free webinars from top experts</li>
                    <li>Engaging video content</li>
                    <li>Organic lead generation</li>
                    <li>Brand awareness campaigns</li>
                </ul>
            </div>
            
            <div class="process-card">
                <div class="process-number">2</div>
                <h3 class="process-title">Produce</h3>
                <p class="process-desc">
                    We create premium training courses, video packages, and eBooks that deliver 
                    real value and actionable knowledge.
                </p>
                <ul class="process-list">
                    <li>Comprehensive training courses</li>
                    <li>High-quality video packages</li>
                    <li>Downloadable eBooks & resources</li>
                    <li>Partner products integration</li>
                </ul>
            </div>
            
            <div class="process-card">
                <div class="process-number">3</div>
                <h3 class="process-title">Provide</h3>
                <p class="process-desc">
                    We deliver a systematic, organized platform to teach, train, and develop 
                    entrepreneurs for lasting success.
                </p>
                <ul class="process-list">
                    <li>Structured learning paths</li>
                    <li>Progress tracking & certificates</li>
                    <li>Scholarship opportunities</li>
                    <li>Exclusive membership benefits</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- FINAL CTA - UPDATED WITH CENTERED BUTTON -->
<section class="cta-banner">
    <div class="container">
        <div class="cta-content">
            <h2>Ready to Transform?</h2>
            <p>
                Join thousands of entrepreneurs who have transformed their skills, 
                businesses, and lives with EntrepreneurEducation. The future of 
                entrepreneurship starts here.
            </p>
            
            <div class="cta-button-container">
                <a href="https://induction.entreprenreducation.com/learn/course/41" class="cta-button">
                    <span>Start Your Free Induction Now</span>
                    <span>🚀</span>
                </a>
            </div>
            
            <div class="cta-warning">
                <span>⚠️</span>
                <span>Pay close attention - you will be tested on the content</span>
            </div>
        </div>
    </div>
</section>

<script>
    // Add micro-interactions
    document.addEventListener('DOMContentLoaded', function() {
        // Add hover effect to value cards
        const valueCards = document.querySelectorAll('.value-card, .track-card, .service-item');
        valueCards.forEach(card => {
            card.addEventListener('mouseenter', () => {
                card.style.transform = 'translateY(-8px)';
            });
            card.addEventListener('mouseleave', () => {
                card.style.transform = 'translateY(0)';
            });
        });
        
        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
        
        // Parallax effect for hero background
        window.addEventListener('scroll', () => {
            const scrolled = window.pageYOffset;
            const heroSection = document.querySelector('.hero-section');
            if (heroSection) {
                heroSection.style.backgroundPositionY = `${scrolled * 0.5}px`;
            }
        });
        
        // Add click handlers for CTA buttons
        document.querySelectorAll('.cta-primary, .cta-button').forEach(button => {
            button.addEventListener('click', (e) => {
                console.log('Starting your EntrepreneurEducation journey! 🚀');
                // Link will naturally navigate, no need for alert
            });
        });
        
        // PDF download tracking
        const pdfButton = document.querySelector('a[href*="Induction 2025.pdf"]');
        if (pdfButton) {
            pdfButton.addEventListener('click', () => {
                console.log('Downloading EntrepreneurEducation Induction PDF');
            });
        }
    });
</script>
@endsection