@extends('layouts.public')

@section('title', 'Contact EntrepreneurEducation')
@section('meta_description', 'Get in touch with EntrepreneurEducation. Questions about training, AI tools, or our induction process? We\'re here to help.')

@push('styles')
<style>
    :root {
        --ee-purple: #7c3aed;
        --ee-cyan: #06b6d4;
        --ee-dark: #0f172a;
        --ee-light: #f8fafc;
        --ee-card: #ffffff;
        --ee-border: #e2e8f0;
        --ee-text: #334155;
        --ee-text-light: #64748b;
    }
    
    .page-hero {
        background: linear-gradient(135deg, var(--ee-purple) 0%, var(--ee-cyan) 100%);
        color: white;
        padding: 100px 0 80px;
        text-align: center;
        position: relative;
        overflow: hidden;
    }
    
    .page-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: 
            radial-gradient(circle at 20% 80%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
            radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
    }
    
    .page-hero h1 {
        font-size: 3.5rem;
        font-weight: 900;
        margin-bottom: 20px;
        position: relative;
    }
    
    .page-hero p {
        font-size: 1.25rem;
        opacity: 0.95;
        max-width: 600px;
        margin: 0 auto;
        color: rgba(255, 255, 255, 0.95);
    }
    
    .contact-section {
        padding: 80px 0;
        background: var(--ee-light);
    }
    
    .contact-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 60px;
    }
    
    .contact-form {
        background: var(--ee-card);
        padding: 40px;
        border-radius: 24px;
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
        border: 1px solid var(--ee-border);
    }
    
    .form-group {
        margin-bottom: 24px;
    }
    
    .form-group label {
        display: block;
        font-weight: 600;
        margin-bottom: 8px;
        color: var(--ee-text);
    }
    
    .form-group input,
    .form-group textarea,
    .form-group select {
        width: 100%;
        padding: 16px;
        border: 2px solid var(--ee-border);
        border-radius: 12px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background: white;
        color: var(--ee-text);
    }
    
    .form-group input:focus,
    .form-group textarea:focus,
    .form-group select:focus {
        outline: none;
        border-color: var(--ee-purple);
        box-shadow: 0 0 0 3px rgba(124, 58, 237, 0.1);
    }
    
    .form-group textarea {
        min-height: 150px;
        resize: vertical;
    }
    
    .submit-btn {
        width: 100%;
        padding: 18px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        color: white;
        border: none;
        border-radius: 12px;
        font-size: 1rem;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }
    
    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 30px rgba(124, 58, 237, 0.3);
    }
    
    .contact-info {
        display: flex;
        flex-direction: column;
        gap: 24px;
    }
    
    .info-card {
        background: var(--ee-card);
        padding: 30px;
        border-radius: 20px;
        display: flex;
        gap: 20px;
        border: 1px solid var(--ee-border);
        transition: all 0.3s ease;
    }
    
    .info-card:hover {
        transform: translateY(-5px);
        border-color: var(--ee-purple);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    }
    
    .info-icon {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
        flex-shrink: 0;
    }
    
    .info-content h3 {
        font-size: 1.25rem;
        font-weight: 700;
        margin-bottom: 8px;
        color: var(--ee-text);
    }
    
    .info-content p {
        color: var(--ee-text-light);
        line-height: 1.6;
        margin-bottom: 8px;
    }
    
    .info-content a {
        color: var(--ee-purple);
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }
    
    .info-content a:hover {
        color: var(--ee-cyan);
        text-decoration: underline;
    }
    
    .social-icons {
        display: flex;
        gap: 12px;
        margin-top: 12px;
    }
    
    .social-icons a {
        width: 40px;
        height: 40px;
        background: var(--ee-light);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--ee-purple);
        font-size: 18px;
        transition: all 0.3s ease;
    }
    
    .social-icons a:hover {
        background: var(--ee-purple);
        color: white;
        transform: translateY(-3px);
    }
    
    .faq-section {
        padding: 80px 0;
        background: white;
    }
    
    .section-title {
        text-align: center;
        margin-bottom: 60px;
    }
    
    .section-title h2 {
        font-size: 2.5rem;
        font-weight: 900;
        margin-bottom: 16px;
        background: linear-gradient(135deg, var(--ee-purple), var(--ee-cyan));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .section-subtitle {
        font-size: 1.125rem;
        color: var(--ee-text-light);
        max-width: 600px;
        margin: 0 auto;
    }
    
    .faq-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 24px;
    }
    
    .faq-card {
        background: var(--ee-light);
        padding: 32px;
        border-radius: 20px;
        border: 1px solid var(--ee-border);
        transition: all 0.3s ease;
    }
    
    .faq-card:hover {
        border-color: var(--ee-purple);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
    }
    
    .faq-question {
        font-size: 1.125rem;
        font-weight: 700;
        margin-bottom: 16px;
        color: var(--ee-text);
        display: flex;
        align-items: center;
        gap: 10px;
    }
    
    .faq-question i {
        color: var(--ee-purple);
        font-size: 20px;
    }
    
    .faq-answer {
        color: var(--ee-text-light);
        line-height: 1.6;
    }
    
    .faq-answer strong {
        color: var(--ee-text);
    }
    
    .induction-note {
        margin-top: 48px;
        padding: 24px;
        background: linear-gradient(135deg, rgba(124, 58, 237, 0.05), rgba(6, 182, 212, 0.05));
        border-radius: 16px;
        border-left: 4px solid var(--ee-purple);
        text-align: center;
    }
    
    .induction-note p {
        font-weight: 600;
        color: var(--ee-text);
        margin-bottom: 8px;
    }
    
    .induction-note small {
        color: var(--ee-text-light);
        font-size: 0.875rem;
    }
    
    @media (max-width: 1024px) {
        .contact-grid {
            grid-template-columns: 1fr;
        }
        
        .page-hero h1 {
            font-size: 2.75rem;
        }
    }
    
    @media (max-width: 768px) {
        .page-hero {
            padding: 80px 0 60px;
        }
        
        .page-hero h1 {
            font-size: 2.25rem;
        }
        
        .faq-grid {
            grid-template-columns: 1fr;
        }
        
        .contact-form,
        .info-card {
            padding: 24px;
        }
        
        .info-card {
            flex-direction: column;
            text-align: center;
        }
        
        .info-icon {
            margin: 0 auto;
        }
        
        .social-icons {
            justify-content: center;
        }
    }
</style>
@endpush

@section('content')
<!-- Page Hero -->
<section class="page-hero">
    <div class="container">
        <h1>Get in Touch</h1>
        <p>Questions about our entrepreneur training, AI tools, or induction process? We're here to help you succeed.</p>
    </div>
</section>

<!-- Contact Section -->
<section class="contact-section">
    <div class="container">
        <div class="contact-grid">
            <!-- Contact Form -->
            <div>
                <h2 style="font-size: 2rem; font-weight: 900; margin-bottom: 30px; color: var(--ee-text);">Send Us a Message</h2>
                <form class="contact-form" action="#" method="POST">
                    @csrf
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input type="text" id="name" name="name" required placeholder="Your name">
                    </div>
                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input type="email" id="email" name="email" required placeholder="you@example.com">
                    </div>
                    <div class="form-group">
                        <label for="subject">Subject *</label>
                        <select id="subject" name="subject" required>
                            <option value="">What can we help with?</option>
                            <option value="induction">Induction Questions</option>
                            <option value="training">Training Programs</option>
                            <option value="ai_tools">Business AI Tools</option>
                            <option value="partnership">Partnership Opportunities</option>
                            <option value="scholarship">Scholarship Inquiry</option>
                            <option value="technical">Technical Support</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="message">Message *</label>
                        <textarea id="message" name="message" required placeholder="Tell us about your entrepreneurial journey or question..."></textarea>
                    </div>
                    <button type="submit" class="submit-btn">
                        <i class="fas fa-paper-plane"></i> Send Message
                    </button>
                </form>
            </div>
            
            <!-- Contact Information -->
            <div>
                <h2 style="font-size: 2rem; font-weight: 900; margin-bottom: 30px; color: var(--ee-text);">Contact Information</h2>
                <div class="contact-info">
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="info-content">
                            <h3>Email Us</h3>
                            <p>Get support or ask questions</p>
                            <a href="mailto:support@entrepreneureducation.com">support@entrepreneureducation.com</a><br>
                            <a href="mailto:info@entrepreneureducation.com">info@entrepreneureducation.com</a>
                        </div>
                    </div>
                    
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-graduation-cap"></i>
                        </div>
                        <div class="info-content">
                            <h3>Induction Support</h3>
                            <p>Questions about the induction process?</p>
                            <a href="mailto:induction@entrepreneureducation.com">induction@entrepreneureducation.com</a>
                            <p style="margin-top: 12px; font-size: 0.875rem; color: var(--ee-purple);">⚠️ Remember: You will be tested on induction content</p>
                        </div>
                    </div>
                    
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="info-content">
                            <h3>Response Time</h3>
                            <p>We typically respond within:</p>
                            <p><strong>24 hours</strong> for general inquiries<br>
                               <strong>48 hours</strong> for induction questions<br>
                               <strong>72 hours</strong> for technical support</p>
                        </div>
                    </div>
                    
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-share-alt"></i>
                        </div>
                        <div class="info-content">
                            <h3>Follow Our Journey</h3>
                            <p>Connect with us for updates, tips, and free content</p>
                            <div class="social-icons">
                                <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin"></i></a>
                                <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                                <a href="#" aria-label="Twitter"><i class="fab fa-twitter"></i></a>
                                <a href="#" aria-label="YouTube"><i class="fab fa-youtube"></i></a>
                                <a href="#" aria-label="TikTok"><i class="fab fa-tiktok"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section (Updated with Induction Content) -->
<section class="faq-section">
    <div class="container">
        <div class="section-title">
            <h2>Frequently Asked Questions</h2>
            <p class="section-subtitle">Quick answers about EntrepreneurEducation and the induction process</p>
        </div>
        
        <div class="faq-grid">
            <!-- FAQ based on Induction Content -->
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What is EntrepreneurEducation?
                </div>
                <p class="faq-answer">
                    <strong>EntrepreneurEducation</strong> specializes in digital products that make entrepreneur training 
                    <strong>Simple, Easy, Enjoyable, and Accessible (S.E.A)</strong>. We offer two main services: 
                    <strong>Education Training</strong> and <strong>Business AI Tools</strong>.
                </p>
            </div>
            
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What are the core training tracks?
                </div>
                <p class="faq-answer">
                    We offer four specialized tracks:
                    <strong>SET</strong> (Spiritual Entrepreneur Training), 
                    <strong>PDT</strong> (Personal Development Training), 
                    <strong>BET</strong> (Business Entrepreneur Training), and 
                    <strong>RBET</strong> (Religious Business Entrepreneur Training).
                </p>
            </div>
            
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What is the E.A.R.T.H culture?
                </div>
                <p class="faq-answer">
                    Our company culture stands for:
                    <strong>E</strong>ntrepreneurial (creative & disciplined),
                    <strong>A</strong>wareness (of tech & customer needs),
                    <strong>R</strong>esponsive (to team & customers),
                    <strong>T</strong>ransparent (open communication),
                    <strong>H</strong>onest (no hidden agendas).
                </p>
            </div>
            
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What are the business processes?
                </div>
                <p class="faq-answer">
                    We follow the <strong>3 P's</strong>:
                    <strong>Promote</strong> (free webinars to inspire),
                    <strong>Produce</strong> (sales from training packages),
                    <strong>Provide</strong> (systematic teaching methods).
                </p>
            </div>
            
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What about work contracts & IP?
                </div>
                <p class="faq-answer">
                    All paid work for EntrepreneurEducation must be under contract. 
                    <strong>All intellectual property created during paid work belongs to the business.</strong> 
                    Ensure clear understanding before starting tasks.
                </p>
            </div>
            
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What's the reporting structure?
                </div>
                <p class="faq-answer">
                    Tasks must have agreed deadlines with regular performance updates. 
                    Report on: <strong>advances, setbacks, personal life updates, current status, and next steps.</strong>
                    Excellent performance leads to future opportunities.
                </p>
            </div>
            
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What are Health & Safety guidelines?
                </div>
                <p class="faq-answer">
                    <strong>At work:</strong> Follow equipment and fire safety rules.
                    <strong>At home:</strong> Have emergency procedures for fire and local emergencies. 
                    Always prioritize safety in all environments.
                </p>
            </div>
            
            <div class="faq-card">
                <div class="faq-question">
                    <i class="fas fa-question-circle"></i>
                    What free content do you offer?
                </div>
                <p class="faq-answer">
                    We provide free webinars, videos, and eBooks to:
                    <strong>Promote company image, Generate sales, and Encourage organic leads</strong> (U.S.E strategy). 
                    These lead to paid training and membership options.
                </p>
            </div>
        </div>
        
        <!-- Induction Note -->
        <div class="induction-note">
            <p>⚠️ Important Induction Reminder</p>
            <p>All workers must know the Vision, Mission, and Objectives of the business to work with us.</p>
            <small>Pay close attention to the induction - you will be tested on the contents.</small>
        </div>
    </div>
</section>

<script>
    // Add form validation and interaction
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('.contact-form');
        const submitBtn = document.querySelector('.submit-btn');
        
        if (form) {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Add loading state
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Sending...';
                submitBtn.disabled = true;
                
                // Simulate API call
                setTimeout(() => {
                    submitBtn.innerHTML = '<i class="fas fa-check"></i> Message Sent!';
                    submitBtn.style.background = '#10b981';
                    
                    // Reset form
                    form.reset();
                    
                    // Reset button after 3 seconds
                    setTimeout(() => {
                        submitBtn.innerHTML = '<i class="fas fa-paper-plane"></i> Send Message';
                        submitBtn.style.background = 'linear-gradient(135deg, var(--ee-purple), var(--ee-cyan))';
                        submitBtn.disabled = false;
                    }, 3000);
                }, 1500);
            });
        }
        
        // Add animation to FAQ cards
        const faqCards = document.querySelectorAll('.faq-card');
        faqCards.forEach((card, index) => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            
            setTimeout(() => {
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, 100 * index);
        });
    });
</script>
@endsection