﻿<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @php
        $brand = \App\Support\BrandSettings::data();

        $siteName = $brand['name'] ?? 'EE Micro LMS';
        $siteTagline = $brand['tagline'] ?? 'Entrepreneurship Training Hub';
        $siteDescription = $brand['description'] ?? $siteTagline;

        $logoUrl = $brand['logo_url'] ?? null;
        $faviconUrl = $brand['favicon_url'] ?? null;

        $colors = $brand['colors'] ?? [];
        $primaryColor = $colors['primary'] ?? '#667eea';
        $primaryDark = $colors['primary_dark'] ?? '#4c51bf';
        $secondaryColor = $colors['secondary'] ?? '#764ba2';
        $accentColor = $colors['secondary_light'] ?? '#8b5cf6';
        $infoColor = $colors['info'] ?? '#4299e1';
        $successColor = $colors['success'] ?? '#48bb78';
        $warningColor = $colors['warning'] ?? '#ed8936';
        $dangerColor = $colors['danger'] ?? '#f56565';
        $gradient = $colors['gradient'] ?? 'linear-gradient(135deg, #667eea, #764ba2)';

        $contact = $brand['contact'] ?? [];
        $contactEmail = $contact['email'] ?? 'info@eemicrolms.com';
        $contactPhone = $contact['phone'] ?? '+1 (234) 567-890';
        $contactPhoneHref = $contact['phone_href'] ?? null;
        $contactAddress = $contact['address'] ?? '123 Education St, Learning City';

        $socialConfig = [
            'facebook' => ['icon' => 'fab fa-facebook-f', 'label' => 'Facebook'],
            'twitter' => ['icon' => 'fab fa-twitter', 'label' => 'Twitter'],
            'linkedin' => ['icon' => 'fab fa-linkedin-in', 'label' => 'LinkedIn'],
            'instagram' => ['icon' => 'fab fa-instagram', 'label' => 'Instagram'],
            'youtube' => ['icon' => 'fab fa-youtube', 'label' => 'YouTube'],
        ];

        $socialLinks = collect($brand['social'] ?? [])->filter()->map(function ($url, $network) use ($socialConfig) {
            $config = $socialConfig[$network] ?? ['icon' => 'fas fa-share-alt', 'label' => ucfirst($network)];
            return array_merge($config, ['url' => $url]);
        });

        $copyright = $brand['copyright'] ?? sprintf('%s %s. All rights reserved.', date('Y'), $siteName);
    @endphp

    <title>@yield('title', $siteName . ' - ' . $siteDescription)</title>
    <meta name="description" content="@yield('meta_description', $siteDescription)">
    <meta name="keywords" content="@yield('meta_keywords', 'LMS, learning management, online education, courses')">

    @if($faviconUrl)
        <link rel="icon" type="image/x-icon" href="{{ $faviconUrl }}">
    @endif

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700,800,900&display=swap" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .sr-only {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0;
        }
        
        :root {
            --primary-color: {{ $primaryColor }};
            --primary-dark: {{ $primaryDark }};
            --secondary-color: {{ $secondaryColor }};
            --accent-color: {{ $accentColor }};
            --info-color: {{ $infoColor }};
            --brand-gradient: {{ $gradient }};
            --text-dark: #1a202c;
            --text-gray: #4a5568;
            --text-light: #718096;
            --bg-light: #f7fafc;
            --bg-white: #ffffff;
            --border-color: #e2e8f0;
            --success-color: {{ $successColor }};
            --warning-color: {{ $warningColor }};
            --error-color: {{ $dangerColor }};
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            background: var(--bg-light);
        }
        
        /* Header Styles - Modern Gen Z Edition */
        .site-header {
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.95) 0%,
                rgba(255, 255, 255, 0.9) 100%
            );
            backdrop-filter: blur(30px) saturate(200%);
            box-shadow: 0 10px 40px rgba(102, 126, 234, 0.15), 
                        0 1px 3px rgba(0, 0, 0, 0.05),
                        inset 0 1px 0 rgba(255, 255, 255, 0.9);
            border-bottom: 2px solid rgba(102, 126, 234, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: slideDown 0.6s ease-out;
        }

        @keyframes slideDown {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .site-header.scrolled {
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.98) 0%,
                rgba(255, 255, 255, 0.95) 100%
            );
            box-shadow: 0 15px 50px rgba(102, 126, 234, 0.2), 
                        0 5px 15px rgba(0, 0, 0, 0.08),
                        inset 0 1px 0 rgba(255, 255, 255, 1);
        }
        
        .header-container {
            max-width: 1280px;
            margin: 0 auto;
            padding: 0 32px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 90px;
        }
        
        .brand-link {
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 16px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .brand-link:hover {
            transform: translateY(-3px);
            filter: drop-shadow(0 8px 16px rgba(102, 126, 234, 0.2));
        }

        .brand-symbol {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 64px;
            height: 64px;
            border-radius: 20px;
            background: var(--brand-gradient);
            color: white;
            flex-shrink: 0;
            font-weight: 800;
            box-shadow: 0 12px 35px rgba(102, 126, 234, 0.4),
                        0 5px 15px rgba(118, 75, 162, 0.3),
                        inset 0 3px 8px rgba(255, 255, 255, 0.25);
            position: relative;
            overflow: hidden;
            transition: all 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
        }

        .brand-symbol::before {
            content: '';
            position: absolute;
            inset: -50%;
            background: linear-gradient(
                135deg, 
                transparent 20%, 
                rgba(255, 255, 255, 0.4) 50%, 
                transparent 80%
            );
            transform: translateX(-100%) rotate(45deg);
            transition: transform 0.8s ease;
        }

        .brand-link:hover .brand-symbol {
            transform: rotate(8deg) scale(1.1);
            box-shadow: 0 18px 45px rgba(102, 126, 234, 0.5),
                        0 8px 20px rgba(118, 75, 162, 0.4),
                        inset 0 4px 12px rgba(255, 255, 255, 0.3);
        }

        .brand-link:hover .brand-symbol::before {
            transform: translateX(100%) rotate(45deg);
        }

        .brand-symbol.with-image {
            background: white;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
        }

        .brand-symbol.with-image img {
            max-height: 64px;
            width: auto;
            display: block;
            filter: drop-shadow(0 4px 12px rgba(0,0,0,0.15));
        }

        .brand-symbol i {
            font-size: 28px;
        }

        .brand-text {
            display: flex;
            flex-direction: column;
            line-height: 1.15;
        }

        .brand-name {
            font-size: 22px;
            font-weight: 800;
            letter-spacing: -0.02em;
            background: linear-gradient(135deg, #0f172a 0%, #334155 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .brand-tagline {
            font-size: 11px;
            font-weight: 600;
            color: #64748b;
            letter-spacing: 0.02em;
            text-transform: uppercase;
        }

        .header-brand .brand-tagline {
            color: #64748b;
        }

        .footer-brand-link {
            color: white;
        }

        .footer-brand-link .brand-symbol {
            background: rgba(255, 255, 255, 0.12);
        }

        .footer-brand-link .brand-name {
            color: white;
            background: white;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .footer-brand-link .brand-tagline {
            color: rgba(255, 255, 255, 0.75);
        }
        
        .main-nav {
            display: flex;
            gap: 32px;
            align-items: center;
        }
        
        .main-nav a {
            text-decoration: none;
            color: var(--text-dark);
            font-weight: 600;
            font-size: 15px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            padding: 8px 0;
        }

        .main-nav a::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 3px;
            background: var(--brand-gradient);
            border-radius: 3px;
            transform: translateX(-50%);
            transition: width 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .main-nav a:hover {
            color: var(--primary-color);
        }

        .main-nav a:hover::after {
            width: 100%;
        }
        
        .main-nav a.active::after {
            width: 100%;
        }
        
        .header-actions {
            display: flex;
            gap: 12px;
            align-items: center;
        }
        
        .btn {
            padding: 11px 24px;
            border-radius: 12px;
            text-decoration: none;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border: none;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            position: relative;
            overflow: hidden;
        }

        .btn::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 60%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .btn:hover::before {
            opacity: 1;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            box-shadow: 0 4px 16px rgba(102, 126, 234, 0.3);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(102, 126, 234, 0.4);
        }
        
        .btn-outline {
            border: 2px solid rgba(102, 126, 234, 0.3);
            color: var(--primary-color);
            background: rgba(102, 126, 234, 0.05);
            backdrop-filter: blur(10px);
        }
        
        .btn-outline:hover {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
            box-shadow: 0 4px 16px rgba(102, 126, 234, 0.3);
        }
        
        .mobile-menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 24px;
            color: var(--text-dark);
            cursor: pointer;
        }
        
        /* Main Content */
        .main-content {
            min-height: calc(100vh - 80px - 400px);
        }
        
        .container {
            max-width: 1280px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* Footer Styles */
        .site-footer {
            background: linear-gradient(135deg, var(--primary-dark) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 60px 0 30px;
            margin-top: 80px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 40px;
            margin-bottom: 40px;
        }

        .footer-brand {
            margin-bottom: 20px;
        }

        .footer-brand h3 {
            font-size: 22px;
            margin: 0;
            font-weight: 700;
            display: inline-flex;
            align-items: center;
            gap: 12px;
        }
        
        .footer-section h3 {
            font-size: 18px;
            margin-bottom: 20px;
            font-weight: 700;
        }
        
        .footer-section p {
            color: rgba(255,255,255,0.75);
            margin-bottom: 20px;
            line-height: 1.8;
        }
        
        .footer-section ul {
            list-style: none;
        }
        
        .footer-section ul li {
            margin-bottom: 12px;
        }
        
        .footer-section ul li a {
            color: #cbd5f5;
            text-decoration: none;
            transition: color 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .footer-section ul li span {
            color: #cbd5f5;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .footer-section ul li a:hover {
            color: white;
        }
        
        .social-links {
            display: flex;
            gap: 15px;
            margin-top: 20px;
        }
        
        .social-links a {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255,255,255,0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            transition: all 0.3s ease;
        }
        
        .social-links a:hover {
            background: var(--accent-color);
            transform: translateY(-3px);
        }

        .footer-logo {
            display: inline-flex;
            align-items: center;
        }

        .footer-logo img {
            max-height: 60px;
            width: auto;
            display: block;
        }
        
        .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: #cbd5f5;
            font-size: 14px;
        }
        
        .footer-bottom-links {
            display: flex;
            gap: 20px;
        }
        
        .footer-bottom-links a {
            color: #cbd5f5;
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .footer-bottom-links a:hover {
            color: white;
        }
        
        /* Responsive */
        @media (max-width: 1024px) {
            .footer-content {
                grid-template-columns: 1fr 1fr;
            }
            
            /* Tablet adjustments */
            .brand-text {
                display: flex;
            }
            
            .brand-name {
                font-size: 18px;
            }
            
            .brand-tagline {
                font-size: 10px;
            }
        }
        
        @media (max-width: 768px) {
            /* Mobile Header - Super Clean */
            .header-container {
                height: 64px;
                padding: 0 16px;
            }
            
            /* Mobile Logo - Compact & Clean */
            .brand-link {
                gap: 10px;
            }
            
            .brand-symbol {
                width: 44px;
                height: 44px;
                border-radius: 12px;
                box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
            }
            
            .brand-symbol.with-image img {
                max-height: 44px;
            }
            
            .brand-symbol i {
                font-size: 20px;
            }
            
            /* Hide brand text on mobile */
            .brand-text {
                display: none;
            }
            
            /* Mobile Navigation */
            .main-nav {
                display: none;
                position: fixed;
                top: 64px;
                left: 0;
                right: 0;
                background: white;
                flex-direction: column;
                padding: 24px 20px;
                box-shadow: 0 8px 24px rgba(0,0,0,0.12);
                border-top: 2px solid rgba(102, 126, 234, 0.1);
                max-height: calc(100vh - 64px);
                overflow-y: auto;
                animation: slideDownMenu 0.3s ease-out;
            }
            
            @keyframes slideDownMenu {
                from {
                    opacity: 0;
                    transform: translateY(-10px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
            
            .main-nav.active {
                display: flex;
            }
            
            .main-nav a {
                padding: 14px 16px;
                border-radius: 8px;
                transition: all 0.2s ease;
                font-size: 16px;
            }
            
            .main-nav a:hover,
            .main-nav a.active {
                background: rgba(102, 126, 234, 0.08);
            }
            
            .main-nav a::after {
                display: none;
            }
            
            /* Mobile Menu Toggle - Modern Hamburger */
            .mobile-menu-toggle {
                display: flex;
                align-items: center;
                justify-content: center;
                width: 44px;
                height: 44px;
                background: rgba(102, 126, 234, 0.08);
                border-radius: 12px;
                border: none;
                cursor: pointer;
                transition: all 0.3s ease;
                position: relative;
            }
            
            .mobile-menu-toggle:hover {
                background: rgba(102, 126, 234, 0.15);
                transform: scale(1.05);
            }
            
            .mobile-menu-toggle i {
                color: var(--primary-color);
                font-size: 20px;
                transition: transform 0.3s ease;
            }
            
            .mobile-menu-toggle.active i {
                transform: rotate(90deg);
            }
            
            /* Mobile Header Actions */
            .header-actions {
                gap: 8px;
            }
            
            .header-actions .btn {
                padding: 10px 16px;
                font-size: 13px;
                border-radius: 10px;
            }
            
            /* Hide login button text on very small screens */
            .btn-outline .btn-text {
                display: inline;
            }
            
            /* Footer adjustments */
            .footer-content {
                grid-template-columns: 1fr;
                gap: 30px;
            }
            
            .footer-bottom {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            /* Show footer brand text */
            .footer-brand-link .brand-text {
                display: flex;
            }
        }
        
        @media (max-width: 480px) {
            /* Extra small mobile */
            .header-container {
                padding: 0 12px;
            }
            
            .brand-symbol {
                width: 40px;
                height: 40px;
                border-radius: 10px;
            }
            
            .brand-symbol.with-image img {
                max-height: 40px;
            }
            
            .header-actions .btn-outline {
                padding: 8px 12px;
                font-size: 12px;
            }
            
            .header-actions .btn-primary {
                padding: 8px 14px;
                font-size: 12px;
            }
            
            .mobile-menu-toggle {
                width: 40px;
                height: 40px;
            }
        }
        
        @media (max-width: 360px) {
            /* Very small screens */
            .header-actions .btn-outline .btn-text {
                display: none;
            }
            
            .header-actions .btn-outline i {
                margin: 0;
            }
        }
        
        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <!-- Header -->
    <header class="site-header">
        <div class="header-container">
            <a href="{{ url('/') }}" class="logo brand-link header-brand" aria-label="{{ $siteName }}">
                <span class="brand-symbol {{ $logoUrl ? 'with-image' : '' }}">
                    @if($logoUrl)
                        <img src="{{ $logoUrl }}" alt="{{ $siteName }} logo">
                    @else
                        <i class="fas fa-graduation-cap" aria-hidden="true"></i>
                    @endif
                </span>
                <span class="brand-text">
                    <span class="brand-name">{{ $siteName }}</span>
                    @if(!empty($siteTagline))
                        <span class="brand-tagline">{{ $siteTagline }}</span>
                    @endif
                </span>
            </a>
            
            <nav class="main-nav" id="mainNav">
                {{-- Always show Home link first --}}
                <a href="{{ url('/') }}" class="{{ request()->is('/') ? 'active' : '' }}">Home</a>
                
                @if(isset($navigationPages) && $navigationPages->count() > 0)
                    @foreach($navigationPages as $page)
                        @php
                            // Skip home page since we show it separately above
                            if($page->slug === 'home') continue;
                            
                            $url = url('/' . $page->slug);
                            $isActive = request()->is($page->slug);
                        @endphp
                        <a href="{{ $url }}" class="{{ $isActive ? 'active' : '' }}">
                            {{ $page->title }}
                        </a>
                    @endforeach
                @endif
            </nav>
            
            <div class="header-actions">
                @auth
                    <a href="{{ route('dashboard') }}" class="btn btn-outline">
                        <i class="fas fa-tachometer-alt"></i>
                        <span class="btn-text">Dashboard</span>
                    </a>
                @else
                    <a href="{{ route('login') }}" class="btn btn-outline">
                        <i class="fas fa-sign-in-alt"></i>
                        <span class="btn-text">Login</span>
                    </a>
                    <a href="{{ route('register') }}" class="btn btn-primary">
                        <span>Get Started</span>
                    </a>
                @endauth
                <button class="mobile-menu-toggle" onclick="toggleMobileMenu()" aria-label="Toggle navigation menu">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <main class="main-content">
        @yield('content')
    </main>
    
    <!-- Footer -->
    <footer class="site-footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <div class="footer-brand">
                        <a href="{{ url('/') }}" class="brand-link footer-brand-link">
                            <span class="brand-symbol {{ $logoUrl ? 'with-image' : '' }}">
                                @if($logoUrl)
                                    <img src="{{ $logoUrl }}" alt="{{ $siteName }} logo">
                                @else
                                    <i class="fas fa-graduation-cap" aria-hidden="true"></i>
                                @endif
                            </span>
                            <span class="brand-text">
                                <span class="brand-name">{{ $siteName }}</span>
                                @if(!empty($siteTagline))
                                    <span class="brand-tagline">{{ $siteTagline }}</span>
                                @endif
                            </span>
                        </a>
                    </div>
                    <p>{{ $siteDescription }}</p>
                    @if($socialLinks->isNotEmpty())
                        <div class="social-links">
                            @foreach($socialLinks as $link)
                                <a href="{{ $link['url'] }}" aria-label="{{ $link['label'] }}" target="_blank" rel="noopener">
                                    <i class="{{ $link['icon'] }}"></i>
                                </a>
                            @endforeach
                        </div>
                    @endif
                </div>
                
                <div class="footer-section">
                    <h3>Quick Links</h3>
                    <ul>
                        {{-- Always show Home link first --}}
                        <li><a href="{{ url('/') }}"><i class="fas fa-chevron-right"></i> Home</a></li>
                        
                        @if(isset($navigationPages) && $navigationPages->count() > 0)
                            @foreach($navigationPages as $page)
                                @php
                                    // Skip home page since we show it separately above
                                    if($page->slug === 'home') continue;
                                    
                                    $footerUrl = url('/' . $page->slug);
                                @endphp
                                <li><a href="{{ $footerUrl }}"><i class="fas fa-chevron-right"></i> {{ $page->title }}</a></li>
                            @endforeach
                        @endif
                        <li><a href="{{ route('login') }}"><i class="fas fa-chevron-right"></i> Student Login</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Legal</h3>
                    <ul>
                        <li><a href="{{ url('/privacy-policy') }}"><i class="fas fa-chevron-right"></i> Privacy Policy</a></li>
                        <li><a href="{{ url('/terms-conditions') }}"><i class="fas fa-chevron-right"></i> Terms &amp; Conditions</a></li>
                    </ul>
                </div>
                
                <div class="footer-section">
                    <h3>Contact Info</h3>
                    <ul>
                        @if($contactEmail)
                            <li><a href="mailto:{{ $contactEmail }}"><i class="fas fa-envelope"></i> {{ $contactEmail }}</a></li>
                        @endif
                        @if($contactPhone && $contactPhoneHref)
                            <li><a href="tel:{{ $contactPhoneHref }}"><i class="fas fa-phone"></i> {{ $contactPhone }}</a></li>
                        @endif
                        @if($contactAddress)
                            <li><span><i class="fas fa-map-marker-alt"></i> {{ $contactAddress }}</span></li>
                        @endif
                    </ul>
                </div>
            </div>
            
            <div class="footer-bottom">
                <div>{{ $copyright }}</div>
                <div class="footer-bottom-links">
                    <a href="{{ url('/privacy-policy') }}">Privacy</a>
                    <a href="{{ url('/terms-conditions') }}">Terms</a>
                    <a href="{{ url('/contact') }}">Support</a>
                </div>
            </div>
        </div>
    </footer>
    
    <script>
        // Mobile menu toggle with animation
        function toggleMobileMenu() {
            const nav = document.getElementById('mainNav');
            const toggle = document.querySelector('.mobile-menu-toggle');
            
            nav.classList.toggle('active');
            toggle.classList.toggle('active');
            
            // Change icon
            const icon = toggle.querySelector('i');
            if (nav.classList.contains('active')) {
                icon.classList.remove('fa-bars');
                icon.classList.add('fa-times');
            } else {
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            }
        }
        
        // Header scroll effect
        window.addEventListener('scroll', function() {
            const header = document.querySelector('.site-header');
            if (window.scrollY > 50) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        });
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', function(event) {
            const nav = document.getElementById('mainNav');
            const toggle = document.querySelector('.mobile-menu-toggle');
            const icon = toggle.querySelector('i');
            
            if (!nav.contains(event.target) && !toggle.contains(event.target)) {
                nav.classList.remove('active');
                toggle.classList.remove('active');
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            }
        });
        
        // Close mobile menu when clicking on a link
        document.querySelectorAll('.main-nav a').forEach(link => {
            link.addEventListener('click', function() {
                const nav = document.getElementById('mainNav');
                const toggle = document.querySelector('.mobile-menu-toggle');
                const icon = toggle.querySelector('i');
                
                nav.classList.remove('active');
                toggle.classList.remove('active');
                icon.classList.remove('fa-times');
                icon.classList.add('fa-bars');
            });
        });
    </script>
    
    @stack('scripts')
</body>
</html>
