<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  @php
    $brand = \App\Support\BrandSettings::data();
    $siteName = $brand['name'] ?? 'EE Micro LMS';
    $siteTagline = $brand['tagline'] ?? 'Entrepreneurship Training Hub';
    $logoUrl = $brand['logo_url'] ?? null;
    $faviconUrl = $brand['favicon_url'] ?? (\App\Models\SiteSetting::get('favicon_path') ?: '/favicon.ico');
    $colors = $brand['colors'] ?? [];
    $brandPrimary = $colors['primary'] ?? '#667eea';
    $brandSecondary = $colors['secondary'] ?? '#764ba2';
    $brandGradient = $colors['gradient'] ?? 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)';
    
    // Chunk words settings
    $chunkWordsSettings = \App\Models\SiteSetting::getChunkWordsSettings();
  @endphp
  <title>{{ $siteName }} &mdash; Tutor Dashboard</title>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/tinymce@6/tinymce.min.js" referrerpolicy="origin"></script>
  <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <link rel="icon" href="{{ $faviconUrl }}" type="image/x-icon">
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; }

    :root {
      --brand-primary: {{ $brandPrimary }};
      --brand-secondary: {{ $brandSecondary }};
      --brand-gradient: {{ $brandGradient }};
    }
    
    body { 
      font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      overflow-x: hidden;
    }

    /* Navbar Styling - Modern Gen Z Edition */
    .navbar {
      background: linear-gradient(135deg, 
        rgba(255, 255, 255, 0.95) 0%,
        rgba(255, 255, 255, 0.9) 100%
      );
      padding: 0;
      backdrop-filter: blur(30px) saturate(200%);
      box-shadow: 0 10px 40px rgba(102, 126, 234, 0.15), 
                  0 1px 3px rgba(0, 0, 0, 0.05),
                  inset 0 1px 0 rgba(255, 255, 255, 0.9);
      border-bottom: 2px solid rgba(102, 126, 234, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1000;
      transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
      animation: slideDown 0.6s ease-out;
    }

    @keyframes slideDown {
      from {
        transform: translateY(-100%);
        opacity: 0;
      }
      to {
        transform: translateY(0);
        opacity: 1;
      }
    }

    .navbar:hover {
      background: linear-gradient(135deg, 
        rgba(255, 255, 255, 0.98) 0%,
        rgba(255, 255, 255, 0.95) 100%
      );
      box-shadow: 0 15px 50px rgba(102, 126, 234, 0.2), 
                  0 5px 15px rgba(0, 0, 0, 0.08),
                  inset 0 1px 0 rgba(255, 255, 255, 1);
    }
    
    .navbar-content {
      max-width: 1400px;
      margin: 0 auto;
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 20px 32px;
      min-height: 90px;
    }
    
    .brand-heading {
      display: flex;
      flex-direction: column;
      gap: 2px;
      align-items: flex-start;
    }

    .logo {
      display: flex;
      align-items: center;
      gap: 16px;
      text-decoration: none;
      color: #0f172a;
      position: relative;
      transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .logo:hover {
      transform: translateY(-3px);
      filter: drop-shadow(0 8px 16px rgba(102, 126, 234, 0.2));
    }

    .logo .brand-symbol {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: 64px;
      height: 64px;
      border-radius: 20px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      flex-shrink: 0;
      font-size: 28px;
      font-weight: 800;
      box-shadow: 0 12px 35px rgba(102, 126, 234, 0.4),
                  0 5px 15px rgba(118, 75, 162, 0.3),
                  inset 0 3px 8px rgba(255, 255, 255, 0.25);
      position: relative;
      overflow: hidden;
      transition: all 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
    }

    .logo .brand-symbol::before {
      content: '';
      position: absolute;
      inset: -50%;
      background: linear-gradient(
        135deg, 
        transparent 20%, 
        rgba(255, 255, 255, 0.4) 50%, 
        transparent 80%
      );
      transform: translateX(-100%) rotate(45deg);
      transition: transform 0.8s ease;
    }

    .logo:hover .brand-symbol {
      transform: rotate(8deg) scale(1.1);
      box-shadow: 0 18px 45px rgba(102, 126, 234, 0.5),
                  0 8px 20px rgba(118, 75, 162, 0.4),
                  inset 0 4px 12px rgba(255, 255, 255, 0.3);
    }

    .logo:hover .brand-symbol::before {
      transform: translateX(100%) rotate(45deg);
    }

    .logo .brand-symbol.with-image {
      background: white;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
    }

    .logo .brand-symbol.with-image img {
      max-height: 64px;
      width: auto;
      display: block;
      filter: drop-shadow(0 4px 12px rgba(0,0,0,0.15));
    }

    .logo .brand-text {
      display: flex;
      flex-direction: column;
      line-height: 1.2;
      gap: 4px;
    }

    .logo .brand-name {
      font-size: 1.5em;
      font-weight: 900;
      color: #0f172a;
      letter-spacing: -0.03em;
      background: linear-gradient(135deg, #0f172a 0%, #667eea 50%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      text-shadow: 0 2px 10px rgba(102, 126, 234, 0.1);
    }

    .logo .brand-tagline {
      font-size: 0.65em;
      font-weight: 700;
      color: #94a3b8;
      letter-spacing: 0.08em;
      text-transform: uppercase;
    }

    .brand-context {
      font-size: 0.75em;
      font-weight: 800;
      padding: 8px 16px;
      margin-top: 8px;
      color: white;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border-radius: 20px;
      letter-spacing: 0.05em;
      text-transform: uppercase;
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
      animation: pulse 2s ease-in-out infinite;
    }

    @keyframes pulse {
      0%, 100% {
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
      }
      50% {
        box-shadow: 0 6px 25px rgba(102, 126, 234, 0.5);
      }
    }
    
    .user-info {
      display: flex;
      align-items: center;
      gap: 16px;
      font-size: 15px;
      font-weight: 600;
      color: #334155;
    }

    .user-info strong {
      color: #667eea;
      font-weight: 800;
    }
    
    .btn {
      padding: 12px 28px;
      border: none;
      border-radius: 16px;
      text-decoration: none;
      font-size: 15px;
      font-weight: 700;
      cursor: pointer;
      transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
      display: inline-flex;
      align-items: center;
      gap: 10px;
      position: relative;
      overflow: hidden;
      text-transform: capitalize;
      letter-spacing: 0.02em;
    }

    .btn::before {
      content: '';
      position: absolute;
      inset: 0;
      background: linear-gradient(135deg, rgba(255,255,255,0.3) 0%, transparent 60%);
      opacity: 0;
      transition: opacity 0.4s ease;
    }

    .btn::after {
      content: '';
      position: absolute;
      top: 50%;
      left: 50%;
      width: 0;
      height: 0;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.5);
      transform: translate(-50%, -50%);
      transition: width 0.6s, height 0.6s;
    }

    .btn:hover::after {
      width: 300px;
      height: 300px;
    }

    .btn:hover::before {
      opacity: 1;
    }

    .btn i {
      position: relative;
      z-index: 1;
    }
    
    .btn-primary {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }

    .btn-primary:hover {
      transform: translateY(-4px) scale(1.05);
      box-shadow: 0 12px 35px rgba(102, 126, 234, 0.5);
    }

    .btn-primary:active {
      transform: translateY(-2px) scale(1.02);
    }
    
    .btn-secondary {
      background: rgba(100, 116, 139, 0.08);
      color: #475569;
      border: 2px solid rgba(100, 116, 139, 0.2);
      backdrop-filter: blur(10px);
    }

    .btn-secondary:hover {
      transform: translateY(-4px) scale(1.05);
      background: rgba(100, 116, 139, 0.15);
      border-color: rgba(100, 116, 139, 0.4);
      box-shadow: 0 8px 25px rgba(100, 116, 139, 0.25);
    }

    /* Course pricing chips */
    .price-chip {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      padding: 6px 12px;
      border-radius: 999px;
      font-weight: 700;
      font-size: 13px;
      margin-top: 6px;
    }
    .price-chip.free { background: #ecfdf3; color: #166534; }
    .price-chip.paid { background: #fef9c3; color: #854d0e; }
    .price-chip i { width: 16px; text-align: center; display: inline-block; color: currentColor; }
    .course-meta-mini { font-size: 12px; color: #475569; display: flex; gap: 12px; align-items: center; flex-wrap: wrap; margin-top: 6px; }

    /* Main Layout */
    .admin-container {
      display: flex;
      margin-top: 110px;
      min-height: calc(100vh - 110px);
      padding-top: 40px;
    }

    /* Sidebar Styling */
    .sidebar {
      width: 280px;
      background: linear-gradient(
        180deg,
        rgba(255, 255, 255, 0.15) 0%,
        rgba(255, 255, 255, 0.08) 100%
      );
      backdrop-filter: blur(15px) saturate(150%);
      padding: 24px;
      position: fixed;
      height: calc(100vh - 130px);
      overflow-y: auto;
      border-right: 2px solid rgba(255, 255, 255, 0.2);
      box-shadow: 4px 0 20px rgba(0, 0, 0, 0.05);
    }

    .sidebar h2 {
      color: white;
      margin-bottom: 24px;
      font-size: 1.3em;
      font-weight: 800;
      letter-spacing: -0.02em;
      text-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .nav-item {
      padding: 14px 18px;
      margin-bottom: 8px;
      color: rgba(255,255,255,0.95);
      cursor: pointer;
      border-radius: 14px;
      transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
      display: flex;
      align-items: center;
      gap: 14px;
      font-weight: 600;
      position: relative;
      overflow: hidden;
    }

    .nav-item::before {
      content: '';
      position: absolute;
      left: 0;
      top: 50%;
      transform: translateY(-50%);
      width: 4px;
      height: 0;
      background: white;
      border-radius: 0 4px 4px 0;
      transition: height 0.3s ease;
    }

    .nav-item:hover {
      background: rgba(255,255,255,0.25);
      transform: translateX(8px);
      box-shadow: 0 4px 15px rgba(255, 255, 255, 0.2);
    }

    .nav-item:hover::before {
      height: 60%;
    }

    .nav-item.active {
      background: rgba(255,255,255,0.3);
      font-weight: 700;
      box-shadow: 0 6px 20px rgba(255, 255, 255, 0.25);
    }

    .nav-item.active::before {
      height: 70%;
    }

    .nav-item i {
      width: 24px;
      text-align: center;
      font-size: 18px;
    }

    /* Submenu styles */
    .nav-item-with-submenu {
      position: relative;
    }

    .nav-item-with-submenu > .nav-item {
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .nav-item-with-submenu > .nav-item .submenu-arrow {
      transition: transform 0.3s;
      font-size: 12px;
      margin-left: auto;
    }

    .nav-item-with-submenu.open > .nav-item .submenu-arrow {
      transform: rotate(180deg);
    }

    .submenu {
      max-height: 0;
      overflow: hidden;
      transition: max-height 0.3s ease-out;
      padding-left: 20px;
      list-style: none;
    }

    .nav-item-with-submenu.open .submenu {
      max-height: 500px;
    }

    .submenu li {
      margin-bottom: 4px;
    }

    .submenu .nav-item {
      padding: 10px 16px;
      font-size: 0.95em;
      background: rgba(255,255,255,0.05);
      margin-bottom: 4px;
    }

    .submenu .nav-item:hover {
      background: rgba(255,255,255,0.15);
    }

    .submenu .nav-item.active {
      background: rgba(255,255,255,0.2);
    }

    /* Content Area */
    .content {
      flex: 1;
      margin-left: 280px;
      padding: 40px;
    }

    .section {
      display: none;
    }

    .section.active {
      display: block;
    }

    /* Cards */
    .card {
      background: rgba(255,255,255,0.95);
      padding: 25px;
      border-radius: 15px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
      backdrop-filter: blur(10px);
      margin-bottom: 20px;
    }

    .card h3 {
      color: #333;
      margin-bottom: 20px;
      font-size: 1.3em;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    /* Section header (match admin) */
    .section-header {
      background: rgba(255,255,255,0.1);
      padding: 25px;
      border-radius: 15px;
      margin-bottom: 30px;
      backdrop-filter: blur(10px);
    }
    .section-header h1 { color: white; font-size: 2em; margin-bottom: 8px; }
    .section-header p { color: rgba(255,255,255,0.9); }

    /* Form controls (match admin) */
    .form-group { margin-bottom: 20px; }
    .form-group label { display: block; margin-bottom: 8px; color: #333; font-weight: 600; font-size: 14px; }
    .form-control {
      width: 100%;
      padding: 10px 12px;
      border: 2px solid #e5e7eb;
      border-radius: 8px;
      font-size: 14px;
      transition: border-color 0.2s;
    }
    .form-control:focus { outline: none; border-color: #667eea; box-shadow: 0 0 0 3px rgba(102,126,234,.1); }

    /* Search input */
    .search-input { padding: 10px 15px; border: 2px solid #e5e7eb; border-radius: 8px; font-size: 14px; transition: all .3s; }
    .search-input:focus { outline: none; border-color: #667eea; box-shadow: 0 0 0 3px rgba(102,126,234,.1); }

    /* Table styles */
    .table-responsive { overflow-x: auto; }
    .data-table { width: 100%; border-collapse: collapse; }
    .data-table th { background: #f9fafb; color: #374151; font-weight: 600; padding: 12px; text-align: left; border-bottom: 2px solid #e5e7eb; }
    .data-table td { padding: 12px; border-bottom: 1px solid #f3f4f6; }
    .data-table tbody tr:hover { background: #f9fafb; }

    /* Tabs (admin-style) */
    .tab-btn { background: transparent; color: rgba(255,255,255,0.7); border: none; padding: 10px 20px; border-radius: 6px 6px 0 0; cursor: pointer; font-weight: 600; transition: all 0.3s; }
    .tab-btn.active { background: rgba(255,255,255,0.2); color: white; }

    /* Switch toggle */
    .switch { position: relative; display: inline-block; width: 50px; height: 28px; }
    .switch input { opacity: 0; width: 0; height: 0; }
    .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; transition: .2s; border-radius: 28px; }
    .slider:before { position: absolute; content: ""; height: 22px; width: 22px; left: 3px; bottom: 3px; background-color: white; transition: .2s; border-radius: 50%; }
    input:checked + .slider { background-color: #667eea; }
    input:checked + .slider:before { transform: translateX(22px); }

    /* Danger button */
    .btn-danger { background: #ef4444; color: white; }
    .btn-danger:hover { background: #dc2626; }

    /* Stats Grid */
    .stats-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
      margin-bottom: 30px;
    }

    .stat-card {
      background: rgba(255,255,255,0.95);
      padding: 25px;
      border-radius: 15px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
      transition: all 0.3s;
    }

    .stat-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 25px rgba(0,0,0,0.15);
    }

    .stat-card .icon {
      font-size: 2.5em;
      margin-bottom: 15px;
      opacity: 0.9;
    }

    .stat-card .value {
      font-size: 2.2em;
      font-weight: bold;
      color: #333;
      margin-bottom: 5px;
    }

    .stat-card .label {
      color: #666;
      font-size: 0.95em;
      font-weight: 500;
    }

    .stat-card .change {
      font-size: 0.85em;
      margin-top: 8px;
      padding: 4px 10px;
      border-radius: 12px;
      display: inline-block;
    }

    .stat-card .change.positive {
      background: #d1f4e0;
      color: #00994d;
    }

    .stat-card .change.neutral {
      background: #e2e8f0;
      color: #64748b;
    }

    /* Course List */
    .course-list {
      max-height: 500px;
      overflow-y: auto;
    }

    .course-item {
      padding: 15px;
      border: 1px solid #e5e7eb;
      border-radius: 10px;
      margin-bottom: 12px;
      transition: all 0.3s;
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
    }

    .course-item:hover {
      background: #f9fafb;
      border-color: #667eea;
      box-shadow: 0 2px 8px rgba(102, 126, 234, 0.1);
    }

    .course-item h4 {
      color: #333;
      margin-bottom: 8px;
      font-size: 1.05em;
    }

    .course-item .course-stats {
      display: flex;
      gap: 15px;
      font-size: 0.85em;
      color: #666;
    }

    .course-item .course-stats span {
      display: flex;
      align-items: center;
      gap: 4px;
    }

    /* Activity Feed */
    .activity-feed {
      max-height: 400px;
      overflow-y: auto;
    }

    .activity-item {
      padding: 12px 0;
      border-bottom: 1px solid #e5e7eb;
    }

    .activity-item:last-child {
      border-bottom: none;
    }

    .activity-item .activity-user {
      font-weight: 600;
      color: #333;
    }

    .activity-item .activity-action {
      color: #666;
      font-size: 0.95em;
    }

    .activity-item .activity-time {
      font-size: 0.8em;
      color: #999;
      margin-top: 4px;
    }

    /* Attention List */
    .attention-item {
      padding: 12px;
      background: #fef3cd;
      border-left: 4px solid #ffc107;
      border-radius: 6px;
      margin-bottom: 10px;
    }

    .attention-item .student-name {
      font-weight: 600;
      color: #333;
      margin-bottom: 4px;
    }

    .attention-item .progress-info {
      font-size: 0.85em;
      color: #666;
    }

    /* Chart Container */
    .chart-container {
      position: relative;
      height: 300px;
      margin-top: 20px;
    }

    /* Empty State */
    .empty-state {
      text-align: center;
      padding: 40px 20px;
      color: #999;
    }

    .empty-state i {
      font-size: 3em;
      margin-bottom: 15px;
      opacity: 0.5;
    }

    /* Quick Actions */
    .quick-actions {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
      gap: 15px;
    }

    .action-btn {
      background: rgba(255,255,255,0.95);
      padding: 20px;
      border-radius: 12px;
      text-align: center;
      text-decoration: none;
      color: #333;
      transition: all 0.3s;
      box-shadow: 0 2px 8px rgba(0,0,0,0.08);
      cursor: pointer;
    }

    .action-btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.15);
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
    }

    .action-btn i {
      font-size: 2em;
      margin-bottom: 10px;
      display: block;
    }

    .action-btn span {
      font-weight: 600;
      font-size: 0.95em;
    }

    /* Content Grid */
    .content-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
      gap: 20px;
      margin-bottom: 30px;
    }

    /* Scrollbar */
    ::-webkit-scrollbar {
      width: 8px;
      height: 8px;
    }

    ::-webkit-scrollbar-track {
      background: #f1f1f1;
      border-radius: 10px;
    }

    ::-webkit-scrollbar-thumb {
      background: #667eea;
      border-radius: 10px;
    }

    ::-webkit-scrollbar-thumb:hover {
      background: #764ba2;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .sidebar {
        width: 200px;
      }
      
      .content {
        margin-left: 200px;
      }

      .content-grid {
        grid-template-columns: 1fr;
      }

      .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
      }
    }

    @media (max-width: 576px) {
      .sidebar {
        display: none;
      }
      
      .content {
        margin-left: 0;
      }
    }

    .hidden {
      display: none !important;
    }

    /* TinyMCE Light Mode Override */
    .tox .tox-edit-area__iframe {
      background-color: #ffffff !important;
    }
    
    .tox-tinymce {
      border: 1px solid #ccc !important;
    }
    
    .tox .tox-editor-header {
      background-color: #f0f0f0 !important;
      border-bottom: 1px solid #ccc !important;
    }
    
    .tox .tox-toolbar,
    .tox .tox-toolbar__overflow,
    .tox .tox-toolbar__primary {
      background-color: #f0f0f0 !important;
    }
    
    .tox .tox-menubar,
    .tox .tox-statusbar {
      background-color: #f0f0f0 !important;
    }

    /* Modal Styling */
    .modal {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.5);
      backdrop-filter: blur(4px);
      z-index: 1000;
      align-items: center;
      justify-content: center;
      opacity: 0;
      transition: opacity 0.3s ease;
    }

    .modal.hidden {
      display: none !important;
      opacity: 0;
    }

    .modal.active {
      display: flex !important;
      opacity: 1;
    }

    .modal-content {
      background: white;
      border-radius: 16px;
      width: 90%;
      max-width: 800px;
      max-height: 90vh;
      overflow-y: auto;
      box-shadow: 0 20px 60px rgba(0,0,0,0.3);
      animation: modalSlideIn 0.3s ease;
    }

    @keyframes modalSlideIn {
      from {
        transform: translateY(-50px);
        opacity: 0;
      }
      to {
        transform: translateY(0);
        opacity: 1;
      }
    }

    .modal-header {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 25px 30px;
      border-radius: 16px 16px 0 0;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .modal-header h3 {
      margin: 0;
      font-size: 1.5em;
      font-weight: 600;
    }

    .close-modal {
      background: rgba(255,255,255,0.2);
      border: none;
      color: white;
      font-size: 24px;
      width: 36px;
      height: 36px;
      border-radius: 50%;
      cursor: pointer;
      transition: all 0.3s;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .close-modal:hover {
      background: rgba(255,255,255,0.3);
      transform: rotate(90deg);
    }

    .modal-body {
      padding: 30px;
    }

    .modal-footer {
      padding: 20px 30px;
      border-top: 1px solid #e5e7eb;
      display: flex;
      justify-content: flex-end;
      gap: 12px;
      background: #f9fafb;
      border-radius: 0 0 16px 16px;
    }

    .modal-footer .btn {
      padding: 10px 24px;
      font-size: 15px;
    }

    .modal-footer .btn-primary {
      background: var(--brand-gradient);
    }

    .modal-footer .btn-primary:hover {
      box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }

    .toggle-switch {
      display: flex;
      align-items: center;
      gap: 12px;
      cursor: pointer;
    }

    .toggle-switch .switch {
      position: relative;
      display: inline-block;
      width: 52px;
      height: 28px;
    }

    .toggle-switch .switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }

    .toggle-switch .slider {
      position: absolute;
      cursor: pointer;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: #e5e7eb;
      transition: 0.2s;
      border-radius: 9999px;
    }

    .toggle-switch .slider:before {
      position: absolute;
      content: "";
      height: 22px;
      width: 22px;
      left: 3px;
      bottom: 3px;
      background-color: white;
      transition: 0.2s;
      border-radius: 50%;
      box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
    }

    .toggle-switch input:checked + .slider {
      background: var(--brand-primary, #4f46e5);
    }

    .toggle-switch input:checked + .slider:before {
      transform: translateX(24px);
    }

    .price-preview {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-top: 6px;
    }

    .price-preview .old-price {
      text-decoration: line-through;
      color: #9ca3af;
      font-weight: 600;
    }

    .price-preview .new-price {
      color: #10b981;
      font-weight: 700;
      font-size: 1.05rem;
    }

    .discount-chip {
      background: #f97316;
      color: white;
      padding: 4px 10px;
      border-radius: 9999px;
      font-weight: 700;
      font-size: 12px;
    }
  </style>
</head>
<body>
  <!-- Navbar -->
  <nav class="navbar">
    <div class="navbar-content">
      <div class="brand-heading">
        <div class="logo" aria-label="{{ $siteName }}">
          <span class="brand-symbol {{ $logoUrl ? 'with-image' : '' }}">
            @if($logoUrl)
              <img src="{{ $logoUrl }}" alt="{{ $siteName }} logo">
            @else
              <i class="fas fa-lightbulb" aria-hidden="true"></i>
            @endif
          </span>
          <span class="brand-text">
            <span class="brand-name">{{ $siteName }}</span>
            @if(!empty($siteTagline))
              <span class="brand-tagline">{{ $siteTagline }}</span>
            @endif
          </span>
        </div>
        <span class="brand-context">Tutor Dashboard</span>
      </div>
      <div class="user-info">
        <span>Welcome, <strong>{{ $user->name }}</strong></span>
        @if($user->hasRole('admin'))
          <a href="{{ route('admin.panel') }}" class="btn btn-primary">
            <i class="fas fa-cog"></i> Admin Panel
          </a>
        @endif
        <form method="POST" action="{{ route('logout') }}" style="display: inline;">
          @csrf
          <button type="submit" class="btn btn-secondary">
            <i class="fas fa-sign-out-alt"></i> Logout
          </button>
        </form>
      </div>
    </div>
  </nav>

  <div class="admin-container">
    <!-- Sidebar -->
    <div class="sidebar">
      <h2><i class="fas fa-chalkboard-teacher"></i> Tutor Panel</h2>
      <div class="nav-item active" data-section="dashboard">
        <i class="fas fa-home"></i> Dashboard
      </div>
      <div class="nav-item-with-submenu">
        <div class="nav-item" onclick="toggleSubmenu(event, this)">
          <span><i class="fas fa-book"></i> Courses</span>
          <i class="fas fa-chevron-down submenu-arrow"></i>
        </div>
        <ul class="submenu">
          <li>
            <div class="nav-item" data-section="courses">
              <i class="fas fa-list"></i> All Courses
            </div>
          </li>
          <li>
            <div class="nav-item" data-section="categories">
              <i class="fas fa-tags"></i> Categories
            </div>
          </li>
        </ul>
      </div>
      <div class="nav-item" data-section="students">
        <i class="fas fa-users"></i> Students
      </div>
      <div class="nav-item" data-section="certificates">
        <i class="fas fa-certificate"></i> Certificates
      </div>
      <div class="nav-item" data-section="badges">
        <i class="fas fa-trophy"></i> Badges
      </div>
      <div class="nav-item" data-section="activity">
        <i class="fas fa-history"></i> Recent Activity
      </div>
      <div class="nav-item" data-section="analytics">
        <i class="fas fa-chart-line"></i> Analytics
      </div>
      <div class="nav-item" data-section="quick-actions">
        <i class="fas fa-bolt"></i> Quick Actions
      </div>
    </div>

    <!-- Main Content -->
    <div class="content">
      <!-- Dashboard Section -->
      <section id="dashboard" class="section active">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-chalkboard-teacher"></i> Tutor Dashboard
        </h1>

        <!-- Student Progress Overview (Top) -->
        <div class="card" style="margin-bottom: 20px;">
          <h3><i class="fas fa-chart-bar"></i> Student Progress Overview</h3>
          <div class="chart-container">
            <canvas id="progressChartTop"></canvas>
          </div>
        </div>

        <!-- Stats Grid -->
        <div class="stats-grid">
          <div class="stat-card">
            <div class="icon" style="color: #667eea;">
              <i class="fas fa-book"></i>
            </div>
            <div class="value">{{ $totalCourses }}</div>
            <div class="label">Total Courses</div>
            <div class="change neutral">
              <i class="fas fa-layer-group"></i> {{ $tutorCourses->sum(fn($c) => $c->lessons->count()) }} Lessons
            </div>
          </div>

          <div class="stat-card" onclick="showStudentDetails('total')" style="cursor: pointer; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
            <div class="icon" style="color: #10b981;">
              <i class="fas fa-users"></i>
            </div>
            <div class="value">{{ $totalStudents }}</div>
            <div class="label">Total Students</div>
            <div class="change positive">
              <i class="fas fa-arrow-up"></i> {{ $recentEnrollments }} new this week
            </div>
            <div style="font-size: 11px; color: #6b7280; margin-top: 8px;">
              <i class="fas fa-mouse-pointer"></i> Click for details
            </div>
          </div>

          <div class="stat-card" onclick="showStudentDetails('active')" style="cursor: pointer; transition: transform 0.2s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
            <div class="icon" style="color: #f59e0b;">
              <i class="fas fa-user-check"></i>
            </div>
            <div class="value">{{ $activeStudents }}</div>
            <div class="label">Active Students</div>
            <div class="change neutral">
              <i class="fas fa-clock"></i> Last 7 days
            </div>
            <div style="font-size: 11px; color: #6b7280; margin-top: 8px;">
              <i class="fas fa-mouse-pointer"></i> Click for details
            </div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #3b82f6;">
              <i class="fas fa-chart-line"></i>
            </div>
            <div class="value">{{ $averageProgress }}%</div>
            <div class="label">Avg Progress</div>
            <div class="change neutral">
              <i class="fas fa-tasks"></i> {{ $completedCourses }} completed
            </div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #8b5cf6;">
              <i class="fas fa-clipboard-question"></i>
            </div>
            <div class="value">{{ $totalQuizzes }}</div>
            <div class="label">Total Quizzes</div>
            <div class="change neutral">
              <i class="fas fa-question-circle"></i> Assessment items
            </div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #ec4899;">
              <i class="fas fa-certificate"></i>
            </div>
            <div class="value">{{ $certificatesIssued }}</div>
            <div class="label">Certificates Issued</div>
            <div class="change neutral">
              <i class="fas fa-award"></i> {{ $certificateTemplates }} templates
            </div>
          </div>
        </div>

        <!-- Overview Cards -->
        <div class="content-grid">
          <div class="card">
            <h3><i class="fas fa-chart-area"></i> Quick Overview</h3>
            <p style="color: #666; line-height: 1.8;">
              Welcome to your tutor dashboard! You have <strong>{{ $totalCourses }} courses</strong> with 
              <strong>{{ $tutorCourses->sum(fn($c) => $c->lessons->count()) }} lessons</strong> and 
              <strong>{{ $tutorCourses->sum(fn($c) => $c->lessons->sum(fn($l) => $l->topics->count())) }} topics</strong>. 
              Currently, <strong>{{ $activeStudents }} students</strong> are actively learning.
            </p>
          </div>

          <div class="card">
            <h3><i class="fas fa-bullhorn"></i> Important Notes</h3>
            @if($studentsNeedingAttention->count() > 0)
              <p style="color: #f59e0b; font-weight: 600;">
                <i class="fas fa-exclamation-triangle"></i> {{ $studentsNeedingAttention->count() }} students need your attention!
              </p>
            @else
              <p style="color: #10b981;">
                <i class="fas fa-check-circle"></i> All students are progressing well!
              </p>
            @endif
            <p style="color: #666; margin-top: 10px;">
              {{ $recentEnrollments }} new students joined this week.
            </p>
          </div>
        </div>
      </section>

      <!-- Courses Section -->
      <section id="courses" class="section">
        <div class="section-header">
          <h1>📚 Course Management</h1>
          <p>Create and manage learning courses, lessons, and topics (Only courses you created)</p>
        </div>

        <!-- Tabs Navigation (Admin-style) -->
        <div style="display: flex; gap: 10px; margin-bottom: 20px; border-bottom: 2px solid rgba(255,255,255,0.2); padding-bottom: 10px;">
          <button class="tab-btn active" data-tab="courses-list" style="background: rgba(255,255,255,0.2); color: white; border: none; padding: 10px 20px; border-radius: 6px 6px 0 0; cursor: pointer; font-weight: 600; transition: all 0.3s;">
            <i class="fas fa-graduation-cap"></i> All Courses
          </button>
          <button class="tab-btn" data-tab="lessons-topics" style="background: transparent; color: rgba(255,255,255,0.7); border: none; padding: 10px 20px; border-radius: 6px 6px 0 0; cursor: pointer; font-weight: 600; transition: all 0.3s;">
            <i class="fas fa-book-open"></i> Lessons & Topics
          </button>
        </div>

        <!-- Tab Content: All Courses (Admin module) -->
        <div id="courses-list-tab" class="tab-content">
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3 style="color: white; margin: 0;">📚 All Courses</h3>
            <button id="add-course-btn" class="btn btn-primary">
              <i class="fas fa-plus"></i> Add New Course
            </button>
          </div>

          <!-- Courses Table -->
          <div class="card">
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; gap: 10px;">
            <h3 style="margin: 0;">📚 All Courses</h3>
            <div style="display: flex; gap: 10px; align-items: center;">
              <input type="text" id="course-search" class="search-input" placeholder="🔍 Search courses..." style="width: 300px; margin-bottom: 0;">
              <select id="course-category-filter" class="form-control" style="min-width: 180px; margin-bottom: 0;">
                <option value="">📁 All Categories</option>
              </select>
              <select id="course-language-filter" class="form-control" style="min-width: 180px; margin-bottom: 0;">
                <option value="">🌐 All languages</option>
              </select>
            </div>
          </div>
          
          <div class="table-responsive">
            <table class="data-table">
              <thead>
                <tr>
                  <th style="width: 25%;">Course Name</th>
                  <th style="width: 12%;">Category</th>
                  <th style="width: 12%;">Status</th>
                  <th style="width: 10%;">Lessons</th>
                  <th style="width: 10%;">Enrolled</th>
                  <th style="width: 10%;">Completion</th>
                  <th style="width: 16%;">Actions</th>
                </tr>
              </thead>
              <tbody id="courses-table-body">
                <tr>
                  <td colspan="7" style="text-align: center; padding: 40px;">
                    <i class="fas fa-spinner fa-spin" style="font-size: 24px; color: #667eea;"></i>
                    <p style="margin-top: 10px; color: #999;">Loading courses...</p>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
        </div>

        <!-- Tab Content: Lessons & Topics (Admin module) -->
        <div id="lessons-topics-tab" class="tab-content hidden">
          <!-- Header Section -->
          <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 25px; border-radius: 15px; margin-bottom: 25px; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
              <div>
                <h2 style="color: white; margin: 0 0 8px 0; font-size: 28px; display: flex; align-items: center; gap: 10px;">
                  <i class="fas fa-graduation-cap"></i> Course Management
                </h2>
                <p style="color: rgba(255,255,255,0.9); margin: 0; font-size: 15px;">
                  Create and organize courses, lessons, topics, and quiz questions
                </p>
              </div>
              <div style="display: flex; gap: 10px; align-items: center;">
                <select id="content-course-filter" style="padding: 10px 15px; border: 2px solid rgba(255,255,255,0.3); background: rgba(255,255,255,0.95); border-radius: 8px; font-size: 14px; min-width: 280px; cursor: pointer;">
                  <option value="">📚 Select Course to Manage</option>
                </select>
                <button id="add-lesson-btn" class="btn" disabled style="background: rgba(255,255,255,0.2); color: white; border: 2px solid rgba(255,255,255,0.3); padding: 10px 20px; border-radius: 8px; font-weight: 600; cursor: not-allowed; transition: all 0.3s;">
                  <i class="fas fa-plus-circle"></i> Add Lesson
                </button>
              </div>
            </div>
          </div>

          <!-- Main Content Area -->
          <div style="display: grid; grid-template-columns: 1fr; gap: 20px;">
            <!-- Course Tree View - Full Width -->
            <div class="card" style="background: white; border-radius: 15px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.08);">
              <div style="display: flex; justify-content: between; align-items: center; margin-bottom: 20px; border-bottom: 2px solid #f3f4f6; padding-bottom: 15px;">
                <h3 style="margin: 0; color: #1f2937; font-size: 20px; display: flex; align-items: center; gap: 10px;">
                  <i class="fas fa-sitemap" style="color: #667eea;"></i> 
                  Course Structure
                </h3>
                <div style="color: #6b7280; font-size: 14px;">
                  <i class="fas fa-info-circle"></i> Drag to reorder lessons and topics
                </div>
              </div>
              <div id="content-tree" class="content-tree" style="min-height: 400px;">
                <div style="text-align: center; padding: 60px 20px; color: #9ca3af;">
                  <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); width: 100px; height: 100px; border-radius: 50%; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);">
                    <i class="fas fa-book-open" style="font-size: 42px; color: white;"></i>
                  </div>
                  <h4 style="color: #4b5563; margin: 0 0 10px 0; font-size: 18px;">No Course Selected</h4>
                  <p style="margin: 0; font-size: 14px; color: #9ca3af;">Select a course from the dropdown above to view and manage its lessons and topics</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Course Modal (Admin module) -->
        <div id="course-modal" class="modal hidden">
          <div class="modal-content" style="max-width: 700px;">
            <div class="modal-header">
              <h2 id="course-modal-title">✨ Add New Course</h2>
              <button class="close-modal" onclick="closeCourseModal()">&times;</button>
            </div>
            <div class="modal-body">
              <form id="course-form">
                <input type="hidden" id="course-id">
                
                <div class="form-group">
                  <label>Course Name <span style="color: #ef4444;">*</span></label>
                  <input type="text" id="course-name" class="form-control" required placeholder="Enter course name">
                </div>

                <div class="form-group">
                  <label>📚 Category <span style="color: #ef4444;">*</span></label>
                  <select id="course-category" class="form-control" required>
                    <option value="">Select a category</option>
                  </select>
                  <small style="color: #6b7280;">Select the category for this course</small>
                </div>

                <div class="form-group">
                  <label>🌐 Language <span style="color: #ef4444;">*</span></label>
                  <select id="course-language" class="form-control" required>
                    <option value="">Select language</option>
                  </select>
                  <small style="color: #6b7280;">Select the language for this course</small>
                </div>

                <div class="grid grid-cols-2 gap-4">
                  <div class="form-group">
                    <label>Slug</label>
                    <input type="text" id="course-slug" class="form-control" placeholder="auto-generated">
                    <small style="color: #6b7280;">URL-friendly identifier (leave empty for auto-generation)</small>
                  </div>

                  <div class="form-group">
                    <label>Chunk Words</label>
                    <input type="number" id="course-chunk-words" class="form-control" value="{{ $chunkWordsSettings['default'] }}" min="{{ $chunkWordsSettings['min'] }}" max="{{ $chunkWordsSettings['max'] }}">
                    <small style="color: #6b7280;">Words per content chunk (min: {{ $chunkWordsSettings['min'] }}, max: {{ $chunkWordsSettings['max'] }})</small>
                  </div>

                  <!-- Study Time Limits -->
                  <div class="form-group">
                    <label style="display: flex; align-items: center; cursor: pointer;">
                      <input type="checkbox" id="course-enable-study-time" style="margin-right: 10px;">
                      <span>⏱️ Enable Daily Study Time Limits</span>
                    </label>
                    <small style="color: #6b7280;">Set minimum and maximum study time per day</small>
                  </div>

                  <div id="study-time-fields" class="hidden" style="padding-left: 20px; margin-top: 10px;">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                      <div class="form-group">
                        <label>Min. Minutes Per Day</label>
                        <input type="number" id="course-min-study-minutes" class="form-control" value="15" min="0" max="1440">
                        <small style="color: #6b7280;">Minimum daily goal</small>
                      </div>
                      <div class="form-group">
                        <label>Max. Minutes Per Day</label>
                        <input type="number" id="course-max-study-minutes" class="form-control" value="60" min="0" max="1440">
                        <small style="color: #6b7280;">Maximum allowed per day</small>
                      </div>
                    </div>
                  </div>

                  <!-- Course Survey -->
                  <div class="form-group">
                    <label style="display: flex; align-items: center; cursor: pointer;">
                      <input type="checkbox" id="course-enable-survey" style="margin-right: 10px;">
                      <span>📋 Enable Course Survey/Feedback</span>
                    </label>
                    <small style="color: #6b7280;">Collect feedback or survey from students upon completion</small>
                  </div>

                  <div id="survey-fields" class="hidden" style="padding-left: 20px; margin-top: 15px; border-left: 3px solid #667eea; padding-left: 15px;">
                    
                    <!-- Survey Mode Selection -->
                    <div class="form-group" style="margin-bottom: 20px;">
                      <label style="font-weight: 600; margin-bottom: 10px; display: block;">Select Mode</label>
                      <div style="display: flex; gap: 20px;">
                        <label style="display: flex; align-items: center; cursor: pointer;">
                          <input type="radio" name="survey-mode" value="feedback" id="survey-mode-feedback" checked style="margin-right: 8px;">
                          <span>
                            <strong>Feedback</strong> 
                            <small style="display: block; color: #6b7280; margin-top: 2px;">Simple rating & comment form</small>
                          </span>
                        </label>
                        <label style="display: flex; align-items: center; cursor: pointer;">
                          <input type="radio" name="survey-mode" value="survey" id="survey-mode-survey" style="margin-right: 8px;">
                          <span>
                            <strong>Survey</strong>
                            <small style="display: block; color: #6b7280; margin-top: 2px;">Comprehensive survey with multiple question types</small>
                          </span>
                        </label>
                      </div>
                    </div>

                    <div class="form-group">
                      <label>Title</label>
                      <input type="text" id="course-survey-title" class="form-control" placeholder="e.g., Course Feedback or Course Survey">
                    </div>
                    <div class="form-group">
                      <label>Description</label>
                      <textarea id="course-survey-description" class="form-control" rows="2" placeholder="Brief description shown to students"></textarea>
                    </div>
                    
                    <div id="feedback-mode-info" style="background: #eff6ff; border: 1px solid #3b82f6; border-radius: 6px; padding: 12px; margin-top: 10px;">
                      <p style="margin: 0; color: #1e40af; font-size: 13px;">
                        <i class="fas fa-info-circle"></i> <strong>Feedback Mode:</strong> Automatically provides a rating (1-5 stars) and a comment field for students.
                      </p>
                    </div>
                    
                    <div id="survey-mode-info" class="hidden" style="background: #f0fdf4; border: 1px solid #10b981; border-radius: 6px; padding: 12px; margin-top: 10px;">
                      <p style="margin: 0; color: #065f46; font-size: 13px;">
                        <i class="fas fa-info-circle"></i> <strong>Survey Mode:</strong> After creating the course, click "Manage Survey" to build custom questions with multiple choice, dropdown, checkboxes, text inputs, and rating scales.
                      </p>
                    </div>
                  </div>
                </div>

                <div class="form-group">
                  <label>Short Description</label>
                  <textarea id="course-description" class="form-control" rows="3" placeholder="Brief description of the course"></textarea>
                </div>

                <div class="form-group">
                  <label class="toggle-switch" for="course-pricing-toggle">
                    <span class="switch">
                      <input type="checkbox" id="course-pricing-toggle">
                      <span class="slider"></span>
                    </span>
                    <div>
                      <div style="font-weight: 600;">Enable Pricing (Paid Course)</div>
                      <div style="color: #6b7280; font-size: 12px;">Turn off to keep the course free.</div>
                    </div>
                  </label>
                </div>

                <div id="course-pricing-fields" class="grid grid-cols-4 gap-4 hidden">
                  <div class="form-group">
                    <label>Price <span style="color: #ef4444;">*</span></label>
                    <input type="number" step="0.01" min="0" id="course-price" class="form-control" placeholder="0.00">
                  </div>
                  <div class="form-group">
                    <label>Discount</label>
                    <input type="number" step="0.01" min="0" id="course-discount" class="form-control" placeholder="0.00">
                  </div>
                  <div class="form-group">
                    <label>Discount Type</label>
                    <select id="course-discount-type" class="form-control">
                      <option value="amount">Amount off</option>
                      <option value="percent">Percentage off</option>
                    </select>
                  </div>
                  <div class="form-group">
                    <label>Currency</label>
                    <input type="text" id="course-currency" class="form-control" maxlength="3" placeholder="USD" style="text-transform: uppercase;">
                  </div>
                  <div class="form-group col-span-4 hidden" id="course-discount-preview" style="background: #ecfdf3; border: 1px solid #bbf7d0; border-radius: 10px; padding: 10px;">
                    <div style="font-weight: 600; color: #065f46; margin-bottom: 4px;">Discount preview</div>
                    <div class="price-preview">
                      <span class="old-price" id="course-original-price">$0.00</span>
                      <span class="new-price" id="course-final-price">$0.00</span>
                      <span class="discount-chip" id="course-discount-chip">0% off</span>
                    </div>
                    <small style="color: #065f46;">Students will see the discounted price with the original price struck through.</small>
                  </div>
                </div>

                <div class="form-group">
                  <label>Course Thumbnail</label>
                  <input type="file" id="course-thumbnail" accept="image/*" class="form-control">
                  <img id="course-thumbnail-preview" src="" alt="Course thumbnail preview" style="margin-top: 8px; max-height: 140px; border-radius: 8px; border: 1px solid #e5e7eb; display: none;">
                  <small style="color: #6b7280;">Shown on course cards and checkout pages</small>
                </div>

                <div class="form-group">
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" id="course-has-prerequisite" style="margin-right: 10px;">
                    <span>This course requires a prerequisite</span>
                  </label>
                </div>

                <div id="prerequisite-select-container" class="form-group hidden">
                  <label>Select Prerequisite Course <span style="color: #ef4444;">*</span></label>
                  <select id="course-prerequisite" class="form-control">
                    <option value="">-- Select a prerequisite course --</option>
                  </select>
                  <small style="color: #6b7280;">Users must complete this course before accessing the current one</small>
                </div>

                <div class="form-group">
                  <label style="font-weight: 600; margin-bottom: 10px;">Completion Behavior</label>
                  <div style="display: flex; gap: 20px; margin-bottom: 15px;">
                    <label style="display: flex; align-items: center; cursor: pointer;">
                      <input type="radio" name="completion-type" value="certificate" id="completion-certificate" style="margin-right: 8px;">
                      <span>📜 Issue Certificate</span>
                    </label>
                    <label style="display: flex; align-items: center; cursor: pointer;">
                      <input type="radio" name="completion-type" value="instructions" id="completion-instructions-radio" style="margin-right: 8px;">
                      <span>📋 Show Instructions</span>
                    </label>
                    <label style="display: flex; align-items: center; cursor: pointer;">
                      <input type="radio" name="completion-type" value="none" id="completion-none" checked style="margin-right: 8px;">
                      <span>❌ None</span>
                    </label>
                  </div>
                </div>

                <div id="certificate-template-group" class="form-group hidden">
                  <label>Select Certificate Template</label>
                  <select id="course-certificate" name="certificate_template" class="form-control">
                    <option value="">No certificate selected</option>
                    <!-- Will be populated dynamically -->
                  </select>
                  <small style="color: #6b7280;">Select a certificate template that will be generated when users complete the course</small>
                </div>

                <div id="completion-instructions-group" class="form-group hidden">
                  <label>Completion Instructions</label>
                  <textarea id="course-instructions" class="form-control" rows="4" placeholder="Instructions or next steps shown to users upon course completion"></textarea>
                  <small style="color: #6b7280;">Provide guidance on what students should do after completing this course</small>
                </div>

                <div class="form-group">
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" id="course-active" style="margin-right: 10px;" checked>
                    <span>Active Course</span>
                  </label>
                  <small style="color: #6b7280;">Only active courses are visible to users</small>
                </div>

                <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                  <button type="button" class="btn btn-secondary" onclick="closeCourseModal()">Cancel</button>
                  <button type="submit" class="btn btn-primary" id="save-course-btn">
                    <i class="fas fa-save"></i> <span id="save-course-text">Create Course</span>
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>

        <!-- Survey Management Modal (Admin module) -->
        <div id="survey-modal" class="modal hidden">
          <div class="modal-content" style="max-width: 800px; max-height: 90vh; overflow-y: auto;">
            <div class="modal-header">
              <h2 id="survey-modal-title">📋 Manage Course Survey</h2>
              <button class="close-modal" onclick="closeSurveyModal()">&times;</button>
            </div>
            <div class="modal-body">
              <div style="background: #f0f9ff; border-left: 4px solid #3b82f6; padding: 15px; margin-bottom: 20px; border-radius: 4px;">
                <p style="color: #1e40af; font-size: 14px; margin: 0;">
                  <i class="fas fa-info-circle"></i> Create survey questions to collect feedback from students when they complete this course.
                </p>
              </div>

              <div id="survey-questions-list" style="margin-bottom: 20px;"></div>

              <button type="button" class="btn btn-secondary" onclick="addSurveyQuestion()" style="width: 100%; margin-bottom: 20px;">
                <i class="fas fa-plus"></i> Add Question
              </button>

              <div style="display: flex; justify-content: flex-end; gap: 10px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
                <button type="button" class="btn btn-secondary" onclick="closeSurveyModal()">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveSurveyQuestions()">
                  <i class="fas fa-save"></i> Save Survey
                </button>
              </div>
            </div>
          </div>
        </div>

        <!-- Survey Results Modal (Tutor) -->
        <div id="survey-results-modal" class="modal hidden">
          <div class="modal-content" style="max-width: 900px; max-height: 90vh; overflow-y: auto;">
            <div class="modal-header" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
              <h2 id="survey-results-title">📊 Survey Results</h2>
              <button class="close-modal" onclick="closeSurveyResultsModal()">&times;</button>
            </div>
            <div class="modal-body">
              <div id="survey-results-loading" style="text-align: center; padding: 40px;">
                <i class="fas fa-spinner fa-spin" style="font-size: 32px; color: #3b82f6;"></i>
                <p style="color: #6b7280; margin-top: 15px;">Loading survey results...</p>
              </div>
              
              <div id="survey-results-content" class="hidden">
                <!-- Summary Stats -->
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 30px;">
                  <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 20px; border-radius: 8px; color: white;">
                    <div style="font-size: 14px; opacity: 0.9;">Total Responses</div>
                    <div id="total-responses" style="font-size: 32px; font-weight: 700; margin-top: 5px;">0</div>
                  </div>
                  <div style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); padding: 20px; border-radius: 8px; color: white;">
                    <div style="font-size: 14px; opacity: 0.9;">Average Rating</div>
                    <div id="avg-rating" style="font-size: 32px; font-weight: 700; margin-top: 5px;">-</div>
                  </div>
                  <div style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); padding: 20px; border-radius: 8px; color: white;">
                    <div style="font-size: 14px; opacity: 0.9;">Response Rate</div>
                    <div id="response-rate" style="font-size: 32px; font-weight: 700; margin-top: 5px;">-</div>
                  </div>
                </div>

                <!-- Questions & Answers -->
                <div id="questions-results-list">
                  <!-- Results will be dynamically added here -->
                </div>
              </div>

              <div id="survey-no-responses" class="hidden" style="text-align: center; padding: 40px;">
                <i class="fas fa-inbox" style="font-size: 48px; color: #d1d5db;"></i>
                <p style="color: #6b7280; margin-top: 15px; font-size: 16px;">No survey responses yet.</p>
                <p style="color: #9ca3af; font-size: 14px;">Students will be prompted to complete the survey when they finish the course.</p>
              </div>
            </div>
          </div>
        </div>

        <!-- Delete Confirmation Modal (Admin module) -->
        <div id="delete-course-modal" class="modal hidden">
          <div class="modal-content" style="max-width: 500px;">
            <div class="modal-header" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
              <h2>🗑️ Delete Course</h2>
              <button class="close-modal" onclick="closeDeleteCourseModal()">&times;</button>
            </div>
            <div class="modal-body">
              <p style="font-size: 16px; color: #374151; margin-bottom: 15px;">Are you sure you want to delete this course?</p>
              <div style="background: #fee2e2; border-left: 4px solid #ef4444; padding: 15px; margin-bottom: 20px; border-radius: 4px;">
                <p style="font-weight: 600; color: #991b1b; margin-bottom: 5px;">⚠️ This action cannot be undone!</p>
                <p style="color: #7f1d1d; font-size: 14px;">This will permanently delete course details, lessons, topics, and related data.</p>
              </div>
              <div style="background: #f9fafb; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
                <p style="font-weight: 600; color: #374151; margin-bottom: 5px;">Course: <span id="delete-course-name" style="color: #667eea;"></span></p>
                <p style="font-size: 14px; color: #6b7280;">ID: <span id="delete-course-id"></span></p>
              </div>
              <div style="display: flex; justify-content: flex-end; gap: 10px;">
                <button type="button" class="btn btn-secondary" onclick="closeDeleteCourseModal()">Cancel</button>
                <button type="button" class="btn btn-danger" onclick="confirmDeleteCourse()"><i class="fas fa-trash"></i> Delete Permanently</button>
              </div>
            </div>
          </div>
        </div>

        <!-- Lesson Modal (Admin module) -->
        <div id="lessonModal" class="modal hidden">
          <div class="modal-content" style="max-width: 800px; max-height: 90vh; overflow-y: auto;">
            <div class="modal-header">
              <h2 id="lesson-modal-title">Add New Lesson</h2>
              <button class="close-modal" onclick="closeModal('lessonModal')">&times;</button>
            </div>
            <div class="modal-body">
              <form id="lesson-form">
                <input type="hidden" id="lesson-id" name="id">
                <input type="hidden" id="lesson-course-id" name="course_id">
                
                <div class="form-group">
                  <label>Lesson Name <span style="color: #ef4444;">*</span></label>
                  <input type="text" id="lesson-name" name="name" class="form-control" required placeholder="Enter lesson name">
                </div>

                <div class="form-group">
                  <label>Description</label>
                  <textarea id="lesson-description" name="intro" class="form-control" rows="4" placeholder="Brief description of the lesson"></textarea>
                </div>

                <div class="form-group" style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 15px; background: #f9fafb;">
                  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                    <label style="margin: 0; font-weight: 600;">📎 Attach Study Material</label>
                    <label class="switch">
                      <input type="checkbox" id="lesson-share-enabled" name="share_enabled">
                      <span class="slider round"></span>
                    </label>
                  </div>

                  <div id="lesson-share-panel" class="hidden" style="margin-top: 15px;">
                    <div class="form-group">
                      <label>Attachment Type</label>
                      <select id="lesson-share-type" name="share_type" class="form-control">
                        <option value="upload">Upload File</option>
                        <option value="link">External Link</option>
                      </select>
                    </div>

                    <div id="lesson-upload-section" class="form-group">
                      <label>Upload File</label>
                      <input type="file" id="lesson-file-upload" class="form-control">
                      <button type="button" id="lesson-upload-btn" class="btn btn-secondary" style="margin-top: 10px;">
                        <i class="fas fa-upload"></i> Upload
                      </button>
                      <input type="hidden" id="lesson-share-url" name="share_url">
                      <input type="hidden" id="lesson-share-filename" name="share_filename">
                      <input type="hidden" id="lesson-share-size" name="share_size">
                      <p id="lesson-upload-status" class="text-sm" style="margin-top: 5px; color: #6b7280;"></p>
                    </div>

                    <div id="lesson-link-section" class="form-group hidden">
                      <label>External URL</label>
                      <input type="url" id="lesson-link-url" class="form-control" placeholder="https://...">
                    </div>
                  </div>
                </div>

                <div class="form-group" style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 15px; background: #f9fafb;">
                  <div style="display: flex; justify-content: space-between; align-items: center;">
                    <label style="margin: 0; font-weight: 600;">📝 Lesson Quiz</label>
                    <label class="switch">
                      <input type="checkbox" id="lesson-has-quiz" name="has_quiz">
                      <span class="slider round"></span>
                    </label>
                  </div>
                  <p class="text-sm" style="margin-top: 5px; color: #6b7280;">Enable quiz for this lesson (manage questions after saving)</p>
                </div>

                <div class="form-group" style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 15px; background: #f9fafb;">
                  <div style="display: flex; justify-content: space-between; align-items: center;">
                    <label style="margin: 0; font-weight: 600;">🏆 Lesson Certificate</label>
                    <label class="switch">
                      <input type="checkbox" id="lesson-has-certificate" name="has_certificate">
                      <span class="slider round"></span>
                    </label>
                  </div>
                  <p class="text-sm" style="margin-top: 5px; color: #6b7280;">Award certificate upon lesson completion</p>
                  <div id="lesson-certificate-panel" class="hidden" style="margin-top: 15px;">
                    <div class="form-group">
                      <label>Select Certificate Template</label>
                      <select id="lesson-certificate-id" name="certificate_id" class="form-control">
                        <option value="">No certificate selected</option>
                      </select>
                      <p class="text-sm" style="margin-top: 5px; color: #9ca3af;">Certificate templates will be created in the certificate builder</p>
                    </div>
                  </div>
                </div>

                <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                  <button type="button" class="btn btn-secondary" onclick="closeModal('lessonModal')">Cancel</button>
                  <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Lesson
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>

        <!-- Topic Modal (Admin module) -->
        <div id="topicModal" class="modal hidden">
          <div class="modal-content" style="max-width: 900px; max-height: 90vh; overflow-y: auto;">
            <div class="modal-header">
              <h2 id="topic-modal-title">Add New Topic</h2>
              <button class="close-modal" onclick="closeModal('topicModal')">&times;</button>
            </div>
            <div class="modal-body">
              <form id="topic-form">
                <input type="hidden" id="topic-id" name="topic_id">
                <input type="hidden" id="topic-lesson-id" name="lesson_id">
                
                <div class="form-group">
                  <label>Topic Title <span style="color: #ef4444;">*</span></label>
                  <input type="text" id="topic-title" name="title" class="form-control" required placeholder="Enter topic title">
                </div>

                <div class="form-group">
                  <label>Content</label>
                  <textarea id="topic-body" name="body" class="form-control" rows="8" placeholder="Enter topic content..."></textarea>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                  <div class="form-group">
                    <label>📹 Video URL (optional)</label>
                    <input type="url" id="topic-video-url" name="video_url" class="form-control" placeholder="https://youtube.com/watch?v=...">
                    <p class="text-sm" style="margin-top: 5px; color: #6b7280;">YouTube, Vimeo, or direct video URL</p>
                  </div>

                  <div class="form-group">
                    <label>🖼️ Image URL (optional)</label>
                    <input type="url" id="topic-image-url" name="image_url" class="form-control" placeholder="https://...">
                    <button type="button" id="topic-image-upload-btn" class="btn btn-secondary" style="margin-top: 5px; width: 100%;">
                      <i class="fas fa-upload"></i> Or Upload Image
                    </button>
                    <input type="file" id="topic-image-file" accept="image/*" class="hidden">
                    <p id="topic-image-status" class="text-sm" style="margin-top: 5px; color: #6b7280;"></p>
                  </div>
                </div>

                <div class="form-group" style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 15px; background: #f9fafb;">
                  <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div>
                      <label style="margin: 0; font-weight: 600;">👁️ Publish Topic</label>
                      <p class="text-sm" style="margin-top: 5px; color: #6b7280;">Make this topic visible to students</p>
                    </div>
                    <label class="switch">
                      <input type="checkbox" id="topic-is-published" name="is_published" checked>
                      <span class="slider round"></span>
                    </label>
                  </div>
                </div>

                <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                  <button type="button" class="btn btn-secondary" onclick="closeModal('topicModal')">Cancel</button>
                  <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Topic
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>

        <!-- Quiz Management Modal (Admin module) -->
        <div id="quizModal" class="modal hidden">
          <div class="modal-content" style="max-width: 1000px; max-height: 90vh; overflow-y: auto;">
            <div class="modal-header">
              <h2>📝 Manage Quiz Questions</h2>
              <button class="close-modal" onclick="closeModal('quizModal')">&times;</button>
            </div>
            <div class="modal-body">
              <input type="hidden" id="quiz-lesson-id">
              <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <p class="text-sm" style="color: #6b7280;">Manage questions for: <strong id="quiz-lesson-name"></strong></p>
                <button type="button" class="btn btn-primary" onclick="addQuizQuestion()">
                  <i class="fas fa-plus"></i> Add Question
                </button>
              </div>

              <div id="quiz-questions-list" class="space-y-4">
                <div style="text-align: center; padding: 40px; color: #999;">
                  <i class="fas fa-spinner fa-spin" style="font-size: 24px;"></i>
                  <p style="margin-top: 10px;">Loading quiz questions...</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Quiz Question Edit Modal (Admin module) -->
        <div id="quizQuestionModal" class="modal hidden">
          <div class="modal-content" style="max-width: 700px;">
            <div class="modal-header">
              <h2 id="quiz-question-modal-title">Add Quiz Question</h2>
              <button class="close-modal" onclick="closeModal('quizQuestionModal')">&times;</button>
            </div>
            <div class="modal-body">
              <form id="quiz-question-form">
                <input type="hidden" id="quiz-question-id">
                <input type="hidden" id="quiz-question-lesson-id">

                <div class="form-group">
                  <label>Question <span style="color: #ef4444;">*</span></label>
                  <textarea id="quiz-question-text" class="form-control" rows="3" required placeholder="Enter your question"></textarea>
                </div>

                <div class="form-group">
                  <label>Answer Options <span style="color: #ef4444;">*</span></label>
                  <div id="quiz-options-container" style="space-y-2;"></div>
                  <button type="button" class="btn btn-secondary btn-sm" onclick="addQuizOption()" style="margin-top: 10px;">
                    <i class="fas fa-plus"></i> Add Option
                  </button>
                </div>

                <div class="form-group">
                  <label>Explanation (optional)</label>
                  <textarea id="quiz-question-explanation" class="form-control" rows="2" placeholder="Explain why this is the correct answer"></textarea>
                </div>

                <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                  <button type="button" class="btn btn-secondary" onclick="closeModal('quizQuestionModal')">Cancel</button>
                  <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Save Question
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>

        <!-- Tab Content: All Courses -->
  <div id="tutor-courses-list-tab" class="tutor-tab-content hidden">
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3 style="color: white; margin: 0;">📚 All Courses</h3>
            <button id="tutor-add-course-btn" class="btn btn-primary">
              <i class="fas fa-plus"></i> Add New Course
            </button>
          </div>

          <!-- Quick Stats Summary -->
          <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 25px;">
            <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 20px; border-radius: 12px; color: white; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
              <div style="font-size: 13px; opacity: 0.9; margin-bottom: 8px;"><i class="fas fa-book"></i> Total Courses</div>
              <div id="tutor-stats-total-courses" style="font-size: 32px; font-weight: 700;">-</div>
            </div>
            <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 20px; border-radius: 12px; color: white; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
              <div style="font-size: 13px; opacity: 0.9; margin-bottom: 8px;"><i class="fas fa-users"></i> Total Students</div>
              <div id="tutor-stats-total-students" style="font-size: 32px; font-weight: 700;">-</div>
            </div>
            <div style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); padding: 20px; border-radius: 12px; color: white; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
              <div style="font-size: 13px; opacity: 0.9; margin-bottom: 8px;"><i class="fas fa-graduation-cap"></i> Total Lessons</div>
              <div id="tutor-stats-total-lessons" style="font-size: 32px; font-weight: 700;">-</div>
            </div>
            <div style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); padding: 20px; border-radius: 12px; color: white; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
              <div style="font-size: 13px; opacity: 0.9; margin-bottom: 8px;"><i class="fas fa-chart-line"></i> Avg. Completion</div>
              <div id="tutor-stats-avg-completion" style="font-size: 32px; font-weight: 700;">-</div>
            </div>
          </div>

          <!-- Courses Table -->
          <div class="card">
          <div style="display: flex; justify-content: space-between; align-items: center; gap: 12px; margin-bottom: 20px; flex-wrap: nowrap; width: 100%; overflow-x: auto;">
            <h3 style="margin: 0; flex-shrink: 0;">📚 All Courses</h3>
            <div style="display: flex; gap: 8px; align-items: center; flex-wrap: nowrap; flex: 1; justify-content: flex-end; min-width: 0; white-space: nowrap;">
              <input type="text" id="tutor-course-search" class="search-input" placeholder="🔍 Search courses..." style="width: 190px; min-width: 150px; margin-bottom: 0; flex-shrink: 0;">
              <select id="tutor-language-filter" class="form-control" style="min-width: 160px; width: 180px; flex-shrink: 0;">
                <option value="">🌐 All languages</option>
              </select>
            </div>
          </div>
            
            <div class="table-responsive">
              <table class="data-table">
                <thead>
                  <tr>
                    <th style="width: 30%;">Course Name</th>
                    <th style="width: 15%;">Status</th>
                    <th style="width: 15%;">Lessons</th>
                    <th style="width: 15%;">Enrolled</th>
                    <th style="width: 10%;">Completion</th>
                    <th style="width: 15%;">Actions</th>
                  </tr>
                </thead>
                <tbody id="tutor-courses-table-body">
                  <tr>
                    <td colspan="6" style="text-align: center; padding: 40px;">
                      <i class="fas fa-spinner fa-spin" style="font-size: 24px; color: #667eea;"></i>
                      <p style="margin-top: 10px; color: #999;">Loading courses...</p>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <!-- Tab Content: Lessons & Topics -->
        <div id="tutor-lessons-topics-tab" class="tutor-tab-content hidden">
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; flex-wrap: wrap; gap: 15px;">
            <div>
              <h3 style="color: white; margin: 0 0 5px 0;">📖 Manage Lessons & Topics</h3>
              <p style="color: rgba(255,255,255,0.8); margin: 0; font-size: 14px;">Select a course to view and edit its content structure</p>
            </div>
            <div style="display: flex; gap: 10px;">
              <select id="tutor-content-course-filter" style="margin-bottom: 0; min-width: 300px;">
                <option value="">Select Course to Manage</option>
              </select>
              <button id="tutor-add-lesson-btn" class="btn btn-primary" disabled style="opacity: 0.5;">
                <i class="fas fa-plus"></i> Add Lesson
              </button>
            </div>
          </div>

          <div class="grid grid-3" style="grid-template-columns: 1fr 2fr; gap: 20px;">
            <!-- Course Tree View -->
            <div class="card">
              <h3>📋 Content Structure</h3>
              <div id="tutor-content-tree" class="content-tree">
                <div style="text-align: center; padding: 40px 20px; color: #999;">
                  <i class="fas fa-folder-open" style="font-size: 48px; color: #667eea; opacity: 0.5;"></i>
                  <p style="margin-top: 15px; font-size: 14px;">Select a course to view its lessons and topics</p>
                </div>
              </div>
            </div>

            <!-- Editor Panel -->
            <div>
              <div id="tutor-lesson-editor-old" class="card hidden">
                <p style="text-align: center; padding: 40px; color: #999;">
                  <i class="fas fa-info-circle" style="font-size: 48px; margin-bottom: 15px; display: block;"></i>
                  Lesson editing now uses modal windows.<br>
                  Click the Edit button on a lesson to open the editor.
                </p>
              </div>

              <div id="tutor-topic-editor-old" class="card hidden">
                <p style="text-align: center; padding: 40px; color: #999;">
                  <i class="fas fa-info-circle" style="font-size: 48px; margin-bottom: 15px; display: block;"></i>
                  Topic editing now uses modal windows.<br>
                  Click the Edit button on a topic to open the editor.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Categories Section -->
      <section id="categories" class="section">
        <div class="section-header">
          <h1>🏷️ Course Categories</h1>
          <p>Create and manage course categories</p>
        </div>

        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
          <h3 style="color: white; margin: 0;">📂 All Categories</h3>
          <button id="tutor-add-category-btn" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Category
          </button>
        </div>

        <!-- Categories Table -->
        <div class="card">
          <div class="table-responsive">
            <table class="data-table">
              <thead>
                <tr>
                  <th style="width: 25%;">Name</th>
                  <th style="width: 30%;">Description</th>
                  <th style="width: 10%;">Icon</th>
                  <th style="width: 10%;">Order</th>
                  <th style="width: 10%;">Status</th>
                  <th style="width: 15%;">Actions</th>
                </tr>
              </thead>
              <tbody id="tutor-categories-table-body">
                <tr>
                  <td colspan="6" style="text-align: center; padding: 20px; color: #999;">
                    <i class="fas fa-spinner fa-spin"></i> Loading categories...
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </section>

      <!-- TUTOR COURSE MANAGEMENT MODALS -->

      <!-- Course Modal -->
      <div id="tutor-course-modal" class="modal hidden">
        <div class="modal-content" style="max-width: 700px;">
          <div class="modal-header">
            <h2 id="tutor-course-modal-title">✨ Add New Course</h2>
            <button class="close-modal" onclick="closeTutorCourseModal()">&times;</button>
          </div>
          <div class="modal-body">
            <form id="tutor-course-form">
              <input type="hidden" id="tutor-course-id">
              
              <div class="form-group">
                <label>Course Name <span style="color: #ef4444;">*</span></label>
                <input type="text" id="tutor-course-name" class="form-control" required placeholder="Enter course name">
              </div>

              <div class="grid grid-cols-2 gap-4">
                <div class="form-group">
                  <label>Slug</label>
                  <input type="text" id="tutor-course-slug" class="form-control" placeholder="auto-generated">
                  <small style="color: #6b7280;">URL-friendly identifier (leave empty for auto-generation)</small>
                </div>

                <div class="form-group">
                  <label>Chunk Words</label>
                  <input type="number" id="tutor-course-chunk-words" class="form-control" value="{{ $chunkWordsSettings['default'] }}" min="{{ $chunkWordsSettings['min'] }}" max="{{ $chunkWordsSettings['max'] }}">
                  <small style="color: #6b7280;">Words per content chunk (min: {{ $chunkWordsSettings['min'] }}, max: {{ $chunkWordsSettings['max'] }})</small>
                </div>
              </div>

              <div class="form-group">
                <label>Language</label>
                <select id="tutor-course-language" class="form-control">
                  <option value="">Use default language</option>
                </select>
              </div>

              <div class="form-group">
                <label>Short Description</label>
                <textarea id="tutor-course-description" class="form-control" rows="3" placeholder="Brief description of the course"></textarea>
              </div>

              <div class="form-group">
                <label class="toggle-switch" for="tutor-course-pricing-toggle">
                  <span class="switch">
                    <input type="checkbox" id="tutor-course-pricing-toggle">
                    <span class="slider"></span>
                  </span>
                  <div>
                    <div style="font-weight: 600;">Enable Pricing (Paid Course)</div>
                    <div style="color: #6b7280; font-size: 12px;">Leave off to keep the course free.</div>
                  </div>
                </label>
              </div>

              <div id="tutor-course-pricing-fields" class="grid grid-cols-4 gap-4 hidden">
                <div class="form-group">
                  <label>Price <span style="color: #ef4444;">*</span></label>
                  <input type="number" step="0.01" min="0" id="tutor-course-price" class="form-control" placeholder="0.00">
                </div>
                <div class="form-group">
                  <label>Discount</label>
                  <input type="number" step="0.01" min="0" id="tutor-course-discount" class="form-control" placeholder="0.00">
                </div>
                <div class="form-group">
                  <label>Discount Type</label>
                  <select id="tutor-course-discount-type" class="form-control">
                    <option value="amount">Amount off</option>
                    <option value="percent">Percentage off</option>
                  </select>
                </div>
                <div class="form-group">
                  <label>Currency</label>
                  <input type="text" id="tutor-course-currency" class="form-control" maxlength="3" placeholder="USD" style="text-transform: uppercase;">
                </div>
                <div class="form-group col-span-4 hidden" id="tutor-course-discount-preview" style="background: #ecfdf3; border: 1px solid #bbf7d0; border-radius: 10px; padding: 10px;">
                  <div style="font-weight: 600; color: #065f46; margin-bottom: 4px;">Discount preview</div>
                  <div class="price-preview">
                    <span class="old-price" id="tutor-course-original-price">$0.00</span>
                    <span class="new-price" id="tutor-course-final-price">$0.00</span>
                    <span class="discount-chip" id="tutor-course-discount-chip">0% off</span>
                  </div>
                  <small style="color: #065f46;">Students will see the discounted price with the original price struck through.</small>
                </div>
              </div>

              <div class="form-group">
                <label>Course Thumbnail</label>
                <input type="file" id="tutor-course-thumbnail" accept="image/*" class="form-control">
                <img id="tutor-course-thumbnail-preview" src="" alt="Course thumbnail preview" style="margin-top: 8px; max-height: 140px; border-radius: 8px; border: 1px solid #e5e7eb; display: none;">
                <small style="color: #6b7280;">Shown on course cards and compact placements</small>
              </div>

              <div class="form-group">
                <label style="display: flex; align-items: center; cursor: pointer;">
                  <input type="checkbox" id="tutor-course-has-prerequisite" style="margin-right: 10px;">
                  <span>This course requires a prerequisite</span>
                </label>
              </div>

              <div id="tutor-prerequisite-select-container" class="form-group hidden">
                <label>Select Prerequisite Course <span style="color: #ef4444;">*</span></label>
                <select id="tutor-course-prerequisite" class="form-control">
                  <option value="">-- Select a prerequisite course --</option>
                </select>
                <small style="color: #6b7280;">Users must complete this course before accessing the current one</small>
              </div>

              <div class="form-group">
                <label style="font-weight: 600; margin-bottom: 10px;">Completion Behavior</label>
                <div style="display: flex; gap: 20px; margin-bottom: 15px;">
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="radio" name="tutor-completion-type" value="certificate" id="tutor-completion-certificate" style="margin-right: 8px;">
                    <span>📜 Issue Certificate</span>
                  </label>
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="radio" name="tutor-completion-type" value="instructions" id="tutor-completion-instructions-radio" style="margin-right: 8px;">
                    <span>📋 Show Instructions</span>
                  </label>
                  <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="radio" name="tutor-completion-type" value="none" id="tutor-completion-none" checked style="margin-right: 8px;">
                    <span>❌ None</span>
                  </label>
                </div>
              </div>

              <div id="tutor-certificate-template-group" class="form-group hidden">
                <label>Select Certificate Template</label>
                <select id="tutor-course-certificate" name="certificate_template" class="form-control">
                  <option value="">No certificate selected</option>
                  <!-- Will be populated dynamically -->
                </select>
                <small style="color: #6b7280;">Select a certificate template that will be generated when users complete the course</small>
              </div>

              <div id="tutor-completion-instructions-group" class="form-group hidden">
                <label>Completion Instructions</label>
                <textarea id="tutor-course-instructions" class="form-control" rows="4" placeholder="Instructions or next steps shown to users upon course completion"></textarea>
                <small style="color: #6b7280;">Provide guidance on what students should do after completing this course</small>
              </div>

              <div class="form-group">
                <label style="display: flex; align-items: center; cursor: pointer;">
                  <input type="checkbox" id="tutor-course-active" style="margin-right: 10px;" checked>
                  <span>Active Course</span>
                </label>
                <small style="color: #6b7280;">Only active courses are visible to users</small>
              </div>

              <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                <button type="button" class="btn btn-secondary" onclick="closeTutorCourseModal()">Cancel</button>
                <button type="submit" class="btn btn-primary" id="tutor-save-course-btn">
                  <i class="fas fa-save"></i> <span id="tutor-save-course-text">Create Course</span>
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Delete Confirmation Modal -->
      <div id="tutor-delete-course-modal" class="modal hidden">
        <div class="modal-content" style="max-width: 500px;">
          <div class="modal-header" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
            <h2>🗑️ Delete Course</h2>
            <button class="close-modal" onclick="closeTutorDeleteCourseModal()">&times;</button>
          </div>
          <div class="modal-body">
            <p style="font-size: 16px; color: #374151; margin-bottom: 15px;">
              Are you sure you want to delete this course?
            </p>
            <div style="background: #fee2e2; border-left: 4px solid #ef4444; padding: 15px; margin-bottom: 20px; border-radius: 4px;">
              <p style="font-weight: 600; color: #991b1b; margin-bottom: 5px;">⚠️ This action cannot be undone!</p>
              <p style="color: #7f1d1d; font-size: 14px;">This will permanently delete:</p>
              <ul style="color: #7f1d1d; font-size: 14px; margin-left: 20px; margin-top: 5px;">
                <li>Course details and settings</li>
                <li>All lessons and topics</li>
                <li>All user progress data</li>
                <li>Quiz questions and results</li>
              </ul>
            </div>
            <div style="background: #f9fafb; padding: 15px; border-radius: 4px; margin-bottom: 20px;">
              <p style="font-weight: 600; color: #374151; margin-bottom: 5px;">Course: <span id="tutor-delete-course-name" style="color: #667eea;"></span></p>
              <p style="font-size: 14px; color: #6b7280;">ID: <span id="tutor-delete-course-id"></span></p>
            </div>
            <div style="display: flex; justify-content: flex-end; gap: 10px;">
              <button type="button" class="btn btn-secondary" onclick="closeTutorDeleteCourseModal()">Cancel</button>
              <button type="button" class="btn btn-danger" onclick="confirmTutorDeleteCourse()">
                <i class="fas fa-trash"></i> Delete Permanently
              </button>
            </div>
          </div>
        </div>
      </div>

      <!-- Lesson Modal -->
      <div id="tutor-lessonModal" class="modal hidden">
        <div class="modal-content" style="max-width: 800px; max-height: 90vh; overflow-y: auto;">
          <div class="modal-header">
            <h2 id="tutor-lesson-modal-title">Add New Lesson</h2>
            <button class="close-modal" onclick="closeTutorModal('tutor-lessonModal')">&times;</button>
          </div>
          <div class="modal-body">
            <form id="tutor-lesson-form">
              <input type="hidden" id="tutor-lesson-id" name="id">
              <input type="hidden" id="tutor-lesson-course-id" name="course_id">
              
              <div class="form-group">
                <label>Lesson Name <span style="color: #ef4444;">*</span></label>
                <input type="text" id="tutor-lesson-name" name="name" class="form-control" required placeholder="Enter lesson name">
              </div>

              <div class="form-group">
                <label>Description</label>
                <textarea id="tutor-lesson-description" name="intro" class="form-control" rows="4" placeholder="Brief description of the lesson"></textarea>
              </div>

              <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                <button type="button" class="btn btn-secondary" onclick="closeTutorModal('tutor-lessonModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">
                  <i class="fas fa-save"></i> Save Lesson
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Topic Modal -->
      <div id="tutor-topicModal" class="modal hidden">
        <div class="modal-content" style="max-width: 900px; max-height: 90vh; overflow-y: auto;">
          <div class="modal-header">
            <h2 id="tutor-topic-modal-title">Add New Topic</h2>
            <button class="close-modal" onclick="closeTutorModal('tutor-topicModal')">&times;</button>
          </div>
          <div class="modal-body">
            <form id="tutor-topic-form">
              <input type="hidden" id="tutor-topic-id" name="topic_id">
              <input type="hidden" id="tutor-topic-lesson-id" name="lesson_id">
              
              <div class="form-group">
                <label>Topic Title <span style="color: #ef4444;">*</span></label>
                <input type="text" id="tutor-topic-title" name="title" class="form-control" required placeholder="Enter topic title">
              </div>

              <div class="form-group">
                <label>Content</label>
                <textarea id="tutor-topic-body" name="body" class="form-control" rows="8" placeholder="Enter topic content..."></textarea>
              </div>

              <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                <div class="form-group">
                  <label>📹 Video URL (optional)</label>
                  <input type="url" id="tutor-topic-video-url" name="video_url" class="form-control" placeholder="https://youtube.com/watch?v=...">
                  <p class="text-sm" style="margin-top: 5px; color: #6b7280;">YouTube, Vimeo, or direct video URL</p>
                </div>

                <div class="form-group">
                  <label>🖼️ Image URL (optional)</label>
                  <input type="url" id="tutor-topic-image-url" name="image_url" class="form-control" placeholder="https://...">
                </div>
              </div>

              <div class="form-group" style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 15px; background: #f9fafb;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                  <div>
                    <label style="margin: 0; font-weight: 600;">👁️ Publish Topic</label>
                    <p class="text-sm" style="margin-top: 5px; color: #6b7280;">Make this topic visible to students</p>
                  </div>
                  <label class="switch">
                    <input type="checkbox" id="tutor-topic-is-published" name="is_published" checked>
                    <span class="slider round"></span>
                  </label>
                </div>
              </div>

              <div style="display: flex; justify-content: flex-end; gap: 10px; margin-top: 20px;">
                <button type="button" class="btn btn-secondary" onclick="closeTutorModal('tutor-topicModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">
                  <i class="fas fa-save"></i> Save Topic
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Category Modal -->
      <div id="tutor-category-modal" class="modal hidden">
        <div class="modal-content" style="max-width: 600px;">
          <div class="modal-header">
            <h2 id="tutor-category-modal-title">📂 Add New Category</h2>
            <button class="close-modal" onclick="closeTutorCategoryModal()">&times;</button>
          </div>
          <div class="modal-body">
            <form id="tutor-category-form">
              <input type="hidden" id="tutor-category-id">
              
              <div class="form-group">
                <label>Category Name <span style="color: #ef4444;">*</span></label>
                <input type="text" id="tutor-category-name" class="form-control" required placeholder="Enter category name">
              </div>

              <div class="form-group">
                <label>Description</label>
                <textarea id="tutor-category-description" class="form-control" rows="3" placeholder="Describe this category"></textarea>
              </div>

              <div class="form-group">
                <label>Icon (FontAwesome)</label>
                <div style="position: relative;">
                  <input type="text" id="tutor-category-icon" class="form-control" placeholder="briefcase, book, rocket">
                  <span id="tutor-category-icon-preview" style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); color: #9ca3af;"></span>
                </div>
                <small style="color: #6b7280;">
                  <i class="fas fa-info-circle"></i> Enter FontAwesome icon name without 'fa-' prefix
                </small>
              </div>

              <div class="grid grid-cols-2 gap-4">
                <div class="form-group">
                  <label>Display Order</label>
                  <input type="number" id="tutor-category-order" class="form-control" value="0" min="0">
                </div>

                <div class="form-group">
                  <label style="display: block; margin-bottom: 8px;">Status</label>
                  <label style="display: flex; align-items: center; cursor: pointer; margin-top: 8px;">
                    <input type="checkbox" id="tutor-category-is-active" checked style="margin-right: 10px;">
                    Active
                  </label>
                </div>
              </div>

              <div class="form-actions" style="display: flex; justify-content: flex-end; gap: 12px; margin-top: 24px; padding-top: 20px; border-top: 1px solid #e5e7eb;">
                <button type="button" class="btn btn-secondary" onclick="closeTutorCategoryModal()">
                  Cancel
                </button>
                <button type="submit" class="btn btn-primary">
                  <i class="fas fa-save"></i> Save Category
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Students Section (Server-rendered list with pagination) -->
      <section id="students" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em; display:flex; align-items:center; gap:10px;">
          <i class="fas fa-users"></i> Students
          <span style="font-size:14px; font-weight:600; color:#dbeafe; background:#1e3a8a; padding:4px 10px; border-radius:999px;">Total: {{ $totalStudents }}</span>
        </h1>

        <div class="card" style="margin-bottom: 15px;">
          <div style="display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
            <div style="flex:1; min-width:240px;">
              <input id="students-search" type="text" class="form-control" placeholder="Search by name or email..." />
            </div>
            <div>
              <select id="students-page-size" class="form-control">
                <option value="25">25</option>
                <option value="50" selected>50</option>
                <option value="100">100</option>
              </select>
            </div>
            <button id="students-refresh" class="btn btn-primary"><i class="fas fa-sync"></i> Refresh</button>
          </div>
        </div>

        <div class="card">
          <div style="overflow-x:auto;">
            <table class="data-table">
              <thead>
                <tr>
                  <th style="min-width:220px;">Student</th>
                  <th style="text-align:center;">Enrolled</th>
                  <th style="text-align:center;">Progress</th>
                  <th style="text-align:center;">Quiz Avg</th>
                  <th style="text-align:center;">Last Activity</th>
                </tr>
              </thead>
              <tbody id="students-tbody">
                @forelse($students as $s)
                <tr>
                  <td>
                    <div style="display:flex; align-items:center; gap:10px;">
                      <div style="width:36px; height:36px; border-radius:50%; background:linear-gradient(135deg,#667eea,#764ba2); color:white; display:flex; align-items:center; justify-content:center; font-weight:700;">
                        {{ strtoupper(substr($s->name ?? 'U',0,1)) }}
                      </div>
                      <div>
                        <div style="font-weight:600; color:#374151;">{{ $s->name ?? 'Unknown' }}</div>
                        <div style="font-size:12px; color:#6b7280;">{{ $s->email ?? '' }}</div>
                      </div>
                    </div>
                  </td>
                  <td style="text-align:center;">
                    <span style="display:inline-block; padding:4px 10px; background:#e0e7ff; color:#3730a3; border-radius:999px; font-weight:600;">{{ $s->enrolled_courses ?? 0 }}</span>
                  </td>
                  <td style="text-align:center;">
                    @php $p = (int) round($s->total_progress ?? 0); @endphp
                    <div style="display:flex; align-items:center; justify-content:center; gap:8px;">
                      <div style="width:100px; height:8px; background:#e5e7eb; border-radius:4px; overflow:hidden;">
                        <div style="height:100%; width:{{ $p }}%; background: {{ $p>=75 ? '#10b981' : ($p>=50 ? '#f59e0b' : ($p>=25 ? '#3b82f6' : '#ef4444')) }};"></div>
                      </div>
                      <span style="font-weight:600; color:#374151;">{{ $p }}%</span>
                    </div>
                  </td>
                  <td style="text-align:center;">
                    @php $q = (int) round($s->average_quiz_score ?? 0); @endphp
                    <span style="font-weight:600; color: {{ $q>=80 ? '#10b981' : ($q>=60 ? '#f59e0b' : '#ef4444') }};">{{ $q }}%</span>
                  </td>
                  <td style="text-align:center; color:#6b7280;">
                    {{ optional(\Carbon\Carbon::parse($s->last_activity))->diffForHumans() ?? 'Never' }}
                  </td>
                </tr>
                @empty
                <tr>
                  <td colspan="5" style="text-align:center; color:#9ca3af; padding:20px;">No students found</td>
                </tr>
                @endforelse
              </tbody>
            </table>
          </div>

          @php $meta = $studentsMeta ?? (object)['page'=>1,'limit'=>50,'total'=>0,'has_more'=>false]; @endphp
          <div id="students-pager" data-page="{{ $meta->page ?? 1 }}" data-limit="{{ $meta->limit ?? 50 }}" data-has-more="{{ ($meta->has_more ?? false) ? '1' : '0' }}" style="display:flex; justify-content:center; gap:10px; margin-top:15px;">
            <button id="students-prev" class="btn btn-secondary" {{ ($meta->page ?? 1) <= 1 ? 'disabled' : '' }}><i class="fas fa-chevron-left"></i> Prev</button>
            <span style="align-self:center; color:#6b7280;">Page {{ $meta->page ?? 1 }}</span>
            <button id="students-next" class="btn btn-primary" {{ ($meta->has_more ?? false) ? '' : 'disabled' }}>Next <i class="fas fa-chevron-right"></i></button>
          </div>
        </div>

        @if($studentsNeedingAttention->count() > 0)
          <div class="card" style="margin-top:15px;">
            <h3><i class="fas fa-exclamation-triangle"></i> Students Needing Attention</h3>
            <div>
              @foreach($studentsNeedingAttention as $progress)
                <div class="attention-item">
                  <div class="student-name">
                    <i class="fas fa-user"></i> {{ $progress->user->name }}
                  </div>
                  <div class="progress-info">
                    Lesson: {{ $progress->lesson->title }} 
                    @if($progress->lesson->course)
                      (Course: {{ $progress->lesson->course->name }})
                    @endif
                    • Status: Not completed
                    • Last active: {{ $progress->updated_at->diffForHumans() }}
                  </div>
                </div>
              @endforeach
            </div>
          </div>
        @endif
      </section>

      <!-- Activity Section -->
      <section id="activity" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-history"></i> Recent Activity
        </h1>

        <div class="card">
          <h3><i class="fas fa-clock"></i> Latest Student Actions</h3>
          @if($recentActivities->count() > 0)
            <div class="activity-feed">
              @foreach($recentActivities as $activity)
                <div class="activity-item">
                  <div class="activity-user">
                    <i class="fas fa-user-circle"></i> {{ $activity->user->name }}
                  </div>
                  <div class="activity-action">
                    @if($activity->completed)
                      <i class="fas fa-check-circle" style="color: #10b981;"></i> Completed
                    @else
                      <i class="fas fa-play-circle" style="color: #3b82f6;"></i> Started
                    @endif
                    "{{ $activity->lesson->title }}"
                    @if($activity->lesson->course)
                      in <strong>{{ $activity->lesson->course->name }}</strong>
                    @endif
                  </div>
                  <div class="activity-time">
                    <i class="fas fa-clock"></i> {{ $activity->updated_at->diffForHumans() }}
                  </div>
                </div>
              @endforeach
            </div>
          @else
            <div class="empty-state">
              <i class="fas fa-history"></i>
              <p>No recent activity</p>
            </div>
          @endif
        </div>
      </section>

      <!-- Analytics Section -->
      <section id="analytics" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-chart-line"></i> Analytics
        </h1>

        @if($monthlyEnrollments->count() > 0)
          <div class="card">
            <h3><i class="fas fa-chart-area"></i> Enrollment Trend (Last 6 Months)</h3>
            <div class="chart-container">
              <canvas id="enrollmentChart"></canvas>
            </div>
          </div>
        @endif

        <div class="card">
          <h3><i class="fas fa-chart-bar"></i> Student Progress Overview</h3>
          <div class="chart-container">
            <canvas id="progressChart"></canvas>
          </div>
        </div>

        <div class="card">
          <h3><i class="fas fa-star"></i> Quiz Performance</h3>
          <div class="chart-container">
            <canvas id="quizChart"></canvas>
          </div>
        </div>

        <div class="stats-grid" style="margin-top: 20px;">
          <div class="stat-card">
            <div class="icon" style="color: #667eea;">
              <i class="fas fa-percentage"></i>
            </div>
            <div class="value">{{ $averageProgress }}%</div>
            <div class="label">Average Progress</div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #10b981;">
              <i class="fas fa-check-double"></i>
            </div>
            <div class="value">{{ $completedCourses }}</div>
            <div class="label">Completed Lessons</div>
          </div>

          <div class="stat-card">
            <div class="icon" style="color: #ec4899;">
              <i class="fas fa-certificate"></i>
            </div>
            <div class="value">{{ $certificatesIssued }}</div>
            <div class="label">Certificates Issued</div>
          </div>
        </div>
      </section>

      <!-- Certificates Section -->
      <section id="certificates" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-certificate"></i> Certificate Template Builder
        </h1>

        <div class="card" style="padding: 0; overflow: hidden;">
          <iframe 
            src="/tutor/certificates-builder" 
            style="width: 100%; height: 80vh; border: none; display: block;"
            title="Certificate Template Builder">
          </iframe>
        </div>
      </section>

      <!-- Badges Section -->
      <section id="badges" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-trophy"></i> Badge Management
        </h1>

        <div class="card" style="padding: 20px;">
          <p style="color: #374151; font-size: 16px; line-height: 1.6;">
            <strong>Badge Management System</strong><br>
            View badges that your students can earn for completing your courses. Badges are managed at the system level.
          </p>
          <br>
          <p style="color: #6b7280; font-size: 14px;">
            <i class="fas fa-info-circle"></i> Contact your administrator to create or modify badge templates.
          </p>
          <br>

          <!-- Statistics Cards -->
          <div style="background: #f3f4f6; padding: 20px; border-radius: 8px; margin-bottom: 30px;">
            <h3 style="color: #374151; margin-bottom: 15px;">📊 Badge Statistics</h3>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
              <div style="background: white; padding: 15px; border-radius: 8px; text-align: center;">
                <i class="fas fa-award" style="font-size: 32px; color: #667eea; margin-bottom: 10px;"></i>
                <h4 id="tutor-total-badges-count" style="color: #374151; font-size: 24px; margin: 5px 0;">0</h4>
                <p style="color: #6b7280; font-size: 14px;">Total Badges</p>
              </div>
              <div style="background: white; padding: 15px; border-radius: 8px; text-align: center;">
                <i class="fas fa-users" style="font-size: 32px; color: #10b981; margin-bottom: 10px;"></i>
                <h4 id="tutor-students-with-badges-count" style="color: #374151; font-size: 24px; margin: 5px 0;">0</h4>
                <p style="color: #6b7280; font-size: 14px;">Students Awarded</p>
              </div>
              <div style="background: white; padding: 15px; border-radius: 8px; text-align: center;">
                <i class="fas fa-star" style="font-size: 32px; color: #f59e0b; margin-bottom: 10px;"></i>
                <h4 id="tutor-badges-earned-count" style="color: #374151; font-size: 24px; margin: 5px 0;">0</h4>
                <p style="color: #6b7280; font-size: 14px;">Badges Earned</p>
              </div>
            </div>
          </div>

          <!-- Badge Tabs -->
          <div style="margin-bottom: 20px;">
            <div style="display: flex; gap: 0; border-bottom: 1px solid #e5e7eb;">
              <button class="tutor-badge-tab active" data-tab="all-badges" style="padding: 12px 24px; background: none; border: none; border-bottom: 3px solid #667eea; color: #667eea; font-weight: 600; cursor: pointer;">
                All Badges
              </button>
            </div>
          </div>

          <!-- All Badges Tab -->
          <div id="tutor-all-badges-tab" class="tutor-badge-tab-content">
            <div style="margin-bottom: 20px;">
              <p style="color: #666; font-size: 14px;">View all achievement badges available in the system</p>
            </div>

            <!-- Badge Filters -->
            <div style="display: flex; gap: 15px; margin-bottom: 20px; flex-wrap: wrap;">
              <div style="display: flex; align-items: center; gap: 8px;">
                <label style="font-weight: 600; color: #374151; font-size: 14px;">Category:</label>
                <select id="tutor-badge-category-filter" style="padding: 8px 12px; border: 1px solid #d1d5db; border-radius: 6px; font-size: 14px;">
                  <option value="all">All Categories</option>
                </select>
              </div>
              <div style="display: flex; align-items: center; gap: 8px;">
                <label style="font-weight: 600; color: #374151; font-size: 14px;">Status:</label>
                <select id="tutor-badge-status-filter" style="padding: 8px 12px; border: 1px solid #d1d5db; border-radius: 6px; font-size: 14px;">
                  <option value="all">All Status</option>
                  <option value="active">Active</option>
                  <option value="inactive">Inactive</option>
                </select>
              </div>
            </div>

            <!-- Badges Grid -->
            <div id="tutor-badges-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 20px;">
              <!-- Badges will be loaded here -->
              <div style="grid-column: 1 / -1; text-align: center; padding: 40px; color: #666;">
                <i class="fas fa-spinner fa-spin" style="font-size: 32px; margin-bottom: 16px;"></i>
                <p>Loading badges...</p>
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- Quick Actions Section -->
      <section id="quick-actions" class="section">
        <h1 style="color: white; margin-bottom: 30px; font-size: 2.5em;">
          <i class="fas fa-bolt"></i> Quick Actions
        </h1>

        <div class="card">
          <div class="quick-actions">
            <a href="javascript:void(0)" onclick="showCreateCourseModal()" class="action-btn">
              <i class="fas fa-plus-circle"></i>
              <span>Create Course</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=courses]').click()" class="action-btn">
              <i class="fas fa-edit"></i>
              <span>Manage Courses</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=students]').click()" class="action-btn">
              <i class="fas fa-users"></i>
              <span>View Students</span>
            </a>
            <a href="javascript:void(0)" onclick="loadCourses()" class="action-btn">
              <i class="fas fa-sync"></i>
              <span>Refresh Data</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=certificates]').click()" class="action-btn">
              <i class="fas fa-certificate"></i>
              <span>Certificates</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=badges]').click()" class="action-btn">
              <i class="fas fa-trophy"></i>
              <span>Badges</span>
            </a>
            <a href="javascript:void(0)" onclick="document.querySelector('[data-section=analytics]').click()" class="action-btn">
              <i class="fas fa-chart-line"></i>
              <span>Analytics</span>
            </a>
          </div>
        </div>
      </section>
    </div>
  </div>

  

  <!-- Student Details Modal -->
  <div id="student-details-modal" class="modal hidden" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); z-index: 1000; padding: 20px; overflow-y: auto;">
    <div class="modal-content" style="max-width: 1000px; margin: 50px auto; background: white; border-radius: 12px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
      <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px 30px; border-radius: 12px 12px 0 0; display: flex; justify-content: space-between; align-items: center;">
        <h2 id="student-modal-title" style="margin: 0; font-size: 24px;">👥 Student Details</h2>
        <button class="close-modal" onclick="closeStudentModal()" style="background: none; border: none; color: white; font-size: 32px; cursor: pointer; line-height: 1; padding: 0; width: 32px; height: 32px;">&times;</button>
      </div>
      <div class="modal-body" style="padding: 30px;">
        <div id="student-list-content" style="min-height: 300px;">
          <div style="text-align: center; padding: 40px;">
            <i class="fas fa-spinner fa-spin" style="font-size: 32px; color: #667eea;"></i>
            <p style="margin-top: 15px; color: #6b7280;">Loading student data...</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script>
    // Global chunk words settings from backend
    const CHUNK_WORDS_SETTINGS = {
      default: {{ $chunkWordsSettings['default'] }},
      min: {{ $chunkWordsSettings['min'] }},
      max: {{ $chunkWordsSettings['max'] }}
    };

    // Helper function to escape HTML for safe rendering
    function escapeHtml(text) {
      if (!text) return '';
      const div = document.createElement('div');
      div.textContent = text;
      return div.innerHTML;
    }

    // Toggle Submenu Function
    function toggleSubmenu(event, element) {
      event.preventDefault();
      event.stopPropagation();
      
      const parentLi = element.closest('.nav-item-with-submenu');
      const isOpen = parentLi.classList.contains('open');
      
      // Close all other submenus
      document.querySelectorAll('.nav-item-with-submenu').forEach(item => {
        item.classList.remove('open');
      });
      
      // Toggle current submenu
      if (!isOpen) {
        parentLi.classList.add('open');
      }
    }

    // Navigation
    document.querySelectorAll('.nav-item').forEach(item => {
      item.addEventListener('click', function() {
        try {
          const section = this.getAttribute('data-section');
          const target = document.getElementById(section);
          console.debug('Nav click ->', section);
          if (!target) {
            console.warn('Section not found:', section);
            return;
          }

          // Remove active class from all nav items and sections
          document.querySelectorAll('.nav-item').forEach(nav => nav.classList.remove('active'));
          document.querySelectorAll('.section').forEach(sec => sec.classList.remove('active'));

          // Add active class to clicked nav item and corresponding section
          this.classList.add('active');
          target.classList.add('active');

          // When entering Students, warm data cache
          if (section === 'students') {
            prefetchStudents();
          }
        } catch (e) {
          console.error('Navigation error:', e);
        }
      });
    });

    // Enrollment Chart
    @if($monthlyEnrollments->count() > 0)
    const ctx = document.getElementById('enrollmentChart');
    if (ctx) {
      new Chart(ctx, {
        type: 'line',
        data: {
          labels: {!! json_encode($monthlyEnrollments->pluck('month')->map(function($m) {
            return date('M Y', strtotime($m . '-01'));
          })) !!},
          datasets: [{
            label: 'New Students',
            data: {!! json_encode($monthlyEnrollments->pluck('count')) !!},
            borderColor: '#667eea',
            backgroundColor: 'rgba(102, 126, 234, 0.1)',
            borderWidth: 3,
            fill: true,
            tension: 0.4,
            pointRadius: 5,
            pointBackgroundColor: '#667eea',
            pointBorderColor: '#fff',
            pointBorderWidth: 2,
            pointHoverRadius: 7
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: {
              display: false
            },
            tooltip: {
              backgroundColor: 'rgba(0,0,0,0.8)',
              padding: 12,
              borderRadius: 8,
              titleFont: {
                size: 14,
                weight: 'bold'
              },
              bodyFont: {
                size: 13
              }
            }
          },
          scales: {
            y: {
              beginAtZero: true,
              ticks: {
                stepSize: 1,
                font: {
                  size: 12
                }
              },
              grid: {
                color: 'rgba(0,0,0,0.05)'
              }
            },
            x: {
              ticks: {
                font: {
                  size: 12
                }
              },
              grid: {
                display: false
              }
            }
          }
        }
      });
    }
    @endif

    // Student Progress Chart(s) - render wherever canvas exists
    const progressChartIds = ['progressChart', 'progressChartTop'];
    progressChartIds.forEach((chartId) => {
      const progressCtx = document.getElementById(chartId);
      if (!progressCtx) return;

      new Chart(progressCtx, {
        type: 'bar',
        data: {
          labels: ['0-25%', '26-50%', '51-75%', '76-100%'],
          datasets: [{
            label: 'Students',
            data: {!! json_encode([
              $students->where('total_progress', '<=', 25)->count(),
              $students->whereBetween('total_progress', [26, 50])->count(),
              $students->whereBetween('total_progress', [51, 75])->count(),
              $students->where('total_progress', '>=', 76)->count()
            ]) !!},
            backgroundColor: [
              'rgba(239, 68, 68, 0.8)',
              'rgba(245, 158, 11, 0.8)',
              'rgba(59, 130, 246, 0.8)',
              'rgba(16, 185, 129, 0.8)'
            ],
            borderColor: [
              'rgba(239, 68, 68, 1)',
              'rgba(245, 158, 11, 1)',
              'rgba(59, 130, 246, 1)',
              'rgba(16, 185, 129, 1)'
            ],
            borderWidth: 2,
            borderRadius: 6,
            borderSkipped: false
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: {
              display: false
            },
            tooltip: {
              backgroundColor: 'rgba(0,0,0,0.8)',
              padding: 12,
              borderRadius: 8,
              titleFont: {
                size: 14,
                weight: 'bold'
              },
              bodyFont: {
                size: 13
              },
              callbacks: {
                label: function(context) {
                  const total = context.dataset.data.reduce((a, b) => a + b, 0);
                  const percentage = total > 0 ? ((context.parsed.y / total) * 100).toFixed(1) : 0;
                  return context.parsed.y + ' students (' + percentage + '%)';
                }
              }
            }
          },
          scales: {
            y: {
              beginAtZero: true,
              ticks: {
                stepSize: 1,
                font: {
                  size: 12
                }
              },
              grid: {
                color: 'rgba(0,0,0,0.05)'
              }
            },
            x: {
              ticks: {
                font: {
                  size: 12
                }
              },
              grid: {
                display: false
              }
            }
          }
        }
      });
    });

    // Quiz Performance Chart
    const quizCtx = document.getElementById('quizChart');
    if (quizCtx) {
      new Chart(quizCtx, {
        type: 'doughnut',
        data: {
          labels: ['Excellent (80-100%)', 'Good (60-79%)', 'Needs Improvement (0-59%)'],
          datasets: [{
            data: {!! json_encode([
              $students->where('average_quiz_score', '>=', 80)->count(),
              $students->whereBetween('average_quiz_score', [60, 79])->count(),
              $students->where('average_quiz_score', '<', 60)->count()
            ]) !!},
            backgroundColor: [
              'rgba(16, 185, 129, 0.8)',
              'rgba(245, 158, 11, 0.8)',
              'rgba(239, 68, 68, 0.8)'
            ],
            borderColor: [
              'rgba(16, 185, 129, 1)',
              'rgba(245, 158, 11, 1)',
              'rgba(239, 68, 68, 1)'
            ],
            borderWidth: 3,
            hoverOffset: 10
          }]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
            legend: {
              position: 'bottom',
              labels: {
                padding: 20,
                font: {
                  size: 12
                }
              }
            },
            tooltip: {
              backgroundColor: 'rgba(0,0,0,0.8)',
              padding: 12,
              borderRadius: 8,
              titleFont: {
                size: 14,
                weight: 'bold'
              },
              bodyFont: {
                size: 13
              },
              callbacks: {
                label: function(context) {
                  const total = context.dataset.data.reduce((a, b) => a + b, 0);
                  const percentage = total > 0 ? ((context.parsed / total) * 100).toFixed(1) : 0;
                  return context.parsed + ' students (' + percentage + '%)';
                }
              }
            }
          },
          cutout: '60%'
        }
      });
    }

  // API Helper Function
    async function apiCall(url, method = 'GET', data = null, timeoutMs = 30000) {
      // Add cache-busting timestamp for GET requests
      if (method === 'GET') {
        url += (url.includes('?') ? '&' : '?') + '_t=' + Date.now();
      }
      
      const controller = new AbortController();
      const timeout = setTimeout(() => controller.abort(), timeoutMs);

      const isFormData = typeof FormData !== 'undefined' && data instanceof FormData;
      const options = {
        method: method,
        headers: {
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
          'Accept': 'application/json',
          'Cache-Control': 'no-cache, no-store, must-revalidate',
          'Pragma': 'no-cache',
          'Expires': '0'
        },
        signal: controller.signal
      };

      if (!isFormData) {
        options.headers['Content-Type'] = 'application/json';
      }

      if (data && (method === 'POST' || method === 'PUT')) {
        options.body = isFormData ? data : JSON.stringify(data);
      }

      try {
        const response = await fetch(url, options);
        const contentType = response.headers.get('content-type') || '';
        let payload;
        if (contentType.includes('application/json')) {
          payload = await response.json();
        } else {
          const text = await response.text();
          console.warn('Non-JSON response for', url, 'status', response.status, text?.slice(0, 200));
          throw new Error('Unexpected response format');
        }

        if (!response.ok) {
          throw new Error(payload.message || `Request failed (${response.status})`);
        }
        return payload;
      } catch (error) {
        console.error('API Error:', error);
        if (error.name === 'AbortError') {
          alert('Request timed out. Please try again.');
        } else {
          alert('Error: ' + (error.message || 'Unknown error'));
        }
        throw error;
      } finally {
        clearTimeout(timeout);
      }
    }

    // Prefetch Students to avoid modal delay
    window.cachedStudents = null;
    async function prefetchStudents() {
      try {
        const data = await apiCall('/tutor/students?limit=50&page=1', 'GET', null, 8000);
        const students = data.students || data.data || [];
        const meta = data.meta || { total: students.length, page: 1, limit: 50, has_more: false };
        window.cachedStudents = { data: students, meta };
      } catch (_) {
        // ignore prefetch errors
      }
    }

    // Show notification
    function showNotification(message, type = 'success') {
      const notification = document.createElement('div');
      notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        padding: 15px 25px;
        background: ${type === 'success' ? '#10b981' : '#ef4444'};
        color: white;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        z-index: 10000;
        animation: slideIn 0.3s ease-out;
      `;
      notification.textContent = message;
      document.body.appendChild(notification);
      
      setTimeout(() => {
        notification.style.animation = 'slideOut 0.3s ease-out';
        setTimeout(() => notification.remove(), 300);
      }, 3000);
    }

    function calculateDiscountedPrice(price, discount, discountType) {
      const priceValue = parseFloat(price || '0');
      const discountValue = parseFloat(discount || '0');
      if (priceValue <= 0) return 0;
      if (discountValue <= 0) return priceValue;
      const type = discountType === 'percent' ? 'percent' : 'amount';
      const discounted = type === 'percent'
        ? priceValue - (priceValue * (discountValue / 100))
        : priceValue - discountValue;
      return Math.max(discounted, 0);
    }

    function updateDiscountPreview(baseId = 'course') {
      const priceInput = document.getElementById(`${baseId}-price`);
      const discountInput = document.getElementById(`${baseId}-discount`);
      const discountTypeInput = document.getElementById(`${baseId}-discount-type`);
      const currencyInput = document.getElementById(`${baseId}-currency`);
      const preview = document.getElementById(`${baseId}-discount-preview`);
      if (!preview || !priceInput || !discountTypeInput) return;

      const price = parseFloat(priceInput.value || '0');
      const discount = parseFloat(discountInput?.value || '0');
      const discountType = discountTypeInput.value || 'amount';
      const currency = (currencyInput?.value || 'USD').toUpperCase();
      const hasDiscount = discount > 0 && price > 0;
      const finalPrice = calculateDiscountedPrice(price, discount, discountType);

      if (price > 0) {
        preview.classList.remove('hidden');
        const originalPriceEl = document.getElementById(`${baseId}-original-price`);
        const finalPriceEl = document.getElementById(`${baseId}-final-price`);
        const chipEl = document.getElementById(`${baseId}-discount-chip`);

        if (originalPriceEl) {
          originalPriceEl.textContent = `${currency} ${price.toFixed(2)}`;
          originalPriceEl.style.visibility = hasDiscount ? 'visible' : 'hidden';
        }
        if (finalPriceEl) {
          finalPriceEl.textContent = `${currency} ${finalPrice.toFixed(2)}`;
        }
        if (chipEl) {
          if (hasDiscount) {
            chipEl.textContent = discountType === 'percent'
              ? `${discount}% off`
              : `${currency} ${discount.toFixed(2)} off`;
            chipEl.style.display = 'inline-flex';
          } else {
            chipEl.style.display = 'none';
          }
        }
      } else {
        preview.classList.add('hidden');
      }
    }

    function showHidePricing(toggleEl, containerEl) {
      if (!toggleEl || !containerEl) return;
      const baseId = containerEl.id?.startsWith('tutor-course') ? 'tutor-course' : 'course';
      const priceInput = document.getElementById(`${baseId}-price`);
      const discountInput = document.getElementById(`${baseId}-discount`);
      const discountTypeInput = document.getElementById(`${baseId}-discount-type`);
      const currencyInput = document.getElementById(`${baseId}-currency`);
      const preview = document.getElementById(`${baseId}-discount-preview`);
      if (toggleEl.checked) {
        containerEl.classList.remove('hidden');
        if (priceInput) priceInput.required = true;
        if (currencyInput && !currencyInput.value) currencyInput.value = 'USD';
        updateDiscountPreview(baseId);
      } else {
        containerEl.classList.add('hidden');
        preview?.classList.add('hidden');
        if (priceInput) { priceInput.required = false; priceInput.value = ''; }
        if (discountInput) discountInput.value = '';
        if (discountTypeInput) discountTypeInput.value = 'amount';
      }
    }

    function attachImagePreview(inputEl, previewEl) {
      if (!inputEl || !previewEl) return;
      inputEl.addEventListener('change', () => {
        const file = inputEl.files && inputEl.files[0];
        if (file) {
          previewEl.src = URL.createObjectURL(file);
          previewEl.style.display = 'block';
        } else {
          previewEl.src = '';
          previewEl.style.display = 'none';
        }
      });
    }

    function setImagePreview(previewEl, url) {
      if (!previewEl) return;
      if (url) {
        previewEl.src = url;
        previewEl.style.display = 'block';
      } else {
        previewEl.src = '';
        previewEl.style.display = 'none';
      }
    }

    // Load Courses
    async function loadCourses() {
      try {
        const courses = await apiCall('/tutor/courses');
        console.log('Courses loaded:', courses);
        showNotification('Courses refreshed successfully!');
      } catch (error) {
        console.error('Failed to load courses:', error);
      }
    }

    // Course Modal Variables
    let currentCourseId = null;
    let deleteCourseId = null;

    // Show Create Course Modal
    function showCreateCourseModal() {
      openCourseModal();
    }

    // Open Course Modal (for create or edit)
    async function openCourseModal(courseId = null) {
      currentCourseId = courseId;
      const modal = document.getElementById('course-modal');
      const title = document.getElementById('course-modal-title');
      const saveText = document.getElementById('save-course-text');
      
      // Load categories if not already loaded
      await loadCategoriesForFilter();
      
      // Open modal first
      modal.classList.remove('hidden');
      modal.classList.add('active');
      
      // Reset form
      document.getElementById('course-form').reset();
      document.getElementById('course-id').value = '';
      document.getElementById('course-chunk-words').value = CHUNK_WORDS_SETTINGS.default;
      document.getElementById('course-active').checked = true;
      document.getElementById('prerequisite-select-container').style.display = 'none';
      document.getElementById('course-has-prerequisite').checked = false;
      
      // Reset study time fields
      document.getElementById('course-enable-study-time').checked = false;
      document.getElementById('study-time-fields').classList.add('hidden');
      document.getElementById('course-min-study-minutes').value = '15';
      document.getElementById('course-max-study-minutes').value = '60';
      
      // Reset survey fields
      document.getElementById('course-enable-survey').checked = false;
      document.getElementById('survey-fields').classList.add('hidden');
      document.getElementById('course-survey-title').value = '';
      document.getElementById('course-survey-description').value = '';
      
      document.getElementById('certificate-template-group').style.display = 'none';
      document.getElementById('completion-instructions-group').style.display = 'none';
      document.getElementById('completion-none').checked = true;
      document.getElementById('course-price').value = '';
      document.getElementById('course-discount').value = '';
      document.getElementById('course-discount-type').value = 'amount';
      document.getElementById('course-currency').value = 'USD';
      document.getElementById('course-pricing-toggle').checked = false;
      showHidePricing(document.getElementById('course-pricing-toggle'), document.getElementById('course-pricing-fields'));
      setImagePreview(document.getElementById('course-thumbnail-preview'), '');

      // Load available prerequisites
      await loadAvailablePrerequisites(courseId);

      if (courseId) {
        // Edit mode
        title.textContent = '✏️ Edit Course';
        saveText.textContent = 'Update Course';
        
        try {
          const data = await apiCall(`/tutor/courses/${courseId}`);
          const course = data.course || data;
          
          document.getElementById('course-id').value = course.id;
          document.getElementById('course-name').value = course.name;
          document.getElementById('course-category').value = course.category || '';
          document.getElementById('course-slug').value = course.slug || '';
          document.getElementById('course-description').value = course.short_description || '';
          document.getElementById('course-chunk-words').value = course.chunk_words || CHUNK_WORDS_SETTINGS.default;
          document.getElementById('course-certificate').value = course.certificate_template || '';
          document.getElementById('course-instructions').value = course.completion_instructions || '';
          document.getElementById('course-active').checked = course.is_active;
          
          // Study time limits
          document.getElementById('course-enable-study-time').checked = course.enable_study_time_limit || false;
          document.getElementById('course-min-study-minutes').value = course.min_study_time_per_day || 15;
          document.getElementById('course-max-study-minutes').value = course.max_study_time_per_day || 60;
          if (course.enable_study_time_limit) {
            document.getElementById('study-time-fields').classList.remove('hidden');
          }
          
          // Survey settings
          document.getElementById('course-enable-survey').checked = course.enable_course_survey || false;
          if (course.survey_mode === 'survey') {
            document.getElementById('survey-mode-survey').checked = true;
            document.getElementById('feedback-mode-info').classList.add('hidden');
            document.getElementById('survey-mode-info').classList.remove('hidden');
          } else {
            document.getElementById('survey-mode-feedback').checked = true;
            document.getElementById('feedback-mode-info').classList.remove('hidden');
            document.getElementById('survey-mode-info').classList.add('hidden');
          }
          document.getElementById('course-survey-title').value = course.survey_title || '';
          document.getElementById('course-survey-description').value = course.survey_description || '';
          if (course.enable_course_survey) {
            document.getElementById('survey-fields').classList.remove('hidden');
          }
          
          const coursePricingToggleEl = document.getElementById('course-pricing-toggle');
          const isPaidCourse = course.is_free === false;
          coursePricingToggleEl.checked = isPaidCourse;
          document.getElementById('course-price').value = course.price ?? '';
          document.getElementById('course-discount').value = course.discount ?? '';
          document.getElementById('course-discount-type').value = course.discount_type || 'amount';
          document.getElementById('course-currency').value = (course.currency || 'USD');
          showHidePricing(coursePricingToggleEl, document.getElementById('course-pricing-fields'));
          updateDiscountPreview('course');
          setImagePreview(document.getElementById('course-thumbnail-preview'), course.thumbnail_url || course.image_url || '');
          
          // Set completion type radio buttons
          if (course.certificate_template) {
            document.getElementById('completion-certificate').checked = true;
            document.getElementById('certificate-template-group').style.display = 'block';
          } else if (course.completion_instructions) {
            document.getElementById('completion-instructions-radio').checked = true;
            document.getElementById('completion-instructions-group').style.display = 'block';
          } else {
            document.getElementById('completion-none').checked = true;
          }
          
          if (course.has_prerequisite && course.prerequisite_course_id) {
            document.getElementById('course-has-prerequisite').checked = true;
            document.getElementById('prerequisite-select-container').style.display = 'block';
            document.getElementById('course-prerequisite').value = course.prerequisite_course_id;
          }
          const adminFormSelect = document.getElementById('course-language');
          if (adminFormSelect) {
            adminFormSelect.value = course.language_id || course.language || course.language_code || '';
          }
        } catch (error) {
          showNotification('Error loading course details: ' + error.message, 'error');
          console.error('Course load error:', error);
        }
      } else {
        // Create mode
        title.textContent = '✨ Add New Course';
        saveText.textContent = 'Create Course';
        const adminFormSelect = document.getElementById('course-language');
        if (adminFormSelect && tutorLanguages.length) {
          const defaultLang = tutorLanguages.find(l => l.is_default);
          adminFormSelect.value = defaultLang ? defaultLang.id : tutorLanguages[0].id;
        }
      }
    }

    async function loadAvailablePrerequisites(excludeCourseId = null) {
      try {
        const data = await apiCall('/tutor/courses');
        const courses = data.courses || data;
        
        const select = document.getElementById('course-prerequisite');
        select.innerHTML = '<option value="">-- Select a prerequisite course --</option>';
        
        if (courses && courses.length > 0) {
          courses.forEach(course => {
            if (!excludeCourseId || course.id != excludeCourseId) {
              select.innerHTML += `<option value="${course.id}">${course.name}</option>`;
            }
          });
        }
      } catch (error) {
        console.error('Error loading prerequisites:', error);
      }
    }

    function closeCourseModal() {
      const modal = document.getElementById('course-modal');
      modal.classList.remove('active');
      modal.classList.add('hidden');
      currentCourseId = null;
    }

    function showDeleteCourseModal(courseId, courseName) {
      deleteCourseId = courseId;
      document.getElementById('delete-course-name').textContent = courseName;
      document.getElementById('delete-course-id').textContent = courseId;
      const modal = document.getElementById('delete-course-modal');
      modal.classList.remove('hidden');
      modal.classList.add('active');
    }

    function closeDeleteCourseModal() {
      const modal = document.getElementById('delete-course-modal');
      modal.classList.remove('active');
      modal.classList.add('hidden');
      deleteCourseId = null;
    }

    async function confirmDeleteCourse() {
      if (!deleteCourseId) return;

      try {
        await apiCall(`/tutor/courses/${deleteCourseId}`, 'DELETE');
        showNotification('Course deleted successfully!');
        closeDeleteCourseModal();
        setTimeout(() => location.reload(), 1000);
      } catch (error) {
        showNotification('Error deleting course', 'error');
      }
    }

    // Load certificate templates for dropdown
    async function loadCertificateTemplates() {
      try {
        const response = await apiRequest('/tutor/certificate-templates', 'GET');
        if (response.success && response.templates) {
          const templates = response.templates;
          
          // Populate lesson certificate dropdown
          const lessonSelect = document.getElementById('lesson-certificate-id');
          if (lessonSelect) {
            while (lessonSelect.options.length > 1) {
              lessonSelect.remove(1);
            }
            templates.forEach(template => {
              const option = document.createElement('option');
              option.value = template.id;
              option.textContent = template.name;
              lessonSelect.appendChild(option);
            });
          }
          
          // Populate course certificate dropdowns (both create and edit modals)
          const courseSelects = [
            document.getElementById('course-certificate'),
            document.getElementById('tutor-course-certificate')
          ];
          
          courseSelects.forEach(select => {
            if (select) {
              while (select.options.length > 1) {
                select.remove(1);
              }
              templates.forEach(template => {
                const option = document.createElement('option');
                option.value = template.id;
                option.textContent = template.name;
                select.appendChild(option);
              });
            }
          });
        }
      } catch (error) {
        console.error('Failed to load certificate templates:', error);
      }
    }

    // Load categories for course dropdown
    async function loadCategoriesDropdown() {
      try {
        const response = await fetch('/tutor/categories', {
          headers: {
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });
        const categories = await response.json();
        
        const categorySelect = document.getElementById('course-category');
        if (categorySelect) {
          // Clear existing options except the first one (placeholder)
          while (categorySelect.options.length > 1) {
            categorySelect.remove(1);
          }
          
          // Add active categories
          categories
            .filter(cat => cat.is_active)
            .sort((a, b) => a.order - b.order)
            .forEach(category => {
              const option = document.createElement('option');
              option.value = category.name;
              option.textContent = category.name;
              categorySelect.appendChild(option);
            });
          
          console.log(`Loaded ${categories.filter(c => c.is_active).length} active categories for dropdown`);
        }
      } catch (error) {
        console.error('Failed to load categories dropdown:', error);
      }
    }

    // Prerequisite checkbox toggle
    document.addEventListener('DOMContentLoaded', function() {
      // Load certificate templates and categories for dropdowns
      loadCertificateTemplates();
      loadCategoriesDropdown();
      
      // Prefetch students shortly after load to improve responsiveness
      setTimeout(prefetchStudents, 500);
      // Initialize TinyMCE for topic body editor
      tinymce.init({
        selector: '#topic-body',
        height: 400,
        menubar: true,
        plugins: [
          'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
          'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
          'insertdatetime', 'media', 'table', 'help', 'wordcount'
        ],
        toolbar: 'undo redo | blocks | bold italic forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help',
        content_style: `
          body { 
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; 
            font-size: 14px; 
            background-color: #ffffff !important; 
            color: #000000 !important;
            padding: 10px;
          }
          body.mce-content-body { 
            background-color: #ffffff !important; 
            color: #000000 !important;
          }
          * {
            background-color: transparent;
          }
          p, h1, h2, h3, h4, h5, h6, li, td, th, div, span {
            color: #000000 !important;
          }
        `,
        branding: false,
        promotion: false,
        readonly: false,
        setup: function(editor) {
          editor.on('init', function() {
            editor.mode.set('design');
            const body = editor.getBody();
            if (body) {
              body.style.backgroundColor = '#ffffff';
              body.style.color = '#000000';
            }
          });
        }
      });

      const coursePricingToggle = document.getElementById('course-pricing-toggle');
      const coursePricingFields = document.getElementById('course-pricing-fields');
      coursePricingToggle?.addEventListener('change', () => showHidePricing(coursePricingToggle, coursePricingFields));
      showHidePricing(coursePricingToggle, coursePricingFields);

      const tutorPricingToggle = document.getElementById('tutor-course-pricing-toggle');
      const tutorPricingFields = document.getElementById('tutor-course-pricing-fields');
      tutorPricingToggle?.addEventListener('change', () => showHidePricing(tutorPricingToggle, tutorPricingFields));
      showHidePricing(tutorPricingToggle, tutorPricingFields);

      ['course', 'tutor-course'].forEach(baseId => {
        ['price', 'discount', 'discount-type', 'currency'].forEach(field => {
          document.getElementById(`${baseId}-${field}`)?.addEventListener('input', () => updateDiscountPreview(baseId));
        });
      });

      attachImagePreview(document.getElementById('course-thumbnail'), document.getElementById('course-thumbnail-preview'));
      attachImagePreview(document.getElementById('tutor-course-thumbnail'), document.getElementById('tutor-course-thumbnail-preview'));

      document.getElementById('course-has-prerequisite')?.addEventListener('change', (e) => {
        const container = document.getElementById('prerequisite-select-container');
        if (e.target.checked) {
          container.style.display = 'block';
        } else {
          container.style.display = 'none';
          document.getElementById('course-prerequisite').value = '';
        }
      });

      // Completion type radio buttons toggle
      document.querySelectorAll('input[name="completion-type"]').forEach(radio => {
        radio.addEventListener('change', (e) => {
          const certGroup = document.getElementById('certificate-template-group');
          const instrGroup = document.getElementById('completion-instructions-group');
          
          certGroup.style.display = 'none';
          instrGroup.style.display = 'none';
          
          if (e.target.value === 'certificate') {
            certGroup.style.display = 'block';
          } else if (e.target.value === 'instructions') {
            instrGroup.style.display = 'block';
          }
        });
      });

      // Course form submission
      document.getElementById('course-form')?.addEventListener('submit', async (e) => {
        e.preventDefault();
        
        const courseId = document.getElementById('course-id').value;
        const saveBtn = document.getElementById('save-course-btn');
        const originalHtml = saveBtn.innerHTML;
        
        saveBtn.disabled = true;
        saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
        
        try {
          const completionType = document.querySelector('input[name="completion-type"]:checked').value;
          
          const pricingToggle = document.getElementById('course-pricing-toggle');
          const isPaid = pricingToggle?.checked;
          const priceValue = parseFloat(document.getElementById('course-price')?.value || '0');
          if (isPaid && (!priceValue || priceValue <= 0)) {
            showNotification('Please enter a price for paid courses', 'error');
            saveBtn.disabled = false;
            saveBtn.innerHTML = originalHtml;
            return;
          }
          const formData = new FormData();
          formData.append('name', document.getElementById('course-name').value);
          formData.append('category', document.getElementById('course-category').value);
          if (document.getElementById('course-slug').value) {
            formData.append('slug', document.getElementById('course-slug').value);
          }
          formData.append('short_description', document.getElementById('course-description').value || '');
          formData.append('chunk_words', (parseInt(document.getElementById('course-chunk-words').value) || CHUNK_WORDS_SETTINGS.default).toString());
          formData.append('is_active', document.getElementById('course-active').checked ? '1' : '0');
          const hasPrerequisite = document.getElementById('course-has-prerequisite').checked;
          formData.append('has_prerequisite', hasPrerequisite ? '1' : '0');
          if (hasPrerequisite && document.getElementById('course-prerequisite').value) {
            formData.append('prerequisite_course_id', document.getElementById('course-prerequisite').value);
          }
          const languageId = document.getElementById('course-language').value || '';
          if (languageId) {
            formData.append('language_id', languageId);
          }
          formData.append('is_free', isPaid ? '0' : '1');
          if (isPaid) {
            formData.append('price', priceValue.toFixed(2));
            formData.append('discount', document.getElementById('course-discount')?.value || '');
            formData.append('discount_type', document.getElementById('course-discount-type')?.value || 'amount');
            formData.append('currency', (document.getElementById('course-currency').value || 'USD').toUpperCase());
          } else {
            formData.append('price', '0');
            formData.append('discount', '');
            formData.append('currency', (document.getElementById('course-currency').value || 'USD').toUpperCase());
          }
          const courseThumbFile = document.getElementById('course-thumbnail').files[0];
          if (courseThumbFile) {
            formData.append('thumbnail', courseThumbFile);
          }
          
          // Study time limits
          if (document.getElementById('course-enable-study-time').checked) {
            formData.append('enable_study_time_limit', '1');
            formData.append('min_study_minutes_per_day', document.getElementById('course-min-study-minutes').value || '');
            formData.append('max_study_minutes_per_day', document.getElementById('course-max-study-minutes').value || '');
          } else {
            formData.append('enable_study_time_limit', '0');
          }
          
          // Survey settings
          if (document.getElementById('course-enable-survey').checked) {
            formData.append('enable_survey', '1');
            formData.append('survey_mode', document.getElementById('survey-mode-feedback').checked ? 'feedback' : 'survey');
            formData.append('survey_title', document.getElementById('course-survey-title').value || '');
            formData.append('survey_description', document.getElementById('course-survey-description').value || '');
          } else {
            formData.append('enable_survey', '0');
          }
          
          // Add completion behavior fields based on selection
          if (completionType === 'certificate') {
            formData.append('certificate_template', document.getElementById('course-certificate').value || '');
            formData.append('completion_instructions', '');
          } else if (completionType === 'instructions') {
            formData.append('certificate_template', '');
            formData.append('completion_instructions', document.getElementById('course-instructions').value || '');
          } else {
            formData.append('certificate_template', '');
            formData.append('completion_instructions', '');
          }
          
          const method = courseId ? 'PUT' : 'POST';
          const url = courseId ? `/tutor/courses/${courseId}` : '/tutor/courses';
          
          // For Laravel PUT requests with FormData, we need to add _method
          if (courseId) {
            formData.append('_method', 'PUT');
          }
          
          const result = await apiCall(url, courseId ? 'POST' : 'POST', formData);
          
          showNotification(courseId ? 'Course updated successfully!' : 'Course created successfully!');
          closeCourseModal();
          setTimeout(() => location.reload(), 1000);
        } catch (error) {
          showNotification(error.message || 'Error saving course', 'error');
        } finally {
          saveBtn.disabled = false;
          saveBtn.innerHTML = originalHtml;
        }
      });
    });

    // Create Course (for backwards compatibility)
    async function createCourse(name, description = '', isActive = true) {
      try {
        const result = await apiCall('/tutor/courses', 'POST', {
          name: name,
          short_description: description,
          is_active: isActive
        });
        
        showNotification('Course created successfully!');
        console.log('Created course:', result);
        
        // Reload page to show new course
        setTimeout(() => location.reload(), 1000);
      } catch (error) {
        console.error('Failed to create course:', error);
        showNotification('Failed to create course', 'error');
      }
    }

    // Edit Course - now opens modal
    async function editCourse(courseId, currentName, currentDescription, currentActive) {
      openCourseModal(courseId);
    }

    // Delete Course - now uses modal
    async function deleteCourse(courseId, courseName) {
      showDeleteCourseModal(courseId, courseName);
    }

    // Load Students
    async function loadStudents() {
      try {
        const students = await apiCall('/tutor/students');
        console.log('Students loaded:', students);
        showNotification('Students data refreshed!');
      } catch (error) {
        console.error('Failed to load students:', error);
      }
    }

    // ================================
    // Students Table (server-rendered) Controls
    // ================================
    function initStudentsTableControls() {
      const section = document.getElementById('students');
      if (!section) return;

      const tbody = section.querySelector('#students-tbody');
      const pager = section.querySelector('#students-pager');
      const prevBtn = section.querySelector('#students #students-prev');
      const nextBtn = section.querySelector('#students #students-next');
      const pageLabel = pager ? pager.querySelector('span') : null;
      const pageSizeSel = section.querySelector('#students-page-size');
      const searchInput = section.querySelector('#students-search');
      const refreshBtn = section.querySelector('#students-refresh');

      if (!tbody || !pager) return;

      let page = parseInt(pager.getAttribute('data-page') || '1', 10);
      let limit = parseInt(pager.getAttribute('data-limit') || '50', 10);
      let hasMore = (pager.getAttribute('data-has-more') || '0') === '1';
      let search = '';

      // Sync page size select with meta
      if (pageSizeSel) {
        if ([25, 50, 100].includes(limit)) {
          pageSizeSel.value = String(limit);
        }
      }

      function renderRows(students) {
        if (!students || students.length === 0) {
          tbody.innerHTML = '<tr><td colspan="5" style="text-align:center; color:#9ca3af; padding:20px;">No students found</td></tr>';
          return;
        }
        const rows = students.map(s => {
          const name = s.name || 'Unknown';
          const email = s.email || '';
          const enrolled = s.enrolled_courses || s.courses_count || 0;
          const p = Math.round(s.total_progress || 0);
          const q = Math.round(s.average_quiz_score || 0);
          const last = s.last_activity || 'Never';
          const barColor = p >= 75 ? '#10b981' : (p >= 50 ? '#f59e0b' : (p >= 25 ? '#3b82f6' : '#ef4444'));
          const initial = (name || 'U').charAt(0).toUpperCase();
          return `
            <tr>
              <td>
                <div style="display:flex; align-items:center; gap:10px;">
                  <div style="width:36px; height:36px; border-radius:50%; background:linear-gradient(135deg,#667eea,#764ba2); color:white; display:flex; align-items:center; justify-content:center; font-weight:700;">${initial}</div>
                  <div>
                    <div style="font-weight:600; color:#374151;">${name}</div>
                    <div style="font-size:12px; color:#6b7280;">${email}</div>
                  </div>
                </div>
              </td>
              <td style="text-align:center;">
                <span style="display:inline-block; padding:4px 10px; background:#e0e7ff; color:#3730a3; border-radius:999px; font-weight:600;">${enrolled}</span>
              </td>
              <td style="text-align:center;">
                <div style="display:flex; align-items:center; justify-content:center; gap:8px;">
                  <div style="width:100px; height:8px; background:#e5e7eb; border-radius:4px; overflow:hidden;">
                    <div style="height:100%; width:${p}%; background:${barColor};"></div>
                  </div>
                  <span style="font-weight:600; color:#374151;">${p}%</span>
                </div>
              </td>
              <td style="text-align:center;">
                <span style="font-weight:600; color:${q>=80 ? '#10b981' : (q>=60 ? '#f59e0b' : '#ef4444')};">${q}%</span>
              </td>
              <td style="text-align:center; color:#6b7280;">${last}</td>
            </tr>`;
        }).join('');
        tbody.innerHTML = rows;
      }

      function applyPager(meta) {
        if (!meta) return;
        page = parseInt(meta.page || 1, 10);
        limit = parseInt(meta.limit || limit, 10);
        hasMore = !!meta.has_more;
        pager.setAttribute('data-page', String(page));
        pager.setAttribute('data-limit', String(limit));
        pager.setAttribute('data-has-more', hasMore ? '1' : '0');
        if (pageLabel) pageLabel.textContent = `Page ${page}`;
        if (prevBtn) prevBtn.disabled = page <= 1;
        if (nextBtn) nextBtn.disabled = !hasMore;
      }

      async function fetchAndRender(targetPage = page) {
        const params = new URLSearchParams();
        params.set('limit', String(limit));
        params.set('page', String(targetPage));
        if (search && search.trim().length > 0) params.set('search', search.trim());
        const url = `/tutor/students?${params.toString()}`;
        const data = await apiCall(url, 'GET', null, 10000);
        const students = data.students || data.data || [];
        const meta = data.meta || { page: targetPage, limit, has_more: false };
        renderRows(students);
        applyPager(meta);
      }

      // Events
      prevBtn?.addEventListener('click', () => {
        if (page > 1) fetchAndRender(page - 1);
      });
      nextBtn?.addEventListener('click', () => {
        if (hasMore) fetchAndRender(page + 1);
      });
      pageSizeSel?.addEventListener('change', () => {
        limit = parseInt(pageSizeSel.value || '50', 10);
        fetchAndRender(1);
      });
      let searchDebounce;
      searchInput?.addEventListener('input', () => {
        clearTimeout(searchDebounce);
        searchDebounce = setTimeout(() => {
          search = searchInput.value || '';
          fetchAndRender(1);
        }, 400);
      });
      refreshBtn?.addEventListener('click', () => fetchAndRender(page));
    }

    document.addEventListener('DOMContentLoaded', () => {
      // Initialize student server-rendered controls after page ready
      initStudentsTableControls();
    });

    // Show Student Details Modal
  let studentsPage = 1;
  const studentsPageSize = 50;

  function showHidePricing(toggleEl, containerEl) {
    if (!toggleEl || !containerEl) return;
    const priceInput = containerEl.querySelector('input[id$="course-price"]') || containerEl.querySelector('#course-price');
    const discountInput = containerEl.querySelector('input[id$="course-discount"]') || containerEl.querySelector('#course-discount');
    const currencyInput = containerEl.querySelector('input[id$="course-currency"]') || containerEl.querySelector('#course-currency');
    if (toggleEl.checked) {
      containerEl.classList.remove('hidden');
      if (priceInput) priceInput.required = true;
      if (currencyInput && !currencyInput.value) currencyInput.value = 'USD';
    } else {
      containerEl.classList.add('hidden');
      if (priceInput) { priceInput.required = false; priceInput.value = ''; }
      if (discountInput) discountInput.value = '';
    }
  }

  async function showStudentDetails(type) {
      const modal = document.getElementById('student-details-modal');
      const title = document.getElementById('student-modal-title');
      const content = document.getElementById('student-list-content');
      
      // Set title based on type
      const titles = {
        'total': '👥 All Students',
        'active': '✅ Active Students (Last 7 Days)',
        'recent': '🆕 New Students This Week'
      };
      title.textContent = titles[type] || '👥 Student Details';
      
      // Show modal
      modal.style.display = 'flex';
      modal.classList.remove('hidden');
      
      // Show loading
      content.innerHTML = `
        <div style="text-align: center; padding: 40px;">
          <i class="fas fa-spinner fa-spin" style="font-size: 32px; color: #667eea;"></i>
          <p style="margin-top: 15px; color: #6b7280;">Loading student data...</p>
        </div>
      `;
      
      try {
        // If we have cached students, render immediately for responsiveness
        if (window.cachedStudents && Array.isArray(window.cachedStudents.data) && window.cachedStudents.data.length > 0) {
          renderStudentList(window.cachedStudents.data, content, window.cachedStudents.meta);
        }

        // Reset to first page when opening
        studentsPage = 1;
        // Fetch fresh student data (paged)
        const data = await apiCall(`/tutor/students?limit=${studentsPageSize}&page=${studentsPage}`);
        const students = data.students || data.data || [];
        const meta = data.meta || { total: students.length, page: studentsPage, limit: studentsPageSize, has_more: false };
        // Update cache shape
        window.cachedStudents = { data: students, meta };
        // Render
        renderStudentList(students, content, meta);
      } catch (error) {
        console.error('Failed to load student details:', error);
        content.innerHTML = `
          <div style="text-align: center; padding: 40px; color: #ef4444;">
            <i class="fas fa-exclamation-triangle" style="font-size: 48px; opacity: 0.5;"></i>
            <p style="margin-top: 15px; font-size: 16px;">Failed to load student data</p>
            <p style="margin-top: 8px; font-size: 14px; color: #6b7280;">${error.message || 'Unknown error'}</p>
            <button onclick="showStudentDetails('${type}')" style="margin-top: 15px; padding: 10px 20px; background: #667eea; color: white; border: none; border-radius: 8px; cursor: pointer;">
              <i class="fas fa-sync"></i> Retry
            </button>
          </div>
        `;
      }
    }

    function renderStudentList(students, content, meta = null) {
      if (!students || students.length === 0) {
        content.innerHTML = `
          <div style="text-align: center; padding: 40px; color: #6b7280;">
            <i class="fas fa-users" style="font-size: 48px; opacity: 0.3;"></i>
            <p style="margin-top: 15px; font-size: 16px;">No students found</p>
          </div>
        `;
        return;
      }

      // Build student list table
      let html = `
        <table style="width: 100%; border-collapse: collapse;">
          <thead>
            <tr style="background: #f9fafb; border-bottom: 2px solid #e5e7eb;">
              <th style="padding: 12px; text-align: left; font-weight: 600; color: #374151;">Student</th>
              <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Enrolled Courses</th>
              <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Progress</th>
              <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Quiz Avg</th>
              <th style="padding: 12px; text-align: center; font-weight: 600; color: #374151;">Level</th>
              <th style="padding: 12px; text-align: left; font-weight: 600; color: #374151;">Last Activity</th>
            </tr>
          </thead>
          <tbody>
      `;

      students.forEach(student => {
        const progress = student.total_progress || 0;
        const progressColor = progress >= 75 ? '#10b981' : progress >= 50 ? '#f59e0b' : progress >= 25 ? '#3b82f6' : '#ef4444';
        const quizAvg = student.average_quiz_score || 0;
        const level = student.level || 1;
        const lastActivity = student.last_activity || 'Never';
        const enrolledCourses = student.enrolled_courses || student.courses_count || 0;

        html += `
          <tr style="border-bottom: 1px solid #e5e7eb; transition: background 0.2s;" onmouseover="this.style.background='#f9fafb'" onmouseout="this.style.background='white'">
            <td style="padding: 12px;">
              <div style="display: flex; align-items: center; gap: 10px;">
                <div style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: 600; font-size: 16px;">
                  ${(student.name || 'U').charAt(0).toUpperCase()}
                </div>
                <div>
                  <div style="font-weight: 600; color: #374151;">${student.name || 'Unknown'}</div>
                  <div style="font-size: 12px; color: #6b7280;">${student.email || ''}</div>
                </div>
              </div>
            </td>
            <td style="padding: 12px; text-align: center;">
              <span style="display: inline-block; padding: 4px 12px; background: #e0e7ff; color: #667eea; border-radius: 12px; font-weight: 600; font-size: 14px;">
                ${enrolledCourses}
              </span>
            </td>
            <td style="padding: 12px; text-align: center;">
              <div style="display: flex; align-items: center; justify-content: center; gap: 8px;">
                <div style="flex: 0 0 80px; height: 8px; background: #e5e7eb; border-radius: 4px; overflow: hidden;">
                  <div style="height: 100%; background: ${progressColor}; width: ${progress}%; transition: width 0.3s;"></div>
                </div>
                <span style="font-weight: 600; color: ${progressColor}; font-size: 14px;">${Math.round(progress)}%</span>
              </div>
            </td>
            <td style="padding: 12px; text-align: center;">
              <span style="font-weight: 600; color: ${quizAvg >= 80 ? '#10b981' : quizAvg >= 60 ? '#f59e0b' : '#ef4444'}; font-size: 14px;">
                ${Math.round(quizAvg)}%
              </span>
            </td>
            <td style="padding: 12px; text-align: center;">
              <div style="display: inline-flex; align-items: center; gap: 5px; padding: 4px 10px; background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%); color: white; border-radius: 12px; font-weight: 600; font-size: 13px;">
                <i class="fas fa-star"></i> ${level}
              </div>
            </td>
            <td style="padding: 12px; color: #6b7280; font-size: 13px;">
              <i class="fas fa-clock" style="margin-right: 5px;"></i>
              ${lastActivity}
            </td>
          </tr>
        `;
      });

      html += `
          </tbody>
        </table>
      `;

      // Footer with pagination controls
      if (meta && (meta.has_more || (meta.page && meta.page > 1))) {
        html += `
          <div style="display:flex; justify-content: center; gap: 10px; margin-top: 15px;">
            <button id="students-prev" ${meta.page <= 1 ? 'disabled' : ''} class="btn btn-secondary"><i class="fas fa-chevron-left"></i> Prev</button>
            <span style="align-self: center; color:#6b7280;">Page ${meta.page}</span>
            <button id="students-next" ${meta.has_more ? '' : 'disabled'} class="btn btn-primary">Next <i class="fas fa-chevron-right"></i></button>
          </div>
        `;
      }

      content.innerHTML = html;

      // Wire up pagination buttons
      if (meta) {
        document.getElementById('students-prev')?.addEventListener('click', async () => {
          if (meta.page <= 1) return;
          await loadStudentsPage(meta.page - 1, content);
        });
        document.getElementById('students-next')?.addEventListener('click', async () => {
          if (!meta.has_more) return;
          await loadStudentsPage(meta.page + 1, content);
        });
      }
    }

    async function loadStudentsPage(page, contentEl) {
      try {
        const data = await apiCall(`/tutor/students?limit=${studentsPageSize}&page=${page}`);
        const students = data.students || data.data || [];
        const meta = data.meta || { total: students.length, page: page, limit: studentsPageSize, has_more: false };
        window.cachedStudents = { data: students, meta };
        renderStudentList(students, contentEl, meta);
      } catch (e) {
        showNotification('Failed to load page', 'error');
      }
    }

    function closeStudentModal() {
      const modal = document.getElementById('student-details-modal');
      modal.style.display = 'none';
      modal.classList.add('hidden');
    }

    // Add CSS animations
    const style = document.createElement('style');
    style.textContent = `
      @keyframes slideIn {
        from {
          transform: translateX(400px);
          opacity: 0;
        }
        to {
          transform: translateX(0);
          opacity: 1;
        }
      }
      @keyframes slideOut {
        from {
          transform: translateX(0);
          opacity: 1;
        }
        to {
          transform: translateX(400px);
          opacity: 0;
        }
      }
      .btn-danger {
        background: #ef4444;
      }
      .btn-danger:hover {
        background: #dc2626;
      }
    `;
    document.head.appendChild(style);

    // ============================================
    // TUTOR COURSE MANAGEMENT FUNCTIONS
    // ============================================

    let tutorCourses = [];
    let currentTutorCourseId = null;
    let deleteTutorCourseId = null;
    let tutorLanguages = [];

    async function loadTutorLanguages() {
      try {
        const res = await apiCall('/api/languages/active');
        tutorLanguages = res.languages || res.data || [];
        const filterSelect = document.getElementById('tutor-language-filter');
        if (filterSelect) {
          filterSelect.innerHTML = '<option value=\"\">🌐 All languages</option>' + tutorLanguages.map(l => `
            <option value=\"${l.id}\">${l.flag_emoji || ''} ${l.name} (${l.code})</option>
          `).join('');
        }
        const adminFilterSelect = document.getElementById('course-language-filter');
        if (adminFilterSelect) {
          const currentValue = adminFilterSelect.value;
          adminFilterSelect.innerHTML = '<option value=\"\">🌐 All languages</option>' + tutorLanguages.map(l => `
            <option value=\"${l.id}\">${l.flag_emoji || ''} ${l.name} (${l.code})</option>
          `).join('');
          if (currentValue) {
            adminFilterSelect.value = currentValue;
          }
        }
        const adminFormSelect = document.getElementById('course-language');
        if (adminFormSelect) {
          const currentValue = adminFormSelect.value;
          adminFormSelect.innerHTML = '<option value=\"\">Select language</option>' + tutorLanguages.map(l => `
            <option value=\"${l.id}\">${l.flag_emoji || ''} ${l.name} (${l.code})</option>
          `).join('');
          if (currentValue) {
            adminFormSelect.value = currentValue;
          } else {
            const defaultLang = tutorLanguages.find(l => l.is_default);
            if (defaultLang) {
              adminFormSelect.value = defaultLang.id;
            }
          }
        }
        const formSelect = document.getElementById('tutor-course-language');
        if (formSelect) {
          formSelect.innerHTML = '<option value=\"\">Use default language</option>' + tutorLanguages.map(l => `
            <option value=\"${l.code}\">${l.flag_emoji || ''} ${l.name} (${l.code})</option>
          `).join('');
          const defaultLang = tutorLanguages.find(l => l.is_default);
          if (defaultLang) {
            formSelect.value = defaultLang.code;
          }
        }
      } catch (e) {
        console.warn('Failed to load languages', e);
      }
    }

    // Load categories for filter (course page)
    async function loadCategoriesForFilter() {
      try {
        const res = await apiCall('/tutor/categories');
        const categories = (res || []).filter(cat => cat.is_active);
        
        // Populate filter dropdown
        const filterSelect = document.getElementById('course-category-filter');
        if (filterSelect) {
          filterSelect.innerHTML = '<option value="">📁 All Categories</option>' + categories.map(cat => `
            <option value="${cat.name}">${cat.name}</option>
          `).join('');
        }
        
        // Populate form dropdown
        const formSelect = document.getElementById('course-category');
        if (formSelect) {
          const currentValue = formSelect.value;
          formSelect.innerHTML = '<option value="">Select a category</option>' + categories.map(cat => `
            <option value="${cat.name}">${cat.name}</option>
          `).join('');
          if (currentValue) {
            formSelect.value = currentValue;
          }
        }
      } catch (e) {
        console.warn('Failed to load categories', e);
      }
    }

    // Tab switching for course management
    document.querySelectorAll('.tutor-tab-btn').forEach(btn => {
      btn.addEventListener('click', function() {
        const tab = this.getAttribute('data-tab');
        
        // Update button states
        document.querySelectorAll('.tutor-tab-btn').forEach(b => {
          b.style.background = 'transparent';
          b.style.color = 'rgba(255,255,255,0.7)';
        });
        this.style.background = 'rgba(255,255,255,0.2)';
        this.style.color = 'white';
        
        // Update tab content
        document.querySelectorAll('.tutor-tab-content').forEach(content => {
          content.classList.add('hidden');
        });
        
        if (tab === 'courses-list') {
          document.getElementById('tutor-courses-list-tab').classList.remove('hidden');
        } else if (tab === 'lessons-topics') {
          document.getElementById('tutor-lessons-topics-tab').classList.remove('hidden');
        }
      });
    });

    // Load courses on page load
    async function loadTutorCourses() {
      try {
        const langFilter = document.getElementById('tutor-language-filter')?.value;
        let url = '/tutor/courses';
        if (langFilter) {
          url += `?language_id=${langFilter}`;
        }
        url += (url.includes('?') ? '&' : '?') + `_t=${Date.now()}`;
        const response = await fetch(url, {
          headers: {
            'Cache-Control': 'no-cache, no-store, must-revalidate',
            'Pragma': 'no-cache',
            'Accept': 'application/json'
          }
        });
        const courses = await response.json();
        tutorCourses = courses;
        renderTutorCoursesTable(courses);
        populateTutorCourseFilter(courses);
      } catch (error) {
        console.error('Error loading courses:', error);
        document.getElementById('tutor-courses-table-body').innerHTML = `
          <tr>
            <td colspan="6" style="text-align: center; padding: 40px; color: #ef4444;">
              <i class="fas fa-exclamation-triangle" style="font-size: 24px;"></i>
              <p style="margin-top: 10px;">Error loading courses. Please refresh the page.</p>
            </td>
          </tr>
        `;
      }
    }

    function renderTutorCoursesTable(courses) {
      const tbody = document.getElementById('tutor-courses-table-body');
      
      if (!courses || courses.length === 0) {
        tbody.innerHTML = `
          <tr>
            <td colspan="6" style="text-align: center; padding: 40px; color: #999;">
              <i class="fas fa-book-open" style="font-size: 48px; margin-bottom: 15px; display: block; opacity: 0.5;"></i>
              <p>No courses yet. Click "Add New Course" to get started!</p>
            </td>
          </tr>
        `;
        
        // Update stats to zero
        document.getElementById('tutor-stats-total-courses').textContent = '0';
        document.getElementById('tutor-stats-total-students').textContent = '0';
        document.getElementById('tutor-stats-total-lessons').textContent = '0';
        document.getElementById('tutor-stats-avg-completion').textContent = '0%';
        return;
      }

      // Calculate summary stats
      const totalCourses = courses.length;
      const totalStudents = courses.reduce((sum, c) => sum + (c.enrolled_students || 0), 0);
      const totalLessons = courses.reduce((sum, c) => sum + (c.lesson_count || 0), 0);
      const avgCompletion = courses.length > 0 
        ? (courses.reduce((sum, c) => sum + (c.completion_rate || 0), 0) / courses.length).toFixed(1)
        : 0;
      
      // Update stats display
      document.getElementById('tutor-stats-total-courses').textContent = totalCourses;
      document.getElementById('tutor-stats-total-students').textContent = totalStudents;
      document.getElementById('tutor-stats-total-lessons').textContent = totalLessons;
      document.getElementById('tutor-stats-avg-completion').textContent = avgCompletion + '%';

      tbody.innerHTML = courses.map(course => {
        const completionRate = course.completion_rate || 0;
        const completionColor = completionRate >= 75 ? '#10b981' : completionRate >= 50 ? '#f59e0b' : '#ef4444';
        const enrolledCount = course.enrolled_students || 0;
        const activeCount = course.active_students || 0;
        
        return `
        <tr style="border-bottom: 1px solid #e5e7eb; transition: background 0.2s;" onmouseover="this.style.background='#f9fafb'" onmouseout="this.style.background='transparent'">
          <td style="padding: 15px;">
            <div style="display: flex; align-items: center; gap: 12px;">
              <div style="width: 40px; height: 40px; border-radius: 8px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 16px; flex-shrink: 0;">
                ${(course.name || 'U').charAt(0).toUpperCase()}
              </div>
              <div style="flex: 1; min-width: 0;">
                <strong style="color: #374151; font-size: 14px; display: block; margin-bottom: 4px;">${course.name || 'Untitled Course'}</strong>
                ${course.short_description ? `<small style="color: #6b7280; display: block; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${course.short_description}</small>` : ''}
                ${course.language_code ? `<div style="font-size: 11px; color: #374151; margin-top: 4px;"><i class="fas fa-language"></i> ${course.language_flag_emoji || ''} ${course.language_code.toUpperCase()}</div>` : ''}
                <div style="display: flex; gap: 12px; margin-top: 6px; font-size: 11px; color: #9ca3af;">
                  <span title="Lessons"><i class="fas fa-book"></i> ${course.lesson_count || 0} lessons</span>
                  <span title="Topics"><i class="fas fa-bookmark"></i> ${course.topic_count || 0} topics</span>
                </div>
              </div>
            </div>
          </td>
          <td style="padding: 15px; text-align: center;">
            <span style="padding: 6px 14px; border-radius: 16px; font-size: 11px; font-weight: 600; ${course.is_active ? 'background: #d1fae5; color: #065f46;' : 'background: #fee2e2; color: #991b1b;'}">
              ${course.is_active ? '<i class="fas fa-check-circle"></i> Active' : '<i class="fas fa-times-circle"></i> Inactive'}
            </span>
          </td>
          <td style="padding: 15px; text-align: center;">
            <div style="font-size: 20px; font-weight: 700; color: #667eea;">${enrolledCount}</div>
            <small style="color: #9ca3af; font-size: 11px;">
              ${activeCount > 0 ? `<span style="color: #10b981;"><i class="fas fa-circle" style="font-size: 6px;"></i> ${activeCount} active</span>` : 'students'}
            </small>
          </td>
          <td style="padding: 15px; text-align: center;">
            <div style="position: relative; width: 60px; height: 60px; margin: 0 auto;">
              <svg width="60" height="60" style="transform: rotate(-90deg);">
                <circle cx="30" cy="30" r="25" fill="none" stroke="#e5e7eb" stroke-width="6"/>
                <circle cx="30" cy="30" r="25" fill="none" stroke="${completionColor}" stroke-width="6" 
                        stroke-dasharray="${(completionRate / 100) * 157} 157" 
                        stroke-linecap="round"/>
              </svg>
              <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); font-size: 14px; font-weight: 700; color: ${completionColor};">
                ${completionRate}%
              </div>
            </div>
            <small style="color: #6b7280; font-size: 11px; display: block; margin-top: 4px;">completion</small>
          </td>
          <td style="padding: 15px;">
            <div style="display: flex; flex-wrap: nowrap; gap: 6px; justify-content: center; align-items: center; white-space: nowrap; overflow-x: auto;">
              <button onclick="manageTutorCourseContent(${course.id}, '${(course.name || '').replace(/'/g, "\\'")}')" class="btn btn-primary" style="padding: 8px 12px; font-size: 12px; background: #667eea; border: none;" title="Manage Lessons & Topics">
                <i class="fas fa-sitemap"></i>
              </button>
              <button onclick="editTutorCourse(${course.id})" class="btn btn-primary" style="padding: 8px 12px; font-size: 12px; background: #8b5cf6; border: none;" title="Edit Course">
                <i class="fas fa-edit"></i>
              </button>
              <button onclick="viewCourseStudents(${course.id}, '${(course.name || '').replace(/'/g, "\\'")}')" class="btn btn-secondary" style="padding: 8px 12px; font-size: 12px; background: #3b82f6; border: none;" title="View Students">
                <i class="fas fa-users"></i>
              </button>
              ${course.enable_course_survey || course.enable_survey ? `
                <button onclick="manageSurvey(${course.id}, '${(course.name || '').replace(/'/g, "\\'")}')" class="btn btn-secondary" style="padding: 8px 12px; font-size: 12px; background: #10b981; border: none;" title="Manage Survey">
                  <i class="fas fa-poll"></i>
                </button>
                <button onclick="viewSurveyResults(${course.id}, '${(course.name || '').replace(/'/g, "\\'")}' )" class="btn btn-secondary" style="padding: 8px 12px; font-size: 12px; background: #f59e0b; border: none;" title="Survey Results">
                  <i class="fas fa-chart-bar"></i>
                </button>
              ` : ''}
              <button onclick="duplicateTutorCourse(${course.id})" class="btn btn-secondary" style="padding: 8px 12px; font-size: 12px; background: #6b7280; border: none;" title="Duplicate Course">
                <i class="fas fa-copy"></i>
              </button>
              <button onclick="showTutorDeleteCourseModal(${course.id}, '${(course.name || '').replace(/'/g, "\\'")}' )" class="btn btn-danger" style="padding: 8px 12px; font-size: 12px; border: none;" title="Delete Course">
                <i class="fas fa-trash"></i>
              </button>
            </div>
          </td>
        </tr>
      `}).join('');
    }

    function populateTutorCourseFilter(courses) {
      const select = document.getElementById('tutor-content-course-filter');
      if (select) {
        select.innerHTML = '<option value="">Select Course to Manage</option>' +
          courses.map(c => `<option value="${c.id}">${c.name}</option>`).join('');
      }
    }

    // Add course button
    document.getElementById('tutor-add-course-btn')?.addEventListener('click', () => {
      openTutorCourseModal();
    });

    async function openTutorCourseModal(courseId = null) {
      currentTutorCourseId = courseId;
      const modal = document.getElementById('tutor-course-modal');
      const title = document.getElementById('tutor-course-modal-title');
      const saveText = document.getElementById('tutor-save-course-text');
      
      // Reset form
      document.getElementById('tutor-course-form').reset();
      document.getElementById('tutor-course-id').value = '';
      document.getElementById('tutor-course-chunk-words').value = CHUNK_WORDS_SETTINGS.default;
      document.getElementById('tutor-course-active').checked = true;
      document.getElementById('tutor-prerequisite-select-container').classList.add('hidden');
      document.getElementById('tutor-course-has-prerequisite').checked = false;
      document.getElementById('tutor-certificate-template-group').classList.add('hidden');
      document.getElementById('tutor-completion-instructions-group').classList.add('hidden');
      document.getElementById('tutor-completion-none').checked = true;
      document.getElementById('tutor-course-price').value = '';
      document.getElementById('tutor-course-discount').value = '';
      document.getElementById('tutor-course-discount-type').value = 'amount';
      document.getElementById('tutor-course-currency').value = 'USD';
      document.getElementById('tutor-course-pricing-toggle').checked = false;
      showHidePricing(document.getElementById('tutor-course-pricing-toggle'), document.getElementById('tutor-course-pricing-fields'));
      setImagePreview(document.getElementById('tutor-course-thumbnail-preview'), '');

      // Load available prerequisites
      await loadTutorAvailablePrerequisites(courseId);

      if (courseId) {
        // Edit mode
        title.textContent = '✏️ Edit Course';
        saveText.textContent = 'Update Course';
        
        try {
          const response = await fetch(`/tutor/courses/${courseId}?_t=${Date.now()}`, {
            headers: {
              'Cache-Control': 'no-cache, no-store, must-revalidate',
              'Pragma': 'no-cache',
              'Accept': 'application/json'
            }
          });
          const data = await response.json();
          const course = data.course || data;
          
          document.getElementById('tutor-course-id').value = course.id;
          document.getElementById('tutor-course-name').value = course.name;
          document.getElementById('tutor-course-slug').value = course.slug || '';
          document.getElementById('tutor-course-description').value = course.short_description || '';
          document.getElementById('tutor-course-chunk-words').value = course.chunk_words || CHUNK_WORDS_SETTINGS.default;
          document.getElementById('tutor-course-language').value = course.language_code || course.language || '';
          document.getElementById('tutor-course-certificate').value = course.certificate_template || '';
          document.getElementById('tutor-course-instructions').value = course.completion_instructions || '';
          document.getElementById('tutor-course-active').checked = course.is_active;
          const tutorPricingToggleEl = document.getElementById('tutor-course-pricing-toggle');
          const isPaidTutorCourse = course.is_free === false;
          tutorPricingToggleEl.checked = isPaidTutorCourse;
          document.getElementById('tutor-course-price').value = course.price ?? '';
          document.getElementById('tutor-course-discount').value = course.discount ?? '';
          document.getElementById('tutor-course-discount-type').value = course.discount_type || 'amount';
          document.getElementById('tutor-course-currency').value = (course.currency || 'USD');
          showHidePricing(tutorPricingToggleEl, document.getElementById('tutor-course-pricing-fields'));
          updateDiscountPreview('tutor-course');
          setImagePreview(document.getElementById('tutor-course-thumbnail-preview'), course.thumbnail_url || course.image_url || '');
          
          // Study time limits
          document.getElementById('course-enable-study-time').checked = course.enable_study_time_limit || false;
          document.getElementById('course-min-study-minutes').value = course.min_study_time_per_day || 15;
          document.getElementById('course-max-study-minutes').value = course.max_study_time_per_day || 60;
          if (course.enable_study_time_limit) {
            document.getElementById('study-time-fields').classList.remove('hidden');
          }
          
          // Survey settings
          document.getElementById('course-enable-survey').checked = course.enable_course_survey || false;
          
          // Set survey mode radio buttons
          if (course.survey_mode === 'survey') {
            document.getElementById('survey-mode-survey').checked = true;
            document.getElementById('feedback-mode-info').classList.add('hidden');
            document.getElementById('survey-mode-info').classList.remove('hidden');
          } else {
            document.getElementById('survey-mode-feedback').checked = true;
            document.getElementById('feedback-mode-info').classList.remove('hidden');
            document.getElementById('survey-mode-info').classList.add('hidden');
          }
          
          document.getElementById('course-survey-title').value = course.survey_title || '';
          document.getElementById('course-survey-description').value = course.survey_description || '';
          if (course.enable_course_survey) {
            document.getElementById('survey-fields').classList.remove('hidden');
          }
          
          // Set completion type radio buttons
          if (course.certificate_template) {
            document.getElementById('tutor-completion-certificate').checked = true;
            document.getElementById('tutor-certificate-template-group').classList.remove('hidden');
          } else if (course.completion_instructions) {
            document.getElementById('tutor-completion-instructions-radio').checked = true;
            document.getElementById('tutor-completion-instructions-group').classList.remove('hidden');
          } else {
            document.getElementById('tutor-completion-none').checked = true;
          }
          
          if (course.has_prerequisite && course.prerequisite_course_id) {
            document.getElementById('tutor-course-has-prerequisite').checked = true;
            document.getElementById('tutor-prerequisite-select-container').classList.remove('hidden');
            document.getElementById('tutor-course-prerequisite').value = course.prerequisite_course_id;
          }
        } catch (error) {
          showNotification('Error loading course details', 'error');
          return;
        }
      } else {
        // Create mode
        title.textContent = '✨ Add New Course';
        saveText.textContent = 'Create Course';
      }

      modal.classList.remove('hidden');
    }

    async function loadTutorAvailablePrerequisites(excludeCourseId = null) {
      try {
        const url = excludeCourseId 
          ? `/tutor/available-prerequisites/${excludeCourseId}`
          : '/tutor/available-prerequisites';
        const response = await fetch(url);
        const data = await response.json();
        
        const select = document.getElementById('tutor-course-prerequisite');
        select.innerHTML = '<option value="">-- Select a prerequisite course --</option>';
        
        if (data.courses && data.courses.length > 0) {
          data.courses.forEach(course => {
            select.innerHTML += `<option value="${course.id}">${course.name}</option>`;
          });
        }
      } catch (error) {
        console.error('Error loading prerequisites:', error);
      }
    }

    function closeTutorCourseModal() {
      document.getElementById('tutor-course-modal').classList.add('hidden');
      currentTutorCourseId = null;
    }

    // Prerequisite checkbox toggle
    document.getElementById('tutor-course-has-prerequisite')?.addEventListener('change', (e) => {
      const container = document.getElementById('tutor-prerequisite-select-container');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
        document.getElementById('tutor-course-prerequisite').value = '';
      }
    });

    // Completion type radio buttons toggle
    document.querySelectorAll('input[name="tutor-completion-type"]').forEach(radio => {
      radio.addEventListener('change', (e) => {
        const certificateGroup = document.getElementById('tutor-certificate-template-group');
        const instructionsGroup = document.getElementById('tutor-completion-instructions-group');
        
        // Hide both
        certificateGroup.classList.add('hidden');
        instructionsGroup.classList.add('hidden');
        
        // Show selected
        if (e.target.value === 'certificate') {
          certificateGroup.classList.remove('hidden');
        } else if (e.target.value === 'instructions') {
          instructionsGroup.classList.remove('hidden');
        }
      });
    });

    // Course form submission
    // Study time limits toggle
    document.getElementById('course-enable-study-time')?.addEventListener('change', (e) => {
      const container = document.getElementById('study-time-fields');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
      }
    });

    // Survey toggle and mode selector
    document.getElementById('course-enable-survey')?.addEventListener('change', (e) => {
      const container = document.getElementById('survey-fields');
      if (e.target.checked) {
        container.classList.remove('hidden');
      } else {
        container.classList.add('hidden');
      }
    });

    document.querySelectorAll('input[name="survey-mode"]').forEach(radio => {
      radio.addEventListener('change', (e) => {
        const feedbackInfo = document.getElementById('feedback-mode-info');
        const surveyInfo = document.getElementById('survey-mode-info');
        if (e.target.value === 'feedback') {
          feedbackInfo.classList.remove('hidden');
          surveyInfo.classList.add('hidden');
        } else {
          feedbackInfo.classList.add('hidden');
          surveyInfo.classList.remove('hidden');
        }
      });
    });

      document.getElementById('tutor-course-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const courseId = document.getElementById('tutor-course-id').value;
      const hasPrerequisite = document.getElementById('tutor-course-has-prerequisite').checked;
      const prerequisiteId = document.getElementById('tutor-course-prerequisite').value;
      const courseName = (document.getElementById('tutor-course-name').value || '').trim();

      if (!courseName) {
        showNotification('Please enter a course name', 'error');
        return;
      }

      // Validation
      if (hasPrerequisite && !prerequisiteId) {
        showNotification('Please select a prerequisite course', 'error');
        return;
      }

      // Get completion type
      const completionType = document.querySelector('input[name="tutor-completion-type"]:checked').value;
      
      const pricingToggle = document.getElementById('tutor-course-pricing-toggle');
      const isPaid = pricingToggle?.checked;
      const priceValue = parseFloat(document.getElementById('tutor-course-price')?.value || '0');
      if (isPaid && (!priceValue || priceValue <= 0)) {
        showNotification('Please enter a price for paid courses', 'error');
        return;
      }
      const courseData = new FormData();
      courseData.append('name', courseName);
      if (document.getElementById('tutor-course-slug').value) {
        courseData.append('slug', document.getElementById('tutor-course-slug').value);
      }
      courseData.append('short_description', document.getElementById('tutor-course-description').value || '');
      courseData.append('chunk_words', (parseInt(document.getElementById('tutor-course-chunk-words').value) || CHUNK_WORDS_SETTINGS.default).toString());
      if (document.getElementById('course-enable-survey').checked) {
        courseData.append('enable_survey', '1');
        courseData.append('survey_mode', document.getElementById('survey-mode-feedback').checked ? 'feedback' : 'survey');
        if (document.getElementById('course-survey-title').value) {
          courseData.append('survey_title', document.getElementById('course-survey-title').value);
        }
        if (document.getElementById('course-survey-description').value) {
          courseData.append('survey_description', document.getElementById('course-survey-description').value);
        }
      } else {
        courseData.append('enable_survey', '0');
      }
      
      // Study time limits
      if (document.getElementById('course-enable-study-time').checked) {
        courseData.append('enable_study_time_limit', '1');
        courseData.append('min_study_minutes_per_day', document.getElementById('course-min-study-minutes').value || '');
        courseData.append('max_study_minutes_per_day', document.getElementById('course-max-study-minutes').value || '');
      } else {
        courseData.append('enable_study_time_limit', '0');
      }
      
      if (completionType === 'certificate') {
        courseData.append('certificate_template', document.getElementById('tutor-course-certificate').value || '');
      } else if (completionType === 'instructions') {
        courseData.append('completion_instructions', document.getElementById('tutor-course-instructions').value || '');
        courseData.append('certificate_template', '');
      } else {
        courseData.append('certificate_template', '');
        courseData.append('completion_instructions', '');
      }
      courseData.append('has_prerequisite', hasPrerequisite ? '1' : '0');
      if (hasPrerequisite && prerequisiteId) {
        courseData.append('prerequisite_course_id', prerequisiteId);
      }
      courseData.append('is_active', document.getElementById('tutor-course-active').checked ? '1' : '0');
      const tutorLanguage = document.getElementById('tutor-course-language').value || '';
      if (tutorLanguage) {
        courseData.append('language', tutorLanguage);
      }
      courseData.append('is_free', isPaid ? '0' : '1');
      if (isPaid) {
        courseData.append('price', priceValue.toFixed(2));
        courseData.append('discount', document.getElementById('tutor-course-discount')?.value || '');
        courseData.append('discount_type', document.getElementById('tutor-course-discount-type')?.value || 'amount');
        courseData.append('currency', (document.getElementById('tutor-course-currency').value || 'USD').toUpperCase());
      } else {
        courseData.append('price', '0');
        courseData.append('discount', '');
        courseData.append('currency', (document.getElementById('tutor-course-currency').value || 'USD').toUpperCase());
      }
      const tutorThumb = document.getElementById('tutor-course-thumbnail').files[0];
      if (tutorThumb) {
        courseData.append('thumbnail', tutorThumb);
      }

      const saveBtn = document.getElementById('tutor-save-course-btn');
      saveBtn.disabled = true;
      saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';

      try {
        const url = courseId ? `/tutor/courses/${courseId}` : '/tutor/courses';
        if (courseId) {
          courseData.append('_method', 'PUT');
        }
        const headers = {
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
          'Accept': 'application/json'
        };
        if (courseId) {
          headers['X-HTTP-Method-Override'] = 'PUT';
        }

        const response = await fetch(url, {
          method: 'POST',
          headers,
          body: courseData
        });

        const result = await response.json();
        
        if (result.success) {
          showNotification(courseId ? 'Course updated successfully!' : 'Course created successfully!', 'success');
          closeTutorCourseModal();
          loadTutorCourses();
        } else {
          showNotification(result.message || 'Error saving course', 'error');
        }
      } catch (error) {
        showNotification(error.message || 'Error saving course', 'error');
      } finally {
        saveBtn.disabled = false;
        saveBtn.innerHTML = `<i class="fas fa-save"></i> <span id="tutor-save-course-text">${courseId ? 'Update' : 'Create'} Course</span>`;
      }
    });

    // Survey Management (Tutor)
    let currentSurveyCourseId = null;
    let surveyQuestions = [];
    let questionIdCounter = 0;

    window.manageSurvey = async function(courseId, courseName) {
      console.log('manageSurvey called with courseId:', courseId);
      currentSurveyCourseId = courseId;
      document.getElementById('survey-modal-title').textContent = `📋 Manage Survey: ${courseName}`;
      document.getElementById('survey-modal').classList.remove('hidden');
      
      // Load existing questions
      try {
        console.log('Loading survey from /api/courses/' + courseId + '/survey');
        const response = await apiRequest(`/api/courses/${courseId}/survey`);
        console.log('Survey response:', response);
        surveyQuestions = response.questions || [];
        renderSurveyQuestions();
      } catch (error) {
        console.error('Error loading survey:', error);
        surveyQuestions = [];
        renderSurveyQuestions();
      }
    }

    window.closeSurveyModal = function() {
      document.getElementById('survey-modal').classList.add('hidden');
      currentSurveyCourseId = null;
      surveyQuestions = [];
    }

    window.addSurveyQuestion = function() {
      const newQuestion = {
        id: `new_${questionIdCounter++}`,
        question: '',
        question_type: 'rating',
        is_required: false,
        options: [],
        order_index: surveyQuestions.length
      };
      surveyQuestions.push(newQuestion);
      renderSurveyQuestions();
    }

    window.removeSurveyQuestion = function(index) {
      if (confirm('Remove this question?')) {
        surveyQuestions.splice(index, 1);
        renderSurveyQuestions();
      }
    }

    window.moveQuestion = function(index, direction) {
      const newIndex = index + direction;
      if (newIndex < 0 || newIndex >= surveyQuestions.length) return;
      
      [surveyQuestions[index], surveyQuestions[newIndex]] = [surveyQuestions[newIndex], surveyQuestions[index]];
      renderSurveyQuestions();
    }

    window.renderSurveyQuestions = function() {
      const container = document.getElementById('survey-questions-list');
      
      if (surveyQuestions.length === 0) {
        container.innerHTML = `
          <div style="text-align: center; padding: 40px; color: #9ca3af;">
            <i class="fas fa-clipboard-question" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i>
            <p>No questions yet. Click "Add Question" to get started.</p>
          </div>
        `;
        return;
      }

      container.innerHTML = surveyQuestions.map((q, index) => `
        <div class="survey-question-item" style="background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 8px; padding: 20px; margin-bottom: 15px;">
          <div style="display: flex; justify-content: between; align-items: flex-start; margin-bottom: 15px;">
            <div style="flex: 1;">
              <label style="display: block; font-weight: 600; margin-bottom: 8px; color: #374151;">
                Question ${index + 1}
              </label>
              <input type="text" 
                     value="${q.question}" 
                     onchange="surveyQuestions[${index}].question = this.value"
                     placeholder="Enter your question"
                     class="form-control" 
                     style="margin-bottom: 10px;">
            </div>
            <div style="display: flex; gap: 5px; margin-left: 10px;">
              <button type="button" onclick="moveQuestion(${index}, -1)" ${index === 0 ? 'disabled' : ''} class="icon-btn" title="Move Up">
                <i class="fas fa-arrow-up"></i>
              </button>
              <button type="button" onclick="moveQuestion(${index}, 1)" ${index === surveyQuestions.length - 1 ? 'disabled' : ''} class="icon-btn" title="Move Down">
                <i class="fas fa-arrow-down"></i>
              </button>
              <button type="button" onclick="removeSurveyQuestion(${index})" class="icon-btn icon-btn-danger" title="Remove">
                <i class="fas fa-trash"></i>
              </button>
            </div>
          </div>

          <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
            <div class="form-group">
              <label style="display: block; font-weight: 600; margin-bottom: 8px; color: #374151;">Question Type</label>
              <select onchange="surveyQuestions[${index}].question_type = this.value; renderSurveyQuestions();" 
                      class="form-control">
                <option value="rating" ${q.question_type === 'rating' ? 'selected' : ''}>⭐ Rating (1-5)</option>
                <option value="text" ${q.question_type === 'text' ? 'selected' : ''}>📝 Text Response</option>
                <option value="multiple_choice" ${q.question_type === 'multiple_choice' ? 'selected' : ''}>☑️ Multiple Choice</option>
                <option value="dropdown" ${q.question_type === 'dropdown' ? 'selected' : ''}>▼ Dropdown</option>
                <option value="checkboxes" ${q.question_type === 'checkboxes' ? 'selected' : ''}>☑️ Checkboxes</option>
              </select>
            </div>

            <div class="form-group">
              <label style="display: flex; align-items: center; cursor: pointer; padding-top: 28px;">
                <input type="checkbox" 
                       ${q.is_required ? 'checked' : ''} 
                       onchange="surveyQuestions[${index}].is_required = this.checked"
                       style="margin-right: 8px;">
                <span style="font-weight: 600; color: #374151;">Required Question</span>
              </label>
            </div>
          </div>

          ${['multiple_choice','dropdown','checkboxes'].includes(q.question_type) ? `
            <div class="form-group" style="margin-top: 15px;">
              <label style="display: block; font-weight: 600; margin-bottom: 8px; color: #374151;">Options (one per line)</label>
              <textarea 
                onchange="surveyQuestions[${index}].options = this.value.split('\\n').filter(o => o.trim())"
                rows="3" 
                class="form-control" 
                placeholder="Option 1&#10;Option 2&#10;Option 3">${Array.isArray(q.options) ? q.options.join('\\n') : ''}</textarea>
            </div>
          ` : ''}

          <div style="margin-top: 10px; padding: 10px; background: white; border-radius: 4px; border: 1px dashed #d1d5db;">
            <small style="color: #6b7280; font-weight: 600;">Preview:</small>
            <div style="margin-top: 8px; color: #374151;">
              ${q.question || '<em style="color: #9ca3af;">Question preview will appear here...</em>'}
              ${q.is_required ? '<span style="color: #ef4444;">*</span>' : ''}
            </div>
          </div>
        </div>
      `).join('');
    }

    window.saveSurveyQuestions = async function() {
      if (!currentSurveyCourseId) return;

      // Validate
      const invalidQuestions = surveyQuestions.filter(q => !q.question.trim());
      if (invalidQuestions.length > 0) {
        showNotification('Please fill in all questions', 'error');
        return;
      }

      const optionTypes = ['multiple_choice','dropdown','checkboxes'];
      const invalidOptions = surveyQuestions.filter(q => optionTypes.includes(q.question_type) && (!q.options || q.options.length === 0));
      if (invalidOptions.length > 0) {
        showNotification('Choice-based questions must have at least one option', 'error');
        return;
      }

      try {
        await apiRequest(`/api/courses/${currentSurveyCourseId}/survey/questions`, 'POST', {
          questions: surveyQuestions.map((q, index) => ({
            question: q.question,
            question_type: q.question_type,
            is_required: q.is_required,
            options: optionTypes.includes(q.question_type) ? q.options : null,
            order_index: index
          }))
        });

        showNotification('Survey questions saved successfully!', 'success');
        closeSurveyModal();
      } catch (error) {
        showNotification('Error saving survey', 'error');
      }
    }

    // Survey Results Viewer (Tutor)
    window.viewSurveyResults = async function(courseId, courseName) {
      document.getElementById('survey-results-title').textContent = `📊 Survey Results: ${courseName}`;
      document.getElementById('survey-results-modal').classList.remove('hidden');
      document.getElementById('survey-results-loading').classList.remove('hidden');
      document.getElementById('survey-results-content').classList.add('hidden');
      document.getElementById('survey-no-responses').classList.add('hidden');

      try {
        const stats = await apiRequest(`/api/courses/${courseId}/survey/stats`);
        
        if (!stats.responses || stats.responses.length === 0) {
          document.getElementById('survey-results-loading').classList.add('hidden');
          document.getElementById('survey-no-responses').classList.remove('hidden');
          return;
        }

        // Display summary stats
        document.getElementById('total-responses').textContent = stats.total_responses || 0;
        
        const avgRating = stats.average_rating ? parseFloat(stats.average_rating).toFixed(1) : '-';
        document.getElementById('avg-rating').innerHTML = avgRating !== '-' 
          ? `${avgRating} <i class="fas fa-star" style="font-size: 18px;"></i>` 
          : '-';
        
        const responseRate = stats.response_rate ? `${stats.response_rate}%` : '-';
        document.getElementById('response-rate').textContent = responseRate;

        // Display question results
        const questionsContainer = document.getElementById('questions-results-list');
        questionsContainer.innerHTML = stats.question_stats.map((qStat, index) => {
          let answerDisplay = '';
          
          if (qStat.question_type === 'rating') {
            const avg = parseFloat(qStat.average_value || 0).toFixed(1);
            const stars = '★'.repeat(Math.round(avg)) + '☆'.repeat(5 - Math.round(avg));
            answerDisplay = `
              <div style="font-size: 24px; color: #f59e0b; margin: 10px 0;">${stars}</div>
              <div style="font-size: 18px; font-weight: 600; color: #374151;">Average: ${avg} / 5</div>
            `;
          } else if (['multiple_choice', 'dropdown', 'checkboxes'].includes(qStat.question_type)) {
            const total = Object.values(qStat.option_counts || {}).reduce((a, b) => a + b, 0);
            answerDisplay = `
              <div style="margin-top: 15px;">
                ${Object.entries(qStat.option_counts || {}).map(([option, count]) => {
                  const percentage = total > 0 ? ((count / total) * 100).toFixed(1) : 0;
                  return `
                    <div style="margin-bottom: 12px;">
                      <div style="display: flex; justify-content: space-between; margin-bottom: 4px;">
                        <span style="color: #374151;">${option}</span>
                        <span style="color: #6b7280; font-weight: 600;">${count} (${percentage}%)</span>
                      </div>
                      <div style="background: #e5e7eb; height: 8px; border-radius: 4px; overflow: hidden;">
                        <div style="background: linear-gradient(90deg, #3b82f6, #8b5cf6); height: 100%; width: ${percentage}%;"></div>
                      </div>
                    </div>
                  `;
                }).join('')}
              </div>
            `;
          } else if (['text', 'short_text', 'long_text'].includes(qStat.question_type)) {
            answerDisplay = `
              <div style="margin-top: 15px; max-height: 300px; overflow-y: auto;">
                ${(qStat.text_responses || []).map((response, i) => `
                  <div style="background: #f9fafb; border-left: 3px solid #3b82f6; padding: 12px; margin-bottom: 10px; border-radius: 4px;">
                    <div style="color: #6b7280; font-size: 12px; margin-bottom: 5px;">Response ${i + 1}</div>
                    <div style="color: #374151;">${response || '<em>No answer</em>'}</div>
                  </div>
                `).join('')}
              </div>
            `;
          }

          return `
            <div style="background: white; border: 1px solid #e5e7eb; border-radius: 8px; padding: 20px; margin-bottom: 20px;">
              <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 15px;">
                <h3 style="color: #374151; font-size: 16px; font-weight: 600; margin: 0;">
                  ${index + 1}. ${qStat.question}
                </h3>
                <span style="background: #e0e7ff; color: #4f46e5; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600;">
                  ${qStat.question_type.replace('_', ' ').toUpperCase()}
                </span>
              </div>
              <div style="color: #6b7280; font-size: 14px; margin-bottom: 10px;">
                <i class="fas fa-users"></i> ${qStat.response_count || 0} responses
              </div>
              ${answerDisplay}
            </div>
          `;
        }).join('');

        document.getElementById('survey-results-loading').classList.add('hidden');
        document.getElementById('survey-results-content').classList.remove('hidden');

      } catch (error) {
        document.getElementById('survey-results-loading').classList.add('hidden');
        document.getElementById('survey-no-responses').classList.remove('hidden');
        showNotification(error.message || 'Error loading survey results', 'error');
      }
    }

    window.closeSurveyResultsModal = function() {
      document.getElementById('survey-results-modal').classList.add('hidden');
    }

    // Manage Course Content (Lessons & Topics) function
    window.manageTutorCourseContent = function(courseId, courseName) {
      // Switch to lessons & topics tab
      const lessonsTab = document.querySelector('[data-tutor-tab="lessons-topics"]');
      if (lessonsTab) {
        lessonsTab.click();
      }
      
      // Select the course in the filter
      const courseFilter = document.getElementById('tutor-content-course-filter');
      if (courseFilter) {
        courseFilter.value = courseId;
        const event = new Event('change');
        courseFilter.dispatchEvent(event);
      }
      
      showNotification(`Managing content for: ${courseName}`, 'info');
    }

    // View Course Students function
    window.viewCourseStudents = async function(courseId, courseName) {
      try {
        const response = await fetch(`/tutor/courses/${courseId}/students`);
        const data = await response.json();
        
        // Create and show modal with student list
        const modal = document.createElement('div');
        modal.className = 'modal';
        modal.style.display = 'flex';
        modal.innerHTML = `
          <div class="modal-content" style="max-width: 700px; max-height: 80vh; overflow-y: auto;">
            <div class="modal-header" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
              <h2><i class="fas fa-users"></i> Students Enrolled in: ${courseName}</h2>
              <button class="close-modal" onclick="this.closest('.modal').remove()">&times;</button>
            </div>
            <div class="modal-body">
              ${data.students && data.students.length > 0 ? `
                <div style="margin-bottom: 15px; padding: 12px; background: #eff6ff; border-radius: 6px;">
                  <strong style="color: #1e40af;">Total Students: ${data.students.length}</strong>
                </div>
                <div style="display: grid; gap: 12px;">
                  ${data.students.map(student => `
                    <div style="background: #f9fafb; padding: 15px; border-radius: 8px; border: 1px solid #e5e7eb;">
                      <div style="display: flex; justify-content: space-between; align-items: center;">
                        <div>
                          <strong style="color: #374151;">${student.name}</strong>
                          <div style="color: #6b7280; font-size: 13px; margin-top: 4px;">
                            <i class="fas fa-envelope"></i> ${student.email}
                          </div>
                        </div>
                        <div style="text-align: right;">
                          <div style="font-size: 24px; font-weight: 700; color: ${student.progress >= 75 ? '#10b981' : student.progress >= 50 ? '#f59e0b' : '#ef4444'};">
                            ${student.progress}%
                          </div>
                          <small style="color: #6b7280;">progress</small>
                        </div>
                      </div>
                      <div style="background: #e5e7eb; height: 6px; border-radius: 3px; margin-top: 10px; overflow: hidden;">
                        <div style="background: ${student.progress >= 75 ? '#10b981' : student.progress >= 50 ? '#f59e0b' : '#ef4444'}; height: 100%; width: ${student.progress}%; transition: width 0.3s;"></div>
                      </div>
                    </div>
                  `).join('')}
                </div>
              ` : `
                <div style="text-align: center; padding: 40px; color: #9ca3af;">
                  <i class="fas fa-user-slash" style="font-size: 48px; opacity: 0.5;"></i>
                  <p style="margin-top: 15px;">No students enrolled yet.</p>
                </div>
              `}
            </div>
          </div>
        `;
        document.body.appendChild(modal);
      } catch (error) {
        showNotification('Error loading student data', 'error');
      }
    }

    // Duplicate Course function
    window.duplicateTutorCourse = async function(courseId) {
      if (!confirm('Duplicate this course with all its content?')) return;
      
      try {
        const response = await fetch(`/tutor/courses/${courseId}/duplicate`, {
          method: 'POST',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json'
          }
        });
        
        const result = await response.json();
        
        if (result.success) {
          showNotification('Course duplicated successfully!', 'success');
          loadTutorCourses();
        } else {
          showNotification(result.message || 'Error duplicating course', 'error');
        }
      } catch (error) {
        showNotification('Error duplicating course', 'error');
      }
    }

    function editTutorCourse(courseId) {
      openTutorCourseModal(courseId);
    }

    window.showTutorDeleteCourseModal = function(courseId, courseName) {
      deleteTutorCourseId = courseId;
      document.getElementById('tutor-delete-course-name').textContent = courseName;
      document.getElementById('tutor-delete-course-id').textContent = courseId;
      document.getElementById('tutor-delete-course-modal').classList.remove('hidden');
    }

    window.closeTutorDeleteCourseModal = function() {
      document.getElementById('tutor-delete-course-modal').classList.add('hidden');
      deleteTutorCourseId = null;
    }

    window.confirmTutorDeleteCourse = async function() {
      if (!deleteTutorCourseId) return;

      try {
        console.log('Deleting course:', deleteTutorCourseId);
        const response = await fetch(`/tutor/courses/${deleteTutorCourseId}`, {
          method: 'DELETE',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json'
          }
        });
        
        console.log('Delete response status:', response.status);
        const result = await response.json();
        console.log('Delete result:', result);
        
        if (result.success) {
          showNotification('Course deleted successfully!', 'success');
          closeTutorDeleteCourseModal();
          loadTutorCourses();
        } else {
          showNotification('Error deleting course: ' + (result.message || 'Unknown error'), 'error');
          console.error('Delete failed:', result);
        }
      } catch (error) {
        console.error('Delete error:', error);
        showNotification('Error deleting course: ' + error.message, 'error');
      }
    }

    // Course filter change
    document.getElementById('tutor-content-course-filter')?.addEventListener('change', async function() {
      const courseId = this.value;
      const addLessonBtn = document.getElementById('tutor-add-lesson-btn');
      
      if (!courseId) {
        addLessonBtn.disabled = true;
        addLessonBtn.style.opacity = '0.5';
        document.getElementById('tutor-content-tree').innerHTML = `
          <div style="text-align: center; padding: 40px 20px; color: #999;">
            <i class="fas fa-folder-open" style="font-size: 48px; color: #667eea; opacity: 0.5;"></i>
            <p style="margin-top: 15px; font-size: 14px;">Select a course to view its lessons and topics</p>
          </div>
        `;
        return;
      }

      addLessonBtn.disabled = false;
      addLessonBtn.style.opacity = '1';

      try {
        const response = await fetch(`/tutor/courses/${courseId}/lessons`);
        const lessons = await response.json();
        renderTutorContentTree(courseId, lessons);
      } catch (error) {
        console.error('Error loading lessons:', error);
        document.getElementById('tutor-content-tree').innerHTML = `
          <div style="text-align: center; padding: 40px 20px; color: #ef4444;">
            <i class="fas fa-exclamation-triangle" style="font-size: 48px;"></i>
            <p style="margin-top: 15px;">Error loading course content</p>
          </div>
        `;
      }
    });

    function renderTutorContentTree(courseId, lessons) {
      const tree = document.getElementById('tutor-content-tree');
      
      if (!lessons || lessons.length === 0) {
        tree.innerHTML = `
          <div style="text-align: center; padding: 40px 20px; color: #999;">
            <i class="fas fa-layer-group" style="font-size: 48px; color: #667eea; opacity: 0.5;"></i>
            <p style="margin-top: 15px; font-size: 14px;">No lessons yet.<br>Click "Add Lesson" to create one.</p>
          </div>
        `;
        return;
      }

      tree.innerHTML = `
        <div style="padding: 10px;">
          ${lessons.map(lesson => `
            <div class="tree-item" style="margin-bottom: 15px; border: 1px solid #e5e7eb; border-radius: 8px; padding: 12px; background: #f9fafb;">
              <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px;">
                <strong style="color: #374151; font-size: 14px;">
                  <i class="fas fa-book" style="color: #667eea; margin-right: 5px;"></i>
                  ${lesson.name || 'Untitled Lesson'}
                </strong>
                <div>
                  <button onclick="editTutorLesson(${lesson.id})" class="btn btn-primary" style="padding: 4px 8px; font-size: 11px; margin-right: 3px;">
                    <i class="fas fa-edit"></i>
                  </button>
                  <button onclick="deleteTutorLesson(${lesson.id})" class="btn btn-danger" style="padding: 4px 8px; font-size: 11px; margin-right: 3px;">
                    <i class="fas fa-trash"></i>
                  </button>
                  <button onclick="openTutorTopicModal(${lesson.id})" class="btn btn-primary" style="padding: 4px 8px; font-size: 11px; background: #10b981;">
                    <i class="fas fa-plus"></i> Topic
                  </button>
                </div>
              </div>
              ${lesson.topics && lesson.topics.length > 0 ? `
                <div style="margin-left: 20px; margin-top: 10px;">
                  ${lesson.topics.map(topic => `
                    <div style="padding: 8px; background: white; border-radius: 6px; margin-bottom: 6px; display: flex; justify-content: space-between; align-items: center;">
                      <span style="color: #6b7280; font-size: 13px;">
                        <i class="fas fa-file-alt" style="color: #10b981; margin-right: 5px;"></i>
                        ${topic.title || 'Untitled Topic'}
                      </span>
                      <div>
                        <button onclick="editTutorTopic(${topic.id})" class="btn btn-primary" style="padding: 3px 6px; font-size: 10px; margin-right: 3px;">
                          <i class="fas fa-edit"></i>
                        </button>
                        <button onclick="deleteTutorTopic(${topic.id})" class="btn btn-danger" style="padding: 3px 6px; font-size: 10px;">
                          <i class="fas fa-trash"></i>
                        </button>
                      </div>
                    </div>
                  `).join('')}
                </div>
              ` : '<p style="margin-left: 20px; margin-top: 8px; color: #9ca3af; font-size: 12px;">No topics yet</p>'}
            </div>
          `).join('')}
        </div>
      `;
    }

    // Lesson functions
    function editTutorLesson(id) {
      openTutorLessonModal(id);
    }

    async function openTutorLessonModal(lessonId = null) {
      const modal = document.getElementById('tutor-lessonModal');
      const title = document.getElementById('tutor-lesson-modal-title');
      const courseId = document.getElementById('tutor-content-course-filter').value;
      
      // Open modal first
      modal.classList.remove('hidden');
      modal.classList.add('active');
      
      // Reset form
      document.getElementById('tutor-lesson-form').reset();
      document.getElementById('tutor-lesson-id').value = '';
      document.getElementById('tutor-lesson-course-id').value = courseId;
      
      if (lessonId) {
        title.textContent = '✏️ Edit Lesson';
        try {
          const response = await fetch(`/tutor/lessons/${lessonId}?_t=${Date.now()}`, {
            headers: {
              'Cache-Control': 'no-cache',
              'Accept': 'application/json'
            }
          });
          const data = await response.json();
          const lesson = data.lesson;
          
          document.getElementById('tutor-lesson-id').value = lesson.id;
          document.getElementById('tutor-lesson-course-id').value = lesson.course_id;
          document.getElementById('tutor-lesson-name').value = lesson.name;
          document.getElementById('tutor-lesson-description').value = lesson.intro || '';
        } catch (error) {
          showNotification('Error loading lesson: ' + error.message, 'error');
          console.error('Lesson load error:', error);
        }
      } else {
        title.textContent = 'Add New Lesson';
      }
    }

    document.getElementById('tutor-lesson-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const lessonId = document.getElementById('tutor-lesson-id').value;
      const lessonData = {
        course_id: document.getElementById('tutor-lesson-course-id').value,
        name: document.getElementById('tutor-lesson-name').value,
        intro: document.getElementById('tutor-lesson-description').value
      };

      try {
        const url = lessonId ? `/tutor/lessons/${lessonId}` : '/tutor/lessons';
        const method = lessonId ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
          method: method,
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          },
          body: JSON.stringify(lessonData)
        });

        const result = await response.json();
        
        if (result.success) {
          showNotification(lessonId ? 'Lesson updated!' : 'Lesson created!', 'success');
          closeTutorModal('tutor-lessonModal');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        } else {
          showNotification('Error saving lesson', 'error');
        }
      } catch (error) {
        showNotification('Error saving lesson', 'error');
      }
    });

    async function deleteTutorLesson(id) {
      if (!confirm('Delete this lesson and all its topics?')) return;
      
      try {
        const response = await fetch(`/tutor/lessons/${id}`, {
          method: 'DELETE',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });
        
        const result = await response.json();
        
        if (result.success) {
          showNotification('Lesson deleted!', 'success');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        }
      } catch (error) {
        showNotification('Error deleting lesson', 'error');
      }
    }

    // Topic functions
    function editTutorTopic(id) {
      openTutorTopicModal(null, id);
    }

    async function openTutorTopicModal(lessonId = null, topicId = null) {
      const modal = document.getElementById('tutor-topicModal');
      const title = document.getElementById('tutor-topic-modal-title');
      
      // Open modal first
      modal.classList.remove('hidden');
      modal.classList.add('active');
      
      // Reset form
      document.getElementById('tutor-topic-form').reset();
      document.getElementById('tutor-topic-id').value = '';
      document.getElementById('tutor-topic-lesson-id').value = lessonId || '';
      document.getElementById('tutor-topic-is-published').checked = true;
      
      if (topicId) {
        title.textContent = '✏️ Edit Topic';
        try {
          const response = await fetch(`/tutor/topics/${topicId}?_t=${Date.now()}`, {
            headers: {
              'Cache-Control': 'no-cache',
              'Accept': 'application/json'
            }
          });
          const data = await response.json();
          const topic = data.topic;
          
          document.getElementById('tutor-topic-id').value = topic.id;
          document.getElementById('tutor-topic-lesson-id').value = topic.lesson_id;
          document.getElementById('tutor-topic-title').value = topic.title;
          document.getElementById('tutor-topic-body').value = topic.body || '';
          document.getElementById('tutor-topic-video-url').value = topic.video_url || '';
          document.getElementById('tutor-topic-image-url').value = topic.image_url || '';
          document.getElementById('tutor-topic-is-published').checked = topic.is_published;
        } catch (error) {
          showNotification('Error loading topic: ' + error.message, 'error');
          console.error('Topic load error:', error);
        }
      } else {
        title.textContent = 'Add New Topic';
      }
    }

    document.getElementById('tutor-topic-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const topicId = document.getElementById('tutor-topic-id').value;
      const topicData = {
        lesson_id: document.getElementById('tutor-topic-lesson-id').value,
        title: document.getElementById('tutor-topic-title').value,
        body: document.getElementById('tutor-topic-body').value,
        video_url: document.getElementById('tutor-topic-video-url').value,
        image_url: document.getElementById('tutor-topic-image-url').value,
        is_published: document.getElementById('tutor-topic-is-published').checked
      };

      try {
        const url = topicId ? `/tutor/topics/${topicId}` : '/tutor/topics';
        const method = topicId ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
          method: method,
          headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          },
          body: JSON.stringify(topicData)
        });

        const result = await response.json();
        
        if (result.success) {
          showNotification(topicId ? 'Topic updated!' : 'Topic created!', 'success');
          closeTutorModal('tutor-topicModal');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        } else {
          showNotification('Error saving topic', 'error');
        }
      } catch (error) {
        showNotification('Error saving topic', 'error');
      }
    });

    async function deleteTutorTopic(id) {
      if (!confirm('Delete this topic?')) return;
      
      try {
        const response = await fetch(`/tutor/topics/${id}`, {
          method: 'DELETE',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });
        
        const result = await response.json();
        
        if (result.success) {
          showNotification('Topic deleted!', 'success');
          // Refresh content tree
          const courseId = document.getElementById('tutor-content-course-filter').value;
          if (courseId) {
            const resp = await fetch(`/tutor/courses/${courseId}/lessons`);
            const lessons = await resp.json();
            renderTutorContentTree(courseId, lessons);
          }
        }
      } catch (error) {
        showNotification('Error deleting topic', 'error');
      }
    }

    // Add lesson button
    document.getElementById('tutor-add-lesson-btn')?.addEventListener('click', function() {
      const courseId = document.getElementById('tutor-content-course-filter').value;
      if (courseId) {
        openTutorLessonModal();
      }
    });

    // Modal close function
    function closeTutorModal(modalId) {
      const modal = document.getElementById(modalId);
      modal.classList.remove('active');
      modal.classList.add('hidden');
    }

    // Search courses
    document.getElementById('tutor-course-search')?.addEventListener('input', function(e) {
      const query = e.target.value.toLowerCase();
      const filtered = tutorCourses.filter(c => 
        (c.name || '').toLowerCase().includes(query) || 
        (c.short_description || '').toLowerCase().includes(query)
      );
      renderTutorCoursesTable(filtered);
    });

    document.getElementById('tutor-language-filter')?.addEventListener('change', () => {
      loadTutorCourses();
    });

    // Load courses when courses section becomes active
    const coursesSection = document.getElementById('courses');
    if (coursesSection) {
      const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
          if (mutation.target.classList.contains('active') && tutorCourses.length === 0) {
            loadTutorLanguages().then(() => loadTutorCourses());
          }
        });
      });
      observer.observe(coursesSection, { attributes: true, attributeFilter: ['class'] });
    }

    // Load courses immediately if courses section is already active
    if (coursesSection?.classList.contains('active')) {
      loadTutorLanguages().then(() => loadTutorCourses());
    }

    // ==============================
    // Admin-style Course Module JS
    // ==============================
    // Small helpers for modals and API
    function openModal(id) {
      const m = document.getElementById(id);
      if (m) { m.classList.remove('hidden'); m.classList.add('active'); }
    }

    function closeModal(id) {
      const m = document.getElementById(id);
      if (m) { m.classList.remove('active'); m.classList.add('hidden'); }
    }

    async function apiRequest(url, method = 'GET', payload = null) {
      if (method === 'GET') {
        url += (url.includes('?') ? '&' : '?') + '_t=' + Date.now();
      }
      const res = await fetch(url, {
        method,
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
          'Accept': 'application/json',
          'Cache-Control': 'no-cache, no-store, must-revalidate',
          'Pragma': 'no-cache',
          'Expires': '0'
        },
        body: payload && method !== 'GET' ? JSON.stringify(payload) : null
      });
      const data = await res.json().catch(() => ({}));
      if (!res.ok) throw new Error(data.message || `Request failed: ${res.status}`);
      return data;
    }

    // Tab switching for new admin-style tabs
    document.querySelectorAll('.tab-btn').forEach(btn => {
      btn.addEventListener('click', function() {
        const tab = this.getAttribute('data-tab');
        document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
        this.classList.add('active');
        document.querySelectorAll('.tab-content').forEach(el => el.classList.add('hidden'));
        document.getElementById(`${tab}-tab`).classList.remove('hidden');
      });
    });

    // Courses list and content structure
    let courses = [];
    let selectedCourseId = null;

    async function loadCourses() {
      try {
        const langFilter = document.getElementById('course-language-filter')?.value;
        const categoryFilter = document.getElementById('course-category-filter')?.value;
        let url = '/tutor/courses';
        const params = [];
        if (langFilter) params.push(`language_id=${langFilter}`);
        if (params.length > 0) url += '?' + params.join('&');
        
        const data = await apiRequest(url);
        courses = data.courses || data;
        
        // Apply category filter client-side
        let filtered = courses;
        if (categoryFilter) {
          filtered = courses.filter(c => c.category === categoryFilter);
        }
        
        displayCourses(filtered);
      } catch (e) {
        console.error('loadCourses error', e);
        const tbody = document.getElementById('courses-table-body');
        if (tbody) tbody.innerHTML = `<tr><td colspan="7" style="text-align:center;color:#ef4444;padding:24px;">Failed to load courses</td></tr>`;
      }
      // Also refresh the content structure dropdown
      try { await loadContentStructure(); } catch (_) {}
    }

    function displayCourses(list) {
      const tbody = document.getElementById('courses-table-body');
      if (!tbody) return;
      if (!list || list.length === 0) {
        tbody.innerHTML = `
          <tr>
            <td colspan="7" style="text-align:center; padding: 40px; color:#9ca3af;">
              <i class=\"fas fa-book-open\" style=\"font-size:42px; opacity:0.4;\"></i>
              <div style=\"margin-top:10px;\">No courses yet</div>
            </td>
          </tr>
        `;
        return;
      }
      tbody.innerHTML = list.map(c => {
        const lessonCount = (c.lessons?.length) ?? c.lesson_count ?? c.lessons_count ?? 0;
        const topicCount = c.topic_count ?? 0;
        const currencyCode = (c.currency || 'USD').toUpperCase();
        const basePrice = Number(c.price || 0);
        const hasDiscount = !c.is_free && Number(c.discount || 0) > 0;
        const discountValue = Number(c.discount || 0);
        const discountType = c.discount_type || 'amount';
        const discountedPrice = hasDiscount
          ? Math.max(0, discountType === 'percent' ? basePrice - (basePrice * (discountValue / 100)) : basePrice - discountValue)
          : basePrice;
        const discountLabel = hasDiscount
          ? (discountType === 'percent' ? `${discountValue}% off` : `-${currencyCode} ${discountValue.toFixed(2)}`)
          : '';
        
        const categoryBadge = c.category ? `<span style="display:inline-block;padding:3px 10px;border-radius:12px;background:#f3e8ff;color:#7c3aed;font-size:11px;font-weight:600;">${c.category}</span>` : '<span style="color:#9ca3af;font-size:11px;">Uncategorized</span>';

        return `
          <tr>
            <td style="padding:12px;">
              <div style="font-weight:600; color:#1f2937;">${c.name ?? ''}</div>
              ${c.short_description ? `<div style=\"font-size:12px;color:#6b7280;\">${c.short_description}</div>` : ''}
              <div class="course-meta-mini">
                <span><i class="fas fa-book"></i> ${lessonCount} Lesson${lessonCount === 1 ? '' : 's'}</span>
                <span><i class="fas fa-clock"></i> Self-paced</span>
              </div>
              ${c.is_free ? `<span class="price-chip free">Free</span>` : `
                <div class="price-chip paid">
                  <i class="fas fa-tag"></i>
                  ${hasDiscount ? `<span style="text-decoration: line-through; color:#b91c1c;">${currencyCode} ${basePrice.toFixed(2)}</span>` : ''}
                  <span>${currencyCode} ${discountedPrice.toFixed(2)}</span>
                  ${hasDiscount ? `<span style="font-size:11px; font-weight:800; color:#c2410c;">${discountLabel}</span>` : ''}
                </div>
              `}
            </td>
            <td style="padding:12px;">${categoryBadge}</td>
            <td style="padding:12px;">
              <span style="padding:4px 10px;border-radius:12px;${c.is_active ? 'background:#d1fae5;color:#065f46;' : 'background:#e5e7eb;color:#6b7280;'}">${c.is_active ? 'Active' : 'Inactive'}</span>
            </td>
            <td style="padding:12px; color:#6b7280; text-align:center;">${lessonCount}</td>
            <td style="padding:12px; color:#6b7280; text-align:center;">${topicCount || '-'}</td>
            <td style="padding:12px; color:#6b7280; text-align:center;">-</td>
            <td style="padding:12px;">
              <div style="display:flex; gap:6px; align-items:center;">
                <button class="btn btn-primary" onclick="editCourse(${c.id})" style="padding:6px 10px; font-size:12px;"><i class='fas fa-edit'></i> Edit</button>
                <button class="btn btn-secondary" onclick="goManageContent(${c.id})" style="padding:6px 10px; font-size:12px;"><i class='fas fa-sitemap'></i> Content</button>
                <button class="btn btn-danger" onclick="deleteCourse(${c.id}, '${(c.name||'').replace(/'/g, "\\'")}')" style="padding:6px 10px; font-size:12px;"><i class='fas fa-trash'></i></button>
              </div>
            </td>
          </tr>
        `;
      }).join('');
    }

    function goManageContent(courseId) {
      // Switch tab
      document.querySelector('.tab-btn[data-tab="lessons-topics"]')?.click();
      const filter = document.getElementById('content-course-filter');
      if (filter) {
        filter.value = String(courseId);
        filter.dispatchEvent(new Event('change'));
      }
    }

    async function loadContentStructure() {
      const filter = document.getElementById('content-course-filter');
      if (!filter) return;
      try {
        const data = await apiRequest('/tutor/courses');
        const list = data.courses || data;
        filter.innerHTML = '<option value="">📚 Select Course to Manage</option>' +
          (list || []).map(c => `<option value="${c.id}">${c.name}</option>`).join('');
        document.getElementById('add-lesson-btn')?.setAttribute('disabled', 'true');
      } catch (e) {
        console.error('loadContentStructure error', e);
      }
    }

    async function loadCourseLessons(courseId) {
      const tree = document.getElementById('content-tree');
      const addBtn = document.getElementById('add-lesson-btn');
      if (!tree) return;
      if (!courseId) {
        addBtn?.setAttribute('disabled', 'true');
        tree.innerHTML = `<div style='text-align:center;padding:40px;color:#9ca3af;'>Select a course to manage content</div>`;
        return;
      }
      addBtn?.removeAttribute('disabled');
      selectedCourseId = Number(courseId);
      tree.innerHTML = `<div style='text-align:center;padding:30px;color:#9ca3af;'><i class="fas fa-spinner fa-spin"></i> Loading...</div>`;
      try {
        const data = await apiRequest(`/tutor/courses/${courseId}/lessons`);
        renderContentTree(data || []);
      } catch (e) {
        console.error('loadCourseLessons error', e);
        tree.innerHTML = `<div style='text-align:center;padding:30px;color:#ef4444;'>Failed to load lessons</div>`;
      }
    }

    function renderContentTree(lessons) {
      const tree = document.getElementById('content-tree');
      if (!tree) return;
      if (!lessons || lessons.length === 0) {
        tree.innerHTML = `<div style='text-align:center;padding:40px;color:#9ca3af;'>No lessons yet. Click Add Lesson to create one.</div>`;
        return;
      }
      tree.innerHTML = `
        <div id="lessons-container" style="display:flex; flex-direction:column; gap:12px;">
          ${lessons.map(l => `
            <div class="lesson-item" data-id="${l.id}" style="border:1px solid #e5e7eb;border-radius:8px;">
              <div style="display:flex;justify-content:space-between;align-items:center;padding:12px;background:#f9fafb;border-bottom:1px solid #e5e7eb;">
                <div style="font-weight:600;color:#374151;"><i class='fas fa-grip-vertical' style='cursor:grab;margin-right:8px;color:#9ca3af;'></i> ${l.name || 'Untitled Lesson'}</div>
                <div style="display:flex; gap:6px;">
                  <button class="btn btn-secondary" onclick="manageQuiz(${l.id}, '${(l.name||'').replace(/'/g, "\\'")}')" title="Manage Quiz"><i class='fas fa-question'></i></button>
                  <button class="btn btn-primary" onclick="editLesson(${l.id})"><i class='fas fa-edit'></i></button>
                  <button class="btn btn-danger" onclick="deleteLesson(${l.id})"><i class='fas fa-trash'></i></button>
                  <button class="btn btn-primary" style="background:#10b981;" onclick="addTopic(${l.id})"><i class='fas fa-plus'></i> Topic</button>
                </div>
              </div>
              <div class="topics" data-lesson-id="${l.id}" style="padding:10px; display:flex; flex-direction:column; gap:6px;">
                ${(l.topics||[]).map(t => `
                  <div class="topic-item" data-id="${t.id}" style="display:flex;justify-content:space-between;align-items:center;padding:8px 10px;background:white;border:1px solid #e5e7eb;border-radius:6px;">
                    <div style="color:#6b7280;"><i class='fas fa-grip-vertical' style='cursor:grab;margin-right:8px;color:#9ca3af;'></i> <i class='fas fa-file-alt' style='color:#10b981;'></i> ${t.title || 'Untitled Topic'}</div>
                    <div style="display:flex; gap:6px;">
                      <button class="btn btn-primary" onclick="editTopic(${t.id})"><i class='fas fa-edit'></i></button>
                      <button class="btn btn-danger" onclick="deleteTopic(${t.id})"><i class='fas fa-trash'></i></button>
                    </div>
                  </div>
                `).join('')}
              </div>
            </div>
          `).join('')}
        </div>
      `;

      // Initialize drag & drop
      const lessonsContainer = document.getElementById('lessons-container');
      if (lessonsContainer && window.Sortable) {
        new Sortable(lessonsContainer, {
          handle: '.fa-grip-vertical',
          animation: 150,
          onEnd: async () => {
            const order = Array.from(lessonsContainer.querySelectorAll('.lesson-item')).map((el, idx) => ({ id: Number(el.dataset.id), position: idx+1 }));
            try { await apiRequest('/tutor/lessons/reorder', 'POST', { course_id: selectedCourseId, order }); } catch (e) { console.warn('Lesson reorder failed', e); }
          }
        });
      }
      document.querySelectorAll('.topics').forEach(list => {
        if (window.Sortable) {
          new Sortable(list, {
            handle: '.fa-grip-vertical',
            animation: 150,
            onEnd: async (evt) => {
              const lessonId = Number(list.dataset.lessonId);
              const order = Array.from(list.querySelectorAll('.topic-item')).map((el, idx) => ({ id: Number(el.dataset.id), position: idx+1 }));
              try { await apiRequest('/tutor/topics/reorder', 'POST', { lesson_id: lessonId, order }); } catch (e) { console.warn('Topic reorder failed', e); }
            }
          });
        }
      });
    }

    // Lessons CRUD (admin-style modals)
    function addLesson(courseId) {
      const form = document.getElementById('lesson-form');
      if (!form) return;
      form.reset();
      document.getElementById('lesson-id').value = '';
      document.getElementById('lesson-course-id').value = courseId;
      document.getElementById('lesson-modal-title').textContent = 'Add New Lesson';
      openModal('lessonModal');
    }
    async function editLesson(id) {
      openModal('lessonModal');
      document.getElementById('lesson-modal-title').textContent = '✏️ Edit Lesson';
      try {
        const data = await apiRequest(`/tutor/lessons/${id}`);
        const l = data.lesson || data;
        document.getElementById('lesson-id').value = l.id;
        document.getElementById('lesson-course-id').value = l.course_id;
        document.getElementById('lesson-name').value = l.name || '';
        document.getElementById('lesson-description').value = l.intro || '';
      } catch (e) { showNotification('Failed to load lesson', 'error'); }
    }
    async function deleteLesson(id) {
      if (!confirm('Delete this lesson and all its topics?')) return;
      try { await apiRequest(`/tutor/lessons/${id}`, 'DELETE'); loadCourseLessons(selectedCourseId); showNotification('Lesson deleted'); } catch (e) { showNotification('Delete failed','error'); }
    }

    document.getElementById('lesson-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      const id = document.getElementById('lesson-id').value;
      const payload = {
        course_id: document.getElementById('lesson-course-id').value,
        name: document.getElementById('lesson-name').value,
        intro: document.getElementById('lesson-description').value,
        share_enabled: document.getElementById('lesson-share-enabled')?.checked || false,
        share_type: document.getElementById('lesson-share-type')?.value || null,
        share_url: document.getElementById('lesson-share-url')?.value || null,
        share_filename: document.getElementById('lesson-share-filename')?.value || null,
        share_size: document.getElementById('lesson-share-size')?.value || null,
        has_quiz: document.getElementById('lesson-has-quiz')?.checked || false,
        has_certificate: document.getElementById('lesson-has-certificate')?.checked || false,
        certificate_id: document.getElementById('lesson-certificate-id')?.value || null
      };
      try {
        await apiRequest(id ? `/tutor/lessons/${id}` : '/tutor/lessons', id ? 'PUT' : 'POST', payload);
        closeModal('lessonModal');
        loadCourseLessons(selectedCourseId);
        showNotification(id ? 'Lesson updated' : 'Lesson created');
      } catch (e) { showNotification('Save failed','error'); }
    });

    // Topics CRUD (admin-style modals)
    function addTopic(lessonId) {
      const form = document.getElementById('topic-form');
      if (!form) return;
      form.reset();
      document.getElementById('topic-id').value = '';
      document.getElementById('topic-lesson-id').value = lessonId;
      document.getElementById('topic-modal-title').textContent = 'Add New Topic';
      // Reset TinyMCE field if present
      try { tinymce.get('topic-body')?.setContent(''); } catch(_) {}
      openModal('topicModal');
    }
    async function editTopic(id) {
      openModal('topicModal');
      document.getElementById('topic-modal-title').textContent = '✏️ Edit Topic';
      try {
        const data = await apiRequest(`/tutor/topics/${id}`);
        const t = data.topic || data;
        document.getElementById('topic-id').value = t.id;
        document.getElementById('topic-lesson-id').value = t.lesson_id;
        document.getElementById('topic-title').value = t.title || '';
        document.getElementById('topic-body').value = t.body || '';
        try { tinymce.get('topic-body')?.setContent(t.body || ''); } catch(_) {}
        document.getElementById('topic-video-url').value = t.video_url || '';
        document.getElementById('topic-image-url').value = t.image_url || '';
        document.getElementById('topic-is-published').checked = !!t.is_published;
      } catch (e) { showNotification('Failed to load topic','error'); }
    }
    async function deleteTopic(id) {
      if (!confirm('Delete this topic?')) return;
      try { await apiRequest(`/tutor/topics/${id}`, 'DELETE'); loadCourseLessons(selectedCourseId); showNotification('Topic deleted'); } catch (e) { showNotification('Delete failed','error'); }
    }

    document.getElementById('topic-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      const id = document.getElementById('topic-id').value;
      // Prefer TinyMCE content if available
      const editor = tinymce.get('topic-body');
      const bodyHtml = editor ? editor.getContent() : document.getElementById('topic-body').value;
      const payload = {
        lesson_id: document.getElementById('topic-lesson-id').value,
        title: document.getElementById('topic-title').value,
        body: bodyHtml,
        video_url: document.getElementById('topic-video-url').value,
        image_url: document.getElementById('topic-image-url').value,
        is_published: document.getElementById('topic-is-published').checked
      };
      try {
        await apiRequest(id ? `/tutor/topics/${id}` : '/tutor/topics', id ? 'PUT' : 'POST', payload);
        closeModal('topicModal');
        loadCourseLessons(selectedCourseId);
        showNotification(id ? 'Topic updated' : 'Topic created');
      } catch (e) { showNotification('Save failed','error'); }
    });

    // Quiz management
    async function manageQuiz(lessonId, lessonName) {
      document.getElementById('quiz-lesson-id').value = lessonId;
      document.getElementById('quiz-lesson-name').textContent = lessonName || '';
      openModal('quizModal');
      await loadQuizQuestions(lessonId);
    }
    async function loadQuizQuestions(lessonId) {
      const list = document.getElementById('quiz-questions-list');
      list.innerHTML = `<div style='text-align:center;padding:30px;color:#9ca3af;'><i class="fas fa-spinner fa-spin"></i> Loading...</div>`;
      try {
        const response = await apiRequest(`/tutor/lessons/${lessonId}/quiz-questions`);
        const items = response.questions || response.data || response || [];
        if (!items.length) {
          list.innerHTML = `<div style='text-align:center;padding:24px;color:#9ca3af;'><i class="fas fa-question-circle" style="font-size: 48px; margin-bottom: 15px;"></i><p>No quiz questions yet. Click "Add Question" to get started.</p></div>`;
          return;
        }
        list.innerHTML = items.map((q, index) => `
          <div class="card" style="padding: 15px; margin-bottom: 10px;">
            <div style="display: flex; justify-content: space-between; align-items: start;">
              <div style="flex: 1;">
                <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 10px;">
                  <span style="background: #667eea; color: white; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600;">Q${index + 1}</span>
                  <h4 style="margin: 0;">${q.question || ''}</h4>
                </div>
                <div style="margin-left: 15px;">
                  ${(q.options || []).map((opt, i) => `
                    <div style="margin: 5px 0; display: flex; align-items: center;">
                      <i class="fas fa-${i === q.correct_answer ? 'check-circle' : 'circle'}" style="color: ${i === q.correct_answer ? '#10b981' : '#d1d5db'}; margin-right: 8px;"></i>
                      <span style="${i === q.correct_answer ? 'font-weight: 600; color: #10b981;' : ''}">${opt}</span>
                    </div>
                  `).join('')}
                </div>
                ${q.explanation ? `<p style="margin: 10px 0 0 15px; padding: 10px; background: #f3f4f6; border-radius: 4px; font-size: 14px; color: #6b7280;"><strong>Explanation:</strong> ${q.explanation}</p>` : ''}
              </div>
              <div style="display: flex; gap: 5px;">
                <button class="bg-blue-600 hover:bg-blue-700 text-white px-3 py-1 rounded text-xs" onclick="editQuizQuestion(${q.id})">
                  <i class="fas fa-edit"></i>
                </button>
                <button class="bg-red-600 hover:bg-red-700 text-white px-3 py-1 rounded text-xs" onclick="deleteQuizQuestion(${q.id})">
                  <i class="fas fa-trash"></i>
                </button>
              </div>
            </div>
          </div>
        `).join('');
      } catch (e) {
        list.innerHTML = `<div style='text-align:center;padding:24px;color:#ef4444;'>Failed to load questions</div>`;
        console.error(e);
      }
    }
    function addQuizQuestion() {
      const lessonId = document.getElementById('quiz-lesson-id').value;
      document.getElementById('quiz-question-form').reset();
      document.getElementById('quiz-question-id').value = '';
      document.getElementById('quiz-question-lesson-id').value = lessonId;
      document.getElementById('quiz-options-container').innerHTML = '';
      
      // Initialize with 4 empty options (first one is correct by default)
      for (let i = 0; i < 4; i++) {
        addQuizOption('', i === 0);
      }
      
      document.getElementById('quiz-question-modal-title').textContent = 'Add Quiz Question';
      openModal('quizQuestionModal');
    }
    async function editQuizQuestion(id) {
      try {
        const response = await apiRequest(`/tutor/quiz-questions/${id}`);
        const q = response.question || response.data || response;
        document.getElementById('quiz-question-id').value = q.id;
        document.getElementById('quiz-question-lesson-id').value = q.lesson_id;
        document.getElementById('quiz-question-text').value = q.question || '';
        document.getElementById('quiz-question-explanation').value = q.explanation || '';
        
        const opts = q.options || [];
        const correctIdx = q.correct_answer !== undefined ? q.correct_answer : (q.correct_index || 0);
        const container = document.getElementById('quiz-options-container');
        container.innerHTML = '';
        
        if (opts.length > 0) {
          opts.forEach((optText, idx) => {
            addQuizOption(optText, idx === correctIdx);
          });
        } else {
          addQuizOption('', true);
          addQuizOption('', false);
        }
        
        document.getElementById('quiz-question-modal-title').textContent = 'Edit Quiz Question';
        openModal('quizQuestionModal');
      } catch (e) { 
        showNotification('Failed to load question','error');
        console.error(e);
      }
    }
    function addQuizOption(text = '', correct = false) {
      const container = document.getElementById('quiz-options-container');
      const idx = container.children.length;
      const wrap = document.createElement('div');
      wrap.style.display = 'flex';
      wrap.style.gap = '8px';
      wrap.style.alignItems = 'center';
      wrap.style.marginBottom = '6px';
      wrap.innerHTML = `
        <input type='checkbox' ${correct ? 'checked' : ''} title='Correct' />
        <input type='text' value='${text.replace(/'/g, "&#39;")}' placeholder='Option text' class='form-control' style='flex:1;' />
        <button type='button' class='btn btn-danger btn-sm' title='Remove'>&times;</button>
      `;
      wrap.querySelector('button').onclick = () => wrap.remove();
      container.appendChild(wrap);
    }
    document.getElementById('quiz-question-form')?.addEventListener('submit', async (e) => {
      e.preventDefault();
      const id = document.getElementById('quiz-question-id').value;
      const lessonId = document.getElementById('quiz-question-lesson-id').value;
      const question = document.getElementById('quiz-question-text').value;
      const explanation = document.getElementById('quiz-question-explanation').value;
      const options = Array.from(document.getElementById('quiz-options-container').children).map(row => ({
        text: row.querySelector('input[type="text"]').value,
        correct: row.querySelector('input[type="checkbox"]').checked
      })).filter(o => o.text && o.text.trim().length > 0);
      if (options.length < 2) { showNotification('Add at least two options','error'); return; }
      if (!options.some(o => o.correct)) { showNotification('Mark a correct option','error'); return; }
      try {
        await apiRequest(id ? `/tutor/quiz-questions/${id}` : '/tutor/quiz-questions', id ? 'PUT' : 'POST', { lesson_id: lessonId, question, explanation, options });
        closeModal('quizQuestionModal');
        await loadQuizQuestions(lessonId);
        showNotification(id ? 'Question updated' : 'Question added');
      } catch (e) { showNotification('Save failed','error'); }
    });
    async function deleteQuizQuestion(id) {
      if (!confirm('Delete this question?')) return;
      try {
        const lessonId = document.getElementById('quiz-lesson-id').value;
        await apiRequest(`/tutor/quiz-questions/${id}`, 'DELETE');
        await loadQuizQuestions(lessonId);
        showNotification('Question deleted');
      } catch (e) { showNotification('Delete failed','error'); }
    }

    // Wire up admin-style controls
    document.getElementById('add-course-btn')?.addEventListener('click', () => openCourseModal());
    document.getElementById('course-search')?.addEventListener('input', (e) => {
      const q = e.target.value.toLowerCase();
      const filtered = (courses || []).filter(c => (c.name||'').toLowerCase().includes(q) || (c.short_description||'').toLowerCase().includes(q));
      displayCourses(filtered);
    });
    document.getElementById('course-language-filter')?.addEventListener('change', () => loadCourses());
    document.getElementById('course-category-filter')?.addEventListener('change', () => loadCourses());
    document.getElementById('content-course-filter')?.addEventListener('change', (e) => loadCourseLessons(e.target.value));
    document.getElementById('add-lesson-btn')?.addEventListener('click', () => { if (selectedCourseId) addLesson(selectedCourseId); });

    // Initialize when Courses section activates (guarded)
    if (coursesSection) {
      const initIfNeeded = () => {
        if (coursesSection.classList.contains('active') && !window._tutorAdminCourseInit) {
          window._tutorAdminCourseInit = true;
          Promise.all([loadTutorLanguages(), loadCategoriesForFilter()]).finally(() => loadCourses());
        }
      };
      const obs = new MutationObserver(() => initIfNeeded());
      obs.observe(coursesSection, { attributes: true, attributeFilter: ['class'] });
      initIfNeeded();
    }

    // ============================================
    // TUTOR BADGE MANAGEMENT FUNCTIONS
    // ============================================

    let tutorAllBadges = [];
    let tutorBadgeStats = {};

    // Load badges when badges section becomes active
    const badgesSection = document.getElementById('badges');
    if (badgesSection) {
      const initBadgesIfNeeded = () => {
        if (badgesSection.classList.contains('active') && !window._tutorBadgesInit) {
          window._tutorBadgesInit = true;
          loadTutorBadges();
        }
      };
      const obs = new MutationObserver(() => initBadgesIfNeeded());
      obs.observe(badgesSection, { attributes: true, attributeFilter: ['class'] });
      initBadgesIfNeeded();
    }

    // ============================================
    // CATEGORY MANAGEMENT FUNCTIONS (TUTOR)
    // ============================================

    // Load categories
    async function loadTutorCategories() {
      const tbody = document.getElementById('tutor-categories-table-body');
      if (!tbody) return;
      
      // Show loading state
      tbody.innerHTML = `
        <tr>
          <td colspan="6" style="text-align: center; padding: 20px;">
            <i class="fas fa-spinner fa-spin" style="font-size: 24px; color: #667eea;"></i>
            <p style="margin-top: 10px; color: #999;">Loading categories...</p>
          </td>
        </tr>
      `;
      
      try {
        const response = await fetch('/tutor/categories', {
          headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Cache-Control': 'no-cache'
          }
        });
        
        if (!response.ok) {
          throw new Error('Failed to load categories');
        }
        
        const data = await response.json();
        // API returns array directly, not wrapped in categories key
        displayTutorCategories(Array.isArray(data) ? data : (data.categories || []));
      } catch (error) {
        console.error('Error loading categories:', error);
        tbody.innerHTML = `
          <tr>
            <td colspan="6" style="text-align: center; padding: 20px; color: #ef4444;">
              ❌ Error loading categories: ${escapeHtml(error.message)}
              <br><br>
              <button onclick="loadTutorCategories()" class="btn btn-primary" style="padding: 8px 16px; font-size: 14px;">
                <i class="fas fa-sync"></i> Retry
              </button>
            </td>
          </tr>
        `;
      }
    }

    // Display categories in table
    function displayTutorCategories(categories) {
      const tbody = document.getElementById('tutor-categories-table-body');
      if (!tbody) return;

      if (!categories || categories.length === 0) {
        tbody.innerHTML = `
          <tr>
            <td colspan="6" style="text-align: center; padding: 20px; color: #999;">
              📂 No categories found. Create your first category!
            </td>
          </tr>
        `;
        return;
      }

      tbody.innerHTML = categories.map(cat => {
        // Handle both boolean and integer values for is_active
        const isActive = cat.is_active === true || cat.is_active === 1 || cat.is_active === '1';
        const statusBadge = isActive 
          ? '<span style="background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 4px; font-size: 12px;">✓ Active</span>'
          : '<span style="background: #f8d7da; color: #721c24; padding: 4px 8px; border-radius: 4px; font-size: 12px;">○ Inactive</span>';
        
        // Escape the name for safe use in onclick attribute
        const safeName = (cat.name || '').replace(/'/g, "\\'").replace(/"/g, '&quot;');

        return `
          <tr>
            <td style="font-weight: 600;">${escapeHtml(cat.name)}</td>
            <td>${escapeHtml(cat.description || 'No description')}</td>
            <td style="text-align: center; font-size: 20px;">
              ${cat.icon ? `<i class="fas fa-${escapeHtml(cat.icon)}"></i>` : '-'}
            </td>
            <td style="text-align: center;">${cat.order || 0}</td>
            <td style="text-align: center;">${statusBadge}</td>
            <td style="text-align: center;">
              <button onclick="editTutorCategory(${cat.id})" class="btn" style="background: #ffc107; color: #000; padding: 6px 12px; margin: 2px;" title="Edit">
                ✏️
              </button>
              <button onclick="deleteTutorCategory(${cat.id}, '${safeName}')" class="btn" style="background: #dc3545; color: white; padding: 6px 12px; margin: 2px;" title="Delete">
                🗑️
              </button>
            </td>
          </tr>
        `;
      }).join('');
    }

    // Open category modal
    function openTutorCategoryModal(categoryId = null) {
      const modal = document.getElementById('tutor-category-modal');
      const title = document.getElementById('tutor-category-modal-title');
      const form = document.getElementById('tutor-category-form');
      
      form.reset();
      document.getElementById('tutor-category-id').value = '';
      document.getElementById('tutor-category-icon-preview').innerHTML = '';
      
      if (categoryId) {
        title.textContent = '📂 Edit Category';
        loadTutorCategoryData(categoryId);
      } else {
        title.textContent = '📂 Add New Category';
      }
      
      modal.classList.remove('hidden');
      modal.classList.add('active');
    }

    // Close category modal
    function closeTutorCategoryModal() {
      const modal = document.getElementById('tutor-category-modal');
      modal.classList.remove('active');
      setTimeout(() => modal.classList.add('hidden'), 300);
    }

    // Load category data for editing
    async function loadTutorCategoryData(categoryId) {
      try {
        const response = await fetch(`/tutor/categories/${categoryId}`, {
          headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });
        
        if (!response.ok) {
          throw new Error('Failed to load category');
        }
        
        const data = await response.json();
        const category = data.category || data;
        
        document.getElementById('tutor-category-id').value = category.id;
        document.getElementById('tutor-category-name').value = category.name;
        document.getElementById('tutor-category-description').value = category.description || '';
        document.getElementById('tutor-category-icon').value = category.icon || '';
        document.getElementById('tutor-category-order').value = category.order || 0;
        // Handle both boolean and integer values for is_active
        document.getElementById('tutor-category-is-active').checked = category.is_active === true || category.is_active === 1 || category.is_active === '1';
        
        // Update icon preview
        if (category.icon) {
          document.getElementById('tutor-category-icon-preview').innerHTML = 
            `<i class="fas fa-${escapeHtml(category.icon)}"></i>`;
        }
      } catch (error) {
        console.error('Error loading category:', error);
        showNotification('Failed to load category data', 'error');
        closeTutorCategoryModal();
      }
    }

    // Edit category
    function editTutorCategory(categoryId) {
      openTutorCategoryModal(categoryId);
    }

    // Delete category
    async function deleteTutorCategory(categoryId, categoryName) {
      if (!confirm(`Delete category "${categoryName}"?\n\nThis action cannot be undone.`)) {
        return;
      }

      try {
        const response = await fetch(`/tutor/categories/${categoryId}`, {
          method: 'DELETE',
          headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });

        const result = await response.json();

        if (!response.ok) {
          throw new Error(result.message || 'Failed to delete category');
        }

        showNotification('Category deleted successfully!', 'success');
        
        // Reload categories after a short delay
        setTimeout(async () => {
          await loadTutorCategories();
          // Also refresh category filter if on courses tab
          await loadCategoriesForFilter();
        }, 200);
      } catch (error) {
        console.error('Error deleting category:', error);
        showNotification(error.message || 'Failed to delete category', 'error');
      }
    }

    // Setup category form
    function setupTutorCategoryForm() {
      const form = document.getElementById('tutor-category-form');
      const iconInput = document.getElementById('tutor-category-icon');
      const iconPreview = document.getElementById('tutor-category-icon-preview');

      // Icon preview
      if (iconInput && iconPreview) {
        // Remove existing listener if any
        const newIconInput = iconInput.cloneNode(true);
        iconInput.parentNode.replaceChild(newIconInput, iconInput);
        
        newIconInput.addEventListener('input', function() {
          const icon = this.value.trim();
          if (icon) {
            document.getElementById('tutor-category-icon-preview').innerHTML = `<i class="fas fa-${escapeHtml(icon)}"></i>`;
          } else {
            document.getElementById('tutor-category-icon-preview').innerHTML = '';
          }
        });
      }

      // Form submission
      if (form && !form.dataset.listenerAttached) {
        form.dataset.listenerAttached = 'true';
        form.addEventListener('submit', async function(e) {
          e.preventDefault();
          
          const submitBtn = form.querySelector('button[type="submit"]');
          const originalBtnText = submitBtn.innerHTML;
          
          // Disable button and show loading state
          submitBtn.disabled = true;
          submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saving...';
          
          const categoryId = document.getElementById('tutor-category-id').value;
          const categoryData = {
            name: document.getElementById('tutor-category-name').value.trim(),
            description: document.getElementById('tutor-category-description').value.trim(),
            icon: document.getElementById('tutor-category-icon').value.trim(),
            order: parseInt(document.getElementById('tutor-category-order').value) || 0,
            is_active: document.getElementById('tutor-category-is-active').checked ? 1 : 0
          };

          try {
            const url = categoryId 
              ? `/tutor/categories/${categoryId}`
              : '/tutor/categories';
            
            const method = categoryId ? 'PUT' : 'POST';

            const response = await fetch(url, {
              method: method,
              headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
              },
              body: JSON.stringify(categoryData)
            });

            const result = await response.json();

            if (!response.ok) {
              throw new Error(result.message || 'Failed to save category');
            }

            showNotification(categoryId ? 'Category updated successfully!' : 'Category created successfully!', 'success');
            closeTutorCategoryModal();
            
            // Reload categories after a short delay to ensure server has processed
            setTimeout(async () => {
              await loadTutorCategories();
              // Also refresh category filter if on courses tab
              await loadCategoriesForFilter();
            }, 200);
          } catch (error) {
            console.error('Error saving category:', error);
            showNotification(error.message || 'Failed to save category', 'error');
          } finally {
            // Re-enable button and restore text
            submitBtn.disabled = false;
            submitBtn.innerHTML = originalBtnText;
          }
        });
      }
    }

    // Add category button handler
    const addCategoryBtn = document.getElementById('tutor-add-category-btn');
    if (addCategoryBtn && !addCategoryBtn.dataset.listenerAttached) {
      addCategoryBtn.dataset.listenerAttached = 'true';
      addCategoryBtn.addEventListener('click', () => openTutorCategoryModal());
    }

    // Initialize category section when it becomes visible
    const categoriesSection = document.getElementById('categories');
    if (categoriesSection) {
      let categoriesLoaded = false;
      const initCategoriesIfNeeded = () => {
        if (categoriesSection.classList.contains('active') && !categoriesLoaded) {
          categoriesLoaded = true;
          loadTutorCategories();
          setupTutorCategoryForm();
        }
      };
      const catObs = new MutationObserver(() => initCategoriesIfNeeded());
      catObs.observe(categoriesSection, { attributes: true, attributeFilter: ['class'] });
      initCategoriesIfNeeded();
    }

    async function loadTutorBadges() {
      try {
        console.log('Loading tutor badges...');
        const response = await fetch('/tutor/badges/all', {
          headers: {
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
          }
        });

        if (!response.ok) throw new Error('Failed to load badges');

        const data = await response.json();
        tutorAllBadges = data.badges || [];
        tutorBadgeStats = data.stats || {};

        console.log('Loaded badges:', tutorAllBadges.length);

        // Update statistics
        updateTutorBadgeStats();

        // Display badges
        displayTutorBadges(tutorAllBadges);

        // Setup badge filters
        setupTutorBadgeFilters();

      } catch (error) {
        console.error('Error loading badges:', error);
        showNotification('Error loading badges', 'error');
        document.getElementById('tutor-badges-grid').innerHTML = `
          <div style="grid-column: 1 / -1; text-align: center; padding: 40px; color: #dc3545;">
            <i class="fas fa-exclamation-triangle" style="font-size: 48px; margin-bottom: 16px; opacity: 0.3;"></i>
            <p style="font-size: 18px;">Failed to load badges</p>
            <p style="font-size: 14px; color: #6b7280;">Please try refreshing the page</p>
          </div>
        `;
      }
    }

    function updateTutorBadgeStats() {
      document.getElementById('tutor-total-badges-count').textContent = tutorBadgeStats.total_badges || tutorAllBadges.length;
      document.getElementById('tutor-students-with-badges-count').textContent = tutorBadgeStats.students_with_badges || 0;
      document.getElementById('tutor-badges-earned-count').textContent = tutorBadgeStats.total_awarded || 0;
    }

    function displayTutorBadges(badges) {
      const grid = document.getElementById('tutor-badges-grid');
      if (!grid) return;

      if (badges.length === 0) {
        grid.innerHTML = `
          <div style="grid-column: 1 / -1; text-align: center; padding: 40px; color: #666;">
            <i class="fas fa-trophy" style="font-size: 48px; margin-bottom: 16px; opacity: 0.3;"></i>
            <p style="font-size: 18px;">No badges found</p>
            <p style="font-size: 14px; color: #9ca3af;">Badges will appear here once they are created by an administrator</p>
          </div>
        `;
        return;
      }

      grid.innerHTML = badges.map(badge => `
        <div class="tutor-badge-card" style="background: white; border-radius: 12px; padding: 20px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); transition: transform 0.2s, box-shadow 0.2s; cursor: pointer; position: relative;">
          <div style="position: absolute; top: 12px; right: 12px; display: flex; gap: 8px;">
            ${badge.is_active
              ? '<span style="background: #10b981; color: white; padding: 4px 8px; border-radius: 6px; font-size: 11px; font-weight: 600;">ACTIVE</span>'
              : '<span style="background: #6b7280; color: white; padding: 4px 8px; border-radius: 6px; font-size: 11px; font-weight: 600;">INACTIVE</span>'
            }
          </div>

          <div style="text-align: center; margin-bottom: 16px;">
            <div style="font-size: 48px; margin-bottom: 8px;">${badge.icon || '🏆'}</div>
            <h3 style="font-size: 18px; font-weight: 600; color: #333; margin-bottom: 4px;">${badge.name}</h3>
            <p style="color: #666; font-size: 13px; line-height: 1.4;">${badge.description}</p>
          </div>

          <div style="display: flex; justify-content: space-between; align-items: center; padding-top: 16px; border-top: 1px solid #e5e7eb;">
            <div>
              <span style="display: inline-block; padding: 4px 10px; background: ${badge.color || '#667eea'}20; color: ${badge.color || '#667eea'}; border-radius: 6px; font-size: 12px; font-weight: 600;">
                ${badge.points || 0} pts
              </span>
              <span style="display: inline-block; padding: 4px 10px; background: #f3f4f6; color: #666; border-radius: 6px; font-size: 12px; margin-left: 6px;">
                ${badge.category || 'General'}
              </span>
            </div>
          </div>

          <div style="margin-top: 12px; padding-top: 12px; border-top: 1px solid #e5e7eb;">
            <div style="font-size: 12px; color: #666; margin-bottom: 4px;">Awarded to <strong>${badge.users_count || 0}</strong> students</div>
            ${badge.criteria ? `
              <div style="font-size: 11px; color: #999; background: #f9fafb; padding: 6px 10px; border-radius: 6px; margin-top: 6px;">
                <strong>Criteria:</strong> ${formatTutorCriteria(badge.criteria)}
              </div>
            ` : ''}
          </div>
        </div>
      `).join('');

      // Add hover effects
      document.querySelectorAll('.tutor-badge-card').forEach(card => {
        card.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-4px)';
          this.style.boxShadow = '0 8px 16px rgba(0,0,0,0.15)';
        });
        card.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0)';
          this.style.boxShadow = '0 2px 8px rgba(0,0,0,0.1)';
        });
      });

      // Populate category filter
      populateTutorBadgeCategories(badges);
    }

    function formatTutorCriteria(criteriaObj) {
      if (!criteriaObj || typeof criteriaObj !== 'object') return 'N/A';

      const type = criteriaObj.type || 'unknown';
      const value = criteriaObj.value || criteriaObj.required_count || '';

      const labels = {
        'course_completion': 'Complete a course',
        'course_count': `Complete ${value} courses`,
        'quiz_score': `Score ${value}% or higher on quiz`,
        'perfect_score': 'Get 100% on a quiz',
        'speed_completion': `Complete within ${value} hours`,
        'streak': `Maintain ${value} day streak`,
        'lesson_count': `Complete ${value} lessons`
      };

      return labels[type] || type;
    }

    function setupTutorBadgeFilters() {
      const categoryFilter = document.getElementById('tutor-badge-category-filter');
      const statusFilter = document.getElementById('tutor-badge-status-filter');

      if (categoryFilter) {
        categoryFilter.addEventListener('change', filterTutorBadges);
      }
      if (statusFilter) {
        statusFilter.addEventListener('change', filterTutorBadges);
      }
    }

    function filterTutorBadges() {
      const category = document.getElementById('tutor-badge-category-filter')?.value || 'all';
      const status = document.getElementById('tutor-badge-status-filter')?.value || 'all';

      let filtered = tutorAllBadges;

      if (category !== 'all') {
        filtered = filtered.filter(b => b.category === category);
      }

      if (status === 'active') {
        filtered = filtered.filter(b => b.is_active === true || b.is_active === 1);
      } else if (status === 'inactive') {
        filtered = filtered.filter(b => b.is_active === false || b.is_active === 0);
      }

      displayTutorBadges(filtered);
    }

    function populateTutorBadgeCategories(badges) {
      const categoryFilter = document.getElementById('tutor-badge-category-filter');
      if (!categoryFilter) return;

      // Get unique categories
      const categories = [...new Set(badges.map(b => b.category).filter(c => c))];

      // Clear existing options except "All Categories"
      categoryFilter.innerHTML = '<option value="all">All Categories</option>';

      // Add category options
      categories.forEach(category => {
        categoryFilter.innerHTML += `<option value="${category}">${category}</option>`;
      });
    }

    // Badge tab switching
    document.querySelectorAll('.tutor-badge-tab').forEach(tab => {
      tab.addEventListener('click', function() {
        const tabName = this.getAttribute('data-tab');

        // Update tab styles
        document.querySelectorAll('.tutor-badge-tab').forEach(t => {
          t.style.borderBottomColor = 'transparent';
          t.style.color = '#666';
          t.classList.remove('active');
        });
        this.style.borderBottomColor = '#667eea';
        this.style.color = '#667eea';
        this.classList.add('active');

        // Show/hide content
        document.querySelectorAll('.tutor-badge-tab-content').forEach(content => {
          content.classList.add('hidden');
        });
        document.getElementById(`tutor-${tabName}-tab`).classList.remove('hidden');
      });
    });

  </script>
</body>
</html>
