<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - EE Micro LMS</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { 
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .navbar {
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.95) 0%,
                rgba(255, 255, 255, 0.9) 100%
            );
            padding: 0;
            backdrop-filter: blur(30px) saturate(200%);
            box-shadow: 0 10px 40px rgba(102, 126, 234, 0.15), 
                        0 1px 3px rgba(0, 0, 0, 0.05),
                        inset 0 1px 0 rgba(255, 255, 255, 0.9);
            border-bottom: 2px solid rgba(102, 126, 234, 0.1);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: slideDown 0.6s ease-out;
        }

        @keyframes slideDown {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .navbar:hover {
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.98) 0%,
                rgba(255, 255, 255, 0.95) 100%
            );
            box-shadow: 0 15px 50px rgba(102, 126, 234, 0.2), 
                        0 5px 15px rgba(0, 0, 0, 0.08),
                        inset 0 1px 0 rgba(255, 255, 255, 1);
        }
        .navbar-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 32px;
            min-height: 90px;
        }
        .logo {
            font-size: 1.8em;
            font-weight: 900;
            background: linear-gradient(135deg, #0f172a 0%, #667eea 50%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -0.03em;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .logo:hover {
            transform: translateY(-3px) scale(1.05);
            filter: drop-shadow(0 8px 16px rgba(102, 126, 234, 0.2));
        }
        .user-info {
            display: flex;
            align-items: center;
            gap: 16px;
            font-weight: 600;
            color: #334155;
        }
        .btn {
            padding: 12px 28px;
            border: none;
            border-radius: 16px;
            text-decoration: none;
            font-size: 15px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.34, 1.56, 0.64, 1);
            position: relative;
            overflow: hidden;
            display: inline-flex;
            align-items: center;
            gap: 10px;
        }

        .btn::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.3) 0%, transparent 60%);
            opacity: 0;
            transition: opacity 0.4s ease;
        }

        .btn::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.5);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }

        .btn:hover::after {
            width: 300px;
            height: 300px;
        }

        .btn:hover::before {
            opacity: 1;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 12px 35px rgba(102, 126, 234, 0.5);
        }
        .btn-secondary {
            background: rgba(100, 116, 139, 0.08);
            color: #475569;
            border: 2px solid rgba(100, 116, 139, 0.2);
            backdrop-filter: blur(10px);
        }

        .btn-secondary:hover {
            transform: translateY(-4px) scale(1.05);
            background: rgba(100, 116, 139, 0.15);
            border-color: rgba(100, 116, 139, 0.3);
            box-shadow: 0 4px 16px rgba(100, 116, 139, 0.2);
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        .dashboard-header {
            background: rgba(255,255,255,0.1);
            padding: 30px;
            border-radius: 20px;
            text-align: center;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
        }
        .dashboard-header h1 {
            color: white;
            font-size: 2.5em;
            margin-bottom: 10px;
        }
        .dashboard-header p {
            color: rgba(255,255,255,0.9);
            font-size: 1.1em;
        }
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }
        .card {
            background: rgba(255,255,255,0.95);
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            backdrop-filter: blur(10px);
        }
        .card h3 {
            color: #333;
            margin-bottom: 15px;
            font-size: 1.3em;
        }
        .card p {
            color: #666;
            line-height: 1.6;
            margin-bottom: 15px;
        }
        .card .btn {
            display: inline-block;
            margin-top: 10px;
        }
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }
        .status-active {
            background: #d1edff;
            color: #0066cc;
        }
        .status-admin {
            background: #ffe6cc;
            color: #cc6600;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-content">
            <div class="logo">🎓 EE Micro LMS</div>
            <div class="user-info">
                <span>Welcome, <strong>{{ $user->name }}</strong></span>
                @if($user->hasRole('admin'))
                    <span class="status-badge status-admin">Admin</span>
                    <a href="{{ route('admin.panel') }}" class="btn btn-primary">Admin Panel</a>
                @elseif($user->hasRole('tutor'))
                    <span class="status-badge status-admin">Tutor</span>
                @else
                    <span class="status-badge status-active">Student</span>
                @endif
                <form method="POST" action="{{ route('logout') }}" style="display: inline;">
                    @csrf
                    <button type="submit" class="btn btn-secondary">Logout</button>
                </form>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="dashboard-header">
            <h1>👋 Welcome to Your Dashboard</h1>
            <p>Explore your electrical engineering learning journey</p>
        </div>

        <div class="dashboard-grid">
            <div class="card">
                <h3>📚 My Courses</h3>
                <p>Access your enrolled courses and track your progress through various electrical engineering topics.</p>
                <a href="/courses" class="btn btn-primary">View Courses</a>
            </div>

            <div class="card">
                <h3>📊 Progress Tracking</h3>
                <p>Monitor your learning progress, completed lessons, and upcoming assignments.</p>
                <a href="/progress" class="btn btn-primary">View Progress</a>
            </div>

            <div class="card">
                <h3>🧪 Practice Quizzes</h3>
                <p>Test your knowledge with interactive quizzes and reinforce your understanding.</p>
                <a href="/quiz-questions" class="btn btn-primary">Take Quizzes</a>
            </div>

            <div class="card">
                <h3>📖 Recent Activity</h3>
                <p>Stay updated with your recent learning activities and achievements.</p>
                <div style="margin-top: 15px;">
                    <small style="color: #888;">
                        Last login: {{ $user->updated_at->format('M d, Y at g:i A') }}
                    </small>
                </div>
            </div>

            <div class="card">
                <h3>🎯 Learning Goals</h3>
                <p>Set and track your learning objectives. Stay motivated and achieve your goals.</p>
                <a href="/goals" class="btn btn-primary">Set Goals</a>
            </div>
        </div>

        <div style="text-align: center; margin-top: 40px;">
            <p style="color: rgba(255,255,255,0.8);">
                <strong>EE Micro LMS</strong> - Your gateway to electrical engineering mastery
            </p>
        </div>
    </div>
</body>
</html>