{{-- Course Management Component --}}
{{-- This component is used by both Admin and Tutor dashboards --}}
{{-- Parameters: $apiPrefix (e.g., 'admin' or 'tutor') --}}

@php
    $apiPrefix = $apiPrefix ?? 'admin'; // Default to admin if not specified
@endphp

<!-- Courses Section -->
<div id="courses-section" class="{{$sectionClass ?? 'hidden'}}">
    <div class="section-header">
        <h1>📚 Course Management</h1>
        <p>Create and manage learning courses, lessons, and topics</p>
    </div>

    <!-- Tabs Navigation -->
    <div style="display: flex; gap: 10px; margin-bottom: 20px; border-bottom: 2px solid rgba(255,255,255,0.2); padding-bottom: 10px;">
        <button class="tab-btn active" data-tab="courses-list" style="background: rgba(255,255,255,0.2); color: white; border: none; padding: 10px 20px; border-radius: 6px 6px 0 0; cursor: pointer; font-weight: 600; transition: all 0.3s;">
            <i class="fas fa-graduation-cap"></i> All Courses
        </button>
        <button class="tab-btn" data-tab="lessons-topics" style="background: transparent; color: rgba(255,255,255,0.7); border: none; padding: 10px 20px; border-radius: 6px 6px 0 0; cursor: pointer; font-weight: 600; transition: all 0.3s;">
            <i class="fas fa-book-open"></i> Lessons & Topics
        </button>
    </div>

    <!-- Tab Content: All Courses -->
    <div id="courses-list-tab" class="tab-content">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3 style="color: white; margin: 0;">📚 All Courses</h3>
            <button id="add-course-btn" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Course
            </button>
        </div>

        <!-- Courses Table -->
        <div class="card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h3>📚 All Courses</h3>
                <input type="text" id="course-search" class="search-input" placeholder="🔍 Search courses..." style="width: 300px; margin-bottom: 0;">
            </div>
            
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th style="width: 30%;">Course Name</th>
                            <th style="width: 15%;">Status</th>
                            <th style="width: 15%;">Lessons</th>
                            <th style="width: 15%;">Enrolled</th>
                            <th style="width: 10%;">Completion</th>
                            <th style="width: 15%;">Actions</th>
                        </tr>
                    </thead>
                    <tbody id="courses-table-body">
                        <tr>
                            <td colspan="6" style="text-align: center; padding: 40px;">
                                <i class="fas fa-spinner fa-spin" style="font-size: 24px; color: #667eea;"></i>
                                <p style="margin-top: 10px; color: #999;">Loading courses...</p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Tab Content: Lessons & Topics -->
    <div id="lessons-topics-tab" class="tab-content hidden">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; flex-wrap: wrap; gap: 15px;">
            <div>
                <h3 style="color: white; margin: 0 0 5px 0;">📖 Manage Lessons & Topics</h3>
                <p style="color: rgba(255,255,255,0.8); margin: 0; font-size: 14px;">Select a course to view and edit its content structure</p>
            </div>
            <div style="display: flex; gap: 10px;">
                <select id="content-course-filter" style="margin-bottom: 0; min-width: 300px;">
                    <option value="">Select Course to Manage</option>
                </select>
                <button id="add-lesson-btn" class="btn btn-primary" disabled style="opacity: 0.5;">
                    <i class="fas fa-plus"></i> Add Lesson
                </button>
            </div>
        </div>

        <div class="grid grid-3" style="grid-template-columns: 1fr 2fr; gap: 20px;">
            <!-- Course Tree View -->
            <div class="card">
                <h3>📋 Content Structure</h3>
                <div id="content-tree" class="content-tree">
                    <div style="text-align: center; padding: 40px 20px; color: #999;">
                        <i class="fas fa-folder-open" style="font-size: 48px; color: #667eea; opacity: 0.5;"></i>
                        <p style="margin-top: 15px; font-size: 14px;">Select a course to view its lessons and topics</p>
                    </div>
                </div>
            </div>

            <!-- Editor Panel (Using Modals Now) -->
            <div>
                <div id="lesson-editor-old" class="card hidden">
                    <p style="text-align: center; padding: 40px; color: #999;">
                        <i class="fas fa-info-circle" style="font-size: 48px; margin-bottom: 15px; display: block;"></i>
                        Lesson editing now uses modal windows.<br>
                        Click the Edit button on a lesson to open the editor.
                    </p>
                </div>

                <div id="topic-editor-old" class="card hidden">
                    <p style="text-align: center; padding: 40px; color: #999;">
                        <i class="fas fa-info-circle" style="font-size: 48px; margin-bottom: 15px; display: block;"></i>
                        Topic editing now uses modal windows.<br>
                        Click the Edit button on a topic to open the editor.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Set the API prefix for this instance
    window.COURSE_MGMT_API_PREFIX = '{{ $apiPrefix }}';
</script>
