﻿<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    @php
        $siteName = \App\Models\SiteSetting::get('site_name', 'EE Micro LMS') ?: 'EE Micro LMS';
        $siteDescription = \App\Models\SiteSetting::get('site_description', 'Transform Your Learning Experience') ?: 'Transform Your Learning Experience';
        $logoPath = \App\Models\SiteSetting::get('logo_path');
        $faviconPath = \App\Models\SiteSetting::get('favicon_path');

        $normalizeColor = function ($value, $fallback) {
            $value = trim((string) ($value ?? ''));
            if ($value === '') {
                return $fallback;
            }
            if ($value[0] !== '#') {
                $value = '#' . ltrim($value, '#');
            }
            return $value;
        };

        $primaryColor = $normalizeColor(\App\Models\SiteSetting::get('primary_color'), '#667eea');
        $secondaryColor = $normalizeColor(\App\Models\SiteSetting::get('secondary_color'), '#764ba2');
    @endphp
    <title>Register - {{ $siteName }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @if(!empty($faviconPath))
        <link rel="icon" type="image/x-icon" href="{{ preg_match('/^https?:\/\//i', $faviconPath) ? $faviconPath : asset($faviconPath) }}">
    @endif
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, {{ $primaryColor }} 0%, {{ $secondaryColor }} 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .register-container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 450px;
            backdrop-filter: blur(10px);
        }
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo img {
            max-height: 80px;
            max-width: 250px;
            object-fit: contain;
            margin-bottom: 10px;
        }
        .logo h1 {
            color: {{ $primaryColor }};
            font-size: 2.4em;
            margin-bottom: 5px;
        }
        .logo p {
            color: #666;
            font-size: 0.9em;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e1e5e9;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        .form-group input:focus {
            outline: none;
            border-color: {{ $primaryColor }};
            box-shadow: 0 0 0 3px {{ $primaryColor }}1a;
        }
        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, {{ $primaryColor }} 0%, {{ $secondaryColor }} 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
            margin-top: 10px;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .links {
            text-align: center;
            margin-top: 20px;
        }
        .links a {
            color: {{ $primaryColor }};
            text-decoration: none;
            font-size: 14px;
        }
        .links a:hover {
            text-decoration: underline;
        }
        .error {
            background: #fee;
            color: #c33;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid #c33;
        }
        .password-requirements {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="logo">
            @if(!empty($logoPath))
                <img src="{{ preg_match('/^https?:\/\//i', $logoPath) ? $logoPath : asset($logoPath) }}" alt="{{ $siteName }}">
                <p>Join the {{ $siteName }} Community</p>
            @else
                <h1> {{ $siteName }}</h1>
                <p>Join the {{ $siteName }} Community</p>
            @endif
        </div>

        @if ($errors->any())
            <div class="error">
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        @endif

        <form method="POST" action="{{ route('register') }}">
            @csrf
            
            <div class="form-group">
                <label for="name">Full Name</label>
                <input type="text" id="name" name="name" value="{{ old('name') }}" required autofocus>
            </div>

            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" name="email" value="{{ old('email') }}" required>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
                <div class="password-requirements">
                    Password must be at least 8 characters long
                </div>
            </div>

            <div class="form-group">
                <label for="password_confirmation">Confirm Password</label>
                <input type="password" id="password_confirmation" name="password_confirmation" required>
            </div>

            @if(!empty($accessCodeRequired))
            <div class="form-group" id="access-code-group">
                <label for="access_code">Access Code</label>
                <input type="text" id="access_code" name="access_code" placeholder="Enter your access code" style="text-transform: uppercase;" required>
                <div class="password-requirements">
                    Enter the access code provided to you
                </div>
            </div>
            @endif

            <button type="submit" class="btn">Create Account</button>
        </form>

        <div class="links">
            <a href="{{ route('login') }}">Already have an account? Sign in here</a>
            <br><br>
            <a href="{{ url('/') }}"> Back to Home</a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const accessCodeInput = document.getElementById('access_code');
            if (accessCodeInput) {
                accessCodeInput.addEventListener('input', function(e) {
                    e.target.value = e.target.value.toUpperCase();
                });
            }
        });
    </script>
</body>
</html>
