<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    @php
        $brand = \App\Support\BrandSettings::data();
        $siteName = $brand['name'] ?? 'EE Micro LMS';
        $siteTagline = $brand['tagline'] ?? 'Entrepreneurship Training Hub';
        $logoUrl = $brand['logo_url'] ?? null;
        $faviconUrl = $brand['favicon_url'] ?? null;
        $primaryColor = $brand['colors']['primary'] ?? '#667eea';
        $secondaryColor = $brand['colors']['secondary'] ?? '#764ba2';
        $gradient = $brand['colors']['gradient'] ?? 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)';
    @endphp
    <title>Sign In - {{ $siteName }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @if (!empty($faviconUrl))
        <link rel="icon" type="image/x-icon" href="{{ $faviconUrl }}">
    @endif
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        body { 
            font-family: 'Poppins', sans-serif; 
            background: {{ $gradient }};
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .auth-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 25px -5px rgba(0,0,0,0.1), 0 10px 10px -5px rgba(0,0,0,0.04);
            width: 100%;
            max-width: 450px;
            overflow: hidden;
        }
        
        .logo-section {
            text-align: center;
            padding: 40px 40px 20px;
            background: {{ $gradient }};
            color: white;
        }

        .logo-section img {
            display: block;
            max-width: 220px;
            max-height: 70px;
            object-fit: contain;
            margin: 0 auto 10px;
        }

        .logo-fallback {
            font-size: 2.4em;
            font-weight: 700;
            margin-bottom: 10px;
        }

        .logo-section p {
            font-size: 0.95em;
            opacity: 0.9;
        }
        
        .auth-tabs {
            display: flex;
            border-bottom: 1px solid #e5e7eb;
            background: #f8fafc;
        }
        
        .auth-tab {
            flex: 1;
            padding: 15px;
            cursor: pointer;
            border-bottom: 2px solid transparent;
            font-weight: 500;
            text-align: center;
            transition: all 0.3s ease;
            background: #f8fafc;
        }
        
        .auth-tab.active {
            border-bottom-color: {{ $primaryColor }};
            color: {{ $primaryColor }};
            background: white;
        }
        
        .auth-tab:hover:not(.active) {
            background: #e2e8f0;
        }
        
        .form-container {
            padding: 30px 40px 40px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #374151;
            font-weight: 500;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e5e7eb;
            border-radius: 10px;
            font-size: 16px;
            transition: border-color 0.3s, box-shadow 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: {{ $primaryColor }};
            box-shadow: 0 0 0 3px {{ $primaryColor }}1a;
        }
        
        .password-field {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #6b7280;
            font-size: 16px;
        }
        
        .password-toggle:hover {
            color: #374151;
        }
        
        .btn {
            width: 100%;
            padding: 14px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, {{ $primaryColor }} 0%, {{ $secondaryColor }} 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .error-message {
            background: #fef2f2;
            color: #dc2626;
            padding: 12px 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            border-left: 4px solid #dc2626;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .success-message {
            background: #f0fdf4;
            color: #166534;
            padding: 12px 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            border-left: 4px solid #22c55e;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .links {
            text-align: center;
            margin-top: 20px;
        }
        
        .links a {
            color: {{ $primaryColor }};
            text-decoration: none;
            font-size: 14px;
        }
        
        .links a:hover {
            text-decoration: underline;
        }
        
        .hidden {
            display: none !important;
        }
        
        .access-code-required {
            color: #dc2626 !important;
            font-weight: 600 !important;
        }

        .loading {
            pointer-events: none;
            opacity: 0.7;
        }

        .loading::after {
            content: '';
            width: 16px;
            height: 16px;
            margin-left: 8px;
            border: 2px solid #ffffff;
            border-top: 2px solid transparent;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <div class="logo-section">
            @if (!empty($logoUrl))
                <img src="{{ $logoUrl }}" alt="{{ $siteName }}">
            @else
                <div class="logo-fallback">{{ $siteName }}</div>
            @endif
            <p>{{ $siteTagline }}</p>
        </div>

        <div class="auth-tabs">
            <div class="auth-tab active" id="login-tab">Sign In</div>
            <div class="auth-tab" id="register-tab">Sign Up</div>
        </div>

        <div class="form-container">
            <!-- Status Messages -->
            @if (session('status'))
                <div class="success-message">
                    <i class="fas fa-check-circle"></i>
                    {{ session('status') }}
                </div>
            @endif

            @if ($errors->any())
                <div class="error-message">
                    <i class="fas fa-exclamation-circle"></i>
                    <div>
                        @foreach ($errors->all() as $error)
                            <div>{{ $error }}</div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Login Form -->
            <div id="login-form-container">
                <form method="POST" action="{{ route('login') }}" id="login-form">
                    @csrf
                    
                    <div class="form-group">
                        <label for="login-email">Email Address</label>
                        <input type="email" id="login-email" name="email" value="{{ old('email') }}" required autofocus>
                    </div>

                    <div class="form-group">
                        <label for="login-password">Password</label>
                        <div class="password-field">
                            <input type="password" id="login-password" name="password" required>
                            <i class="fas fa-eye password-toggle" id="login-toggle-password"></i>
                        </div>
                    </div>

                    <div class="form-group" style="margin-bottom: 30px;">
                        <label style="display: flex; align-items: center; font-weight: normal; cursor: pointer;">
                            <input type="checkbox" name="remember" style="width: auto; margin-right: 8px;">
                            Remember me
                        </label>
                    </div>

                    <div class="form-group" style="text-align: right; margin-top: -10px; margin-bottom: 20px;">
                        <a href="{{ route('password.request') }}" style="color: {{ $primaryColor }}; font-size: 14px; text-decoration: none;">
                            Forgot your password?
                        </a>
                    </div>

                    <button type="submit" class="btn btn-primary" id="login-btn">
                        <i class="fas fa-sign-in-alt"></i> Sign In
                    </button>
                </form>
            </div>

            <!-- Registration Form -->
            <div id="register-form-container" class="hidden">
                <form method="POST" action="{{ route('register') }}" id="register-form">
                    @csrf
                    
                    <div class="form-group">
                        <label for="register-name">Full Name</label>
                        <input type="text" id="register-name" name="name" value="{{ old('name') }}" required>
                    </div>

                    <div class="form-group">
                        <label for="register-email">Email Address</label>
                        <input type="email" id="register-email" name="email" value="{{ old('email') }}" required>
                    </div>

                    <!-- Access Code Field - Dynamic -->
                    <div class="form-group {{ $accessCodeRequired ? '' : 'hidden' }}" id="access-code-group">
                        <label for="access-code" id="access-code-label">
                            Access Code
                            <span id="access-code-required" class="access-code-required {{ $accessCodeRequired ? '' : 'hidden' }}">*</span>
                        </label>
                        <input type="text" id="access-code" name="access_code"
                               {{ $accessCodeRequired ? 'required' : '' }}
                               placeholder="{{ $accessCodeRequired ? 'Access code is required to register' : 'Enter access code if you have one' }}"
                               value="{{ old('access_code') }}">
                    </div>

                    <div class="form-group">
                        <label for="register-password">Password</label>
                        <div class="password-field">
                            <input type="password" id="register-password" name="password" required>
                            <i class="fas fa-eye password-toggle" id="register-toggle-password"></i>
                        </div>
                        <div style="font-size: 12px; color: #6b7280; margin-top: 5px;">
                            Password must be at least 8 characters long
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password_confirmation">Confirm Password</label>
                        <div class="password-field">
                            <input type="password" id="password_confirmation" name="password_confirmation" required>
                            <i class="fas fa-eye password-toggle" id="confirm-toggle-password"></i>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary" id="register-btn">
                        <i class="fas fa-user-plus"></i> Create Account
                    </button>
                </form>
            </div>

            <div class="links">
                <a href="{{ url('/') }}">← Back to Home</a>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get elements
            const loginTab = document.getElementById('login-tab');
            const registerTab = document.getElementById('register-tab');
            const loginForm = document.getElementById('login-form-container');
            const registerForm = document.getElementById('register-form-container');
            
            // Tab switching
            loginTab.addEventListener('click', () => {
                loginTab.classList.add('active');
                registerTab.classList.remove('active');
                loginForm.classList.remove('hidden');
                registerForm.classList.add('hidden');
            });
            
            registerTab.addEventListener('click', () => {
                registerTab.classList.add('active');
                loginTab.classList.remove('active');
                registerForm.classList.remove('hidden');
                loginForm.classList.add('hidden');
            });

            // Password toggle functionality
            function setupPasswordToggle(toggleId, passwordId) {
                const toggle = document.getElementById(toggleId);
                const password = document.getElementById(passwordId);
                
                if (toggle && password) {
                    toggle.addEventListener('click', function() {
                        const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
                        password.setAttribute('type', type);
                        this.classList.toggle('fa-eye-slash');
                        this.classList.toggle('fa-eye');
                    });
                }
            }

            // Setup all password toggles
            setupPasswordToggle('login-toggle-password', 'login-password');
            setupPasswordToggle('register-toggle-password', 'register-password');
            setupPasswordToggle('confirm-toggle-password', 'password_confirmation');

            // Form loading states
            document.getElementById('login-form').addEventListener('submit', function() {
                const btn = document.getElementById('login-btn');
                btn.classList.add('loading');
                btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Signing In...';
            });

            document.getElementById('register-form').addEventListener('submit', function() {
                const btn = document.getElementById('register-btn');
                btn.classList.add('loading');
                btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Creating Account...';
            });

            const accessCodeRequiredInitial = Boolean(@json($accessCodeRequired ?? false));
            applyAccessCodeState(accessCodeRequiredInitial);
            checkAccessCodeRequirement();

            function applyAccessCodeState(isRequired) {
                const accessCodeGroup = document.getElementById('access-code-group');
                const accessCodeRequiredBadge = document.getElementById('access-code-required');
                const accessCodeInput = document.getElementById('access-code');

                if (!accessCodeGroup || !accessCodeInput) {
                    return;
                }

                if (isRequired) {
                    accessCodeGroup.classList.remove('hidden');
                    accessCodeRequiredBadge?.classList.remove('hidden');
                    accessCodeInput.required = true;
                    accessCodeInput.placeholder = 'Access code is required to register';
                } else {
                    accessCodeGroup.classList.add('hidden');
                    accessCodeRequiredBadge?.classList.add('hidden');
                    accessCodeInput.required = false;
                    accessCodeInput.placeholder = 'Enter access code if you have one';
                    accessCodeInput.value = '';
                }
            }

            function checkAccessCodeRequirement() {
                fetch('/api/settings/access-code-status')
                    .then(response => response.json())
                    .then(data => {
                        applyAccessCodeState(Boolean(data.required));
                    })
                    .catch(error => {
                        console.log('Could not check access code requirement');
                    });
            }

            // If there are validation errors, show the appropriate form
            @if (old('name') || old('email'))
                registerTab.click();
            @endif
        });
    </script>
</body>
</html>
