import React from 'react';
import { Head } from '@inertiajs/react';

export default function Dashboard({ auth }) {
    return (
        <>
            <Head title="Tutor Dashboard" />

            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <h1 className="text-2xl font-bold mb-6">Tutor Dashboard</h1>
                            <p>Welcome to the tutor dashboard, {auth.user.name}!</p>
                        </div>
                    </div>
                </div>
            </div>
        </>
    );
}