import React from 'react';
import { Head } from '@inertiajs/react';

export default function Dashboard({ auth, totalUsers, completedCourses, avgScore }) {
    return (
        <>
            <Head title="Admin Dashboard" />

            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <h1 className="text-2xl font-bold mb-6">Admin Dashboard</h1>

                            <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                                <div className="bg-blue-50 p-6 rounded-lg">
                                    <h3 className="text-lg font-semibold text-blue-800">Total Users</h3>
                                    <p className="text-3xl font-bold text-blue-600">{totalUsers}</p>
                                </div>
                                <div className="bg-green-50 p-6 rounded-lg">
                                    <h3 className="text-lg font-semibold text-green-800">Completed Courses</h3>
                                    <p className="text-3xl font-bold text-green-600">{completedCourses}</p>
                                </div>
                                <div className="bg-yellow-50 p-6 rounded-lg">
                                    <h3 className="text-lg font-semibold text-yellow-800">Avg. Score</h3>
                                    <p className="text-3xl font-bold text-yellow-600">{avgScore}%</p>
                                </div>
                            </div>

                            <p>Welcome to the admin dashboard, {auth.user.name}!</p>
                        </div>
                    </div>
                </div>
            </div>
        </>
    );
}