import { forwardRef, InputHTMLAttributes } from 'react';

export default forwardRef<HTMLInputElement, InputHTMLAttributes<HTMLInputElement>>(
    function TextInput({ className = '', ...props }, ref) {
        return (
            <input
                {...props}
                className={
                    'border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm ' +
                    className
                }
                ref={ref}
            />
        );
    }
);