export default function InputLabel({
    value,
    htmlFor,
    className = '',
    children,
    ...props
}: {
    value?: string;
    htmlFor?: string;
    className?: string;
    children?: React.ReactNode;
} & React.LabelHTMLAttributes<HTMLLabelElement>) {
    return (
        <label
            {...props}
            htmlFor={htmlFor}
            className={`block font-medium text-sm text-gray-700 ` + className}
        >
            {value ? value : children}
        </label>
    );
}