<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class TestUsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create roles if they don't exist
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $tutorRole = Role::firstOrCreate(['name' => 'tutor']);
        $userRole = Role::firstOrCreate(['name' => 'user']);

        // Create Admin User
        $admin = User::firstOrCreate(
            ['email' => 'admin@eelms.com'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('admin123'),
                'is_admin' => true,
                'email_verified_at' => now(),
            ]
        );
        $admin->assignRole('admin');

        // Create Teacher/Tutor User
        $teacher = User::firstOrCreate(
            ['email' => 'teacher@eelms.com'],
            [
                'name' => 'Teacher User',
                'password' => Hash::make('teacher123'),
                'is_admin' => false,
                'email_verified_at' => now(),
            ]
        );
        $teacher->assignRole('tutor');

        // Create Student User
        $student = User::firstOrCreate(
            ['email' => 'student@eelms.com'],
            [
                'name' => 'Student User',
                'password' => Hash::make('student123'),
                'is_admin' => false,
                'email_verified_at' => now(),
            ]
        );
        $student->assignRole('user');

        $this->command->info('Test users created successfully!');
        $this->command->info('');
        $this->command->info('=== LOGIN CREDENTIALS ===');
        $this->command->info('');
        $this->command->info('👤 ADMIN:');
        $this->command->info('   Email: admin@eelms.com');
        $this->command->info('   Password: admin123');
        $this->command->info('   Role: Administrator');
        $this->command->info('');
        $this->command->info('👨‍🏫 TEACHER:');
        $this->command->info('   Email: teacher@eelms.com');
        $this->command->info('   Password: teacher123');
        $this->command->info('   Role: Tutor/Teacher');
        $this->command->info('');
        $this->command->info('👨‍🎓 STUDENT:');
        $this->command->info('   Email: student@eelms.com');
        $this->command->info('   Password: student123');
        $this->command->info('   Role: Student/User');
        $this->command->info('');
        $this->command->info('🌐 Access: http://127.0.0.1:8000/login');
    }
}
