<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SiteSetting;

class SiteSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // General Settings
            [
                'key' => 'site_name',
                'value' => 'EE Micro LMS',
                'type' => 'text',
                'group' => 'general',
                'description' => 'The name of your site that appears in the header and browser title'
            ],
            [
                'key' => 'site_description',
                'value' => 'Learn and Grow with Our Courses',
                'type' => 'textarea',
                'group' => 'general',
                'description' => 'A brief description of your site (tagline or slogan)'
            ],
            [
                'key' => 'copyright_text',
                'value' => 'EE Micro LMS. All rights reserved.',
                'type' => 'text',
                'group' => 'general',
                'description' => 'Copyright text for footer (year will be auto-added)'
            ],
            [
                'key' => 'contact_email',
                'value' => 'support@eelms.com',
                'type' => 'email',
                'group' => 'general',
                'description' => 'Main contact email address'
            ],
            [
                'key' => 'contact_phone',
                'value' => '+1 (555) 123-4567',
                'type' => 'text',
                'group' => 'general',
                'description' => 'Contact phone number'
            ],

            // Branding
            [
                'key' => 'logo_path',
                'value' => '/images/logo.png',
                'type' => 'image',
                'group' => 'branding',
                'description' => 'Site logo (displayed in header)'
            ],
            [
                'key' => 'favicon_path',
                'value' => '/images/favicon.ico',
                'type' => 'image',
                'group' => 'branding',
                'description' => 'Favicon (browser tab icon, 32x32 or 64x64 px)'
            ],
            [
                'key' => 'logo_dark_path',
                'value' => '/images/logo-dark.png',
                'type' => 'image',
                'group' => 'branding',
                'description' => 'Dark mode logo (optional)'
            ],

            // Theme / Color Scheme
            [
                'key' => 'primary_color',
                'value' => '#667eea',
                'type' => 'color',
                'group' => 'theme',
                'description' => 'Primary brand color (buttons, links, accents)'
            ],
            [
                'key' => 'secondary_color',
                'value' => '#764ba2',
                'type' => 'color',
                'group' => 'theme',
                'description' => 'Secondary brand color (gradients, highlights)'
            ],
            [
                'key' => 'success_color',
                'value' => '#10b981',
                'type' => 'color',
                'group' => 'theme',
                'description' => 'Success state color (green)'
            ],
            [
                'key' => 'danger_color',
                'value' => '#ef4444',
                'type' => 'color',
                'group' => 'theme',
                'description' => 'Danger/error state color (red)'
            ],
            [
                'key' => 'warning_color',
                'value' => '#f59e0b',
                'type' => 'color',
                'group' => 'theme',
                'description' => 'Warning state color (orange/yellow)'
            ],
            [
                'key' => 'info_color',
                'value' => '#3b82f6',
                'type' => 'color',
                'group' => 'theme',
                'description' => 'Info state color (blue)'
            ],

            // SEO Meta Tags
            [
                'key' => 'meta_title',
                'value' => 'EE Micro LMS - Online Learning Platform',
                'type' => 'text',
                'group' => 'seo',
                'description' => 'Default page title for SEO'
            ],
            [
                'key' => 'meta_description',
                'value' => 'Join thousands of learners on EE Micro LMS. Access premium courses, earn certificates, and transform your career with our comprehensive learning platform.',
                'type' => 'textarea',
                'group' => 'seo',
                'description' => 'Default meta description for search engines (155-160 characters)'
            ],
            [
                'key' => 'meta_keywords',
                'value' => 'online learning, courses, education, LMS, certificates, e-learning',
                'type' => 'textarea',
                'group' => 'seo',
                'description' => 'Meta keywords (comma-separated)'
            ],
            [
                'key' => 'og_image',
                'value' => '/images/og-image.jpg',
                'type' => 'image',
                'group' => 'seo',
                'description' => 'Open Graph image for social media sharing (1200x630 px recommended)'
            ],
            [
                'key' => 'google_analytics_id',
                'value' => '',
                'type' => 'text',
                'group' => 'seo',
                'description' => 'Google Analytics tracking ID (e.g., UA-XXXXXXXXX-X or G-XXXXXXXXXX)'
            ],
            [
                'key' => 'google_site_verification',
                'value' => '',
                'type' => 'text',
                'group' => 'seo',
                'description' => 'Google Search Console verification code'
            ],

            // Social Media Links
            [
                'key' => 'facebook_url',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'description' => 'Facebook page URL'
            ],
            [
                'key' => 'twitter_url',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'description' => 'Twitter/X profile URL'
            ],
            [
                'key' => 'linkedin_url',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'description' => 'LinkedIn page URL'
            ],
            [
                'key' => 'instagram_url',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'description' => 'Instagram profile URL'
            ],
            [
                'key' => 'youtube_url',
                'value' => '',
                'type' => 'url',
                'group' => 'social',
                'description' => 'YouTube channel URL'
            ],
        ];

        foreach ($settings as $setting) {
            SiteSetting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }

        $this->command->info('Site settings seeded successfully!');
    }
}

