<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CertificateTemplate;
use App\Models\User;

class CertificateTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first admin user (or create a demo admin if none exists)
        $admin = User::where('is_admin', true)->first();
        
        if (!$admin) {
            // If no admin exists, use the first user
            $admin = User::first();
        }

        // Demo Certificate 1: Classic Professional Certificate (Landscape)
        CertificateTemplate::create([
            'name' => 'Classic Professional Certificate',
            'description' => 'A classic, professional certificate design suitable for course completions. Features elegant styling with centered text layout.',
            'orientation' => 'landscape',
            'background_image' => null, // No background image - will use default white background
            'layout_config' => [
                'width' => 1122,
                'height' => 794,
                'background_color' => '#ffffff',
                'border' => [
                    'enabled' => true,
                    'color' => '#667eea',
                    'width' => 20,
                    'style' => 'double'
                ]
            ],
            'text_fields' => [
                'name' => [
                    'label' => 'Student Name',
                    'x' => 50,
                    'y' => 200,
                    'size' => 42,
                    'font' => 'Georgia',
                    'color' => '#2c3e50',
                    'align' => 'center',
                    'weight' => 'bold'
                ],
                'course' => [
                    'label' => 'Course Title',
                    'x' => 50,
                    'y' => 300,
                    'size' => 28,
                    'font' => 'Arial',
                    'color' => '#667eea',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'date' => [
                    'label' => 'Completion Date',
                    'x' => 50,
                    'y' => 400,
                    'size' => 20,
                    'font' => 'Arial',
                    'color' => '#7f8c8d',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'code' => [
                    'label' => 'Certificate Code',
                    'x' => 50,
                    'y' => 480,
                    'size' => 14,
                    'font' => 'Courier New',
                    'color' => '#95a5a6',
                    'align' => 'center',
                    'weight' => 'normal'
                ]
            ],
            'is_active' => true,
            'created_by' => $admin->id
        ]);

        // Demo Certificate 2: Modern Minimalist (Landscape)
        CertificateTemplate::create([
            'name' => 'Modern Minimalist',
            'description' => 'A sleek, modern design with minimalist styling. Perfect for tech courses and contemporary learning programs.',
            'orientation' => 'landscape',
            'background_image' => null,
            'layout_config' => [
                'width' => 1122,
                'height' => 794,
                'background_color' => '#f8f9fa',
                'border' => [
                    'enabled' => false
                ]
            ],
            'text_fields' => [
                'name' => [
                    'label' => 'Student Name',
                    'x' => 50,
                    'y' => 220,
                    'size' => 48,
                    'font' => 'Arial',
                    'color' => '#1a1a1a',
                    'align' => 'center',
                    'weight' => 'bold'
                ],
                'course' => [
                    'label' => 'Course Title',
                    'x' => 50,
                    'y' => 310,
                    'size' => 24,
                    'font' => 'Arial',
                    'color' => '#4a5568',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'date' => [
                    'label' => 'Completion Date',
                    'x' => 50,
                    'y' => 390,
                    'size' => 18,
                    'font' => 'Arial',
                    'color' => '#718096',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'code' => [
                    'label' => 'Certificate Code',
                    'x' => 50,
                    'y' => 460,
                    'size' => 12,
                    'font' => 'Courier New',
                    'color' => '#a0aec0',
                    'align' => 'center',
                    'weight' => 'normal'
                ]
            ],
            'is_active' => true,
            'created_by' => $admin->id
        ]);

        // Demo Certificate 3: Academic Achievement (Portrait)
        CertificateTemplate::create([
            'name' => 'Academic Achievement',
            'description' => 'A traditional academic-style certificate in portrait orientation. Ideal for formal educational programs and degree completions.',
            'orientation' => 'portrait',
            'background_image' => null,
            'layout_config' => [
                'width' => 794,
                'height' => 1122,
                'background_color' => '#fffef5',
                'border' => [
                    'enabled' => true,
                    'color' => '#d4af37',
                    'width' => 15,
                    'style' => 'solid'
                ]
            ],
            'text_fields' => [
                'name' => [
                    'label' => 'Student Name',
                    'x' => 50,
                    'y' => 350,
                    'size' => 38,
                    'font' => 'Times New Roman',
                    'color' => '#1a202c',
                    'align' => 'center',
                    'weight' => 'bold'
                ],
                'course' => [
                    'label' => 'Course Title',
                    'x' => 50,
                    'y' => 480,
                    'size' => 26,
                    'font' => 'Times New Roman',
                    'color' => '#2d3748',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'date' => [
                    'label' => 'Completion Date',
                    'x' => 50,
                    'y' => 620,
                    'size' => 20,
                    'font' => 'Times New Roman',
                    'color' => '#4a5568',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'code' => [
                    'label' => 'Certificate Code',
                    'x' => 50,
                    'y' => 720,
                    'size' => 14,
                    'font' => 'Courier New',
                    'color' => '#718096',
                    'align' => 'center',
                    'weight' => 'normal'
                ]
            ],
            'is_active' => true,
            'created_by' => $admin->id
        ]);

        // Demo Certificate 4: Colorful Achievement (Landscape)
        CertificateTemplate::create([
            'name' => 'Colorful Achievement',
            'description' => 'A vibrant, eye-catching design with bold colors. Great for creative courses and celebrating achievements.',
            'orientation' => 'landscape',
            'background_image' => null,
            'layout_config' => [
                'width' => 1122,
                'height' => 794,
                'background_color' => '#ffffff',
                'border' => [
                    'enabled' => true,
                    'color' => '#ff6b6b',
                    'width' => 12,
                    'style' => 'solid'
                ]
            ],
            'text_fields' => [
                'name' => [
                    'label' => 'Student Name',
                    'x' => 50,
                    'y' => 210,
                    'size' => 44,
                    'font' => 'Arial',
                    'color' => '#ff6b6b',
                    'align' => 'center',
                    'weight' => 'bold'
                ],
                'course' => [
                    'label' => 'Course Title',
                    'x' => 50,
                    'y' => 300,
                    'size' => 26,
                    'font' => 'Arial',
                    'color' => '#4ecdc4',
                    'align' => 'center',
                    'weight' => 'bold'
                ],
                'date' => [
                    'label' => 'Completion Date',
                    'x' => 50,
                    'y' => 390,
                    'size' => 20,
                    'font' => 'Arial',
                    'color' => '#95e1d3',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'code' => [
                    'label' => 'Certificate Code',
                    'x' => 50,
                    'y' => 460,
                    'size' => 14,
                    'font' => 'Courier New',
                    'color' => '#f38181',
                    'align' => 'center',
                    'weight' => 'normal'
                ]
            ],
            'is_active' => true,
            'created_by' => $admin->id
        ]);

        // Demo Certificate 5: EE Engineering Excellence (Landscape)
        CertificateTemplate::create([
            'name' => 'EE Engineering Excellence',
            'description' => 'Specifically designed for Electrical Engineering courses with professional branding. Features the EE LMS color scheme.',
            'orientation' => 'landscape',
            'background_image' => null,
            'layout_config' => [
                'width' => 1122,
                'height' => 794,
                'background_color' => '#f8f9fc',
                'border' => [
                    'enabled' => true,
                    'color' => '#667eea',
                    'width' => 18,
                    'style' => 'double'
                ]
            ],
            'text_fields' => [
                'name' => [
                    'label' => 'Student Name',
                    'x' => 50,
                    'y' => 180,
                    'size' => 46,
                    'font' => 'Georgia',
                    'color' => '#2c3e50',
                    'align' => 'center',
                    'weight' => 'bold'
                ],
                'course' => [
                    'label' => 'Course Title',
                    'x' => 50,
                    'y' => 280,
                    'size' => 30,
                    'font' => 'Arial',
                    'color' => '#667eea',
                    'align' => 'center',
                    'weight' => 'bold'
                ],
                'date' => [
                    'label' => 'Completion Date',
                    'x' => 50,
                    'y' => 380,
                    'size' => 22,
                    'font' => 'Arial',
                    'color' => '#764ba2',
                    'align' => 'center',
                    'weight' => 'normal'
                ],
                'code' => [
                    'label' => 'Certificate Code',
                    'x' => 50,
                    'y' => 460,
                    'size' => 16,
                    'font' => 'Courier New',
                    'color' => '#9fa4b8',
                    'align' => 'center',
                    'weight' => 'normal'
                ]
            ],
            'is_active' => true,
            'created_by' => $admin->id
        ]);

        echo "\n✅ Created 5 demo certificate templates successfully!\n";
        echo "   1. Classic Professional Certificate (Landscape)\n";
        echo "   2. Modern Minimalist (Landscape)\n";
        echo "   3. Academic Achievement (Portrait)\n";
        echo "   4. Colorful Achievement (Landscape)\n";
        echo "   5. EE Engineering Excellence (Landscape)\n\n";
        echo "🎓 Access them at: http://localhost:8000/admin/certificates-builder\n\n";
    }
}
