<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add chunk words settings to site_settings table
        DB::table('site_settings')->insert([
            [
                'key' => 'chunk_words_default',
                'value' => '150',
                'type' => 'integer',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chunk_words_min',
                'value' => '50',
                'type' => 'integer',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'chunk_words_max',
                'value' => '500',
                'type' => 'integer',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);

        // Update existing courses to use new default (150) if they're still using old default (100 or 800)
        DB::table('courses')
            ->whereIn('chunk_words', [100, 800])
            ->update(['chunk_words' => 150]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove chunk words settings
        DB::table('site_settings')
            ->whereIn('key', ['chunk_words_default', 'chunk_words_min', 'chunk_words_max'])
            ->delete();

        // Optionally revert courses to old default
        DB::table('courses')
            ->where('chunk_words', 150)
            ->update(['chunk_words' => 800]);
    }
};
