<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'phone')) {
                $table->string('phone', 20)->nullable()->after('email');
            }
            if (!Schema::hasColumn('users', 'location')) {
                $table->string('location', 100)->nullable()->after('phone');
            }
            if (!Schema::hasColumn('users', 'bio')) {
                $table->text('bio')->nullable()->after('location');
            }
            if (!Schema::hasColumn('users', 'avatar')) {
                $table->string('avatar')->nullable()->after('bio');
            }
            
            // Notification settings
            if (!Schema::hasColumn('users', 'email_notifications')) {
                $table->boolean('email_notifications')->default(true)->after('avatar');
            }
            if (!Schema::hasColumn('users', 'course_updates')) {
                $table->boolean('course_updates')->default(true)->after('email_notifications');
            }
            if (!Schema::hasColumn('users', 'achievement_notifications')) {
                $table->boolean('achievement_notifications')->default(true)->after('course_updates');
            }
            if (!Schema::hasColumn('users', 'weekly_digest')) {
                $table->boolean('weekly_digest')->default(false)->after('achievement_notifications');
            }
            
            // Privacy settings
            if (!Schema::hasColumn('users', 'profile_visible')) {
                $table->boolean('profile_visible')->default(true)->after('weekly_digest');
            }
            if (!Schema::hasColumn('users', 'show_leaderboard')) {
                $table->boolean('show_leaderboard')->default(true)->after('profile_visible');
            }
            if (!Schema::hasColumn('users', 'share_progress')) {
                $table->boolean('share_progress')->default(false)->after('show_leaderboard');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'phone',
                'location',
                'bio',
                'avatar',
                'email_notifications',
                'course_updates',
                'achievement_notifications',
                'weekly_digest',
                'profile_visible',
                'show_leaderboard',
                'share_progress',
            ]);
        });
    }
};
