<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('student_daily_study_time', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('course_id')->constrained()->onDelete('cascade');
            $table->date('study_date');
            $table->integer('total_minutes')->default(0)->comment('Total study time in minutes for this date');
            $table->timestamp('session_start')->nullable()->comment('Current session start time');
            $table->timestamps();
            
            // Ensure one record per user per course per day
            $table->unique(['user_id', 'course_id', 'study_date']);
            
            $table->index(['user_id', 'course_id', 'study_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_daily_study_time');
    }
};
