<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            // Study time limit settings
            $table->boolean('enable_study_time_limit')->default(false)->after('chunk_words');
            $table->integer('min_study_time_per_day')->nullable()->comment('Minimum minutes per day')->after('enable_study_time_limit');
            $table->integer('max_study_time_per_day')->nullable()->comment('Maximum minutes per day')->after('min_study_time_per_day');
            
            // Course survey/feedback settings
            $table->boolean('enable_course_survey')->default(false)->after('max_study_time_per_day');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->dropColumn([
                'enable_study_time_limit',
                'min_study_time_per_day',
                'max_study_time_per_day',
                'enable_course_survey',
            ]);
        });
    }
};
