<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('phone')->nullable()->after('email');
            $table->text('bio')->nullable()->after('phone');
            $table->string('avatar')->nullable()->after('bio');
            $table->boolean('email_notifications')->default(true)->after('avatar');
            $table->boolean('quiz_notifications')->default(true)->after('email_notifications');
            $table->boolean('course_updates')->default(true)->after('quiz_notifications');
            $table->boolean('achievement_notifications')->default(true)->after('course_updates');
            $table->string('timezone')->default('UTC')->after('achievement_notifications');
            $table->string('language')->default('en')->after('timezone');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'phone',
                'bio',
                'avatar',
                'email_notifications',
                'quiz_notifications',
                'course_updates',
                'achievement_notifications',
                'timezone',
                'language'
            ]);
        });
    }
};
