<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('badges', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->string('icon')->default('🏆'); // Emoji or icon class
            $table->string('type')->default('achievement'); // achievement, progress, special
            $table->string('category')->nullable(); // course, quiz, time, streak, etc.
            $table->json('criteria')->nullable(); // JSON criteria for auto-awarding
            $table->integer('points')->default(10); // Points awarded
            $table->string('color')->default('#FFD700'); // Badge color
            $table->integer('required_count')->nullable(); // For "Complete X courses" badges
            $table->boolean('is_active')->default(true);
            $table->integer('order')->default(0); // Display order
            $table->timestamps();
        });

        // Pivot table for user badges
        Schema::create('user_badges', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('badge_id')->constrained()->onDelete('cascade');
            $table->timestamp('earned_at')->useCurrent();
            $table->json('metadata')->nullable(); // Extra info about how it was earned
            $table->unique(['user_id', 'badge_id']); // Can't earn same badge twice
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_badges');
        Schema::dropIfExists('badges');
    }
};
