<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('certificate_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->json('layout_config'); // Store template design (background, fonts, positions, etc.)
            $table->string('background_image')->nullable(); // Path to background image
            $table->string('orientation')->default('landscape'); // landscape or portrait
            $table->json('text_fields'); // Dynamic text fields (name, course, date, etc.)
            $table->boolean('is_active')->default(true);
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });

        // Certificate assignments to courses/lessons
        Schema::create('certificate_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('certificate_template_id')->constrained()->onDelete('cascade');
            $table->string('assignable_type'); // Course or Lesson
            $table->unsignedBigInteger('assignable_id');
            $table->timestamps();
            
            $table->index(['assignable_type', 'assignable_id']);
        });

        // Issued certificates tracking
        Schema::create('issued_certificates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('certificate_template_id')->constrained()->onDelete('cascade');
            $table->string('assignable_type'); // Course or Lesson
            $table->unsignedBigInteger('assignable_id');
            $table->string('certificate_code')->unique(); // Unique verification code
            $table->string('pdf_path')->nullable(); // Path to generated PDF
            $table->timestamp('issued_at');
            $table->timestamps();
            
            $table->index(['user_id', 'assignable_type', 'assignable_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('issued_certificates');
        Schema::dropIfExists('certificate_assignments');
        Schema::dropIfExists('certificate_templates');
    }
};
