<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('lessons', function (Blueprint $table) {
            $table->boolean('has_certificate')->default(false)->after('share_size');
            $table->unsignedBigInteger('certificate_id')->nullable()->after('has_certificate');
            $table->boolean('has_quiz')->default(false)->after('certificate_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('lessons', function (Blueprint $table) {
            $table->dropColumn(['has_certificate', 'certificate_id', 'has_quiz']);
        });
    }
};
