<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_prerequisites', function (Blueprint $table) {
            $table->unsignedBigInteger('course_id');
            $table->unsignedBigInteger('required_course_id');

            $table->primary(['course_id', 'required_course_id']);
            $table->unique(['course_id', 'required_course_id']);
            $table->foreign('course_id')->references('id')->on('courses');
            $table->foreign('required_course_id')->references('id')->on('courses');
        });

        // Triggers would be added separately if needed, but for now, use model events
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_prerequisites');
    }
};