<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->tinyInteger('id')->primary();
            $table->string('site_name')->nullable();
            $table->string('site_tagline')->nullable();
            $table->string('logo_url', 1024)->nullable();
            $table->string('favicon_url', 1024)->nullable();
            $table->string('seo_title')->nullable();
            $table->string('seo_description', 512)->nullable();
            $table->string('seo_keywords', 512)->nullable();
            $table->string('footer_credit', 512)->nullable();
            $table->string('footer_image_url', 1024)->nullable();
            $table->integer('word_limit')->default(100);
            $table->integer('pass_mark')->default(100);
            $table->integer('max_attempts')->default(3);
            $table->boolean('access_code_required')->default(false);
            $table->timestamp('updated_at')->useCurrentOnUpdate()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};