<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_questions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('lesson_id')->nullable();
            $table->unsignedBigInteger('topic_id')->nullable();
            $table->text('question');
            $table->longText('options_json')->nullable();
            $table->integer('correct_index')->nullable();
            $table->longText('options');
            $table->string('correct_answer')->default('');
            $table->text('explanation')->nullable();
            $table->integer('order_index')->default(0);
            $table->timestamps();

            $table->foreign('lesson_id')->references('id')->on('lessons');
            $table->foreign('topic_id')->references('id')->on('topics');
            $table->index(['topic_id', 'order_index', 'id']);
            $table->index(['lesson_id', 'id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_questions');
    }
};