<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Console\Scheduling\Schedule;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->web(append: [
            \App\Http\Middleware\ShareSettings::class,
            \App\Http\Middleware\HandleInertiaRequests::class,
            // \App\Http\Middleware\RoleRedirect::class,
            \Illuminate\Http\Middleware\AddLinkHeadersForPreloadedAssets::class,
        ]);

        $middleware->alias([
            'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
            'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
        ]);

        // Exclude webhook URLs from CSRF verification
        $middleware->validateCsrfTokens(except: [
            'api/webhooks/*',
        ]);
    })
    ->withSchedule(function (Schedule $schedule) {
        // Check penalties every 6 hours
        $schedule->command('penalties:check --escalate')
            ->everySixHours()
            ->withoutOverlapping()
            ->runInBackground();
        
        // Daily comprehensive check with statistics
        $schedule->command('penalties:check --escalate --stats')
            ->daily()
            ->at('01:00')
            ->withoutOverlapping();
        
        // Clear expired access codes daily (codes older than 7 days)
        $schedule->command('app:clear-expired-access-codes')
            ->daily()
            ->at('02:00');
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();