<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserProgress extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'topic_id',
        'quiz_score',
        'attempts',
        'completed',
        'video_watch_seconds',
        'last_attempt_at',
        'completed_at',
    ];

    protected $casts = [
        'completed' => 'boolean',
        'last_attempt_at' => 'datetime',
        'completed_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function topic()
    {
        return $this->belongsTo(Topic::class);
    }
}