<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserActivityLog extends Model
{
    use HasFactory;

    const UPDATED_AT = null; // Activity logs are append-only
    
    protected $table = 'user_activity_log'; // Explicitly set table name

    protected $fillable = [
        'user_id',
        'activity_type',
        'related_id',
        'related_type',
        'activity_at',
        'metadata'
    ];

    protected $casts = [
        'user_id' => 'integer',
        'related_id' => 'integer',
        'activity_at' => 'datetime',
        'metadata' => 'array',
        'created_at' => 'datetime'
    ];

    /**
     * Get the user who performed the activity
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Scope for specific activity type
     */
    public function scopeActivityType($query, $type)
    {
        return $query->where('activity_type', $type);
    }

    /**
     * Scope for recent activities
     */
    public function scopeRecent($query, $days = 7)
    {
        return $query->where('activity_at', '>=', now()->subDays($days));
    }

    /**
     * Scope for specific user
     */
    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }
}