<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StudentDailyStudyTime extends Model
{
    protected $table = 'student_daily_study_time';

    protected $fillable = [
        'user_id',
        'course_id',
        'study_date',
        'total_minutes_studied',
    ];

    protected $casts = [
        'study_date' => 'date',
        'total_minutes_studied' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }
}
