<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'site_name',
        'site_tagline',
        'logo_url',
        'favicon_url',
        'seo_title',
        'seo_description',
        'seo_keywords',
        'footer_credit',
        'footer_image_url',
        'word_limit',
        'pass_mark',
        'max_attempts',
        'access_code_required',
    ];

    protected $casts = [
        'access_code_required' => 'boolean',
    ];

    public $incrementing = false;
    protected $keyType = 'tinyInteger';
    protected $primaryKey = 'id';

    // Since it's a single row, id = 1
    protected static function booted()
    {
        static::creating(function ($setting) {
            $setting->id = 1;
        });
    }

    public static function getSettings()
    {
        return static::find(1) ?? new static(['id' => 1]);
    }
}