<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuizQuestion extends Model
{
    use HasFactory;

    protected $fillable = [
        'lesson_id',
        'topic_id',
        'question',
        'options_json',
        'correct_index',
        'options',
        'correct_answer',
        'explanation',
        'order_index',
        'is_active',
    ];

    public function lesson()
    {
        return $this->belongsTo(Lesson::class);
    }

    public function topic()
    {
        return $this->belongsTo(Topic::class);
    }

    protected static function booted()
    {
        static::creating(function ($question) {
            if (empty($question->options)) {
                $question->options = '[]';
            }
        });
    }
}