<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PenaltyRule extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'card_type',
        'trigger_type',
        'threshold_value',
        'points_deduction',
        'escalation_days',
        'escalation_points',
        'is_active',
        'order',
        'metadata'
    ];

    protected $casts = [
        'threshold_value' => 'integer',
        'points_deduction' => 'integer',
        'escalation_days' => 'integer',
        'escalation_points' => 'integer',
        'is_active' => 'boolean',
        'order' => 'integer',
        'metadata' => 'array'
    ];

    /**
     * Get penalty cards issued using this rule
     */
    public function penaltyCards()
    {
        return $this->hasMany(UserPenaltyCard::class);
    }

    /**
     * Scope for active rules
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope for specific card type
     */
    public function scopeCardType($query, $type)
    {
        return $query->where('card_type', $type);
    }

    /**
     * Scope for specific trigger type
     */
    public function scopeTriggerType($query, $type)
    {
        return $query->where('trigger_type', $type);
    }

    /**
     * Get formatted threshold text
     */
    public function getThresholdTextAttribute()
    {
        $labels = [
            'inactivity_days' => "{$this->threshold_value} days of inactivity",
            'missed_deadline' => "{$this->threshold_value} missed deadlines",
            'failed_quiz' => "{$this->threshold_value} failed quizzes",
            'custom' => $this->description
        ];

        return $labels[$this->trigger_type] ?? 'Unknown trigger';
    }
}