<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PaymentSetting extends Model
{
    protected $fillable = [
        'gateway',
        'is_enabled',
        'public_key',
        'secret_key',
        'webhook_secret',
        'mode',
        'additional_config'
    ];

    protected $casts = [
        'is_enabled' => 'boolean',
        'additional_config' => 'array'
    ];

    /**
     * Get gateway display name
     */
    public function getDisplayNameAttribute(): string
    {
        return match($this->gateway) {
            'stripe' => 'Stripe',
            'paypal' => 'PayPal',
            'paystack' => 'Paystack',
            'crypto' => 'Cryptocurrency',
            default => ucfirst($this->gateway)
        };
    }

    /**
     * Check if gateway is in live mode
     */
    public function isLive(): bool
    {
        return $this->mode === 'live';
    }

    /**
     * Check if gateway is in sandbox mode
     */
    public function isSandbox(): bool
    {
        return $this->mode === 'sandbox';
    }
}
