<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NotificationSetting extends Model
{
    protected $fillable = [
        'email_enabled',
        'push_enabled',
        'sms_enabled',
        'mail_mailer',
        'mail_host',
        'mail_port',
        'mail_username',
        'mail_password',
        'mail_encryption',
        'mail_from_address',
        'mail_from_name',
        'push_provider',
        'push_api_key',
        'push_server_key',
        'push_config',
        'sms_provider',
        'sms_api_key',
        'sms_api_secret',
        'sms_from_number',
        'sms_config',
    ];

    protected $casts = [
        'email_enabled' => 'boolean',
        'push_enabled' => 'boolean',
        'sms_enabled' => 'boolean',
        'push_config' => 'array',
        'sms_config' => 'array',
    ];

    protected $hidden = [
        'mail_password',
        'push_api_key',
        'push_server_key',
        'sms_api_key',
        'sms_api_secret',
    ];

    /**
     * Get the singleton instance
     */
    public static function getSettings()
    {
        return self::firstOrCreate([], [
            'email_enabled' => true,
            'push_enabled' => false,
            'sms_enabled' => false,
        ]);
    }

    /**
     * Check if email notifications are enabled
     */
    public static function isEmailEnabled(): bool
    {
        return self::getSettings()->email_enabled;
    }

    /**
     * Check if push notifications are enabled
     */
    public static function isPushEnabled(): bool
    {
        return self::getSettings()->push_enabled;
    }

    /**
     * Check if SMS notifications are enabled
     */
    public static function isSmsEnabled(): bool
    {
        return self::getSettings()->sms_enabled;
    }
}
