<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Language extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'native_name',
        'flag_emoji',
        'is_active',
        'is_default',
        'order_index',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_default' => 'boolean',
        'order_index' => 'integer',
    ];

    /**
     * Get courses in this language
     */
    public function courses()
    {
        return $this->hasMany(Course::class);
    }

    /**
     * Get active courses count
     */
    public function getActiveCoursesCountAttribute()
    {
        return $this->courses()->where('is_active', true)->count();
    }

    /**
     * Scope to get only active languages
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to get default language
     */
    public function scopeDefault($query)
    {
        return $query->where('is_default', true);
    }

    /**
     * Scope to order by order_index
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('order_index');
    }

    /**
     * Get the default language
     */
    public static function getDefault()
    {
        return self::where('is_default', true)->first();
    }
}
