<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IssuedCertificate extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'certificate_template_id',
        'assignable_type',
        'assignable_id',
        'certificate_code',
        'qr_code_path',
        'verification_url',
        'pdf_path',
        'issued_at',
    ];

    protected $casts = [
        'issued_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function template()
    {
        return $this->belongsTo(CertificateTemplate::class, 'certificate_template_id');
    }

    public function assignable()
    {
        return $this->morphTo();
    }
}