<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CourseSurvey extends Model
{
    protected $fillable = [
        'course_id',
        'question',
        'question_type',
        'options',
        'is_required',
        'order_index',
    ];

    protected $casts = [
        'options' => 'array',
        'is_required' => 'boolean',
        'order_index' => 'integer',
    ];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function responses()
    {
        return $this->hasMany(CourseSurveyResponse::class, 'survey_id');
    }
}
