<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CertificateTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'layout_config',
        'background_image',
        'orientation',
        'text_fields',
        'is_active',
        'qr_code_enabled',
        'qr_code_config',
        'created_by',
    ];

    protected $casts = [
        'layout_config' => 'array',
        'text_fields' => 'array',
        'qr_code_config' => 'array',
        'is_active' => 'boolean',
        'qr_code_enabled' => 'boolean',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function assignments()
    {
        return $this->hasMany(CertificateAssignment::class);
    }

    public function issuedCertificates()
    {
        return $this->hasMany(IssuedCertificate::class);
    }
}