<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ShareSettings
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Share settings with all views
        $isRequired = false;
        if (Schema::hasTable('settings')) {
            try {
                $isRequired = (bool) DB::table('settings')->where('id', 1)->value('access_code_required');
            } catch (\Exception $e) {
                // table might not be migrated yet
                $isRequired = false;
            }
        }
        
        view()->share('accessCodeRequired', $isRequired);

        return $next($request);
    }
}
