<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SettingsController extends Controller
{
    public function index()
    {
        try {
            $settings = Setting::first();

            if (!$settings) {
                $settings = new Setting(['id' => 1]);
            }

            return response()->json([
                'success' => true,
                'settings' => $settings
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error loading settings: ' . $e->getMessage()
            ], 500);
        }
    }

    public function update(Request $request)
    {
        $settings = Setting::first();

        if (!$settings) {
            $settings = new Setting(['id' => 1]);
        }

        $validator = Validator::make($request->all(), [
            'site_name' => 'nullable|string|max:255',
            'site_tagline' => 'nullable|string|max:255',
            'logo_url' => 'nullable|string|max:1024',
            'favicon_url' => 'nullable|string|max:1024',
            'seo_title' => 'nullable|string|max:255',
            'seo_description' => 'nullable|string|max:500',
            'seo_keywords' => 'nullable|string|max:500',
            'footer_credit' => 'nullable|string|max:255',
            'footer_image_url' => 'nullable|string|max:1024',
            'word_limit' => 'nullable|integer',
            'pass_mark' => 'nullable|integer|min:0|max:100',
            'max_attempts' => 'nullable|integer|min:1',
            'access_code_required' => 'boolean',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 400);
        }

        try {
            $settings->fill($request->all());
            $settings->save();

            return response()->json([
                'success' => true,
                'settings' => $settings
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error updating settings: ' . $e->getMessage()
            ], 500);
        }
    }
}