<?php

namespace App\Http\Controllers;

use App\Models\IssuedCertificate;
use Illuminate\Http\Request;

class CertificateVerificationController extends Controller
{
    /**
     * Verify a certificate by its unique code
     */
    public function verify($code)
    {
        $certificate = IssuedCertificate::where('certificate_code', $code)
            ->with(['user', 'template', 'assignable'])
            ->first();

        if (!$certificate) {
            return view('certificates.verify', [
                'found' => false,
                'message' => 'Certificate not found. Please check the code and try again.'
            ]);
        }

        return view('certificates.verify', [
            'found' => true,
            'certificate' => $certificate,
            'studentName' => $certificate->user->name,
            'courseName' => $certificate->assignable->title ?? $certificate->assignable->name ?? 'N/A',
            'issuedDate' => $certificate->issued_at->format('F j, Y'),
            'certificateCode' => $certificate->certificate_code,
        ]);
    }

    /**
     * API endpoint for verifying certificates
     */
    public function verifyApi($code)
    {
        $certificate = IssuedCertificate::where('certificate_code', $code)
            ->with(['user', 'template', 'assignable'])
            ->first();

        if (!$certificate) {
            return response()->json([
                'valid' => false,
                'message' => 'Certificate not found'
            ], 404);
        }

        return response()->json([
            'valid' => true,
            'certificate' => [
                'code' => $certificate->certificate_code,
                'student_name' => $certificate->user->name,
                'course_name' => $certificate->assignable->title ?? $certificate->assignable->name ?? 'N/A',
                'issued_date' => $certificate->issued_at->format('F j, Y'),
                'template_name' => $certificate->template->name,
            ]
        ]);
    }
}
